var documenterSearchIndex = {"docs":
[{"location":"stdlib/CRC32c.html","page":"CRC32c","title":"CRC32c","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/stdlib/CRC32c/docs/src/index.md\"","category":"page"},{"location":"stdlib/CRC32c.html#CRC32c","page":"CRC32c","title":"CRC32c","text":"","category":"section"},{"location":"stdlib/CRC32c.html","page":"CRC32c","title":"CRC32c","text":"Standard library module for computing the CRC-32c checksum.","category":"page"},{"location":"stdlib/CRC32c.html","page":"CRC32c","title":"CRC32c","text":"CRC32c.crc32c\nCRC32c.crc32c(::IO, ::Integer, ::UInt32)","category":"page"},{"location":"stdlib/CRC32c.html#CRC32c.crc32c","page":"CRC32c","title":"CRC32c.crc32c","text":"crc32c(data, crc::UInt32=0x00000000)\n\nCompute the CRC-32c checksum of the given data, which can be an Array{UInt8}, a contiguous subarray thereof, or a String.  Optionally, you can pass a starting crc integer to be mixed in with the checksum.  The crc parameter can be used to compute a checksum on data divided into chunks: performing crc32c(data2, crc32c(data1)) is equivalent to the checksum of [data1; data2]. (Technically, a little-endian checksum is computed.)\n\nThere is also a method crc32c(io, nb, crc) to checksum nb bytes from a stream io, or crc32c(io, crc) to checksum all the remaining bytes. Hence you can do open(crc32c, filename) to checksum an entire file, or crc32c(seekstart(buf)) to checksum an IOBuffer without calling take!.\n\nFor a String, note that the result is specific to the UTF-8 encoding (a different checksum would be obtained from a different Unicode encoding). To checksum an a::Array of some other bitstype, you can do crc32c(reinterpret(UInt8,a)), but note that the result may be endian-dependent.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/CRC32c.html#CRC32c.crc32c-Tuple{IO, Integer, UInt32}","page":"CRC32c","title":"CRC32c.crc32c","text":"crc32c(io::IO, [nb::Integer,] crc::UInt32=0x00000000)\n\nRead up to nb bytes from io and return the CRC-32c checksum, optionally mixed with a starting crc integer.  If nb is not supplied, then io will be read until the end of the stream.\n\n\n\n\n\n","category":"method"},{"location":"manual/installation.html#man-installation","page":"Installation","title":"Installation","text":"","category":"section"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"There are many ways to install Julia. The following sections highlight the recommended method for each of the main supported platforms, and then present alternative ways that might be useful in specialized situations.","category":"page"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"The current installation recommendation is a solution based on Juliaup. If you installed Julia previously with a method that is not based on Juliaup and want to switch your system to an installation that is based on Juliaup, we recommend that you uninstall all previous Julia versions, ensure that you remove anything Julia related from your PATH variable and then install Julia with one of the methods described below.","category":"page"},{"location":"manual/installation.html#Windows","page":"Installation","title":"Windows","text":"","category":"section"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"On Windows Julia can be installed directly from the Windows store here. One can also install exactly the same version by executing","category":"page"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"winget install julia -s msstore","category":"page"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"in any shell.","category":"page"},{"location":"manual/installation.html#Mac-and-Linux","page":"Installation","title":"Mac and Linux","text":"","category":"section"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"Julia can be installed on Linux or Mac by executing","category":"page"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"curl -fsSL https://install.julialang.org | sh","category":"page"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"in a shell.","category":"page"},{"location":"manual/installation.html#Command-line-arguments","page":"Installation","title":"Command line arguments","text":"","category":"section"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"One can pass various command line arguments to the Julia installer. The syntax for installer arguments is","category":"page"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"curl -fsSL https://install.julialang.org | sh -s -- <ARGS>","category":"page"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"Here <ARGS> should be replaced with one or more of the following arguments:","category":"page"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"--yes (or -y): Run the installer in a non-interactive mode. All configuration values use their default or a value supplied as a command line argument.\n--default-channel=<NAME>: Configure the default Juliaup channel. For example --default-channel lts would install the lts channel and configure it as the default.\n--add-to-path=<yes|no>: Configure whether Julia should be added to the PATH environment variable. Valid values are yes (default) and no.\n--background-selfupdate=<SECONDS>: Configure an optional CRON job that auto-updates Juliaup if <SECONDS> has a value larger than 0. The actual value controls how often the CRON job will run to check for a new Juliaup version in seconds. The default value is 0, i.e. no CRON job will be created.\n--startup-selfupdate=<MINUTES>: Configure how often Julia will check for new versions of Juliaup when Julia is started. The default is every 1440 minutes.\n-p=<PATH> (or --path): Configure where the Julia and Juliaup binaries are installed. The default is ~/.juliaup.","category":"page"},{"location":"manual/installation.html#Alternative-installation-methods","page":"Installation","title":"Alternative installation methods","text":"","category":"section"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"Note that we recommend the following methods only if none of the installation methods described above work for your system.","category":"page"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"Some of the installation methods described below recommend installing a package called juliaup. Note that this nevertheless installs a fully functional Julia system, not just Juliaup.","category":"page"},{"location":"manual/installation.html#App-Installer-(Windows)","page":"Installation","title":"App Installer (Windows)","text":"","category":"section"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"If the Windows Store is blocked on a system, we have an alternative MSIX App Installer based setup. To use the App Installer version, download this file and open it by double clicking on it.","category":"page"},{"location":"manual/installation.html#MSI-Installer-(Windows)","page":"Installation","title":"MSI Installer (Windows)","text":"","category":"section"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"If neither the Windows Store nor the App Installer version work on your Windows system, you can also use a MSI based installer. Note that this installation methods comes with serious limitations and is generally not recommended unless no other method works. For example, there is no automatic update mechanism for Juliaup with this installation method. The 64 bit version of the MSI installer can be downloaded from here and the 32 bit version from here.","category":"page"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"By default the install will be a per-user install that does not require  elevation. You can also do a system install by running the following command  from a shell:","category":"page"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"msiexec /i <PATH_TO_JULIA_MSI> ALLUSERS=1","category":"page"},{"location":"manual/installation.html#[Homebrew](https://brew.sh)-(Mac-and-Linux)","page":"Installation","title":"Homebrew (Mac and Linux)","text":"","category":"section"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"On systems with brew, you can install Julia by running","category":"page"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"brew install juliaup","category":"page"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"in a shell. Note that you will have to update Juliaup with standard brew commands.","category":"page"},{"location":"manual/installation.html#[Arch-Linux-AUR](https://aur.archlinux.org/packages/juliaup/)-(Linux)","page":"Installation","title":"Arch Linux - AUR (Linux)","text":"","category":"section"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"On Arch Linux, Juliaup is available in the Arch User Repository (AUR).","category":"page"},{"location":"manual/installation.html#[openSUSE-Tumbleweed](https://get.opensuse.org/tumbleweed/)-(Linux)","page":"Installation","title":"openSUSE Tumbleweed (Linux)","text":"","category":"section"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"On openSUSE Tumbleweed, you can install Julia by running","category":"page"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"zypper install juliaup","category":"page"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"in a shell with root privileges.","category":"page"},{"location":"manual/installation.html#[cargo](https://crates.io/crates/juliaup/)-(Windows,-Mac-and-Linux)","page":"Installation","title":"cargo (Windows, Mac and Linux)","text":"","category":"section"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"To install Julia via Rust's cargo, run:","category":"page"},{"location":"manual/installation.html","page":"Installation","title":"Installation","text":"cargo install juliaup","category":"page"},{"location":"base/sort.html#Sorting-and-Related-Functions","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"","category":"section"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"Julia has an extensive, flexible API for sorting and interacting with already-sorted arrays of values. By default, Julia picks reasonable algorithms and sorts in ascending order:","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"julia> sort([2,3,1])\n3-element Vector{Int64}:\n 1\n 2\n 3","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"You can sort in reverse order as well:","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"julia> sort([2,3,1], rev=true)\n3-element Vector{Int64}:\n 3\n 2\n 1","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"sort constructs a sorted copy leaving its input unchanged. Use the \"bang\" version of the sort function to mutate an existing array:","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"julia> a = [2,3,1];\n\njulia> sort!(a);\n\njulia> a\n3-element Vector{Int64}:\n 1\n 2\n 3","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"Instead of directly sorting an array, you can compute a permutation of the array's indices that puts the array into sorted order:","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"julia> v = randn(5)\n5-element Array{Float64,1}:\n  0.297288\n  0.382396\n -0.597634\n -0.0104452\n -0.839027\n\njulia> p = sortperm(v)\n5-element Array{Int64,1}:\n 5\n 3\n 4\n 1\n 2\n\njulia> v[p]\n5-element Array{Float64,1}:\n -0.839027\n -0.597634\n -0.0104452\n  0.297288\n  0.382396","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"Arrays can be sorted according to an arbitrary transformation of their values:","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"julia> sort(v, by=abs)\n5-element Array{Float64,1}:\n -0.0104452\n  0.297288\n  0.382396\n -0.597634\n -0.839027","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"Or in reverse order by a transformation:","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"julia> sort(v, by=abs, rev=true)\n5-element Array{Float64,1}:\n -0.839027\n -0.597634\n  0.382396\n  0.297288\n -0.0104452","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"If needed, the sorting algorithm can be chosen:","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"julia> sort(v, alg=InsertionSort)\n5-element Array{Float64,1}:\n -0.839027\n -0.597634\n -0.0104452\n  0.297288\n  0.382396","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"All the sorting and order related functions rely on a \"less than\" relation defining a strict weak order on the values to be manipulated. The isless function is invoked by default, but the relation can be specified via the lt keyword, a function that takes two array elements and returns true if and only if the first argument is \"less than\" the second. See sort! and Alternate Orderings for more information.","category":"page"},{"location":"base/sort.html#Sorting-Functions","page":"Sorting and Related Functions","title":"Sorting Functions","text":"","category":"section"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"Base.sort!\nBase.sort\nBase.sortperm\nBase.InsertionSort\nBase.MergeSort\nBase.QuickSort\nBase.PartialQuickSort\nBase.Sort.sortperm!\nBase.Sort.sortslices","category":"page"},{"location":"base/sort.html#Base.sort!","page":"Sorting and Related Functions","title":"Base.sort!","text":"sort!(v; alg::Algorithm=defalg(v), lt=isless, by=identity, rev::Bool=false, order::Ordering=Forward)\n\nSort the vector v in place. A stable algorithm is used by default: the ordering of elements that compare equal is preserved. A specific algorithm can be selected via the alg keyword (see Sorting Algorithms for available algorithms).\n\nElements are first transformed with the function by and then compared according to either the function lt or the ordering order. Finally, the resulting order is reversed if rev=true (this preserves forward stability: elements that compare equal are not reversed). The current implementation applies the by transformation before each comparison rather than once per element.\n\nPassing an lt other than isless along with an order other than Base.Order.Forward or Base.Order.Reverse is not permitted, otherwise all options are independent and can be used together in all possible combinations. Note that order can also include a \"by\" transformation, in which case it is applied after that defined with the by keyword. For more information on order values see the documentation on Alternate Orderings.\n\nRelations between two elements are defined as follows (with \"less\" and \"greater\" exchanged when rev=true):\n\nx is less than y if lt(by(x), by(y)) (or Base.Order.lt(order, by(x), by(y))) yields true.\nx is greater than y if y is less than x.\nx and y are equivalent if neither is less than the other (\"incomparable\" is sometimes used as a synonym for \"equivalent\").\n\nThe result of sort! is sorted in the sense that every element is greater than or equivalent to the previous one.\n\nThe lt function must define a strict weak order, that is, it must be\n\nirreflexive: lt(x, x) always yields false,\nasymmetric: if lt(x, y) yields true then lt(y, x) yields false,\ntransitive: lt(x, y) && lt(y, z) implies lt(x, z),\ntransitive in equivalence: !lt(x, y) && !lt(y, x) and !lt(y, z) && !lt(z, y) together imply !lt(x, z) && !lt(z, x). In words: if x and y are equivalent and y and z are equivalent then x and z must be equivalent.\n\nFor example < is a valid lt function for Int values but ≤ is not: it violates irreflexivity. For Float64 values even < is invalid as it violates the fourth condition: 1.0 and NaN are equivalent and so are NaN and 2.0 but 1.0 and 2.0 are not equivalent.\n\nSee also sort, sortperm, sortslices, partialsort!, partialsortperm, issorted, searchsorted, insorted, Base.Order.ord.\n\nExamples\n\njulia> v = [3, 1, 2]; sort!(v); v\n3-element Vector{Int64}:\n 1\n 2\n 3\n\njulia> v = [3, 1, 2]; sort!(v, rev = true); v\n3-element Vector{Int64}:\n 3\n 2\n 1\n\njulia> v = [(1, \"c\"), (3, \"a\"), (2, \"b\")]; sort!(v, by = x -> x[1]); v\n3-element Vector{Tuple{Int64, String}}:\n (1, \"c\")\n (2, \"b\")\n (3, \"a\")\n\njulia> v = [(1, \"c\"), (3, \"a\"), (2, \"b\")]; sort!(v, by = x -> x[2]); v\n3-element Vector{Tuple{Int64, String}}:\n (3, \"a\")\n (2, \"b\")\n (1, \"c\")\n\njulia> sort(0:3, by=x->x-2, order=Base.Order.By(abs)) # same as sort(0:3, by=abs(x->x-2))\n4-element Vector{Int64}:\n 2\n 1\n 3\n 0\n\njulia> sort([2, NaN, 1, NaN, 3]) # correct sort with default lt=isless\n5-element Vector{Float64}:\n   1.0\n   2.0\n   3.0\n NaN\n NaN\n\njulia> sort([2, NaN, 1, NaN, 3], lt=<) # wrong sort due to invalid lt. This behavior is undefined.\n5-element Vector{Float64}:\n   2.0\n NaN\n   1.0\n NaN\n   3.0\n\n\n\n\n\nsort!(A; dims::Integer, alg::Algorithm=defalg(A), lt=isless, by=identity, rev::Bool=false, order::Ordering=Forward)\n\nSort the multidimensional array A along dimension dims. See the one-dimensional version of sort! for a description of possible keyword arguments.\n\nTo sort slices of an array, refer to sortslices.\n\ncompat: Julia 1.1\nThis function requires at least Julia 1.1.\n\nExamples\n\njulia> A = [4 3; 1 2]\n2×2 Matrix{Int64}:\n 4  3\n 1  2\n\njulia> sort!(A, dims = 1); A\n2×2 Matrix{Int64}:\n 1  2\n 4  3\n\njulia> sort!(A, dims = 2); A\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\n\n\n\n\n","category":"function"},{"location":"base/sort.html#Base.sort","page":"Sorting and Related Functions","title":"Base.sort","text":"sort(v; alg::Algorithm=defalg(v), lt=isless, by=identity, rev::Bool=false, order::Ordering=Forward)\n\nVariant of sort! that returns a sorted copy of v leaving v itself unmodified.\n\nExamples\n\njulia> v = [3, 1, 2];\n\njulia> sort(v)\n3-element Vector{Int64}:\n 1\n 2\n 3\n\njulia> v\n3-element Vector{Int64}:\n 3\n 1\n 2\n\n\n\n\n\nsort(A; dims::Integer, alg::Algorithm=defalg(A), lt=isless, by=identity, rev::Bool=false, order::Ordering=Forward)\n\nSort a multidimensional array A along the given dimension. See sort! for a description of possible keyword arguments.\n\nTo sort slices of an array, refer to sortslices.\n\nExamples\n\njulia> A = [4 3; 1 2]\n2×2 Matrix{Int64}:\n 4  3\n 1  2\n\njulia> sort(A, dims = 1)\n2×2 Matrix{Int64}:\n 1  2\n 4  3\n\njulia> sort(A, dims = 2)\n2×2 Matrix{Int64}:\n 3  4\n 1  2\n\n\n\n\n\n","category":"function"},{"location":"base/sort.html#Base.sortperm","page":"Sorting and Related Functions","title":"Base.sortperm","text":"sortperm(A; alg::Algorithm=DEFAULT_UNSTABLE, lt=isless, by=identity, rev::Bool=false, order::Ordering=Forward, [dims::Integer])\n\nReturn a permutation vector or array I that puts A[I] in sorted order along the given dimension. If A has more than one dimension, then the dims keyword argument must be specified. The order is specified using the same keywords as sort!. The permutation is guaranteed to be stable even if the sorting algorithm is unstable: the indices of equal elements will appear in ascending order.\n\nSee also sortperm!, partialsortperm, invperm, indexin. To sort slices of an array, refer to sortslices.\n\ncompat: Julia 1.9\nThe method accepting dims requires at least Julia 1.9.\n\nExamples\n\njulia> v = [3, 1, 2];\n\njulia> p = sortperm(v)\n3-element Vector{Int64}:\n 2\n 3\n 1\n\njulia> v[p]\n3-element Vector{Int64}:\n 1\n 2\n 3\n\njulia> A = [8 7; 5 6]\n2×2 Matrix{Int64}:\n 8  7\n 5  6\n\njulia> sortperm(A, dims = 1)\n2×2 Matrix{Int64}:\n 2  4\n 1  3\n\njulia> sortperm(A, dims = 2)\n2×2 Matrix{Int64}:\n 3  1\n 2  4\n\n\n\n\n\n","category":"function"},{"location":"base/sort.html#Base.Sort.InsertionSort","page":"Sorting and Related Functions","title":"Base.Sort.InsertionSort","text":"InsertionSort\n\nUse the insertion sort algorithm.\n\nInsertion sort traverses the collection one element at a time, inserting each element into its correct, sorted position in the output vector.\n\nCharacteristics:\n\nstable: preserves the ordering of elements that compare equal\n\n(e.g. \"a\" and \"A\" in a sort of letters that ignores case).\n\nin-place in memory.\nquadratic performance in the number of elements to be sorted:\n\nit is well-suited to small collections but should not be used for large ones.\n\n\n\n\n\n","category":"constant"},{"location":"base/sort.html#Base.Sort.MergeSort","page":"Sorting and Related Functions","title":"Base.Sort.MergeSort","text":"MergeSort\n\nIndicate that a sorting function should use the merge sort algorithm. Merge sort divides the collection into subcollections and repeatedly merges them, sorting each subcollection at each step, until the entire collection has been recombined in sorted form.\n\nCharacteristics:\n\nstable: preserves the ordering of elements that compare equal (e.g. \"a\" and \"A\" in a sort of letters that ignores case).\nnot in-place in memory.\ndivide-and-conquer sort strategy.\ngood performance for large collections but typically not quite as fast as QuickSort.\n\n\n\n\n\n","category":"constant"},{"location":"base/sort.html#Base.Sort.QuickSort","page":"Sorting and Related Functions","title":"Base.Sort.QuickSort","text":"QuickSort\n\nIndicate that a sorting function should use the quick sort algorithm, which is not stable.\n\nCharacteristics:\n\nnot stable: does not preserve the ordering of elements that compare equal (e.g. \"a\" and \"A\" in a sort of letters that ignores case).\nin-place in memory.\ndivide-and-conquer: sort strategy similar to MergeSort.\ngood performance for large collections.\n\n\n\n\n\n","category":"constant"},{"location":"base/sort.html#Base.Sort.PartialQuickSort","page":"Sorting and Related Functions","title":"Base.Sort.PartialQuickSort","text":"PartialQuickSort{T <: Union{Integer,OrdinalRange}}\n\nIndicate that a sorting function should use the partial quick sort algorithm. PartialQuickSort(k) is like QuickSort, but is only required to find and sort the elements that would end up in v[k] were v fully sorted.\n\nCharacteristics:\n\nnot stable: does not preserve the ordering of elements that compare equal (e.g. \"a\" and \"A\" in a sort of letters that ignores case).\nin-place in memory.\ndivide-and-conquer: sort strategy similar to MergeSort.\n\nNote that PartialQuickSort(k) does not necessarily sort the whole array. For example,\n\njulia> x = rand(100);\n\njulia> k = 50:100;\n\njulia> s1 = sort(x; alg=QuickSort);\n\njulia> s2 = sort(x; alg=PartialQuickSort(k));\n\njulia> map(issorted, (s1, s2))\n(true, false)\n\njulia> map(x->issorted(x[k]), (s1, s2))\n(true, true)\n\njulia> s1[k] == s2[k]\ntrue\n\n\n\n\n\n","category":"type"},{"location":"base/sort.html#Base.Sort.sortperm!","page":"Sorting and Related Functions","title":"Base.Sort.sortperm!","text":"sortperm!(ix, A; alg::Algorithm=DEFAULT_UNSTABLE, lt=isless, by=identity, rev::Bool=false, order::Ordering=Forward, [dims::Integer])\n\nLike sortperm, but accepts a preallocated index vector or array ix with the same axes as A. ix is initialized to contain the values LinearIndices(A).\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\ncompat: Julia 1.9\nThe method accepting dims requires at least Julia 1.9.\n\nExamples\n\njulia> v = [3, 1, 2]; p = zeros(Int, 3);\n\njulia> sortperm!(p, v); p\n3-element Vector{Int64}:\n 2\n 3\n 1\n\njulia> v[p]\n3-element Vector{Int64}:\n 1\n 2\n 3\n\njulia> A = [8 7; 5 6]; p = zeros(Int,2, 2);\n\njulia> sortperm!(p, A; dims=1); p\n2×2 Matrix{Int64}:\n 2  4\n 1  3\n\njulia> sortperm!(p, A; dims=2); p\n2×2 Matrix{Int64}:\n 3  1\n 2  4\n\n\n\n\n\n","category":"function"},{"location":"base/sort.html#Base.sortslices","page":"Sorting and Related Functions","title":"Base.sortslices","text":"sortslices(A; dims, alg::Algorithm=DEFAULT_UNSTABLE, lt=isless, by=identity, rev::Bool=false, order::Ordering=Forward)\n\nSort slices of an array A. The required keyword argument dims must be either an integer or a tuple of integers. It specifies the dimension(s) over which the slices are sorted.\n\nE.g., if A is a matrix, dims=1 will sort rows, dims=2 will sort columns. Note that the default comparison function on one dimensional slices sorts lexicographically.\n\nFor the remaining keyword arguments, see the documentation of sort!.\n\nExamples\n\njulia> sortslices([7 3 5; -1 6 4; 9 -2 8], dims=1) # Sort rows\n3×3 Matrix{Int64}:\n -1   6  4\n  7   3  5\n  9  -2  8\n\njulia> sortslices([7 3 5; -1 6 4; 9 -2 8], dims=1, lt=(x,y)->isless(x[2],y[2]))\n3×3 Matrix{Int64}:\n  9  -2  8\n  7   3  5\n -1   6  4\n\njulia> sortslices([7 3 5; -1 6 4; 9 -2 8], dims=1, rev=true)\n3×3 Matrix{Int64}:\n  9  -2  8\n  7   3  5\n -1   6  4\n\njulia> sortslices([7 3 5; 6 -1 -4; 9 -2 8], dims=2) # Sort columns\n3×3 Matrix{Int64}:\n  3   5  7\n -1  -4  6\n -2   8  9\n\njulia> sortslices([7 3 5; 6 -1 -4; 9 -2 8], dims=2, alg=InsertionSort, lt=(x,y)->isless(x[2],y[2]))\n3×3 Matrix{Int64}:\n  5   3  7\n -4  -1  6\n  8  -2  9\n\njulia> sortslices([7 3 5; 6 -1 -4; 9 -2 8], dims=2, rev=true)\n3×3 Matrix{Int64}:\n 7   5   3\n 6  -4  -1\n 9   8  -2\n\nHigher dimensions\n\nsortslices extends naturally to higher dimensions. E.g., if A is a a 2x2x2 array, sortslices(A, dims=3) will sort slices within the 3rd dimension, passing the 2x2 slices A[:, :, 1] and A[:, :, 2] to the comparison function. Note that while there is no default order on higher-dimensional slices, you may use the by or lt keyword argument to specify such an order.\n\nIf dims is a tuple, the order of the dimensions in dims is relevant and specifies the linear order of the slices. E.g., if A is three dimensional and dims is (1, 2), the orderings of the first two dimensions are re-arranged such that the slices (of the remaining third dimension) are sorted. If dims is (2, 1) instead, the same slices will be taken, but the result order will be row-major instead.\n\nHigher dimensional examples\n\njulia> A = [4 3; 2 1 ;;; 'A' 'B'; 'C' 'D']\n2×2×2 Array{Any, 3}:\n[:, :, 1] =\n 4  3\n 2  1\n\n[:, :, 2] =\n 'A'  'B'\n 'C'  'D'\n\njulia> sortslices(A, dims=(1,2))\n2×2×2 Array{Any, 3}:\n[:, :, 1] =\n 1  3\n 2  4\n\n[:, :, 2] =\n 'D'  'B'\n 'C'  'A'\n\njulia> sortslices(A, dims=(2,1))\n2×2×2 Array{Any, 3}:\n[:, :, 1] =\n 1  2\n 3  4\n\n[:, :, 2] =\n 'D'  'C'\n 'B'  'A'\n\njulia> sortslices(reshape([5; 4; 3; 2; 1], (1,1,5)), dims=3, by=x->x[1,1])\n1×1×5 Array{Int64, 3}:\n[:, :, 1] =\n 1\n\n[:, :, 2] =\n 2\n\n[:, :, 3] =\n 3\n\n[:, :, 4] =\n 4\n\n[:, :, 5] =\n 5\n\n\n\n\n\n","category":"function"},{"location":"base/sort.html#Order-Related-Functions","page":"Sorting and Related Functions","title":"Order-Related Functions","text":"","category":"section"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"Base.issorted\nBase.Sort.searchsorted\nBase.Sort.searchsortedfirst\nBase.Sort.searchsortedlast\nBase.Sort.insorted\nBase.Sort.partialsort!\nBase.Sort.partialsort\nBase.Sort.partialsortperm\nBase.Sort.partialsortperm!","category":"page"},{"location":"base/sort.html#Base.issorted","page":"Sorting and Related Functions","title":"Base.issorted","text":"issorted(v, lt=isless, by=identity, rev::Bool=false, order::Ordering=Forward)\n\nTest whether a collection is in sorted order. The keywords modify what order is considered sorted, as described in the sort! documentation.\n\nExamples\n\njulia> issorted([1, 2, 3])\ntrue\n\njulia> issorted([(1, \"b\"), (2, \"a\")], by = x -> x[1])\ntrue\n\njulia> issorted([(1, \"b\"), (2, \"a\")], by = x -> x[2])\nfalse\n\njulia> issorted([(1, \"b\"), (2, \"a\")], by = x -> x[2], rev=true)\ntrue\n\njulia> issorted([1, 2, -2, 3], by=abs)\ntrue\n\n\n\n\n\n","category":"function"},{"location":"base/sort.html#Base.Sort.searchsorted","page":"Sorting and Related Functions","title":"Base.Sort.searchsorted","text":"searchsorted(v, x; by=identity, lt=isless, rev=false)\n\nReturn the range of indices in v where values are equivalent to x, or an empty range located at the insertion point if v does not contain values equivalent to x. The vector v must be sorted according to the order defined by the keywords. Refer to sort! for the meaning of the keywords and the definition of equivalence. Note that the by function is applied to the searched value x as well as the values in v.\n\nThe range is generally found using binary search, but there are optimized implementations for some inputs.\n\nSee also: searchsortedfirst, sort!, insorted, findall.\n\nExamples\n\njulia> searchsorted([1, 2, 4, 5, 5, 7], 4) # single match\n3:3\n\njulia> searchsorted([1, 2, 4, 5, 5, 7], 5) # multiple matches\n4:5\n\njulia> searchsorted([1, 2, 4, 5, 5, 7], 3) # no match, insert in the middle\n3:2\n\njulia> searchsorted([1, 2, 4, 5, 5, 7], 9) # no match, insert at end\n7:6\n\njulia> searchsorted([1, 2, 4, 5, 5, 7], 0) # no match, insert at start\n1:0\n\njulia> searchsorted([1=>\"one\", 2=>\"two\", 2=>\"two\", 4=>\"four\"], 2=>\"two\", by=first) # compare the keys of the pairs\n2:3\n\n\n\n\n\n","category":"function"},{"location":"base/sort.html#Base.Sort.searchsortedfirst","page":"Sorting and Related Functions","title":"Base.Sort.searchsortedfirst","text":"searchsortedfirst(v, x; by=identity, lt=isless, rev=false)\n\nReturn the index of the first value in v that is not ordered before x. If all values in v are ordered before x, return lastindex(v) + 1.\n\nThe vector v must be sorted according to the order defined by the keywords. insert!ing x at the returned index will maintain the sorted order. Refer to sort! for the meaning and use of the keywords. Note that the by function is applied to the searched value x as well as the values in v.\n\nThe index is generally found using binary search, but there are optimized implementations for some inputs.\n\nSee also: searchsortedlast, searchsorted, findfirst.\n\nExamples\n\njulia> searchsortedfirst([1, 2, 4, 5, 5, 7], 4) # single match\n3\n\njulia> searchsortedfirst([1, 2, 4, 5, 5, 7], 5) # multiple matches\n4\n\njulia> searchsortedfirst([1, 2, 4, 5, 5, 7], 3) # no match, insert in the middle\n3\n\njulia> searchsortedfirst([1, 2, 4, 5, 5, 7], 9) # no match, insert at end\n7\n\njulia> searchsortedfirst([1, 2, 4, 5, 5, 7], 0) # no match, insert at start\n1\n\njulia> searchsortedfirst([1=>\"one\", 2=>\"two\", 4=>\"four\"], 3=>\"three\", by=first) # compare the keys of the pairs\n3\n\n\n\n\n\n","category":"function"},{"location":"base/sort.html#Base.Sort.searchsortedlast","page":"Sorting and Related Functions","title":"Base.Sort.searchsortedlast","text":"searchsortedlast(v, x; by=identity, lt=isless, rev=false)\n\nReturn the index of the last value in v that is not ordered after x. If all values in v are ordered after x, return firstindex(v) - 1.\n\nThe vector v must be sorted according to the order defined by the keywords. insert!ing x immediately after the returned index will maintain the sorted order. Refer to sort! for the meaning and use of the keywords. Note that the by function is applied to the searched value x as well as the values in v.\n\nThe index is generally found using binary search, but there are optimized implementations for some inputs\n\nExamples\n\njulia> searchsortedlast([1, 2, 4, 5, 5, 7], 4) # single match\n3\n\njulia> searchsortedlast([1, 2, 4, 5, 5, 7], 5) # multiple matches\n5\n\njulia> searchsortedlast([1, 2, 4, 5, 5, 7], 3) # no match, insert in the middle\n2\n\njulia> searchsortedlast([1, 2, 4, 5, 5, 7], 9) # no match, insert at end\n6\n\njulia> searchsortedlast([1, 2, 4, 5, 5, 7], 0) # no match, insert at start\n0\n\njulia> searchsortedlast([1=>\"one\", 2=>\"two\", 4=>\"four\"], 3=>\"three\", by=first) # compare the keys of the pairs\n2\n\n\n\n\n\n","category":"function"},{"location":"base/sort.html#Base.Sort.insorted","page":"Sorting and Related Functions","title":"Base.Sort.insorted","text":"insorted(x, v; by=identity, lt=isless, rev=false) -> Bool\n\nDetermine whether a vector v contains any value equivalent to x. The vector v must be sorted according to the order defined by the keywords. Refer to sort! for the meaning of the keywords and the definition of equivalence. Note that the by function is applied to the searched value x as well as the values in v.\n\nThe check is generally done using binary search, but there are optimized implementations for some inputs.\n\nSee also in.\n\nExamples\n\njulia> insorted(4, [1, 2, 4, 5, 5, 7]) # single match\ntrue\n\njulia> insorted(5, [1, 2, 4, 5, 5, 7]) # multiple matches\ntrue\n\njulia> insorted(3, [1, 2, 4, 5, 5, 7]) # no match\nfalse\n\njulia> insorted(9, [1, 2, 4, 5, 5, 7]) # no match\nfalse\n\njulia> insorted(0, [1, 2, 4, 5, 5, 7]) # no match\nfalse\n\njulia> insorted(2=>\"TWO\", [1=>\"one\", 2=>\"two\", 4=>\"four\"], by=first) # compare the keys of the pairs\ntrue\n\ncompat: Julia 1.6\ninsorted was added in Julia 1.6.\n\n\n\n\n\n","category":"function"},{"location":"base/sort.html#Base.Sort.partialsort!","page":"Sorting and Related Functions","title":"Base.Sort.partialsort!","text":"partialsort!(v, k; by=identity, lt=isless, rev=false)\n\nPartially sort the vector v in place so that the value at index k (or range of adjacent values if k is a range) occurs at the position where it would appear if the array were fully sorted. If k is a single index, that value is returned; if k is a range, an array of values at those indices is returned. Note that partialsort! may not fully sort the input array.\n\nFor the keyword arguments, see the documentation of sort!.\n\nExamples\n\njulia> a = [1, 2, 4, 3, 4]\n5-element Vector{Int64}:\n 1\n 2\n 4\n 3\n 4\n\njulia> partialsort!(a, 4)\n4\n\njulia> a\n5-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 4\n\njulia> a = [1, 2, 4, 3, 4]\n5-element Vector{Int64}:\n 1\n 2\n 4\n 3\n 4\n\njulia> partialsort!(a, 4, rev=true)\n2\n\njulia> a\n5-element Vector{Int64}:\n 4\n 4\n 3\n 2\n 1\n\n\n\n\n\n","category":"function"},{"location":"base/sort.html#Base.Sort.partialsort","page":"Sorting and Related Functions","title":"Base.Sort.partialsort","text":"partialsort(v, k, by=identity, lt=isless, rev=false)\n\nVariant of partialsort! that copies v before partially sorting it, thereby returning the same thing as partialsort! but leaving v unmodified.\n\n\n\n\n\n","category":"function"},{"location":"base/sort.html#Base.Sort.partialsortperm","page":"Sorting and Related Functions","title":"Base.Sort.partialsortperm","text":"partialsortperm(v, k; by=identity, lt=isless, rev=false)\n\nReturn a partial permutation I of the vector v, so that v[I] returns values of a fully sorted version of v at index k. If k is a range, a vector of indices is returned; if k is an integer, a single index is returned. The order is specified using the same keywords as sort!. The permutation is stable: the indices of equal elements will appear in ascending order.\n\nThis function is equivalent to, but more efficient than, calling sortperm(...)[k].\n\nExamples\n\njulia> v = [3, 1, 2, 1];\n\njulia> v[partialsortperm(v, 1)]\n1\n\njulia> p = partialsortperm(v, 1:3)\n3-element view(::Vector{Int64}, 1:3) with eltype Int64:\n 2\n 4\n 3\n\njulia> v[p]\n3-element Vector{Int64}:\n 1\n 1\n 2\n\n\n\n\n\n","category":"function"},{"location":"base/sort.html#Base.Sort.partialsortperm!","page":"Sorting and Related Functions","title":"Base.Sort.partialsortperm!","text":"partialsortperm!(ix, v, k; by=identity, lt=isless, rev=false)\n\nLike partialsortperm, but accepts a preallocated index vector ix the same size as v, which is used to store (a permutation of) the indices of v.\n\nix is initialized to contain the indices of v.\n\n(Typically, the indices of v will be 1:length(v), although if v has an alternative array type with non-one-based indices, such as an OffsetArray, ix must share those same indices)\n\nUpon return, ix is guaranteed to have the indices k in their sorted positions, such that\n\npartialsortperm!(ix, v, k);\nv[ix[k]] == partialsort(v, k)\n\nThe return value is the kth element of ix if k is an integer, or view into ix if k is a range.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nExamples\n\njulia> v = [3, 1, 2, 1];\n\njulia> ix = Vector{Int}(undef, 4);\n\njulia> partialsortperm!(ix, v, 1)\n2\n\njulia> ix = [1:4;];\n\njulia> partialsortperm!(ix, v, 2:3)\n2-element view(::Vector{Int64}, 2:3) with eltype Int64:\n 4\n 3\n\n\n\n\n\n\n\n","category":"function"},{"location":"base/sort.html#Sorting-Algorithms","page":"Sorting and Related Functions","title":"Sorting Algorithms","text":"","category":"section"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"There are currently four sorting algorithms publicly available in base Julia:","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"InsertionSort\nQuickSort\nPartialQuickSort(k)\nMergeSort","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"By default, the sort family of functions uses stable sorting algorithms that are fast on most inputs. The exact algorithm choice is an implementation detail to allow for future performance improvements. Currently, a hybrid of RadixSort, ScratchQuickSort, InsertionSort, and CountingSort is used based on input type, size, and composition. Implementation details are subject to change but currently available in the extended help of ??Base.DEFAULT_STABLE and the docstrings of internal sorting algorithms listed there.","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"You can explicitly specify your preferred algorithm with the alg keyword (e.g. sort!(v, alg=PartialQuickSort(10:20))) or reconfigure the default sorting algorithm for custom types by adding a specialized method to the Base.Sort.defalg function. For example, InlineStrings.jl defines the following method:","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"Base.Sort.defalg(::AbstractArray{<:Union{SmallInlineStrings, Missing}}) = InlineStringSort","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"compat: Julia 1.9\nThe default sorting algorithm (returned by Base.Sort.defalg) is guaranteed to be stable since Julia 1.9. Previous versions had unstable edge cases when sorting numeric arrays.","category":"page"},{"location":"base/sort.html#Alternate-Orderings","page":"Sorting and Related Functions","title":"Alternate Orderings","text":"","category":"section"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"By default, sort, searchsorted, and related functions use isless to compare two elements in order to determine which should come first. The Base.Order.Ordering abstract type provides a mechanism for defining alternate orderings on the same set of elements: when calling a sorting function like sort!, an instance of Ordering can be provided with the keyword argument order.","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"Instances of Ordering define an order through the Base.Order.lt function, which works as a generalization of isless. This function's behavior on custom Orderings must satisfy all the conditions of a strict weak order. See sort! for details and examples of valid and invalid lt functions.","category":"page"},{"location":"base/sort.html","page":"Sorting and Related Functions","title":"Sorting and Related Functions","text":"Base.Order.Ordering\nBase.Order.lt\nBase.Order.ord\nBase.Order.Forward\nBase.Order.ReverseOrdering\nBase.Order.Reverse\nBase.Order.By\nBase.Order.Lt\nBase.Order.Perm","category":"page"},{"location":"base/sort.html#Base.Order.Ordering","page":"Sorting and Related Functions","title":"Base.Order.Ordering","text":"Base.Order.Ordering\n\nAbstract type which represents a strict weak order on some set of elements. See sort! for more.\n\nUse Base.Order.lt to compare two elements according to the ordering.\n\n\n\n\n\n","category":"type"},{"location":"base/sort.html#Base.Order.lt","page":"Sorting and Related Functions","title":"Base.Order.lt","text":"lt(o::Ordering, a, b) -> Bool\n\nTest whether a is less than b according to the ordering o.\n\n\n\n\n\n","category":"function"},{"location":"base/sort.html#Base.Order.ord","page":"Sorting and Related Functions","title":"Base.Order.ord","text":"ord(lt, by, rev::Union{Bool, Nothing}, order::Ordering=Forward)\n\nConstruct an Ordering object from the same arguments used by sort!. Elements are first transformed by the function by (which may be identity) and are then compared according to either the function lt or an existing ordering order. lt should be isless or a function that obeys the same rules as the lt parameter of sort!. Finally, the resulting order is reversed if rev=true.\n\nPassing an lt other than isless along with an order other than Base.Order.Forward or Base.Order.Reverse is not permitted, otherwise all options are independent and can be used together in all possible combinations.\n\n\n\n\n\n","category":"function"},{"location":"base/sort.html#Base.Order.Forward","page":"Sorting and Related Functions","title":"Base.Order.Forward","text":"Base.Order.Forward\n\nDefault ordering according to isless.\n\n\n\n\n\n","category":"constant"},{"location":"base/sort.html#Base.Order.ReverseOrdering","page":"Sorting and Related Functions","title":"Base.Order.ReverseOrdering","text":"ReverseOrdering(fwd::Ordering=Forward)\n\nA wrapper which reverses an ordering.\n\nFor a given Ordering o, the following holds for all  a, b:\n\nlt(ReverseOrdering(o), a, b) == lt(o, b, a)\n\n\n\n\n\n","category":"type"},{"location":"base/sort.html#Base.Order.Reverse","page":"Sorting and Related Functions","title":"Base.Order.Reverse","text":"Base.Order.Reverse\n\nReverse ordering according to isless.\n\n\n\n\n\n","category":"constant"},{"location":"base/sort.html#Base.Order.By","page":"Sorting and Related Functions","title":"Base.Order.By","text":"By(by, order::Ordering=Forward)\n\nOrdering which applies order to elements after they have been transformed by the function by.\n\n\n\n\n\n","category":"type"},{"location":"base/sort.html#Base.Order.Lt","page":"Sorting and Related Functions","title":"Base.Order.Lt","text":"Lt(lt)\n\nOrdering that calls lt(a, b) to compare elements. lt must obey the same rules as the lt parameter of sort!.\n\n\n\n\n\n","category":"type"},{"location":"base/sort.html#Base.Order.Perm","page":"Sorting and Related Functions","title":"Base.Order.Perm","text":"Perm(order::Ordering, data::AbstractVector)\n\nOrdering on the indices of data where i is less than j if data[i] is less than data[j] according to order. In the case that data[i] and data[j] are equal, i and j are compared by numeric value.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Base64.html","page":"Base64","title":"Base64","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/stdlib/Base64/docs/src/index.md\"","category":"page"},{"location":"stdlib/Base64.html#Base64","page":"Base64","title":"Base64","text":"","category":"section"},{"location":"stdlib/Base64.html","page":"Base64","title":"Base64","text":"Base64.Base64\nBase64.Base64EncodePipe\nBase64.base64encode\nBase64.Base64DecodePipe\nBase64.base64decode\nBase64.stringmime","category":"page"},{"location":"stdlib/Base64.html#Base64.Base64","page":"Base64","title":"Base64.Base64","text":"Base64\n\nFunctionality for base64 encoding and decoding, a method to represent binary data using text, common on the web.\n\n\n\n\n\n","category":"module"},{"location":"stdlib/Base64.html#Base64.Base64EncodePipe","page":"Base64","title":"Base64.Base64EncodePipe","text":"Base64EncodePipe(ostream)\n\nReturn a new write-only I/O stream, which converts any bytes written to it into base64-encoded ASCII bytes written to ostream.  Calling close on the Base64EncodePipe stream is necessary to complete the encoding (but does not close ostream).\n\nExamples\n\njulia> io = IOBuffer();\n\njulia> iob64_encode = Base64EncodePipe(io);\n\njulia> write(iob64_encode, \"Hello!\")\n6\n\njulia> close(iob64_encode);\n\njulia> str = String(take!(io))\n\"SGVsbG8h\"\n\njulia> String(base64decode(str))\n\"Hello!\"\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Base64.html#Base64.base64encode","page":"Base64","title":"Base64.base64encode","text":"base64encode(writefunc, args...; context=nothing)\nbase64encode(args...; context=nothing)\n\nGiven a write-like function writefunc, which takes an I/O stream as its first argument, base64encode(writefunc, args...) calls writefunc to write args... to a base64-encoded string, and returns the string. base64encode(args...) is equivalent to base64encode(write, args...): it converts its arguments into bytes using the standard write functions and returns the base64-encoded string.\n\nThe optional keyword argument context can be set to :key=>value pair or an IO or IOContext object whose attributes are used for the I/O stream passed to writefunc or write.\n\nSee also base64decode.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Base64.html#Base64.Base64DecodePipe","page":"Base64","title":"Base64.Base64DecodePipe","text":"Base64DecodePipe(istream)\n\nReturn a new read-only I/O stream, which decodes base64-encoded data read from istream.\n\nExamples\n\njulia> io = IOBuffer();\n\njulia> iob64_decode = Base64DecodePipe(io);\n\njulia> write(io, \"SGVsbG8h\")\n8\n\njulia> seekstart(io);\n\njulia> String(read(iob64_decode))\n\"Hello!\"\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Base64.html#Base64.base64decode","page":"Base64","title":"Base64.base64decode","text":"base64decode(string)\n\nDecode the base64-encoded string and returns a Vector{UInt8} of the decoded bytes.\n\nSee also base64encode.\n\nExamples\n\njulia> b = base64decode(\"SGVsbG8h\")\n6-element Vector{UInt8}:\n 0x48\n 0x65\n 0x6c\n 0x6c\n 0x6f\n 0x21\n\njulia> String(b)\n\"Hello!\"\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Base64.html#Base64.stringmime","page":"Base64","title":"Base64.stringmime","text":"stringmime(mime, x; context=nothing)\n\nReturn an AbstractString containing the representation of x in the requested mime type. This is similar to repr(mime, x) except that binary data is base64-encoded as an ASCII string.\n\nThe optional keyword argument context can be set to :key=>value pair or an IO or IOContext object whose attributes are used for the I/O stream passed to show.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/FileWatching.html","page":"File Events","title":"File Events","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/stdlib/FileWatching/docs/src/index.md\"","category":"page"},{"location":"stdlib/FileWatching.html#lib-filewatching","page":"File Events","title":"File Events","text":"","category":"section"},{"location":"stdlib/FileWatching.html","page":"File Events","title":"File Events","text":"FileWatching.poll_fd\nFileWatching.poll_file\nFileWatching.watch_file\nFileWatching.watch_folder\nFileWatching.unwatch_folder","category":"page"},{"location":"stdlib/FileWatching.html#FileWatching.poll_fd","page":"File Events","title":"FileWatching.poll_fd","text":"poll_fd(fd, timeout_s::Real=-1; readable=false, writable=false)\n\nMonitor a file descriptor fd for changes in the read or write availability, and with a timeout given by timeout_s seconds.\n\nThe keyword arguments determine which of read and/or write status should be monitored; at least one of them must be set to true.\n\nThe returned value is an object with boolean fields readable, writable, and timedout, giving the result of the polling.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/FileWatching.html#FileWatching.poll_file","page":"File Events","title":"FileWatching.poll_file","text":"poll_file(path::AbstractString, interval_s::Real=5.007, timeout_s::Real=-1) -> (previous::StatStruct, current)\n\nMonitor a file for changes by polling every interval_s seconds until a change occurs or timeout_s seconds have elapsed. The interval_s should be a long period; the default is 5.007 seconds.\n\nReturns a pair of status objects (previous, current) when a change is detected. The previous status is always a StatStruct, but it may have all of the fields zeroed (indicating the file didn't previously exist, or wasn't previously accessible).\n\nThe current status object may be a StatStruct, an EOFError (indicating the timeout elapsed), or some other Exception subtype (if the stat operation failed - for example, if the path does not exist).\n\nTo determine when a file was modified, compare current isa StatStruct && mtime(prev) != mtime(current) to detect notification of changes. However, using watch_file for this operation is preferred, since it is more reliable and efficient, although in some situations it may not be available.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/FileWatching.html#FileWatching.watch_file","page":"File Events","title":"FileWatching.watch_file","text":"watch_file(path::AbstractString, timeout_s::Real=-1)\n\nWatch file or directory path for changes until a change occurs or timeout_s seconds have elapsed. This function does not poll the file system and instead uses platform-specific functionality to receive notifications from the operating system (e.g. via inotify on Linux). See the NodeJS documentation linked below for details.\n\nThe returned value is an object with boolean fields renamed, changed, and timedout, giving the result of watching the file.\n\nThis behavior of this function varies slightly across platforms. See https://nodejs.org/api/fs.html#fs_caveats for more detailed information.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/FileWatching.html#FileWatching.watch_folder","page":"File Events","title":"FileWatching.watch_folder","text":"watch_folder(path::AbstractString, timeout_s::Real=-1)\n\nWatches a file or directory path for changes until a change has occurred or timeout_s seconds have elapsed. This function does not poll the file system and instead uses platform-specific functionality to receive notifications from the operating system (e.g. via inotify on Linux). See the NodeJS documentation linked below for details.\n\nThis will continuing tracking changes for path in the background until unwatch_folder is called on the same path.\n\nThe returned value is an pair where the first field is the name of the changed file (if available) and the second field is an object with boolean fields renamed, changed, and timedout, giving the event.\n\nThis behavior of this function varies slightly across platforms. See https://nodejs.org/api/fs.html#fs_caveats for more detailed information.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/FileWatching.html#FileWatching.unwatch_folder","page":"File Events","title":"FileWatching.unwatch_folder","text":"unwatch_folder(path::AbstractString)\n\nStop background tracking of changes for path. It is not recommended to do this while another task is waiting for watch_folder to return on the same path, as the result may be unpredictable.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/FileWatching.html#Pidfile","page":"File Events","title":"Pidfile","text":"","category":"section"},{"location":"stdlib/FileWatching.html","page":"File Events","title":"File Events","text":"CurrentModule = FileWatching.Pidfile","category":"page"},{"location":"stdlib/FileWatching.html","page":"File Events","title":"File Events","text":"A simple utility tool for creating advisory pidfiles (lock files).","category":"page"},{"location":"stdlib/FileWatching.html#Primary-Functions","page":"File Events","title":"Primary Functions","text":"","category":"section"},{"location":"stdlib/FileWatching.html","page":"File Events","title":"File Events","text":"mkpidlock\ntrymkpidlock\nclose(lock::LockMonitor)","category":"page"},{"location":"stdlib/FileWatching.html#FileWatching.Pidfile.mkpidlock","page":"File Events","title":"FileWatching.Pidfile.mkpidlock","text":"mkpidlock([f::Function], at::String, [pid::Cint]; kwopts...)\nmkpidlock(at::String, proc::Process; kwopts...)\n\nCreate a pidfile lock for the path \"at\" for the current process or the process identified by pid or proc. Can take a function to execute once locked, for usage in do blocks, after which the lock will be automatically closed. If the lock fails and wait is false, then an error is thrown.\n\nThe lock will be released by either close, a finalizer, or shortly after proc exits. Make sure the return value is live through the end of the critical section of your program, so the finalizer does not reclaim it early.\n\nOptional keyword arguments:\n\nmode: file access mode (modified by the process umask). Defaults to world-readable.\npoll_interval: Specify the maximum time to between attempts (if watch_file doesn't work)\nstale_age: Delete an existing pidfile (ignoring the lock) if it is older than this many seconds, based on its mtime.   The file won't be deleted until 5x longer than this if the pid in the file appears that it may be valid.   Or 25x longer if refresh is overridden to 0 to disable lock refreshing.   By default this is disabled (stale_age = 0), but a typical recommended value would be about 3-5x an   estimated normal completion time.\nrefresh: Keeps a lock from becoming stale by updating the mtime every interval of time that passes.   By default, this is set to stale_age/2, which is the recommended value.\nwait: If true, block until we get the lock, if false, raise error if lock fails.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/FileWatching.html#FileWatching.Pidfile.trymkpidlock","page":"File Events","title":"FileWatching.Pidfile.trymkpidlock","text":"trymkpidlock([f::Function], at::String, [pid::Cint]; kwopts...)\ntrymkpidlock(at::String, proc::Process; kwopts...)\n\nLike mkpidlock except returns false instead of waiting if the file is already locked.\n\ncompat: Julia 1.10\nThis function requires at least Julia 1.10.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/FileWatching.html#Base.close-Tuple{FileWatching.Pidfile.LockMonitor}","page":"File Events","title":"Base.close","text":"close(lock::LockMonitor)\n\nRelease a pidfile lock.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/FileWatching.html#Helper-Functions","page":"File Events","title":"Helper Functions","text":"","category":"section"},{"location":"stdlib/FileWatching.html","page":"File Events","title":"File Events","text":"Pidfile.open_exclusive\nPidfile.tryopen_exclusive\nPidfile.write_pidfile\nPidfile.parse_pidfile\nPidfile.stale_pidfile\nPidfile.isvalidpid\nBase.touch(::Pidfile.LockMonitor)","category":"page"},{"location":"stdlib/FileWatching.html#FileWatching.Pidfile.open_exclusive","page":"File Events","title":"FileWatching.Pidfile.open_exclusive","text":"open_exclusive(path::String; mode, poll_interval, wait, stale_age, refresh) :: File\n\nCreate a new a file for read-write advisory-exclusive access. If wait is false then error out if the lock files exist otherwise block until we get the lock.\n\nFor a description of the keyword arguments, see mkpidlock.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/FileWatching.html#FileWatching.Pidfile.tryopen_exclusive","page":"File Events","title":"FileWatching.Pidfile.tryopen_exclusive","text":"tryopen_exclusive(path::String, mode::Integer = 0o444) :: Union{Void, File}\n\nTry to create a new file for read-write advisory-exclusive access, return nothing if it already exists.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/FileWatching.html#FileWatching.Pidfile.write_pidfile","page":"File Events","title":"FileWatching.Pidfile.write_pidfile","text":"write_pidfile(io, pid)\n\nWrite our pidfile format to an open IO descriptor.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/FileWatching.html#FileWatching.Pidfile.parse_pidfile","page":"File Events","title":"FileWatching.Pidfile.parse_pidfile","text":"parse_pidfile(file::Union{IO, String}) => (pid, hostname, age)\n\nAttempt to parse our pidfile format, replaced an element with (0, \"\", 0.0), respectively, for any read that failed.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/FileWatching.html#FileWatching.Pidfile.stale_pidfile","page":"File Events","title":"FileWatching.Pidfile.stale_pidfile","text":"stale_pidfile(path::String, stale_age::Real, refresh::Real) :: Bool\n\nHelper function for open_exclusive for deciding if a pidfile is stale.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/FileWatching.html#FileWatching.Pidfile.isvalidpid","page":"File Events","title":"FileWatching.Pidfile.isvalidpid","text":"isvalidpid(hostname::String, pid::Cuint) :: Bool\n\nAttempt to conservatively estimate whether pid is a valid process id.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/FileWatching.html#Base.Filesystem.touch-Tuple{FileWatching.Pidfile.LockMonitor}","page":"File Events","title":"Base.Filesystem.touch","text":"Base.touch(::Pidfile.LockMonitor)\n\nUpdate the mtime on the lock, to indicate it is still fresh.\n\nSee also the refresh keyword in the mkpidlock constructor.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/stdlib/Logging/docs/src/index.md\"","category":"page"},{"location":"stdlib/Logging.html#man-logging","page":"Logging","title":"Logging","text":"","category":"section"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"The Logging module provides a way to record the history and progress of a computation as a log of events.  Events are created by inserting a logging statement into the source code, for example:","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"@warn \"Abandon printf debugging, all ye who enter here!\"\n┌ Warning: Abandon printf debugging, all ye who enter here!\n└ @ Main REPL[1]:1","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"The system provides several advantages over peppering your source code with calls to println().  First, it allows you to control the visibility and presentation of messages without editing the source code.  For example, in contrast to the @warn above","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"@debug \"The sum of some values $(sum(rand(100)))\"","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"will produce no output by default.  Furthermore, it's very cheap to leave debug statements like this in the source code because the system avoids evaluating the message if it would later be ignored.  In this case sum(rand(100)) and the associated string processing will never be executed unless debug logging is enabled.","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Second, the logging tools allow you to attach arbitrary data to each event as a set of key–value pairs. This allows you to capture local variables and other program state for later analysis. For example, to attach the local array variable A and the sum of a vector v as the key s you can use","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"A = ones(Int, 4, 4)\nv = ones(100)\n@info \"Some variables\"  A  s=sum(v)\n\n# output\n┌ Info: Some variables\n│   A =\n│    4×4 Matrix{Int64}:\n│     1  1  1  1\n│     1  1  1  1\n│     1  1  1  1\n│     1  1  1  1\n└   s = 100.0","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"All of the logging macros @debug, @info, @warn and @error share common features that are described in detail in the documentation for the more general macro @logmsg.","category":"page"},{"location":"stdlib/Logging.html#Log-event-structure","page":"Logging","title":"Log event structure","text":"","category":"section"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Each event generates several pieces of data, some provided by the user and some automatically extracted. Let's examine the user-defined data first:","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"The log level is a broad category for the message that is used for early filtering. There are several standard levels of type LogLevel; user-defined levels are also possible. Each is distinct in purpose:\nLogging.Debug (log level -1000) is information intended for the developer of the program. These events are disabled by default.\nLogging.Info (log level 0) is for general information to the user. Think of it as an alternative to using println directly.\nLogging.Warn (log level 1000) means something is wrong and action is likely required but that for now the program is still working.\nLogging.Error (log level 2000) means something is wrong and it is unlikely to be recovered, at least by this part of the code. Often this log-level is unneeded as throwing an exception can convey all the required information.\nThe message  is an object describing the event. By convention AbstractStrings passed as messages are assumed to be in markdown format. Other types will be displayed using print(io, obj) or string(obj) for text-based output and possibly show(io,mime,obj) for other multimedia displays used in the installed logger.\nOptional key–value pairs allow arbitrary data to be attached to each event. Some keys have conventional meaning that can affect the way an event is interpreted (see @logmsg).","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"The system also generates some standard information for each event:","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"The module in which the logging macro was expanded.\nThe file and line where the logging macro occurs in the source code.\nA message id that is a unique, fixed identifier for the source code statement where the logging macro appears. This identifier is designed to be fairly stable even if the source code of the file changes, as long as the logging statement itself remains the same.\nA group for the event, which is set to the base name of the file by default, without extension.  This can be used to group messages into categories more finely than the log level (for example, all deprecation warnings have group :depwarn), or into logical groupings across or within modules.","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Notice that some useful information such as the event time is not included by default. This is because such information can be expensive to extract and is also dynamically available to the current logger. It's simple to define a custom logger to augment event data with the time, backtrace, values of global variables and other useful information as required.","category":"page"},{"location":"stdlib/Logging.html#Processing-log-events","page":"Logging","title":"Processing log events","text":"","category":"section"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"As you can see in the examples, logging statements make no mention of where log events go or how they are processed. This is a key design feature that makes the system composable and natural for concurrent use. It does this by separating two different concerns:","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Creating log events is the concern of the module author who needs to decide where events are triggered and which information to include.\nProcessing of log events — that is, display, filtering, aggregation and recording — is the concern of the application author who needs to bring multiple modules together into a cooperating application.","category":"page"},{"location":"stdlib/Logging.html#Loggers","page":"Logging","title":"Loggers","text":"","category":"section"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Processing of events is performed by a logger, which is the first piece of user configurable code to see the event. All loggers must be subtypes of AbstractLogger.","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"When an event is triggered, the appropriate logger is found by looking for a task-local logger with the global logger as fallback.  The idea here is that the application code knows how log events should be processed and exists somewhere at the top of the call stack. So we should look up through the call stack to discover the logger — that is, the logger should be dynamically scoped. (This is a point of contrast with logging frameworks where the logger is lexically scoped; provided explicitly by the module author or as a simple global variable. In such a system it's awkward to control logging while composing functionality from multiple modules.)","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"The global logger may be set with global_logger, and task-local loggers controlled using with_logger.  Newly spawned tasks inherit the logger of the parent task.","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"There are three logger types provided by the library.  ConsoleLogger is the default logger you see when starting the REPL.  It displays events in a readable text format and tries to give simple but user friendly control over formatting and filtering.  NullLogger is a convenient way to drop all messages where necessary; it is the logging equivalent of the devnull stream.  SimpleLogger is a very simplistic text formatting logger, mainly useful for debugging the logging system itself.","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Custom loggers should come with overloads for the functions described in the reference section.","category":"page"},{"location":"stdlib/Logging.html#Early-filtering-and-message-handling","page":"Logging","title":"Early filtering and message handling","text":"","category":"section"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"When an event occurs, a few steps of early filtering occur to avoid generating messages that will be discarded:","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"The message log level is checked against a global minimum level (set via disable_logging).  This is a crude but extremely cheap global setting.\nThe current logger state is looked up and the message level checked against the logger's cached minimum level, as found by calling Logging.min_enabled_level. This behavior can be overridden via environment variables (more on this later).\nThe Logging.shouldlog function is called with the current logger, taking some minimal information (level, module, group, id) which can be computed statically.  Most usefully, shouldlog is passed an event id which can be used to discard events early based on a cached predicate.","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"If all these checks pass, the message and key–value pairs are evaluated in full and passed to the current logger via the Logging.handle_message function. handle_message() may perform additional filtering as required and display the event to the screen, save it to a file, etc.","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Exceptions that occur while generating the log event are captured and logged by default.  This prevents individual broken events from crashing the application, which is helpful when enabling little-used debug events in a production system.  This behavior can be customized per logger type by extending Logging.catch_exceptions.","category":"page"},{"location":"stdlib/Logging.html#Testing-log-events","page":"Logging","title":"Testing log events","text":"","category":"section"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Log events are a side effect of running normal code, but you might find yourself wanting to test particular informational messages and warnings. The Test module provides a @test_logs macro that can be used to pattern match against the log event stream.","category":"page"},{"location":"stdlib/Logging.html#Environment-variables","page":"Logging","title":"Environment variables","text":"","category":"section"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Message filtering can be influenced through the JULIA_DEBUG environment variable, and serves as an easy way to enable debug logging for a file or module. Loading julia with JULIA_DEBUG=loading will activate @debug log messages in loading.jl. For example, in Linux shells:","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"$ JULIA_DEBUG=loading julia -e 'using OhMyREPL'\n┌ Debug: Rejecting cache file /home/user/.julia/compiled/v0.7/OhMyREPL.ji due to it containing an incompatible cache header\n└ @ Base loading.jl:1328\n[ Info: Recompiling stale cache file /home/user/.julia/compiled/v0.7/OhMyREPL.ji for module OhMyREPL\n┌ Debug: Rejecting cache file /home/user/.julia/compiled/v0.7/Tokenize.ji due to it containing an incompatible cache header\n└ @ Base loading.jl:1328\n...","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"On windows, the same can be achieved in CMD via first running set JULIA_DEBUG=\"loading\" and in Powershell via $env:JULIA_DEBUG=\"loading\".","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Similarly, the environment variable can be used to enable debug logging of modules, such as Pkg, or module roots (see Base.moduleroot). To enable all debug logging, use the special value all.","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"To turn debug logging on from the REPL, set ENV[\"JULIA_DEBUG\"] to the name of the module of interest. Functions defined in the REPL belong to module Main; logging for them can be enabled like this:","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"julia> foo() = @debug \"foo\"\nfoo (generic function with 1 method)\n\njulia> foo()\n\njulia> ENV[\"JULIA_DEBUG\"] = Main\nMain\n\njulia> foo()\n┌ Debug: foo\n└ @ Main REPL[1]:1\n","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Use a comma separator to enable debug for multiple modules: JULIA_DEBUG=loading,Main.","category":"page"},{"location":"stdlib/Logging.html#Examples","page":"Logging","title":"Examples","text":"","category":"section"},{"location":"stdlib/Logging.html#Example:-Writing-log-events-to-a-file","page":"Logging","title":"Example: Writing log events to a file","text":"","category":"section"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Sometimes it can be useful to write log events to a file. Here is an example of how to use a task-local and global logger to write information to a text file:","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"# Load the logging module\njulia> using Logging\n\n# Open a textfile for writing\njulia> io = open(\"log.txt\", \"w+\")\nIOStream(<file log.txt>)\n\n# Create a simple logger\njulia> logger = SimpleLogger(io)\nSimpleLogger(IOStream(<file log.txt>), Info, Dict{Any,Int64}())\n\n# Log a task-specific message\njulia> with_logger(logger) do\n           @info(\"a context specific log message\")\n       end\n\n# Write all buffered messages to the file\njulia> flush(io)\n\n# Set the global logger to logger\njulia> global_logger(logger)\nSimpleLogger(IOStream(<file log.txt>), Info, Dict{Any,Int64}())\n\n# This message will now also be written to the file\njulia> @info(\"a global log message\")\n\n# Close the file\njulia> close(io)","category":"page"},{"location":"stdlib/Logging.html#Example:-Enable-debug-level-messages","page":"Logging","title":"Example: Enable debug-level messages","text":"","category":"section"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Here is an example of creating a ConsoleLogger that lets through any messages with log level higher than, or equal, to Logging.Debug.","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"julia> using Logging\n\n# Create a ConsoleLogger that prints any log messages with level >= Debug to stderr\njulia> debuglogger = ConsoleLogger(stderr, Logging.Debug)\n\n# Enable debuglogger for a task\njulia> with_logger(debuglogger) do\n           @debug \"a context specific log message\"\n       end\n\n# Set the global logger\njulia> global_logger(debuglogger)","category":"page"},{"location":"stdlib/Logging.html#Reference","page":"Logging","title":"Reference","text":"","category":"section"},{"location":"stdlib/Logging.html#Logging-module","page":"Logging","title":"Logging module","text":"","category":"section"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Logging.Logging","category":"page"},{"location":"stdlib/Logging.html#Logging.Logging","page":"Logging","title":"Logging.Logging","text":"Utilities for capturing, filtering and presenting streams of log events. Normally you don't need to import Logging to create log events; for this the standard logging macros such as @info are already exported by Base and available by default.\n\n\n\n\n\n","category":"module"},{"location":"stdlib/Logging.html#Creating-events","page":"Logging","title":"Creating events","text":"","category":"section"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Logging.@logmsg\nLogging.LogLevel\nLogging.Debug\nLogging.Info\nLogging.Warn\nLogging.Error\nLogging.BelowMinLevel\nLogging.AboveMaxLevel","category":"page"},{"location":"stdlib/Logging.html#Logging.@logmsg","page":"Logging","title":"Logging.@logmsg","text":"@debug message  [key=value | value ...]\n@info  message  [key=value | value ...]\n@warn  message  [key=value | value ...]\n@error message  [key=value | value ...]\n\n@logmsg level message [key=value | value ...]\n\nCreate a log record with an informational message.  For convenience, four logging macros @debug, @info, @warn and @error are defined which log at the standard severity levels Debug, Info, Warn and Error.  @logmsg allows level to be set programmatically to any LogLevel or custom log level types.\n\nmessage should be an expression which evaluates to a string which is a human readable description of the log event.  By convention, this string will be formatted as markdown when presented.\n\nThe optional list of key=value pairs supports arbitrary user defined metadata which will be passed through to the logging backend as part of the log record.  If only a value expression is supplied, a key representing the expression will be generated using Symbol. For example, x becomes x=x, and foo(10) becomes Symbol(\"foo(10)\")=foo(10).  For splatting a list of key value pairs, use the normal splatting syntax, @info \"blah\" kws....\n\nThere are some keys which allow automatically generated log data to be overridden:\n\n_module=mod can be used to specify a different originating module from the source location of the message.\n_group=symbol can be used to override the message group (this is normally derived from the base name of the source file).\n_id=symbol can be used to override the automatically generated unique message identifier.  This is useful if you need to very closely associate messages generated on different source lines.\n_file=string and _line=integer can be used to override the apparent source location of a log message.\n\nThere's also some key value pairs which have conventional meaning:\n\nmaxlog=integer should be used as a hint to the backend that the message should be displayed no more than maxlog times.\nexception=ex should be used to transport an exception with a log message, often used with @error. An associated backtrace bt may be attached using the tuple exception=(ex,bt).\n\nExamples\n\n@debug \"Verbose debugging information.  Invisible by default\"\n@info  \"An informational message\"\n@warn  \"Something was odd.  You should pay attention\"\n@error \"A non fatal error occurred\"\n\nx = 10\n@info \"Some variables attached to the message\" x a=42.0\n\n@debug begin\n    sA = sum(A)\n    \"sum(A) = $sA is an expensive operation, evaluated only when `shouldlog` returns true\"\nend\n\nfor i=1:10000\n    @info \"With the default backend, you will only see (i = $i) ten times\"  maxlog=10\n    @debug \"Algorithm1\" i progress=i/10000\nend\n\n\n\n\n\n","category":"macro"},{"location":"stdlib/Logging.html#Logging.LogLevel","page":"Logging","title":"Logging.LogLevel","text":"LogLevel(level)\n\nSeverity/verbosity of a log record.\n\nThe log level provides a key against which potential log records may be filtered, before any other work is done to construct the log record data structure itself.\n\nExamples\n\njulia> Logging.LogLevel(0) == Logging.Info\ntrue\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Logging.html#Logging.Debug","page":"Logging","title":"Logging.Debug","text":"Debug\n\nAlias for LogLevel(-1000).\n\n\n\n\n\n","category":"constant"},{"location":"stdlib/Logging.html#Logging.Info","page":"Logging","title":"Logging.Info","text":"Info\n\nAlias for LogLevel(0).\n\n\n\n\n\n","category":"constant"},{"location":"stdlib/Logging.html#Logging.Warn","page":"Logging","title":"Logging.Warn","text":"Warn\n\nAlias for LogLevel(1000).\n\n\n\n\n\n","category":"constant"},{"location":"stdlib/Logging.html#Logging.Error","page":"Logging","title":"Logging.Error","text":"Error\n\nAlias for LogLevel(2000).\n\n\n\n\n\n","category":"constant"},{"location":"stdlib/Logging.html#Logging.BelowMinLevel","page":"Logging","title":"Logging.BelowMinLevel","text":"BelowMinLevel\n\nAlias for LogLevel(-1_000_001).\n\n\n\n\n\n","category":"constant"},{"location":"stdlib/Logging.html#Logging.AboveMaxLevel","page":"Logging","title":"Logging.AboveMaxLevel","text":"AboveMaxLevel\n\nAlias for LogLevel(1_000_001).\n\n\n\n\n\n","category":"constant"},{"location":"stdlib/Logging.html#AbstractLogger-interface","page":"Logging","title":"Processing events with AbstractLogger","text":"","category":"section"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Event processing is controlled by overriding functions associated with AbstractLogger:","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Methods to implement  Brief description\nLogging.handle_message  Handle a log event\nLogging.shouldlog  Early filtering of events\nLogging.min_enabled_level  Lower bound for log level of accepted events\nOptional methods Default definition Brief description\nLogging.catch_exceptions true Catch exceptions during event evaluation","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Logging.AbstractLogger\nLogging.handle_message\nLogging.shouldlog\nLogging.min_enabled_level\nLogging.catch_exceptions\nLogging.disable_logging","category":"page"},{"location":"stdlib/Logging.html#Logging.AbstractLogger","page":"Logging","title":"Logging.AbstractLogger","text":"A logger controls how log records are filtered and dispatched.  When a log record is generated, the logger is the first piece of user configurable code which gets to inspect the record and decide what to do with it.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Logging.html#Logging.handle_message","page":"Logging","title":"Logging.handle_message","text":"handle_message(logger, level, message, _module, group, id, file, line; key1=val1, ...)\n\nLog a message to logger at level.  The logical location at which the message was generated is given by module _module and group; the source location by file and line. id is an arbitrary unique value (typically a Symbol) to be used as a key to identify the log statement when filtering.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Logging.html#Logging.shouldlog","page":"Logging","title":"Logging.shouldlog","text":"shouldlog(logger, level, _module, group, id)\n\nReturn true when logger accepts a message at level, generated for _module, group and with unique log identifier id.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Logging.html#Logging.min_enabled_level","page":"Logging","title":"Logging.min_enabled_level","text":"min_enabled_level(logger)\n\nReturn the minimum enabled level for logger for early filtering.  That is, the log level below or equal to which all messages are filtered.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Logging.html#Logging.catch_exceptions","page":"Logging","title":"Logging.catch_exceptions","text":"catch_exceptions(logger)\n\nReturn true if the logger should catch exceptions which happen during log record construction.  By default, messages are caught\n\nBy default all exceptions are caught to prevent log message generation from crashing the program.  This lets users confidently toggle little-used functionality - such as debug logging - in a production system.\n\nIf you want to use logging as an audit trail you should disable this for your logger type.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Logging.html#Logging.disable_logging","page":"Logging","title":"Logging.disable_logging","text":"disable_logging(level)\n\nDisable all log messages at log levels equal to or less than level.  This is a global setting, intended to make debug logging extremely cheap when disabled. Note that this cannot be used to enable logging that is currently disabled by other mechanisms.\n\nExamples\n\nLogging.disable_logging(Logging.Info) # Disable debug and info\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Logging.html#Using-Loggers","page":"Logging","title":"Using Loggers","text":"","category":"section"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Logger installation and inspection:","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Logging.global_logger\nLogging.with_logger\nLogging.current_logger","category":"page"},{"location":"stdlib/Logging.html#Logging.global_logger","page":"Logging","title":"Logging.global_logger","text":"global_logger()\n\nReturn the global logger, used to receive messages when no specific logger exists for the current task.\n\nglobal_logger(logger)\n\nSet the global logger to logger, and return the previous global logger.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Logging.html#Logging.with_logger","page":"Logging","title":"Logging.with_logger","text":"with_logger(function, logger)\n\nExecute function, directing all log messages to logger.\n\nExamples\n\nfunction test(x)\n    @info \"x = $x\"\nend\n\nwith_logger(logger) do\n    test(1)\n    test([1,2])\nend\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Logging.html#Logging.current_logger","page":"Logging","title":"Logging.current_logger","text":"current_logger()\n\nReturn the logger for the current task, or the global logger if none is attached to the task.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Loggers that are supplied with the system:","category":"page"},{"location":"stdlib/Logging.html","page":"Logging","title":"Logging","text":"Logging.NullLogger\nLogging.ConsoleLogger\nLogging.SimpleLogger","category":"page"},{"location":"stdlib/Logging.html#Logging.NullLogger","page":"Logging","title":"Logging.NullLogger","text":"NullLogger()\n\nLogger which disables all messages and produces no output - the logger equivalent of /dev/null.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Logging.html#Base.CoreLogging.ConsoleLogger","page":"Logging","title":"Base.CoreLogging.ConsoleLogger","text":"ConsoleLogger([stream,] min_level=Info; meta_formatter=default_metafmt,\n              show_limited=true, right_justify=0)\n\nLogger with formatting optimized for readability in a text console, for example interactive work with the Julia REPL.\n\nLog levels less than min_level are filtered out.\n\nThis Logger is thread-safe, with locks for both orchestration of message limits i.e. maxlog, and writes to the stream.\n\nMessage formatting can be controlled by setting keyword arguments:\n\nmeta_formatter is a function which takes the log event metadata (level, _module, group, id, file, line) and returns a color (as would be passed to printstyled), prefix and suffix for the log message.  The default is to prefix with the log level and a suffix containing the module, file and line location.\nshow_limited limits the printing of large data structures to something which can fit on the screen by setting the :limit IOContext key during formatting.\nright_justify is the integer column which log metadata is right justified at. The default is zero (metadata goes on its own line).\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Logging.html#Logging.SimpleLogger","page":"Logging","title":"Logging.SimpleLogger","text":"SimpleLogger([stream,] min_level=Info)\n\nSimplistic logger for logging all messages with level greater than or equal to min_level to stream. If stream is closed then messages with log level greater or equal to Warn will be logged to stderr and below to stdout.\n\nThis Logger is thread-safe, with a lock taken around orchestration of message limits i.e. maxlog, and writes to the stream.\n\n\n\n\n\n","category":"type"},{"location":"devdocs/valgrind.html#Using-Valgrind-with-Julia","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"","category":"section"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"Valgrind is a tool for memory debugging, memory leak detection, and profiling.  This section describes things to keep in mind when using Valgrind to debug memory issues with Julia.","category":"page"},{"location":"devdocs/valgrind.html#General-considerations","page":"Using Valgrind with Julia","title":"General considerations","text":"","category":"section"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"By default, Valgrind assumes that there is no self modifying code in the programs it runs.  This assumption works fine in most instances but fails miserably for a just-in-time compiler like julia.  For this reason it is crucial to pass --smc-check=all-non-file to valgrind, else code may crash or behave unexpectedly (often in subtle ways).","category":"page"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"In some cases, to better detect memory errors using Valgrind, it can help to compile julia with memory pools disabled.  The compile-time flag MEMDEBUG disables memory pools in Julia, and MEMDEBUG2 disables memory pools in FemtoLisp.  To build julia with both flags, add the following line to Make.user:","category":"page"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"CFLAGS = -DMEMDEBUG -DMEMDEBUG2","category":"page"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"Another thing to note: if your program uses multiple worker processes, it is likely that you want all such worker processes to run under Valgrind, not just the parent process.  To do this, pass --trace-children=yes to valgrind.","category":"page"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"Yet another thing to note: if using valgrind errors with Unable to find compatible target in system image, try rebuilding the sysimage with target generic or julia with JULIA_CPU_TARGET=generic.","category":"page"},{"location":"devdocs/valgrind.html#Suppressions","page":"Using Valgrind with Julia","title":"Suppressions","text":"","category":"section"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"Valgrind will typically display spurious warnings as it runs.  To reduce the number of such warnings, it helps to provide a suppressions file to Valgrind.  A sample suppressions file is included in the Julia source distribution at contrib/valgrind-julia.supp.","category":"page"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"The suppressions file can be used from the julia/ source directory as follows:","category":"page"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"$ valgrind --smc-check=all-non-file --suppressions=contrib/valgrind-julia.supp ./julia progname.jl","category":"page"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"Any memory errors that are displayed should either be reported as bugs or contributed as additional suppressions.  Note that some versions of Valgrind are shipped with insufficient default suppressions, so that may be one thing to consider before submitting any bugs.","category":"page"},{"location":"devdocs/valgrind.html#Running-the-Julia-test-suite-under-Valgrind","page":"Using Valgrind with Julia","title":"Running the Julia test suite under Valgrind","text":"","category":"section"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"It is possible to run the entire Julia test suite under Valgrind, but it does take quite some time (typically several hours).  To do so, run the following command from the julia/test/ directory:","category":"page"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"valgrind --smc-check=all-non-file --trace-children=yes --suppressions=$PWD/../contrib/valgrind-julia.supp ../julia runtests.jl all","category":"page"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"If you would like to see a report of \"definite\" memory leaks, pass the flags --leak-check=full --show-leak-kinds=definite to valgrind as well.","category":"page"},{"location":"devdocs/valgrind.html#Additional-spurious-warnings","page":"Using Valgrind with Julia","title":"Additional spurious warnings","text":"","category":"section"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"This section covers Valgrind warnings that cannot be added to the suppressions file yet are nonetheless safe to ignore.","category":"page"},{"location":"devdocs/valgrind.html#Unhandled-rr-system-calls","page":"Using Valgrind with Julia","title":"Unhandled rr system calls","text":"","category":"section"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"Valgrind will emit a warning if it encounters any of the system calls that are specific to rr, the Record and Replay Framework.  In particular, a warning about an unhandled 1008 syscall will be shown when julia tries to detect whether it is running under rr:","category":"page"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"--xxxxxx-- WARNING: unhandled amd64-linux syscall: 1008\n--xxxxxx-- You may be able to write your own handler.\n--xxxxxx-- Read the file README_MISSING_SYSCALL_OR_IOCTL.\n--xxxxxx-- Nevertheless we consider this a bug.  Please report\n--xxxxxx-- it at http://valgrind.org/support/bug_reports.html.","category":"page"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"This issue has been reported to the Valgrind developers as they have requested.","category":"page"},{"location":"devdocs/valgrind.html#Caveats","page":"Using Valgrind with Julia","title":"Caveats","text":"","category":"section"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"Valgrind currently does not support multiple rounding modes, so code that adjusts the rounding mode will behave differently when run under Valgrind.","category":"page"},{"location":"devdocs/valgrind.html","page":"Using Valgrind with Julia","title":"Using Valgrind with Julia","text":"In general, if after setting --smc-check=all-non-file you find that your program behaves differently when run under Valgrind, it may help to pass --tool=none to valgrind as you investigate further.  This will enable the minimal Valgrind machinery but will also run much faster than when the full memory checker is enabled.","category":"page"},{"location":"manual/metaprogramming.html#Metaprogramming","page":"Metaprogramming","title":"Metaprogramming","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The strongest legacy of Lisp in the Julia language is its metaprogramming support. Like Lisp, Julia represents its own code as a data structure of the language itself. Since code is represented by objects that can be created and manipulated from within the language, it is possible for a program to transform and generate its own code. This allows sophisticated code generation without extra build steps, and also allows true Lisp-style macros operating at the level of abstract syntax trees. In contrast, preprocessor \"macro\" systems, like that of C and C++, perform textual manipulation and substitution before any actual parsing or interpretation occurs. Because all data types and code in Julia are represented by Julia data structures, powerful reflection capabilities are available to explore the internals of a program and its types just like any other data.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"warning: Warning\nMetaprogramming is a powerful tool, but it introduces complexity that can make code more difficult to understand. For example, it can be surprisingly hard to get scope rules correct. Metaprogramming should typically be used only when other approaches such as higher order functions and closures cannot be applied.eval and defining new macros should be typically used as a last resort. It is almost never a good idea to use Meta.parse or convert an arbitrary string into Julia code. For manipulating Julia code, use the Expr data structure directly to avoid the complexity of how Julia syntax is parsed.The best uses of metaprogramming often implement most of their functionality in runtime helper functions, striving to minimize the amount of code they generate.","category":"page"},{"location":"manual/metaprogramming.html#Program-representation","page":"Metaprogramming","title":"Program representation","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Every Julia program starts life as a string:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> prog = \"1 + 1\"\n\"1 + 1\"","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"What happens next?","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The next step is to parse each string into an object called an expression, represented by the Julia type Expr:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex1 = Meta.parse(prog)\n:(1 + 1)\n\njulia> typeof(ex1)\nExpr","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Expr objects contain two parts:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"a Symbol identifying the kind of expression. A symbol is an interned string identifier (more discussion below).","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex1.head\n:call","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"the expression arguments, which may be symbols, other expressions, or literal values:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex1.args\n3-element Vector{Any}:\n  :+\n 1\n 1","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Expressions may also be constructed directly in prefix notation:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex2 = Expr(:call, :+, 1, 1)\n:(1 + 1)","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The two expressions constructed above – by parsing and by direct construction – are equivalent:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex1 == ex2\ntrue","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The key point here is that Julia code is internally represented as a data structure that is accessible from the language itself.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The dump function provides indented and annotated display of Expr objects:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> dump(ex2)\nExpr\n  head: Symbol call\n  args: Array{Any}((3,))\n    1: Symbol +\n    2: Int64 1\n    3: Int64 1","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Expr objects may also be nested:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex3 = Meta.parse(\"(4 + 4) / 2\")\n:((4 + 4) / 2)","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Another way to view expressions is with Meta.show_sexpr, which displays the S-expression form of a given Expr, which may look very familiar to users of Lisp. Here's an example illustrating the display on a nested Expr:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> Meta.show_sexpr(ex3)\n(:call, :/, (:call, :+, 4, 4), 2)","category":"page"},{"location":"manual/metaprogramming.html#Symbols","page":"Metaprogramming","title":"Symbols","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The : character has two syntactic purposes in Julia. The first form creates a Symbol, an interned string used as one building-block of expressions, from valid identifiers:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> s = :foo\n:foo\n\njulia> typeof(s)\nSymbol","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The Symbol constructor takes any number of arguments and creates a new symbol by concatenating their string representations together:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> :foo === Symbol(\"foo\")\ntrue\n\njulia> Symbol(\"1foo\") # `:1foo` would not work, as `1foo` is not a valid identifier\nSymbol(\"1foo\")\n\njulia> Symbol(\"func\",10)\n:func10\n\njulia> Symbol(:var,'_',\"sym\")\n:var_sym","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"In the context of an expression, symbols are used to indicate access to variables; when an expression is evaluated, a symbol is replaced with the value bound to that symbol in the appropriate scope.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Sometimes extra parentheses around the argument to : are needed to avoid ambiguity in parsing:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> :(:)\n:(:)\n\njulia> :(::)\n:(::)","category":"page"},{"location":"manual/metaprogramming.html#Expressions-and-evaluation","page":"Metaprogramming","title":"Expressions and evaluation","text":"","category":"section"},{"location":"manual/metaprogramming.html#Quoting","page":"Metaprogramming","title":"Quoting","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The second syntactic purpose of the : character is to create expression objects without using the explicit Expr constructor. This is referred to as quoting. The : character, followed by paired parentheses around a single statement of Julia code, produces an Expr object based on the enclosed code. Here is an example of the short form used to quote an arithmetic expression:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex = :(a+b*c+1)\n:(a + b * c + 1)\n\njulia> typeof(ex)\nExpr","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"(to view the structure of this expression, try ex.head and ex.args, or use dump as above or Meta.@dump)","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Note that equivalent expressions may be constructed using Meta.parse or the direct Expr form:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia>      :(a + b*c + 1)       ==\n       Meta.parse(\"a + b*c + 1\") ==\n       Expr(:call, :+, :a, Expr(:call, :*, :b, :c), 1)\ntrue","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Expressions provided by the parser generally only have symbols, other expressions, and literal values as their args, whereas expressions constructed by Julia code can have arbitrary run-time values without literal forms as args. In this specific example, + and a are symbols, *(b,c) is a subexpression, and 1 is a literal 64-bit signed integer.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"There is a second syntactic form of quoting for multiple expressions: blocks of code enclosed in quote ... end.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex = quote\n           x = 1\n           y = 2\n           x + y\n       end\nquote\n    #= none:2 =#\n    x = 1\n    #= none:3 =#\n    y = 2\n    #= none:4 =#\n    x + y\nend\n\njulia> typeof(ex)\nExpr","category":"page"},{"location":"manual/metaprogramming.html#man-expression-interpolation","page":"Metaprogramming","title":"Interpolation","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Direct construction of Expr objects with value arguments is powerful, but Expr constructors can be tedious compared to \"normal\" Julia syntax. As an alternative, Julia allows interpolation of literals or expressions into quoted expressions. Interpolation is indicated by a prefix $.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"In this example, the value of variable a is interpolated:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> a = 1;\n\njulia> ex = :($a + b)\n:(1 + b)","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Interpolating into an unquoted expression is not supported and will cause a compile-time error:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> $a + b\nERROR: syntax: \"$\" expression outside quote","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"In this example, the tuple (1,2,3) is interpolated as an expression into a conditional test:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex = :(a in $:((1,2,3)) )\n:(a in (1, 2, 3))","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The use of $ for expression interpolation is intentionally reminiscent of string interpolation and command interpolation. Expression interpolation allows convenient, readable programmatic construction of complex Julia expressions.","category":"page"},{"location":"manual/metaprogramming.html#Splatting-interpolation","page":"Metaprogramming","title":"Splatting interpolation","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Notice that the $ interpolation syntax allows inserting only a single expression into an enclosing expression. Occasionally, you have an array of expressions and need them all to become arguments of the surrounding expression. This can be done with the syntax $(xs...). For example, the following code generates a function call where the number of arguments is determined programmatically:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> args = [:x, :y, :z];\n\njulia> :(f(1, $(args...)))\n:(f(1, x, y, z))","category":"page"},{"location":"manual/metaprogramming.html#Nested-quote","page":"Metaprogramming","title":"Nested quote","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Naturally, it is possible for quote expressions to contain other quote expressions. Understanding how interpolation works in these cases can be a bit tricky. Consider this example:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> x = :(1 + 2);\n\njulia> e = quote quote $x end end\nquote\n    #= none:1 =#\n    $(Expr(:quote, quote\n    #= none:1 =#\n    $(Expr(:$, :x))\nend))\nend","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Notice that the result contains $x, which means that x has not been evaluated yet. In other words, the $ expression \"belongs to\" the inner quote expression, and so its argument is only evaluated when the inner quote expression is:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> eval(e)\nquote\n    #= none:1 =#\n    1 + 2\nend","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"However, the outer quote expression is able to interpolate values inside the $ in the inner quote. This is done with multiple $s:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> e = quote quote $$x end end\nquote\n    #= none:1 =#\n    $(Expr(:quote, quote\n    #= none:1 =#\n    $(Expr(:$, :(1 + 2)))\nend))\nend","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Notice that (1 + 2) now appears in the result instead of the symbol x. Evaluating this expression yields an interpolated 3:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> eval(e)\nquote\n    #= none:1 =#\n    3\nend","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The intuition behind this behavior is that x is evaluated once for each $: one $ works similarly to eval(:x), giving x's value, while two $s do the equivalent of eval(eval(:x)).","category":"page"},{"location":"manual/metaprogramming.html#man-quote-node","page":"Metaprogramming","title":"QuoteNode","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The usual representation of a quote form in an AST is an Expr with head :quote:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> dump(Meta.parse(\":(1+2)\"))\nExpr\n  head: Symbol quote\n  args: Array{Any}((1,))\n    1: Expr\n      head: Symbol call\n      args: Array{Any}((3,))\n        1: Symbol +\n        2: Int64 1\n        3: Int64 2","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"As we have seen, such expressions support interpolation with $. However, in some situations it is necessary to quote code without performing interpolation. This kind of quoting does not yet have syntax, but is represented internally as an object of type QuoteNode:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> eval(Meta.quot(Expr(:$, :(1+2))))\n3\n\njulia> eval(QuoteNode(Expr(:$, :(1+2))))\n:($(Expr(:$, :(1 + 2))))","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The parser yields QuoteNodes for simple quoted items like symbols:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> dump(Meta.parse(\":x\"))\nQuoteNode\n  value: Symbol x","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"QuoteNode can also be used for certain advanced metaprogramming tasks.","category":"page"},{"location":"manual/metaprogramming.html#Evaluating-expressions","page":"Metaprogramming","title":"Evaluating expressions","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Given an expression object, one can cause Julia to evaluate (execute) it at global scope using eval:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex1 = :(1 + 2)\n:(1 + 2)\n\njulia> eval(ex1)\n3\n\njulia> ex = :(a + b)\n:(a + b)\n\njulia> eval(ex)\nERROR: UndefVarError: `b` not defined in `Main`\n[...]\n\njulia> a = 1; b = 2;\n\njulia> eval(ex)\n3","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Every module has its own eval function that evaluates expressions in its global scope. Expressions passed to eval are not limited to returning values – they can also have side-effects that alter the state of the enclosing module's environment:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex = :(x = 1)\n:(x = 1)\n\njulia> x\nERROR: UndefVarError: `x` not defined in `Main`\n\njulia> eval(ex)\n1\n\njulia> x\n1","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Here, the evaluation of an expression object causes a value to be assigned to the global variable x.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Since expressions are just Expr objects which can be constructed programmatically and then evaluated, it is possible to dynamically generate arbitrary code which can then be run using eval. Here is a simple example:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> a = 1;\n\njulia> ex = Expr(:call, :+, a, :b)\n:(1 + b)\n\njulia> a = 0; b = 2;\n\njulia> eval(ex)\n3","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The value of a is used to construct the expression ex which applies the + function to the value 1 and the variable b. Note the important distinction between the way a and b are used:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The value of the variable a at expression construction time is used as an immediate value in the expression. Thus, the value of a when the expression is evaluated no longer matters: the value in the expression is already 1, independent of whatever the value of a might be.\nOn the other hand, the symbol :b is used in the expression construction, so the value of the variable b at that time is irrelevant – :b is just a symbol and the variable b need not even be defined. At expression evaluation time, however, the value of the symbol :b is resolved by looking up the value of the variable b.","category":"page"},{"location":"manual/metaprogramming.html#Functions-on-Expressions","page":"Metaprogramming","title":"Functions on Expressions","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"As hinted above, one extremely useful feature of Julia is the capability to generate and manipulate Julia code within Julia itself. We have already seen one example of a function returning Expr objects: the Meta.parse function, which takes a string of Julia code and returns the corresponding Expr. A function can also take one or more Expr objects as arguments, and return another Expr. Here is a simple, motivating example:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> function math_expr(op, op1, op2)\n           expr = Expr(:call, op, op1, op2)\n           return expr\n       end\nmath_expr (generic function with 1 method)\n\njulia>  ex = math_expr(:+, 1, Expr(:call, :*, 4, 5))\n:(1 + 4 * 5)\n\njulia> eval(ex)\n21","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"As another example, here is a function that doubles any numeric argument, but leaves expressions alone:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> function make_expr2(op, opr1, opr2)\n           opr1f, opr2f = map(x -> isa(x, Number) ? 2*x : x, (opr1, opr2))\n           retexpr = Expr(:call, op, opr1f, opr2f)\n           return retexpr\n       end\nmake_expr2 (generic function with 1 method)\n\njulia> make_expr2(:+, 1, 2)\n:(2 + 4)\n\njulia> ex = make_expr2(:+, 1, Expr(:call, :*, 5, 8))\n:(2 + 5 * 8)\n\njulia> eval(ex)\n42","category":"page"},{"location":"manual/metaprogramming.html#man-macros","page":"Metaprogramming","title":"Macros","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Macros provide a mechanism to include generated code in the final body of a program. A macro maps a tuple of arguments to a returned expression, and the resulting expression is compiled directly rather than requiring a runtime eval call. Macro arguments may include expressions, literal values, and symbols.","category":"page"},{"location":"manual/metaprogramming.html#Basics","page":"Metaprogramming","title":"Basics","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Here is an extraordinarily simple macro:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro sayhello()\n           return :( println(\"Hello, world!\") )\n       end\n@sayhello (macro with 1 method)","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Macros have a dedicated character in Julia's syntax: the @ (at-sign), followed by the unique name declared in a macro NAME ... end block. In this example, the compiler will replace all instances of @sayhello with:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":":( println(\"Hello, world!\") )","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"When @sayhello is entered in the REPL, the expression executes immediately, thus we only see the evaluation result:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @sayhello()\nHello, world!","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Now, consider a slightly more complex macro:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro sayhello(name)\n           return :( println(\"Hello, \", $name) )\n       end\n@sayhello (macro with 1 method)","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"This macro takes one argument: name. When @sayhello is encountered, the quoted expression is expanded to interpolate the value of the argument into the final expression:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @sayhello(\"human\")\nHello, human","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"We can view the quoted return expression using the function macroexpand (important note: this is an extremely useful tool for debugging macros):","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex = macroexpand(Main, :(@sayhello(\"human\")) )\n:(Main.println(\"Hello, \", \"human\"))\n\njulia> typeof(ex)\nExpr","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"We can see that the \"human\" literal has been interpolated into the expression.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"There also exists a macro @macroexpand that is perhaps a bit more convenient than the macroexpand function:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @macroexpand @sayhello \"human\"\n:(println(\"Hello, \", \"human\"))","category":"page"},{"location":"manual/metaprogramming.html#Hold-up:-why-macros?","page":"Metaprogramming","title":"Hold up: why macros?","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"We have already seen a function f(::Expr...) -> Expr in a previous section. In fact, macroexpand is also such a function. So, why do macros exist?","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Macros are necessary because they execute when code is parsed, therefore, macros allow the programmer to generate and include fragments of customized code before the full program is run. To illustrate the difference, consider the following example:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro twostep(arg)\n           println(\"I execute at parse time. The argument is: \", arg)\n           return :(println(\"I execute at runtime. The argument is: \", $arg))\n       end\n@twostep (macro with 1 method)\n\njulia> ex = macroexpand(Main, :(@twostep :(1, 2, 3)) );\nI execute at parse time. The argument is: :((1, 2, 3))","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The first call to println is executed when macroexpand is called. The resulting expression contains only the second println:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> typeof(ex)\nExpr\n\njulia> ex\n:(println(\"I execute at runtime. The argument is: \", $(Expr(:copyast, :($(QuoteNode(:((1, 2, 3)))))))))\n\njulia> eval(ex)\nI execute at runtime. The argument is: (1, 2, 3)","category":"page"},{"location":"manual/metaprogramming.html#Macro-invocation","page":"Metaprogramming","title":"Macro invocation","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Macros are invoked with the following general syntax:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"@name expr1 expr2 ...\n@name(expr1, expr2, ...)","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Note the distinguishing @ before the macro name and the lack of commas between the argument expressions in the first form, and the lack of whitespace after @name in the second form. The two styles should not be mixed. For example, the following syntax is different from the examples above; it passes the tuple (expr1, expr2, ...) as one argument to the macro:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"@name (expr1, expr2, ...)","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"An alternative way to invoke a macro over an array literal (or comprehension) is to juxtapose both without using parentheses. In this case, the array will be the only expression fed to the macro. The following syntax is equivalent (and different from @name [a b] * v):","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"@name[a b] * v\n@name([a b]) * v","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"It is important to emphasize that macros receive their arguments as expressions, literals, or symbols. One way to explore macro arguments is to call the show function within the macro body:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro showarg(x)\n           show(x)\n           # ... remainder of macro, returning an expression\n       end\n@showarg (macro with 1 method)\n\njulia> @showarg(a)\n:a\n\njulia> @showarg(1+1)\n:(1 + 1)\n\njulia> @showarg(println(\"Yo!\"))\n:(println(\"Yo!\"))\n\njulia> @showarg(1)        # Numeric literal\n1\n\njulia> @showarg(\"Yo!\")    # String literal\n\"Yo!\"\n\njulia> @showarg(\"Yo! $(\"hello\")\")    # String with interpolation is an Expr rather than a String\n:(\"Yo! $(\"hello\")\")","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"In addition to the given argument list, every macro is passed extra arguments named __source__ and __module__.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The argument __source__ provides information (in the form of a LineNumberNode object) about the parser location of the @ sign from the macro invocation. This allows macros to include better error diagnostic information, and is commonly used by logging, string-parser macros, and docs, for example, as well as to implement the @__LINE__, @__FILE__, and @__DIR__ macros.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The location information can be accessed by referencing __source__.line and __source__.file:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro __LOCATION__(); return QuoteNode(__source__); end\n@__LOCATION__ (macro with 1 method)\n\njulia> dump(\n            @__LOCATION__(\n       ))\nLineNumberNode\n  line: Int64 2\n  file: Symbol none","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The argument __module__ provides information (in the form of a Module object) about the expansion context of the macro invocation. This allows macros to look up contextual information, such as existing bindings, or to insert the value as an extra argument to a runtime function call doing self-reflection in the current module.","category":"page"},{"location":"manual/metaprogramming.html#Building-an-advanced-macro","page":"Metaprogramming","title":"Building an advanced macro","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Here is a simplified definition of Julia's @assert macro:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro assert(ex)\n           return :( $ex ? nothing : throw(AssertionError($(string(ex)))) )\n       end\n@assert (macro with 1 method)","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"This macro can be used like this:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @assert 1 == 1.0\n\njulia> @assert 1 == 0\nERROR: AssertionError: 1 == 0","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"In place of the written syntax, the macro call is expanded at parse time to its returned result. This is equivalent to writing:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"1 == 1.0 ? nothing : throw(AssertionError(\"1 == 1.0\"))\n1 == 0 ? nothing : throw(AssertionError(\"1 == 0\"))","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"That is, in the first call, the expression :(1 == 1.0) is spliced into the test condition slot, while the value of string(:(1 == 1.0)) is spliced into the assertion message slot. The entire expression, thus constructed, is placed into the syntax tree where the @assert macro call occurs. Then at execution time, if the test expression evaluates to true, then nothing is returned, whereas if the test is false, an error is raised indicating the asserted expression that was false. Notice that it would not be possible to write this as a function, since only the value of the condition is available and it would be impossible to display the expression that computed it in the error message.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The actual definition of @assert in Julia Base is more complicated. It allows the user to optionally specify their own error message, instead of just printing the failed expression. Just like in functions with a variable number of arguments (Varargs Functions), this is specified with an ellipses following the last argument:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro assert(ex, msgs...)\n           msg_body = isempty(msgs) ? ex : msgs[1]\n           msg = string(msg_body)\n           return :($ex ? nothing : throw(AssertionError($msg)))\n       end\n@assert (macro with 1 method)","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Now @assert has two modes of operation, depending upon the number of arguments it receives! If there's only one argument, the tuple of expressions captured by msgs will be empty and it will behave the same as the simpler definition above. But now if the user specifies a second argument, it is printed in the message body instead of the failing expression. You can inspect the result of a macro expansion with the aptly named @macroexpand macro:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @macroexpand @assert a == b\n:(if Main.a == Main.b\n        Main.nothing\n    else\n        Main.throw(Main.AssertionError(\"a == b\"))\n    end)\n\njulia> @macroexpand @assert a==b \"a should equal b!\"\n:(if Main.a == Main.b\n        Main.nothing\n    else\n        Main.throw(Main.AssertionError(\"a should equal b!\"))\n    end)","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"There is yet another case that the actual @assert macro handles: what if, in addition to printing \"a should equal b,\" we wanted to print their values? One might naively try to use string interpolation in the custom message, e.g., @assert a==b \"a ($a) should equal b ($b)!\", but this won't work as expected with the above macro. Can you see why? Recall from string interpolation that an interpolated string is rewritten to a call to string. Compare:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> typeof(:(\"a should equal b\"))\nString\n\njulia> typeof(:(\"a ($a) should equal b ($b)!\"))\nExpr\n\njulia> dump(:(\"a ($a) should equal b ($b)!\"))\nExpr\n  head: Symbol string\n  args: Array{Any}((5,))\n    1: String \"a (\"\n    2: Symbol a\n    3: String \") should equal b (\"\n    4: Symbol b\n    5: String \")!\"","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"So now instead of getting a plain string in msg_body, the macro is receiving a full expression that will need to be evaluated in order to display as expected. This can be spliced directly into the returned expression as an argument to the string call; see error.jl for the complete implementation.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The @assert macro makes great use of splicing into quoted expressions to simplify the manipulation of expressions inside the macro body.","category":"page"},{"location":"manual/metaprogramming.html#Hygiene","page":"Metaprogramming","title":"Hygiene","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"An issue that arises in more complex macros is that of hygiene. In short, macros must ensure that the variables they introduce in their returned expressions do not accidentally clash with existing variables in the surrounding code they expand into. Conversely, the expressions that are passed into a macro as arguments are often expected to evaluate in the context of the surrounding code, interacting with and modifying the existing variables. Another concern arises from the fact that a macro may be called in a different module from where it was defined. In this case we need to ensure that all global variables are resolved to the correct module. Julia already has a major advantage over languages with textual macro expansion (like C) in that it only needs to consider the returned expression. All the other variables (such as msg in @assert above) follow the normal scoping block behavior.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"To demonstrate these issues, let us consider writing a @time macro that takes an expression as its argument, records the time, evaluates the expression, records the time again, prints the difference between the before and after times, and then has the value of the expression as its final value. The macro might look like this:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"macro time(ex)\n    return quote\n        local t0 = time_ns()\n        local val = $ex\n        local t1 = time_ns()\n        println(\"elapsed time: \", (t1-t0)/1e9, \" seconds\")\n        val\n    end\nend","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Here, we want t0, t1, and val to be private temporary variables, and we want time_ns to refer to the time_ns function in Julia Base, not to any time_ns variable the user might have (the same applies to println). Imagine the problems that could occur if the user expression ex also contained assignments to a variable called t0, or defined its own time_ns variable. We might get errors, or mysteriously incorrect behavior.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Julia's macro expander solves these problems in the following way. First, variables within a macro result are classified as either local or global. A variable is considered local if it is assigned to (and not declared global), declared local, or used as a function argument name. Otherwise, it is considered global. Local variables are then renamed to be unique (using the gensym function, which generates new symbols), and global variables are resolved within the macro definition environment. Therefore both of the above concerns are handled; the macro's locals will not conflict with any user variables, and time_ns and println will refer to the Julia Base definitions.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"One problem remains however. Consider the following use of this macro:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"module MyModule\nimport Base.@time\n\ntime_ns() = ... # compute something\n\n@time time_ns()\nend","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Here the user expression ex is a call to time_ns, but not the same time_ns function that the macro uses. It clearly refers to MyModule.time_ns. Therefore we must arrange for the code in ex to be resolved in the macro call environment. This is done by \"escaping\" the expression with esc:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"macro time(ex)\n    ...\n    local val = $(esc(ex))\n    ...\nend","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"An expression wrapped in this manner is left alone by the macro expander and simply pasted into the output verbatim. Therefore it will be resolved in the macro call environment.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"This escaping mechanism can be used to \"violate\" hygiene when necessary, in order to introduce or manipulate user variables. For example, the following macro sets x to zero in the call environment:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro zerox()\n           return esc(:(x = 0))\n       end\n@zerox (macro with 1 method)\n\njulia> function foo()\n           x = 1\n           @zerox\n           return x # is zero\n       end\nfoo (generic function with 1 method)\n\njulia> foo()\n0","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"This kind of manipulation of variables should be used judiciously, but is occasionally quite handy.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Getting the hygiene rules correct can be a formidable challenge. Before using a macro, you might want to consider whether a function closure would be sufficient. Another useful strategy is to defer as much work as possible to runtime. For example, many macros simply wrap their arguments in a QuoteNode or other similar Expr. Some examples of this include @task body which simply returns schedule(Task(() -> $body)), and @eval expr, which simply returns eval(QuoteNode(expr)).","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"To demonstrate, we might rewrite the @time example above as:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"macro time(expr)\n    return :(timeit(() -> $(esc(expr))))\nend\nfunction timeit(f)\n    t0 = time_ns()\n    val = f()\n    t1 = time_ns()\n    println(\"elapsed time: \", (t1-t0)/1e9, \" seconds\")\n    return val\nend","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"However, we don't do this for a good reason: wrapping the expr in a new scope block (the anonymous function) also slightly changes the meaning of the expression (the scope of any variables in it), while we want @time to be usable with minimum impact on the wrapped code.","category":"page"},{"location":"manual/metaprogramming.html#Macros-and-dispatch","page":"Metaprogramming","title":"Macros and dispatch","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Macros, just like Julia functions, are generic. This means they can also have multiple method definitions, thanks to multiple dispatch:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro m end\n@m (macro with 0 methods)\n\njulia> macro m(args...)\n           println(\"$(length(args)) arguments\")\n       end\n@m (macro with 1 method)\n\njulia> macro m(x,y)\n           println(\"Two arguments\")\n       end\n@m (macro with 2 methods)\n\njulia> @m \"asd\"\n1 arguments\n\njulia> @m 1 2\nTwo arguments","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"However one should keep in mind, that macro dispatch is based on the types of AST that are handed to the macro, not the types that the AST evaluates to at runtime:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro m(::Int)\n           println(\"An Integer\")\n       end\n@m (macro with 3 methods)\n\njulia> @m 2\nAn Integer\n\njulia> x = 2\n2\n\njulia> @m x\n1 arguments","category":"page"},{"location":"manual/metaprogramming.html#Code-Generation","page":"Metaprogramming","title":"Code Generation","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"When a significant amount of repetitive boilerplate code is required, it is common to generate it programmatically to avoid redundancy. In most languages, this requires an extra build step, and a separate program to generate the repetitive code. In Julia, expression interpolation and eval allow such code generation to take place in the normal course of program execution. For example, consider the following custom type","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"struct MyNumber\n    x::Float64\nend\n# output\n","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"for which we want to add a number of methods to. We can do this programmatically in the following loop:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"for op = (:sin, :cos, :tan, :log, :exp)\n    eval(quote\n        Base.$op(a::MyNumber) = MyNumber($op(a.x))\n    end)\nend\n# output\n","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"and we can now use those functions with our custom type:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> x = MyNumber(π)\nMyNumber(3.141592653589793)\n\njulia> sin(x)\nMyNumber(1.2246467991473532e-16)\n\njulia> cos(x)\nMyNumber(-1.0)","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"In this manner, Julia acts as its own preprocessor, and allows code generation from inside the language. The above code could be written slightly more tersely using the : prefix quoting form:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"for op = (:sin, :cos, :tan, :log, :exp)\n    eval(:(Base.$op(a::MyNumber) = MyNumber($op(a.x))))\nend","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"This sort of in-language code generation, however, using the eval(quote(...)) pattern, is common enough that Julia comes with a macro to abbreviate this pattern:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"for op = (:sin, :cos, :tan, :log, :exp)\n    @eval Base.$op(a::MyNumber) = MyNumber($op(a.x))\nend","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The @eval macro rewrites this call to be precisely equivalent to the above longer versions. For longer blocks of generated code, the expression argument given to @eval can be a block:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"@eval begin\n    # multiple lines\nend","category":"page"},{"location":"manual/metaprogramming.html#meta-non-standard-string-literals","page":"Metaprogramming","title":"Non-Standard String Literals","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Recall from Strings that string literals prefixed by an identifier are called non-standard string literals, and can have different semantics than un-prefixed string literals. For example:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"r\"^\\s*(?:#|$)\" produces a regular expression object rather than a string\nb\"DATA\\xff\\u2200\" is a byte array literal for [68,65,84,65,255,226,136,128].","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Perhaps surprisingly, these behaviors are not hard-coded into the Julia parser or compiler. Instead, they are custom behaviors provided by a general mechanism that anyone can use: prefixed string literals are parsed as calls to specially-named macros. For example, the regular expression macro is just the following:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"macro r_str(p)\n    Regex(p)\nend","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"That's all. This macro says that the literal contents of the string literal r\"^\\s*(?:#|$)\" should be passed to the @r_str macro and the result of that expansion should be placed in the syntax tree where the string literal occurs. In other words, the expression r\"^\\s*(?:#|$)\" is equivalent to placing the following object directly into the syntax tree:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Regex(\"^\\\\s*(?:#|\\$)\")","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Not only is the string literal form shorter and far more convenient, but it is also more efficient: since the regular expression is compiled and the Regex object is actually created when the code is compiled, the compilation occurs only once, rather than every time the code is executed. Consider if the regular expression occurs in a loop:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"for line = lines\n    m = match(r\"^\\s*(?:#|$)\", line)\n    if m === nothing\n        # non-comment\n    else\n        # comment\n    end\nend","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Since the regular expression r\"^\\s*(?:#|$)\" is compiled and inserted into the syntax tree when this code is parsed, the expression is only compiled once instead of each time the loop is executed. In order to accomplish this without macros, one would have to write this loop like this:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"re = Regex(\"^\\\\s*(?:#|\\$)\")\nfor line = lines\n    m = match(re, line)\n    if m === nothing\n        # non-comment\n    else\n        # comment\n    end\nend","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Moreover, if the compiler could not determine that the regex object was constant over all loops, certain optimizations might not be possible, making this version still less efficient than the more convenient literal form above. Of course, there are still situations where the non-literal form is more convenient: if one needs to interpolate a variable into the regular expression, one must take this more verbose approach; in cases where the regular expression pattern itself is dynamic, potentially changing upon each loop iteration, a new regular expression object must be constructed on each iteration. In the vast majority of use cases, however, regular expressions are not constructed based on run-time data. In this majority of cases, the ability to write regular expressions as compile-time values is invaluable.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The mechanism for user-defined string literals is deeply, profoundly powerful. Not only are Julia's non-standard literals implemented using it, but the command literal syntax (`echo \"Hello, $person\"`) is also implemented using the following innocuous-looking macro:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"macro cmd(str)\n    :(cmd_gen($(shell_parse(str)[1])))\nend","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Of course, a large amount of complexity is hidden in the functions used in this macro definition, but they are just functions, written entirely in Julia. You can read their source and see precisely what they do – and all they do is construct expression objects to be inserted into your program's syntax tree.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Like string literals, command literals can also be prefixed by an identifier to form what are called non-standard command literals. These command literals are parsed as calls to specially-named macros. For example, the syntax custom`literal` is parsed as @custom_cmd \"literal\". Julia itself does not contain any non-standard command literals, but packages can make use of this syntax. Aside from the different syntax and the _cmd suffix instead of the _str suffix, non-standard command literals behave exactly like non-standard string literals.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"In the event that two modules provide non-standard string or command literals with the same name, it is possible to qualify the string or command literal with a module name. For instance, if both Foo and Bar provide non-standard string literal @x_str, then one can write Foo.x\"literal\" or Bar.x\"literal\" to disambiguate between the two.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Another way to define a macro would be like this:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"macro foo_str(str, flag)\n    # do stuff\nend","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"This macro can then be called with the following syntax:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"foo\"str\"flag","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The type of flag in the above mentioned syntax would be a String with contents of whatever trails after the string literal.","category":"page"},{"location":"manual/metaprogramming.html#Generated-functions","page":"Metaprogramming","title":"Generated functions","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"A very special macro is @generated, which allows you to define so-called generated functions. These have the capability to generate specialized code depending on the types of their arguments with more flexibility and/or less code than what can be achieved with multiple dispatch. While macros work with expressions at parse time and cannot access the types of their inputs, a generated function gets expanded at a time when the types of the arguments are known, but the function is not yet compiled.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Instead of performing some calculation or action, a generated function declaration returns a quoted expression which then forms the body for the method corresponding to the types of the arguments. When a generated function is called, the expression it returns is compiled and then run. To make this efficient, the result is usually cached. And to make this inferable, only a limited subset of the language is usable. Thus, generated functions provide a flexible way to move work from run time to compile time, at the expense of greater restrictions on allowed constructs.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"When defining generated functions, there are five main differences to ordinary functions:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"You annotate the function declaration with the @generated macro. This adds some information to the AST that lets the compiler know that this is a generated function.\nIn the body of the generated function you only have access to the types of the arguments – not their values.\nInstead of calculating something or performing some action, you return a quoted expression which, when evaluated, does what you want.\nGenerated functions are only permitted to call functions that were defined before the definition of the generated function. (Failure to follow this may result in getting MethodErrors referring to functions from a future world-age.)\nGenerated functions must not mutate or observe any non-constant global state (including, for example, IO, locks, non-local dictionaries, or using hasmethod). This means they can only read global constants, and cannot have any side effects. In other words, they must be completely pure. Due to an implementation limitation, this also means that they currently cannot define a closure or generator.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"It's easiest to illustrate this with an example. We can declare a generated function foo as","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @generated function foo(x)\n           Core.println(x)\n           return :(x * x)\n       end\nfoo (generic function with 1 method)","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Note that the body returns a quoted expression, namely :(x * x), rather than just the value of x * x.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"From the caller's perspective, this is identical to a regular function; in fact, you don't have to know whether you're calling a regular or generated function. Let's see how foo behaves:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> x = foo(2); # note: output is from println() statement in the body\nInt64\n\njulia> x           # now we print x\n4\n\njulia> y = foo(\"bar\");\nString\n\njulia> y\n\"barbar\"","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"So, we see that in the body of the generated function, x is the type of the passed argument, and the value returned by the generated function, is the result of evaluating the quoted expression we returned from the definition, now with the value of x.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"What happens if we evaluate foo again with a type that we have already used?","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> foo(4)\n16","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Note that there is no printout of Int64. We can see that the body of the generated function was only executed once here, for the specific set of argument types, and the result was cached. After that, for this example, the expression returned from the generated function on the first invocation was re-used as the method body. However, the actual caching behavior is an implementation-defined performance optimization, so it is invalid to depend too closely on this behavior.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The number of times a generated function is generated might be only once, but it might also be more often, or appear to not happen at all. As a consequence, you should never write a generated function with side effects - when, and how often, the side effects occur is undefined. (This is true for macros too - and just like for macros, the use of eval in a generated function is a sign that you're doing something the wrong way.) However, unlike macros, the runtime system cannot correctly handle a call to eval, so it is disallowed.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"It is also important to see how @generated functions interact with method redefinition. Following the principle that a correct @generated function must not observe any mutable state or cause any mutation of global state, we see the following behavior. Observe that the generated function cannot call any method that was not defined prior to the definition of the generated function itself.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Initially f(x) has one definition","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> f(x) = \"original definition\";","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Define other operations that use f(x):","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> g(x) = f(x);\n\njulia> @generated gen1(x) = f(x);\n\njulia> @generated gen2(x) = :(f(x));","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"We now add some new definitions for f(x):","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> f(x::Int) = \"definition for Int\";\n\njulia> f(x::Type{Int}) = \"definition for Type{Int}\";","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"and compare how these results differ:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> f(1)\n\"definition for Int\"\n\njulia> g(1)\n\"definition for Int\"\n\njulia> gen1(1)\n\"original definition\"\n\njulia> gen2(1)\n\"definition for Int\"","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Each method of a generated function has its own view of defined functions:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @generated gen1(x::Real) = f(x);\n\njulia> gen1(1)\n\"definition for Type{Int}\"","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The example generated function foo above did not do anything a normal function foo(x) = x * x could not do (except printing the type on the first invocation, and incurring higher overhead). However, the power of a generated function lies in its ability to compute different quoted expressions depending on the types passed to it:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @generated function bar(x)\n           if x <: Integer\n               return :(x ^ 2)\n           else\n               return :(x)\n           end\n       end\nbar (generic function with 1 method)\n\njulia> bar(4)\n16\n\njulia> bar(\"baz\")\n\"baz\"","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"(although of course this contrived example would be more easily implemented using multiple dispatch...)","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Abusing this will corrupt the runtime system and cause undefined behavior:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @generated function baz(x)\n           if rand() < .9\n               return :(x^2)\n           else\n               return :(\"boo!\")\n           end\n       end\nbaz (generic function with 1 method)","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Since the body of the generated function is non-deterministic, its behavior, and the behavior of all subsequent code is undefined.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Don't copy these examples!","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"These examples are hopefully helpful to illustrate how generated functions work, both in the definition end and at the call site; however, don't copy them, for the following reasons:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"the foo function has side-effects (the call to Core.println), and it is undefined exactly when, how often or how many times these side-effects will occur\nthe bar function solves a problem that is better solved with multiple dispatch - defining bar(x) = x and bar(x::Integer) = x ^ 2 will do the same thing, but it is both simpler and faster.\nthe baz function is pathological","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Note that the set of operations that should not be attempted in a generated function is unbounded, and the runtime system can currently only detect a subset of the invalid operations. There are many other operations that will simply corrupt the runtime system without notification, usually in subtle ways not obviously connected to the bad definition. Because the function generator is run during inference, it must respect all of the limitations of that code.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Some operations that should not be attempted include:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Caching of native pointers.\nInteracting with the contents or methods of Core.Compiler in any way.\nObserving any mutable state.\nInference on the generated function may be run at any time, including while your code is attempting to observe or mutate this state.\nTaking any locks: C code you call out to may use locks internally, (for example, it is not problematic to call malloc, even though most implementations require locks internally) but don't attempt to hold or acquire any while executing Julia code.\nCalling any function that is defined after the body of the generated function. This condition is relaxed for incrementally-loaded precompiled modules to allow calling any function in the module.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Alright, now that we have a better understanding of how generated functions work, let's use them to build some more advanced (and valid) functionality...","category":"page"},{"location":"manual/metaprogramming.html#An-advanced-example","page":"Metaprogramming","title":"An advanced example","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Julia's base library has an internal sub2ind function to calculate a linear index into an n-dimensional array, based on a set of n multilinear indices - in other words, to calculate the index i that can be used to index into an array A using A[i], instead of A[x,y,z,...]. One possible implementation is the following:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> function sub2ind_loop(dims::NTuple{N}, I::Integer...) where N\n           ind = I[N] - 1\n           for i = N-1:-1:1\n               ind = I[i]-1 + dims[i]*ind\n           end\n           return ind + 1\n       end;\n\njulia> sub2ind_loop((3, 5), 1, 2)\n4","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"The same thing can be done using recursion:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> sub2ind_rec(dims::Tuple{}) = 1;\n\njulia> sub2ind_rec(dims::Tuple{}, i1::Integer, I::Integer...) =\n           i1 == 1 ? sub2ind_rec(dims, I...) : throw(BoundsError());\n\njulia> sub2ind_rec(dims::Tuple{Integer, Vararg{Integer}}, i1::Integer) = i1;\n\njulia> sub2ind_rec(dims::Tuple{Integer, Vararg{Integer}}, i1::Integer, I::Integer...) =\n           i1 + dims[1] * (sub2ind_rec(Base.tail(dims), I...) - 1);\n\njulia> sub2ind_rec((3, 5), 1, 2)\n4","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Both these implementations, although different, do essentially the same thing: a runtime loop over the dimensions of the array, collecting the offset in each dimension into the final index.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"However, all the information we need for the loop is embedded in the type information of the arguments. This allows the compiler to move the iteration to compile time and eliminate the runtime loops altogether. We can utilize generated functions to achieve a similar effect; in compiler parlance, we use generated functions to manually unroll the loop. The body becomes almost identical, but instead of calculating the linear index, we build up an expression that calculates the index:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @generated function sub2ind_gen(dims::NTuple{N}, I::Integer...) where N\n           ex = :(I[$N] - 1)\n           for i = (N - 1):-1:1\n               ex = :(I[$i] - 1 + dims[$i] * $ex)\n           end\n           return :($ex + 1)\n       end;\n\njulia> sub2ind_gen((3, 5), 1, 2)\n4","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"What code will this generate?","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"An easy way to find out is to extract the body into another (regular) function:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> function sub2ind_gen_impl(dims::Type{T}, I...) where T <: NTuple{N,Any} where N\n           length(I) == N || return :(error(\"partial indexing is unsupported\"))\n           ex = :(I[$N] - 1)\n           for i = (N - 1):-1:1\n               ex = :(I[$i] - 1 + dims[$i] * $ex)\n           end\n           return :($ex + 1)\n       end;\n\njulia> @generated function sub2ind_gen(dims::NTuple{N}, I::Integer...) where N\n           return sub2ind_gen_impl(dims, I...)\n       end;\n\njulia> sub2ind_gen((3, 5), 1, 2)\n4","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"We can now execute sub2ind_gen_impl and examine the expression it returns:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> sub2ind_gen_impl(Tuple{Int,Int}, Int, Int)\n:(((I[1] - 1) + dims[1] * (I[2] - 1)) + 1)","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"So, the method body that will be used here doesn't include a loop at all - just indexing into the two tuples, multiplication and addition/subtraction. All the looping is performed compile-time, and we avoid looping during execution entirely. Thus, we only loop once per type, in this case once per N (except in edge cases where the function is generated more than once - see disclaimer above).","category":"page"},{"location":"manual/metaprogramming.html#Optionally-generated-functions","page":"Metaprogramming","title":"Optionally-generated functions","text":"","category":"section"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Generated functions can achieve high efficiency at run time, but come with a compile time cost: a new function body must be generated for every combination of concrete argument types. Typically, Julia is able to compile \"generic\" versions of functions that will work for any arguments, but with generated functions this is impossible. This means that programs making heavy use of generated functions might be impossible to statically compile.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"To solve this problem, the language provides syntax for writing normal, non-generated alternative implementations of generated functions. Applied to the sub2ind example above, it would look like this:","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"julia> function sub2ind_gen_impl(dims::Type{T}, I...) where T <: NTuple{N,Any} where N\n           ex = :(I[$N] - 1)\n           for i = (N - 1):-1:1\n               ex = :(I[$i] - 1 + dims[$i] * $ex)\n           end\n           return :($ex + 1)\n       end;\n\njulia> function sub2ind_gen_fallback(dims::NTuple{N}, I) where N\n           ind = I[N] - 1\n           for i = (N - 1):-1:1\n               ind = I[i] - 1 + dims[i]*ind\n           end\n           return ind + 1\n       end;\n\njulia> function sub2ind_gen(dims::NTuple{N}, I::Integer...) where N\n           length(I) == N || error(\"partial indexing is unsupported\")\n           if @generated\n               return sub2ind_gen_impl(dims, I...)\n           else\n               return sub2ind_gen_fallback(dims, I)\n           end\n       end;\n\njulia> sub2ind_gen((3, 5), 1, 2)\n4","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Internally, this code creates two implementations of the function: a generated one where the first block in if @generated is used, and a normal one where the else block is used. Inside the then part of the if @generated block, code has the same semantics as other generated functions: argument names refer to types, and the code should return an expression. Multiple if @generated blocks may occur, in which case the generated implementation uses all of the then blocks and the alternate implementation uses all of the else blocks.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"Notice that we added an error check to the top of the function. This code will be common to both versions, and is run-time code in both versions (it will be quoted and returned as an expression from the generated version). That means that the values and types of local variables are not available at code generation time –- the code-generation code can only see the types of arguments.","category":"page"},{"location":"manual/metaprogramming.html","page":"Metaprogramming","title":"Metaprogramming","text":"In this style of definition, the code generation feature is essentially an optional optimization. The compiler will use it if convenient, but otherwise may choose to use the normal implementation instead. This style is preferred, since it allows the compiler to make more decisions and compile programs in more ways, and since normal code is more readable than code-generating code. However, which implementation is used depends on compiler implementation details, so it is essential for the two implementations to behave identically.","category":"page"},{"location":"devdocs/offset-arrays.html#man-custom-indices","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"","category":"section"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"Conventionally, Julia's arrays are indexed starting at 1, whereas some other languages start numbering at 0, and yet others (e.g., Fortran) allow you to specify arbitrary starting indices.  While there is much merit in picking a standard (i.e., 1 for Julia), there are some algorithms which simplify considerably if you can index outside the range 1:size(A,d) (and not just 0:size(A,d)-1, either). To facilitate such computations, Julia supports arrays with arbitrary indices.","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"The purpose of this page is to address the question, \"what do I have to do to support such arrays in my own code?\"  First, let's address the simplest case: if you know that your code will never need to handle arrays with unconventional indexing, hopefully the answer is \"nothing.\" Old code, on conventional arrays, should function essentially without alteration as long as it was using the exported interfaces of Julia. If you find it more convenient to just force your users to supply traditional arrays where indexing starts at one, you can add","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"Base.require_one_based_indexing(arrays...)","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"where arrays... is a list of the array objects that you wish to check for anything that violates 1-based indexing.","category":"page"},{"location":"devdocs/offset-arrays.html#Generalizing-existing-code","page":"Arrays with custom indices","title":"Generalizing existing code","text":"","category":"section"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"As an overview, the steps are:","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"replace many uses of size with axes\nreplace 1:length(A) with eachindex(A), or in some cases LinearIndices(A)\nreplace explicit allocations like Array{Int}(undef, size(B)) with similar(Array{Int}, axes(B))","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"These are described in more detail below.","category":"page"},{"location":"devdocs/offset-arrays.html#Things-to-watch-out-for","page":"Arrays with custom indices","title":"Things to watch out for","text":"","category":"section"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"Because unconventional indexing breaks many people's assumptions that all arrays start indexing with 1, there is always the chance that using such arrays will trigger errors. The most frustrating bugs would be incorrect results or segfaults (total crashes of Julia). For example, consider the following function:","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"function mycopy!(dest::AbstractVector, src::AbstractVector)\n    length(dest) == length(src) || throw(DimensionMismatch(\"vectors must match\"))\n    # OK, now we're safe to use @inbounds, right? (not anymore!)\n    for i = 1:length(src)\n        @inbounds dest[i] = src[i]\n    end\n    dest\nend","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"This code implicitly assumes that vectors are indexed from 1; if dest starts at a different index than src, there is a chance that this code would trigger a segfault. (If you do get segfaults, to help locate the cause try running julia with the option --check-bounds=yes.)","category":"page"},{"location":"devdocs/offset-arrays.html#Using-axes-for-bounds-checks-and-loop-iteration","page":"Arrays with custom indices","title":"Using axes for bounds checks and loop iteration","text":"","category":"section"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"axes(A) (reminiscent of size(A)) returns a tuple of AbstractUnitRange{<:Integer} objects, specifying the range of valid indices along each dimension of A.  When A has unconventional indexing, the ranges may not start at 1.  If you just want the range for a particular dimension d, there is axes(A, d).","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"Base implements a custom range type, OneTo, where OneTo(n) means the same thing as 1:n but in a form that guarantees (via the type system) that the lower index is 1. For any new AbstractArray type, this is the default returned by axes, and it indicates that this array type uses \"conventional\" 1-based indexing.","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"For bounds checking, note that there are dedicated functions checkbounds and checkindex which can sometimes simplify such tests.","category":"page"},{"location":"devdocs/offset-arrays.html#Linear-indexing-(LinearIndices)","page":"Arrays with custom indices","title":"Linear indexing (LinearIndices)","text":"","category":"section"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"Some algorithms are most conveniently (or efficiently) written in terms of a single linear index, A[i] even if A is multi-dimensional. Regardless of the array's native indices, linear indices always range from 1:length(A). However, this raises an ambiguity for one-dimensional arrays (a.k.a., AbstractVector): does v[i] mean linear indexing , or Cartesian indexing with the array's native indices?","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"For this reason, your best option may be to iterate over the array with eachindex(A), or, if you require the indices to be sequential integers, to get the index range by calling LinearIndices(A). This will return axes(A, 1) if A is an AbstractVector, and the equivalent of 1:length(A) otherwise.","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"By this definition, 1-dimensional arrays always use Cartesian indexing with the array's native indices. To help enforce this, it's worth noting that the index conversion functions will throw an error if shape indicates a 1-dimensional array with unconventional indexing (i.e., is a Tuple{UnitRange} rather than a tuple of OneTo). For arrays with conventional indexing, these functions continue to work the same as always.","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"Using axes and LinearIndices, here is one way you could rewrite mycopy!:","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"function mycopy!(dest::AbstractVector, src::AbstractVector)\n    axes(dest) == axes(src) || throw(DimensionMismatch(\"vectors must match\"))\n    for i in LinearIndices(src)\n        @inbounds dest[i] = src[i]\n    end\n    dest\nend","category":"page"},{"location":"devdocs/offset-arrays.html#Allocating-storage-using-generalizations-of-similar","page":"Arrays with custom indices","title":"Allocating storage using generalizations of similar","text":"","category":"section"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"Storage is often allocated with Array{Int}(undef, dims) or similar(A, args...). When the result needs to match the indices of some other array, this may not always suffice. The generic replacement for such patterns is to use similar(storagetype, shape).  storagetype indicates the kind of underlying \"conventional\" behavior you'd like, e.g., Array{Int} or BitArray or even dims->zeros(Float32, dims) (which would allocate an all-zeros array). shape is a tuple of Integer or AbstractUnitRange values, specifying the indices that you want the result to use. Note that a convenient way of producing an all-zeros array that matches the indices of A is simply zeros(A).","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"Let's walk through a couple of explicit examples. First, if A has conventional indices, then similar(Array{Int}, axes(A)) would end up calling Array{Int}(undef, size(A)), and thus return an array.  If A is an AbstractArray type with unconventional indexing, then similar(Array{Int}, axes(A)) should return something that \"behaves like\" an Array{Int} but with a shape (including indices) that matches A.  (The most obvious implementation is to allocate an Array{Int}(undef, size(A)) and then \"wrap\" it in a type that shifts the indices.)","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"Note also that similar(Array{Int}, (axes(A, 2),)) would allocate an AbstractVector{Int} (i.e., 1-dimensional array) that matches the indices of the columns of A.","category":"page"},{"location":"devdocs/offset-arrays.html#Writing-custom-array-types-with-non-1-indexing","page":"Arrays with custom indices","title":"Writing custom array types with non-1 indexing","text":"","category":"section"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"Most of the methods you'll need to define are standard for any AbstractArray type, see Abstract Arrays. This page focuses on the steps needed to define unconventional indexing.","category":"page"},{"location":"devdocs/offset-arrays.html#Custom-AbstractUnitRange-types","page":"Arrays with custom indices","title":"Custom AbstractUnitRange types","text":"","category":"section"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"If you're writing a non-1 indexed array type, you will want to specialize axes so it returns a UnitRange, or (perhaps better) a custom AbstractUnitRange.  The advantage of a custom type is that it \"signals\" the allocation type for functions like similar. If we're writing an array type for which indexing will start at 0, we likely want to begin by creating a new AbstractUnitRange, ZeroRange, where ZeroRange(n) is equivalent to 0:n-1.","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"In general, you should probably not export ZeroRange from your package: there may be other packages that implement their own ZeroRange, and having multiple distinct ZeroRange types is (perhaps counterintuitively) an advantage: ModuleA.ZeroRange indicates that similar should create a ModuleA.ZeroArray, whereas ModuleB.ZeroRange indicates a ModuleB.ZeroArray type.  This design allows peaceful coexistence among many different custom array types.","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"Note that the Julia package CustomUnitRanges.jl can sometimes be used to avoid the need to write your own ZeroRange type.","category":"page"},{"location":"devdocs/offset-arrays.html#Specializing-axes","page":"Arrays with custom indices","title":"Specializing axes","text":"","category":"section"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"Once you have your AbstractUnitRange type, then specialize axes:","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"Base.axes(A::ZeroArray) = map(n->ZeroRange(n), A.size)","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"where here we imagine that ZeroArray has a field called size (there would be other ways to implement this).","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"In some cases, the fallback definition for axes(A, d):","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"axes(A::AbstractArray{T,N}, d) where {T,N} = d <= N ? axes(A)[d] : OneTo(1)","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"may not be what you want: you may need to specialize it to return something other than OneTo(1) when d > ndims(A).  Likewise, in Base there is a dedicated function axes1 which is equivalent to axes(A, 1) but which avoids checking (at runtime) whether ndims(A) > 0. (This is purely a performance optimization.)  It is defined as:","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"axes1(A::AbstractArray{T,0}) where {T} = OneTo(1)\naxes1(A::AbstractArray) = axes(A)[1]","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"If the first of these (the zero-dimensional case) is problematic for your custom array type, be sure to specialize it appropriately.","category":"page"},{"location":"devdocs/offset-arrays.html#Specializing-similar","page":"Arrays with custom indices","title":"Specializing similar","text":"","category":"section"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"Given your custom ZeroRange type, then you should also add the following two specializations for similar:","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"function Base.similar(A::AbstractArray, T::Type, shape::Tuple{ZeroRange,Vararg{ZeroRange}})\n    # body\nend\n\nfunction Base.similar(f::Union{Function,DataType}, shape::Tuple{ZeroRange,Vararg{ZeroRange}})\n    # body\nend","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"Both of these should allocate your custom array type.","category":"page"},{"location":"devdocs/offset-arrays.html#Specializing-reshape","page":"Arrays with custom indices","title":"Specializing reshape","text":"","category":"section"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"Optionally, define a method","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"Base.reshape(A::AbstractArray, shape::Tuple{ZeroRange,Vararg{ZeroRange}}) = ...","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"and you can reshape an array so that the result has custom indices.","category":"page"},{"location":"devdocs/offset-arrays.html#For-objects-that-mimic-AbstractArray-but-are-not-subtypes","page":"Arrays with custom indices","title":"For objects that mimic AbstractArray but are not subtypes","text":"","category":"section"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"has_offset_axes depends on having axes defined for the objects you call it on. If there is some reason you don't have an axes method defined for your object, consider defining a method","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"Base.has_offset_axes(obj::MyNon1IndexedArraylikeObject) = true","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"This will allow code that assumes 1-based indexing to detect a problem and throw a helpful error, rather than returning incorrect results or segfaulting julia.","category":"page"},{"location":"devdocs/offset-arrays.html#Catching-errors","page":"Arrays with custom indices","title":"Catching errors","text":"","category":"section"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"If your new array type triggers errors in other code, one helpful debugging step can be to comment out @boundscheck in your getindex and setindex! implementation. This will ensure that every element access checks bounds. Or, restart julia with --check-bounds=yes.","category":"page"},{"location":"devdocs/offset-arrays.html","page":"Arrays with custom indices","title":"Arrays with custom indices","text":"In some cases it may also be helpful to temporarily disable size and length for your new array type, since code that makes incorrect assumptions frequently uses these functions.","category":"page"},{"location":"devdocs/boundscheck.html#Bounds-checking","page":"Bounds checking","title":"Bounds checking","text":"","category":"section"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"Like many modern programming languages, Julia uses bounds checking to ensure program safety when accessing arrays. In tight inner loops or other performance critical situations, you may wish to skip these bounds checks to improve runtime performance. For instance, in order to emit vectorized (SIMD) instructions, your loop body cannot contain branches, and thus cannot contain bounds checks. Consequently, Julia includes an @inbounds(...) macro to tell the compiler to skip such bounds checks within the given block. User-defined array types can use the @boundscheck(...) macro to achieve context-sensitive code selection.","category":"page"},{"location":"devdocs/boundscheck.html#Eliding-bounds-checks","page":"Bounds checking","title":"Eliding bounds checks","text":"","category":"section"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"The @boundscheck(...) macro marks blocks of code that perform bounds checking. When such blocks are inlined into an @inbounds(...) block, the compiler may remove these blocks. The compiler removes the @boundscheck block only if it is inlined into the calling function. For example, you might write the method sum as:","category":"page"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"function sum(A::AbstractArray)\n    r = zero(eltype(A))\n    for i in eachindex(A)\n        @inbounds r += A[i]\n    end\n    return r\nend","category":"page"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"With a custom array-like type MyArray having:","category":"page"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"@inline getindex(A::MyArray, i::Real) = (@boundscheck checkbounds(A, i); A.data[to_index(i)])","category":"page"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"Then when getindex is inlined into sum, the call to checkbounds(A, i) will be elided. If your function contains multiple layers of inlining, only @boundscheck blocks at most one level of inlining deeper are eliminated. The rule prevents unintended changes in program behavior from code further up the stack.","category":"page"},{"location":"devdocs/boundscheck.html#Caution!","page":"Bounds checking","title":"Caution!","text":"","category":"section"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"It is easy to accidentally expose unsafe operations with @inbounds. You might be tempted to write the above example as","category":"page"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"function sum(A::AbstractArray)\n    r = zero(eltype(A))\n    for i in 1:length(A)\n        @inbounds r += A[i]\n    end\n    return r\nend","category":"page"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"Which quietly assumes 1-based indexing and therefore exposes unsafe memory access when used with OffsetArrays:","category":"page"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"julia> using OffsetArrays\n\njulia> sum(OffsetArray([1, 2, 3], -10))\n9164911648 # inconsistent results or segfault","category":"page"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"While the original source of the error here is 1:length(A), the use of @inbounds increases the consequences from a bounds error to a less easily caught and debugged unsafe memory access. It is often difficult or impossible to prove that a method which uses @inbounds is safe, so one must weigh the benefits of performance improvements against the risk of segfaults and silent misbehavior, especially in public facing APIs.","category":"page"},{"location":"devdocs/boundscheck.html#Propagating-inbounds","page":"Bounds checking","title":"Propagating inbounds","text":"","category":"section"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"There may be certain scenarios where for code-organization reasons you want more than one layer between the @inbounds and @boundscheck declarations. For instance, the default getindex methods have the chain getindex(A::AbstractArray, i::Real) calls getindex(IndexStyle(A), A, i) calls _getindex(::IndexLinear, A, i).","category":"page"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"To override the \"one layer of inlining\" rule, a function may be marked with Base.@propagate_inbounds to propagate an inbounds context (or out of bounds context) through one additional layer of inlining.","category":"page"},{"location":"devdocs/boundscheck.html#The-bounds-checking-call-hierarchy","page":"Bounds checking","title":"The bounds checking call hierarchy","text":"","category":"section"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"The overall hierarchy is:","category":"page"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"checkbounds(A, I...) which calls\ncheckbounds(Bool, A, I...) which calls\ncheckbounds_indices(Bool, axes(A), I) which recursively calls\ncheckindex for each dimension","category":"page"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"Here A is the array, and I contains the \"requested\" indices. axes(A) returns a tuple of \"permitted\" indices of A.","category":"page"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"checkbounds(A, I...) throws an error if the indices are invalid, whereas checkbounds(Bool, A, I...) returns false in that circumstance.  checkbounds_indices discards any information about the array other than its axes tuple, and performs a pure indices-vs-indices comparison: this allows relatively few compiled methods to serve a huge variety of array types. Indices are specified as tuples, and are usually compared in a 1-1 fashion with individual dimensions handled by calling another important function, checkindex: typically,","category":"page"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"checkbounds_indices(Bool, (IA1, IA...), (I1, I...)) = checkindex(Bool, IA1, I1) &\n                                                      checkbounds_indices(Bool, IA, I)","category":"page"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"so checkindex checks a single dimension.  All of these functions, including the unexported checkbounds_indices have docstrings accessible with ? .","category":"page"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"If you have to customize bounds checking for a specific array type, you should specialize checkbounds(Bool, A, I...). However, in most cases you should be able to rely on checkbounds_indices as long as you supply useful axes for your array type.","category":"page"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"If you have novel index types, first consider specializing checkindex, which handles a single index for a particular dimension of an array.  If you have a custom multidimensional index type (similar to CartesianIndex), then you may have to consider specializing checkbounds_indices.","category":"page"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"Note this hierarchy has been designed to reduce the likelihood of method ambiguities.  We try to make checkbounds the place to specialize on array type, and try to avoid specializations on index types; conversely, checkindex is intended to be specialized only on index type (especially, the last argument).","category":"page"},{"location":"devdocs/boundscheck.html#Emit-bounds-checks","page":"Bounds checking","title":"Emit bounds checks","text":"","category":"section"},{"location":"devdocs/boundscheck.html","page":"Bounds checking","title":"Bounds checking","text":"Julia can be launched with --check-bounds={yes|no|auto} to emit bounds checks always, never, or respect @inbounds declarations.","category":"page"},{"location":"devdocs/build/build.html#Building-Julia-(Detailed)","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"","category":"section"},{"location":"devdocs/build/build.html#Downloading-the-Julia-source-code","page":"Building Julia (Detailed)","title":"Downloading the Julia source code","text":"","category":"section"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"If you are behind a firewall, you may need to use the https protocol instead of the git protocol:","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"git config --global url.\"https://\".insteadOf git://","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Be sure to also configure your system to use the appropriate proxy settings, e.g. by setting the https_proxy and http_proxy variables.","category":"page"},{"location":"devdocs/build/build.html#Building-Julia","page":"Building Julia (Detailed)","title":"Building Julia","text":"","category":"section"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"When compiled the first time, the build will automatically download pre-built external dependencies. If you prefer to build all the dependencies on your own, or are building on a system that cannot access the network during the build process, add the following in Make.user:","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"USE_BINARYBUILDER=0","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Building Julia requires 5GiB if building all dependencies and approximately 4GiB of virtual memory.","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"To perform a parallel build, use make -j N and supply the maximum number of concurrent processes. If the defaults in the build do not work for you, and you need to set specific make parameters, you can save them in Make.user, and place the file in the root of your Julia source. The build will automatically check for the existence of Make.user and use it if it exists.","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"You can create out-of-tree builds of Julia by specifying make O=<build-directory> configure on the command line. This will create a directory mirror, with all of the necessary Makefiles to build Julia, in the specified directory. These builds will share the source files in Julia and deps/srccache. Each out-of-tree build directory can have its own Make.user file to override the global Make.user file in the top-level folder.","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"If everything works correctly, you will see a Julia banner and an interactive prompt into which you can enter expressions for evaluation. (Errors related to libraries might be caused by old, incompatible libraries sitting around in your PATH. In this case, try moving the julia directory earlier in the PATH). Note that most of the instructions above apply to unix systems.","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"To run julia from anywhere you can:","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"add an alias (in bash: echo \"alias julia='/path/to/install/folder/bin/julia'\" >> ~/.bashrc && source ~/.bashrc), or\nadd a soft link to the julia executable in the julia directory to /usr/local/bin (or any suitable directory already in your path), or\nadd the julia directory to your executable path for this shell session (in bash: export PATH=\"$(pwd):$PATH\" ; in csh or tcsh:","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"set path= ( $path $cwd ) ), or","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"add the julia directory to your executable path permanently (e.g. in .bash_profile), or\nwrite prefix=/path/to/install/folder into Make.user and then run make install. If there is a version of Julia already installed in this folder, you should delete it before running make install.","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Some of the options you can set to control the build of Julia are listed and documented at the beginning of the file Make.inc, but you should never edit it for this purpose, use Make.user instead.","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Julia's Makefiles define convenient automatic rules called print-<VARNAME> for printing the value of variables, replacing <VARNAME> with the name of the variable to print the value of. For example","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"$ make print-JULIA_PRECOMPILE\nJULIA_PRECOMPILE=1","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"These rules are useful for debugging purposes.","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Now you should be able to run Julia like this:","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"julia","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"If you are building a Julia package for distribution on Linux, macOS, or Windows, take a look at the detailed notes in distributing.md.","category":"page"},{"location":"devdocs/build/build.html#Updating-an-existing-source-tree","page":"Building Julia (Detailed)","title":"Updating an existing source tree","text":"","category":"section"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"If you have previously downloaded julia using git clone, you can update the existing source tree using git pull rather than starting anew:","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"cd julia\ngit pull && make","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Assuming that you had made no changes to the source tree that will conflict with upstream updates, these commands will trigger a build to update to the latest version.","category":"page"},{"location":"devdocs/build/build.html#General-troubleshooting","page":"Building Julia (Detailed)","title":"General troubleshooting","text":"","category":"section"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Over time, the base library may accumulate enough changes such that the bootstrapping process in building the system image will fail. If this happens, the build may fail with an error like\n *** This error is usually fixed by running 'make clean'. If the error persists, try 'make cleanall' ***\nAs described, running make clean && make is usually sufficient. Occasionally, the stronger cleanup done by make cleanall is needed.\nNew versions of external dependencies may be introduced which may occasionally cause conflicts with existing builds of older versions.\na. Special make targets exist to help wipe the existing build of a    dependency. For example, make -C deps clean-llvm will clean out the    existing build of llvm so that llvm will be rebuilt from the    downloaded source distribution the next time make is called.    make -C deps distclean-llvm is a stronger wipe which will also delete    the downloaded source distribution, ensuring that a fresh copy of the    source distribution will be downloaded and that any new patches will be    applied the next time make is called.\nb. To delete existing binaries of julia and all its dependencies,    delete the ./usr directory in the source tree.\nIf you've updated macOS recently, be sure to run xcode-select --install to update the command line tools. Otherwise, you could run into errors for missing headers and libraries, such as ld: library not found for -lcrt1.10.6.o.\nIf you've moved the source directory, you might get errors such as  CMake Error: The current CMakeCache.txt directory ... is different than the directory ... where     CMakeCache.txt was created., in which case you may delete the offending dependency under deps\nIn extreme cases, you may wish to reset the source tree to a pristine state. The following git commands may be helpful:\n git reset --hard #Forcibly remove any changes to any files under version control\n git clean -x -f -d #Forcibly remove any file or directory not under version control\nTo avoid losing work, make sure you know what these commands do before you run them. git will not be able to undo these changes!","category":"page"},{"location":"devdocs/build/build.html#Platform-Specific-Notes","page":"Building Julia (Detailed)","title":"Platform-Specific Notes","text":"","category":"section"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Notes for various operating systems:","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Linux\nmacOS\nWindows\nFreeBSD","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Notes for various architectures:","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"ARM","category":"page"},{"location":"devdocs/build/build.html#Required-Build-Tools-and-External-Libraries","page":"Building Julia (Detailed)","title":"Required Build Tools and External Libraries","text":"","category":"section"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Building Julia requires that the following software be installed:","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"[GNU make]                — building dependencies.\n[gcc & g++][gcc] (>= 7.1) or [Clang][clang] (>= 5.0, >= 9.3 for Apple Clang) — compiling and linking C, C++.\n[libatomic][gcc]          — provided by [gcc] and needed to support atomic operations.\n[python] (>=2.7)          — needed to build LLVM.\n[gfortran]                — compiling and linking Fortran libraries.\n[perl]                    — preprocessing of header files of libraries.\n[wget], [curl], or [fetch] (FreeBSD) — to automatically download external libraries.\n[m4]                      — needed to build GMP.\n[awk]                     — helper tool for Makefiles.\n[patch]                   — for modifying source code.\n[cmake] (>= 3.4.3)        — needed to build libgit2.\n[pkg-config]              — needed to build libgit2 correctly, especially for proxy support.\n[powershell] (>= 3.0)     — necessary only on Windows.\n[which]                   — needed for checking build dependencies.","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"On Debian-based distributions (e.g. Ubuntu), you can easily install them with apt-get:","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"sudo apt-get install build-essential libatomic1 python gfortran perl wget m4 cmake pkg-config curl","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Julia uses the following external libraries, which are automatically downloaded (or in a few cases, included in the Julia source repository) and then compiled from source the first time you run make. The specific version numbers of these libraries that Julia uses are listed in deps/$(libname).version:","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"[LLVM] (15.0 + patches) — compiler infrastructure (see note below).\n[FemtoLisp]            — packaged with Julia source, and used to implement the compiler front-end.\n[libuv]  (custom fork) — portable, high-performance event-based I/O library.\n[OpenLibm]             — portable libm library containing elementary math functions.\n[DSFMT]                — fast Mersenne Twister pseudorandom number generator library.\n[OpenBLAS]             — fast, open, and maintained [basic linear algebra subprograms (BLAS)]\n[LAPACK]               — library of linear algebra routines for solving systems of simultaneous linear equations, least-squares solutions of linear systems of equations, eigenvalue problems, and singular value problems.\n[MKL] (optional)       – OpenBLAS and LAPACK may be replaced by Intel's MKL library.\n[SuiteSparse]          — library of linear algebra routines for sparse matrices.\n[PCRE]                 — Perl-compatible regular expressions library.\n[GMP]                  — GNU multiple precision arithmetic library, needed for BigInt support.\n[MPFR]                 — GNU multiple precision floating point library, needed for arbitrary precision floating point (BigFloat) support.\n[libgit2]              — Git linkable library, used by Julia's package manager.\n[curl]                 — libcurl provides download and proxy support.\n[libssh2]              — library for SSH transport, used by libgit2 for packages with SSH remotes.\n[mbedtls]              — library used for cryptography and transport layer security, used by libssh2\n[utf8proc]             — a library for processing UTF-8 encoded Unicode strings.\n[LLVM libunwind]       — LLVM's fork of [libunwind], a library that determines the call-chain of a program.\n[ITTAPI]               — Intel's Instrumentation and Tracing Technology and Just-In-Time API.","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"[GNU make]:     https://www.gnu.org/software/make [patch]:        https://www.gnu.org/software/patch [wget]:         https://www.gnu.org/software/wget [m4]:           https://www.gnu.org/software/m4 [awk]:          https://www.gnu.org/software/gawk [gcc]:          https://gcc.gnu.org [clang]:        https://clang.llvm.org [python]:       https://www.python.org/ [gfortran]:     https://gcc.gnu.org/fortran/ [curl]:         https://curl.haxx.se [fetch]:        https://www.freebsd.org/cgi/man.cgi?fetch(1) [perl]:         https://www.perl.org [cmake]:        https://www.cmake.org [OpenLibm]:     https://github.com/JuliaLang/openlibm [DSFMT]:        https://github.com/MersenneTwister-Lab/dSFMT [OpenBLAS]:     https://github.com/xianyi/OpenBLAS [LAPACK]:       https://www.netlib.org/lapack [MKL]:          https://software.intel.com/en-us/articles/intel-mkl [SuiteSparse]:  https://people.engr.tamu.edu/davis/suitesparse.html [PCRE]:         https://www.pcre.org [LLVM]:         https://www.llvm.org [LLVM libunwind]: https://github.com/llvm/llvm-project/tree/main/libunwind [FemtoLisp]:    https://github.com/JeffBezanson/femtolisp [GMP]:          https://gmplib.org [MPFR]:         https://www.mpfr.org [libuv]:        https://github.com/JuliaLang/libuv [libgit2]:      https://libgit2.org/ [utf8proc]:     https://julialang.org/utf8proc/ [libunwind]:    https://www.nongnu.org/libunwind [libssh2]:      https://www.libssh2.org [mbedtls]:      https://tls.mbed.org/ [pkg-config]:   https://www.freedesktop.org/wiki/Software/pkg-config/ [powershell]:   https://docs.microsoft.com/en-us/powershell/scripting/wmf/overview [which]:        https://carlowood.github.io/which/ [ITTAPI]:       https://github.com/intel/ittapi","category":"page"},{"location":"devdocs/build/build.html#Build-dependencies","page":"Building Julia (Detailed)","title":"Build dependencies","text":"","category":"section"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"If you already have one or more of these packages installed on your system, you can prevent Julia from compiling duplicates of these libraries by passing USE_SYSTEM_...=1 to make or adding the line to Make.user. The complete list of possible flags can be found in Make.inc.","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Please be aware that this procedure is not officially supported, as it introduces additional variability into the installation and versioning of the dependencies, and is recommended only for system package maintainers. Unexpected compile errors may result, as the build system will do no further checking to ensure the proper packages are installed.","category":"page"},{"location":"devdocs/build/build.html#LLVM","page":"Building Julia (Detailed)","title":"LLVM","text":"","category":"section"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"The most complicated dependency is LLVM, for which we require additional patches from upstream (LLVM is not backward compatible).","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"For packaging Julia with LLVM, we recommend either:","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"bundling a Julia-only LLVM library inside the Julia package, or\nadding the patches to the LLVM package of the distribution.\nA complete list of patches is available in on Github see the julia-release/15.x branch.\nThe only Julia-specific patch is the lib renaming (llvm7-symver-jlprefix.patch), which should not be applied to a system LLVM.\nThe remaining patches are all upstream bug fixes, and have been contributed into upstream LLVM.","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Using an unpatched or different version of LLVM will result in errors and/or poor performance. You can build a different version of LLVM from a remote Git repository with the following options in the Make.user file:","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"# Force source build of LLVM\nUSE_BINARYBUILDER_LLVM = 0\n# Use Git for fetching LLVM source code\n# this is either `1` to get all of them\nDEPS_GIT = 1\n# or a space-separated list of specific dependencies to download with git\nDEPS_GIT = llvm\n\n# Other useful options:\n#URL of the Git repository you want to obtain LLVM from:\n#  LLVM_GIT_URL = ...\n#Name of the alternate branch to clone from git\n#  LLVM_BRANCH = julia-16.0.6-0\n#SHA hash of the alterate commit to check out automatically\n#  LLVM_SHA1 = $(LLVM_BRANCH)\n#List of LLVM targets to build.  It is strongly recommended to keep at least all the\n#default targets listed in `deps/llvm.mk`, even if you don't necessarily need all of them.\n#  LLVM_TARGETS = ...\n#Use ccache for faster recompilation in case you need to restart a build.\n#  USECCACHE = 1\n#  CMAKE_GENERATOR=Ninja\n#  LLVM_ASSERTIONS=1\n#  LLVM_DEBUG=Symbols","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"The various build phases are controlled by specific files:","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"deps/llvm.version : touch or change to checkout a new version, make get-llvm check-llvm\ndeps/srccache/llvm/source-extracted : result of make extract-llvm\ndeps/llvm/build_Release*/build-configured : result of make configure-llvm\ndeps/llvm/build_Release*/build-configured : result of make compile-llvm\nusr-staging/llvm/build_Release*.tgz : result of make stage-llvm (regenerate with make reinstall-llvm)\nusr/manifest/llvm : result of make install-llvm (regenerate with make uninstall-llvm)\nmake version-check-llvm : runs every time to warn the user if there are local modifications","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Though Julia can be built with newer LLVM versions, support for this should be regarded as experimental and not suitable for packaging.","category":"page"},{"location":"devdocs/build/build.html#libuv","page":"Building Julia (Detailed)","title":"libuv","text":"","category":"section"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Julia uses a custom fork of libuv. It is a small dependency, and can be safely bundled in the same package as Julia, and will not conflict with the system library. Julia builds should not try to use the system libuv.","category":"page"},{"location":"devdocs/build/build.html#BLAS-and-LAPACK","page":"Building Julia (Detailed)","title":"BLAS and LAPACK","text":"","category":"section"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"As a high-performance numerical language, Julia should be linked to a multi-threaded BLAS and LAPACK, such as OpenBLAS or ATLAS, which will provide much better performance than the reference libblas implementations which may be default on some systems.","category":"page"},{"location":"devdocs/build/build.html#Source-distributions-of-releases","page":"Building Julia (Detailed)","title":"Source distributions of releases","text":"","category":"section"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Each pre-release and release of Julia has a \"full\" source distribution and a \"light\" source distribution.","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"The full source distribution contains the source code for Julia and all dependencies so that it can be built from source without an internet connection. The light source distribution does not include the source code of dependencies.","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"For example, julia-1.0.0.tar.gz is the light source distribution for the v1.0.0 release of Julia, while julia-1.0.0-full.tar.gz is the full source distribution.","category":"page"},{"location":"devdocs/build/build.html#Building-Julia-from-source-with-a-Git-checkout-of-a-stdlib","page":"Building Julia (Detailed)","title":"Building Julia from source with a Git checkout of a stdlib","text":"","category":"section"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"If you need to build Julia from source with a Git checkout of a stdlib, then use make DEPS_GIT=NAME_OF_STDLIB when building Julia.","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"For example, if you need to build Julia from source with a Git checkout of Pkg, then use make DEPS_GIT=Pkg when building Julia. The Pkg repo is in stdlib/Pkg, and created initially with a detached HEAD. If you're doing this from a pre-existing Julia repository, you may need to make clean beforehand.","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"If you need to build Julia from source with Git checkouts of more than one stdlib, then DEPS_GIT should be a space-separated list of the stdlib names. For example, if you need to build Julia from source with a Git checkout of Pkg, Tar, and Downloads, then use make DEPS_GIT='Pkg Tar Downloads' when building Julia.","category":"page"},{"location":"devdocs/build/build.html#Building-an-\"assert-build\"-of-Julia","page":"Building Julia (Detailed)","title":"Building an \"assert build\" of Julia","text":"","category":"section"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"An \"assert build\" of Julia is a build that was built with both FORCE_ASSERTIONS=1 and LLVM_ASSERTIONS=1. To build an assert build, define both of the following variables in your Make.user file:","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"FORCE_ASSERTIONS=1\nLLVM_ASSERTIONS=1","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Please note that assert builds of Julia will be slower than regular (non-assert) builds.","category":"page"},{"location":"devdocs/build/build.html#Building-32-bit-Julia-on-a-64-bit-machine","page":"Building Julia (Detailed)","title":"Building 32-bit Julia on a 64-bit machine","text":"","category":"section"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Occasionally, bugs specific to 32-bit architectures may arise, and when this happens it is useful to be able to debug the problem on your local machine.  Since most modern 64-bit systems support running programs built for 32-bit ones, if you don't have to recompile Julia from source (e.g. you mainly need to inspect the behavior of a 32-bit Julia without having to touch the C code), you can likely use a 32-bit build of Julia for your system that you can obtain from the official downloads page. However, if you do need to recompile Julia from source one option is to use a Docker container of a 32-bit system.  At least for now, building a 32-bit version of Julia is relatively straightforward using ubuntu 32-bit docker images. In brief, after setting up docker here are the required steps:","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"$ docker pull i386/ubuntu\n$ docker run --platform i386 -i -t i386/ubuntu /bin/bash","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"At this point you should be in a 32-bit machine console (note that uname reports the host architecture, so will still say 64-bit, but this will not affect the Julia build). You can add packages and compile code; when you exit, all the changes will be lost, so be sure to finish your analysis in a single session or set up a copy/pastable script you can use to set up your environment.","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"From this point, you should","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"# apt update","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"(Note that sudo isn't installed, but neither is it necessary since you are running as root, so you can omit sudo from all commands.)","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Then add all the build dependencies, a console-based editor of your choice, git, and anything else you'll need (e.g., gdb, rr, etc). Pick a directory to work in and git clone Julia, check out the branch you wish to debug, and build Julia as usual.","category":"page"},{"location":"devdocs/build/build.html#Update-the-version-number-of-a-dependency","page":"Building Julia (Detailed)","title":"Update the version number of a dependency","text":"","category":"section"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"There are two types of builds","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Build everything (deps/ and src/) from source code.  (Add USE_BINARYBUILDER=0 to Make.user, see Building Julia)\nBuild from source (src/) with pre-compiled dependencies (default)","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"When you want to update the version number of a dependency in deps/, you may want to use the following checklist:","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"### Check list\n\nVersion numbers:\n- [ ] `deps/$(libname).version`: `LIBNAME_VER`, `LIBNAME_BRANCH`, `LIBNAME_SHA1` and `LIBNAME_JLL_VER`\n- [ ] `stdlib/$(LIBNAME_JLL_NAME)_jll/Project.toml`: `version`\n\nChecksum:\n- [ ] `deps/checksums/$(libname)`\n- [ ] `deps/checksums/$(LIBNAME_JLL_NAME)-*/`: `md5` and `sha512`\n\nPatches:\n- [ ] `deps/$(libname).mk`\n- [ ] `deps/patches/$(libname)-*.patch`","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Note:","category":"page"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"For specific dependencies, some items in the checklist may not exist.\nFor checksum file, it may be a single file without a suffix, or a folder containing two files.","category":"page"},{"location":"devdocs/build/build.html#Example:-OpenLibm","page":"Building Julia (Detailed)","title":"Example: OpenLibm","text":"","category":"section"},{"location":"devdocs/build/build.html","page":"Building Julia (Detailed)","title":"Building Julia (Detailed)","text":"Update Version numbers in deps/openlibm.version\nOPENLIBM_VER := 0.X.Y\nOPENLIBM_BRANCH = v0.X.Y\nOPENLIBM_SHA1 = new-sha1-hash\nUpdate Version number in stdlib/OpenLibm_jll/Project.toml\nversion = \"0.X.Y+0\"\nUpdate checksums in deps/checksums/openlibm\nmake -f contrib/refresh_checksums.mk openlibm\nCheck if the patch files deps/patches/openlibm-*.patch exist\nif patches don't exist, skip.\nif patches exist, check if they have been merged into the new version and need to be removed.   When deleting a patch, remember to modify the corresponding Makefile file (deps/openlibm.mk).","category":"page"},{"location":"devdocs/build/freebsd.html#FreeBSD","page":"FreeBSD","title":"FreeBSD","text":"","category":"section"},{"location":"devdocs/build/freebsd.html","page":"FreeBSD","title":"FreeBSD","text":"Clang is the default compiler on FreeBSD 11.0-RELEASE and above. The remaining build tools are available from the Ports Collection, and can be installed using pkg install git gcc gmake cmake pkgconf. To build Julia, simply run gmake. (Note that gmake must be used rather than make, since make on FreeBSD corresponds to the incompatible BSD Make rather than GNU Make.)","category":"page"},{"location":"devdocs/build/freebsd.html","page":"FreeBSD","title":"FreeBSD","text":"As mentioned above, it is important to note that the USE_SYSTEM_* flags should be used with caution on FreeBSD. This is because many system libraries, and even libraries from the Ports Collection, link to the system's libgcc_s.so.1, or to another library which links to the system libgcc_s. This library declares its GCC version to be 4.6, which is too old to build Julia, and conflicts with other libraries when linking. Thus it is highly recommended to simply allow Julia to build all of its dependencies. If you do choose to use the USE_SYSTEM_* flags, note that /usr/local is not on the compiler path by default, so you may need to add LDFLAGS=-L/usr/local/lib and CPPFLAGS=-I/usr/local/include to your Make.user, though doing so may interfere with other dependencies.","category":"page"},{"location":"devdocs/build/freebsd.html","page":"FreeBSD","title":"FreeBSD","text":"Note that the x86 architecture does not support threading due to lack of compiler runtime library support, so you may need to set JULIA_THREADS=0 in your Make.user if you're on a 32-bit system.","category":"page"},{"location":"stdlib/Downloads.html","page":"Downloads","title":"Downloads","text":"EditURL = \"https://github.com/JuliaLang/Downloads.jl/blob/master/docs/src/index.md\"","category":"page"},{"location":"stdlib/Downloads.html#Downloads","page":"Downloads","title":"Downloads","text":"","category":"section"},{"location":"stdlib/Downloads.html","page":"Downloads","title":"Downloads","text":"Downloads.download\nDownloads.request\nDownloads.Response\nDownloads.RequestError\nDownloads.Downloader","category":"page"},{"location":"stdlib/Downloads.html#Downloads.download","page":"Downloads","title":"Downloads.download","text":"download(url, [ output = tempname() ];\n    [ method = \"GET\", ]\n    [ headers = <none>, ]\n    [ timeout = <none>, ]\n    [ progress = <none>, ]\n    [ verbose = false, ]\n    [ debug = <none>, ]\n    [ downloader = <default>, ]\n) -> output\n\n    url        :: AbstractString\n    output     :: Union{AbstractString, AbstractCmd, IO}\n    method     :: AbstractString\n    headers    :: Union{AbstractVector, AbstractDict}\n    timeout    :: Real\n    progress   :: (total::Integer, now::Integer) --> Any\n    verbose    :: Bool\n    debug      :: (type, message) --> Any\n    downloader :: Downloader\n\nDownload a file from the given url, saving it to output or if not specified, a temporary path. The output can also be an IO handle, in which case the body of the response is streamed to that handle and the handle is returned. If output is a command, the command is run and output is sent to it on stdin.\n\nIf the downloader keyword argument is provided, it must be a Downloader object. Resources and connections will be shared between downloads performed by the same Downloader and cleaned up automatically when the object is garbage collected or there have been no downloads performed with it for a grace period. See Downloader for more info about configuration and usage.\n\nIf the headers keyword argument is provided, it must be a vector or dictionary whose elements are all pairs of strings. These pairs are passed as headers when downloading URLs with protocols that supports them, such as HTTP/S.\n\nThe timeout keyword argument specifies a timeout for the download to complete in seconds, with a resolution of milliseconds. By default no timeout is set, but this can also be explicitly requested by passing a timeout value of Inf. Separately, if 20 seconds elapse without receiving any data, the download will timeout. See extended help for how to disable this timeout.\n\nIf the progress keyword argument is provided, it must be a callback function which will be called whenever there are updates about the size and status of the ongoing download. The callback must take two integer arguments: total and now which are the total size of the download in bytes, and the number of bytes which have been downloaded so far. Note that total starts out as zero and remains zero until the server gives an indication of the total size of the download (e.g. with a Content-Length header), which may never happen. So a well-behaved progress callback should handle a total size of zero gracefully.\n\nIf the verbose option is set to true, libcurl, which is used to implement the download functionality will print debugging information to stderr. If the debug option is set to a function accepting two String arguments, then the verbose option is ignored and instead the data that would have been printed to stderr is passed to the debug callback with type and message arguments. The type argument indicates what kind of event has occurred, and is one of: TEXT, HEADER IN, HEADER OUT, DATA IN, DATA OUT, SSL DATA IN or SSL DATA OUT. The message argument is the description of the debug event.\n\nExtended Help\n\nFor further customization, use a Downloader and easy_hooks. For example, to disable the 20 second timeout when no data is received, you may use the following:\n\ndownloader = Downloads.Downloader()\ndownloader.easy_hook = (easy, info) -> Downloads.Curl.setopt(easy, Downloads.Curl.CURLOPT_LOW_SPEED_TIME, 0)\n\nDownloads.download(\"https://httpbingo.julialang.org/delay/30\"; downloader)\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Downloads.html#Downloads.request","page":"Downloads","title":"Downloads.request","text":"request(url;\n    [ input = <none>, ]\n    [ output = <none>, ]\n    [ method = input ? \"PUT\" : output ? \"GET\" : \"HEAD\", ]\n    [ headers = <none>, ]\n    [ timeout = <none>, ]\n    [ progress = <none>, ]\n    [ verbose = false, ]\n    [ debug = <none>, ]\n    [ throw = true, ]\n    [ downloader = <default>, ]\n    [ interrupt = <none>, ]\n) -> Union{Response, RequestError}\n\n    url        :: AbstractString\n    input      :: Union{AbstractString, AbstractCmd, IO}\n    output     :: Union{AbstractString, AbstractCmd, IO}\n    method     :: AbstractString\n    headers    :: Union{AbstractVector, AbstractDict}\n    timeout    :: Real\n    progress   :: (dl_total, dl_now, ul_total, ul_now) --> Any\n    verbose    :: Bool\n    debug      :: (type, message) --> Any\n    throw      :: Bool\n    downloader :: Downloader\n    interrupt  :: Base.Event\n\nMake a request to the given url, returning a Response object capturing the status, headers and other information about the response. The body of the response is written to output if specified and discarded otherwise. For HTTP/S requests, if an input stream is given, a PUT request is made; otherwise if an output stream is given, a GET request is made; if neither is given a HEAD request is made. For other protocols, appropriate default methods are used based on what combination of input and output are requested. The following options differ from the download function:\n\ninput allows providing a request body; if provided default to PUT request\nprogress is a callback taking four integers for upload and download progress\nthrow controls whether to throw or return a RequestError on request error\n\nNote that unlike download which throws an error if the requested URL could not be downloaded (indicated by non-2xx status code), request returns a Response object no matter what the status code of the response is. If there is an error with getting a response at all, then a RequestError is thrown or returned.\n\nIf the interrupt keyword argument is provided, it must be a Base.Event object. If the event is triggered while the request is in progress, the request will be cancelled and an error will be thrown. This can be used to interrupt a long running request, for example if the user wants to cancel a download.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Downloads.html#Downloads.Response","page":"Downloads","title":"Downloads.Response","text":"struct Response\n    proto   :: String\n    url     :: String\n    status  :: Int\n    message :: String\n    headers :: Vector{Pair{String,String}}\nend\n\nResponse is a type capturing the properties of a successful response to a request as an object. It has the following fields:\n\nproto: the protocol that was used to get the response\nurl: the URL that was ultimately requested after following redirects\nstatus: the status code of the response, indicating success, failure, etc.\nmessage: a textual message describing the nature of the response\nheaders: any headers that were returned with the response\n\nThe meaning and availability of some of these responses depends on the protocol used for the request. For many protocols, including HTTP/S and S/FTP, a 2xx status code indicates a successful response. For responses in protocols that do not support headers, the headers vector will be empty. HTTP/2 does not include a status message, only a status code, so the message will be empty.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Downloads.html#Downloads.RequestError","page":"Downloads","title":"Downloads.RequestError","text":"struct RequestError <: ErrorException\n    url      :: String\n    code     :: Int\n    message  :: String\n    response :: Response\nend\n\nRequestError is a type capturing the properties of a failed response to a request as an exception object:\n\nurl: the original URL that was requested without any redirects\ncode: the libcurl error code; 0 if a protocol-only error occurred\nmessage: the libcurl error message indicating what went wrong\nresponse: response object capturing what response info is available\n\nThe same RequestError type is thrown by download if the request was successful but there was a protocol-level error indicated by a status code that is not in the 2xx range, in which case code will be zero and the message field will be the empty string. The request API only throws a RequestError if the libcurl error code is non-zero, in which case the included response object is likely to have a status of zero and an empty message. There are, however, situations where a curl-level error is thrown due to a protocol error, in which case both the inner and outer code and message may be of interest.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Downloads.html#Downloads.Downloader","page":"Downloads","title":"Downloads.Downloader","text":"Downloader(; [ grace::Real = 30 ])\n\nDownloader objects are used to perform individual download operations. Connections, name lookups and other resources are shared within a Downloader. These connections and resources are cleaned up after a configurable grace period (default: 30 seconds) since anything was downloaded with it, or when it is garbage collected, whichever comes first. If the grace period is set to zero, all resources will be cleaned up immediately as soon as there are no more ongoing downloads in progress. If the grace period is set to Inf then resources are not cleaned up until Downloader is garbage collected.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/stdlib/Random/docs/src/index.md\"","category":"page"},{"location":"stdlib/Random.html#Random-Numbers","page":"Random Numbers","title":"Random Numbers","text":"","category":"section"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"DocTestSetup = :(using Random)","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Random number generation in Julia uses the Xoshiro256++ algorithm by default, with per-Task state. Other RNG types can be plugged in by inheriting the AbstractRNG type; they can then be used to obtain multiple streams of random numbers.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"The PRNGs (pseudorandom number generators) exported by the Random package are:","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"TaskLocalRNG: a token that represents use of the currently active Task-local stream, deterministically seeded from the parent task, or by RandomDevice (with system randomness) at program start\nXoshiro: generates a high-quality stream of random numbers with a small state vector and high performance using the Xoshiro256++ algorithm\nRandomDevice: for OS-provided entropy. This may be used for cryptographically secure random numbers (CS(P)RNG).\nMersenneTwister: an alternate high-quality PRNG which was the default in older versions of Julia, and is also quite fast, but requires much more space to store the state vector and generate a random sequence.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Most functions related to random generation accept an optional AbstractRNG object as first argument. Some also accept dimension specifications dims... (which can also be given as a tuple) to generate arrays of random values. In a multi-threaded program, you should generally use different RNG objects from different threads or tasks in order to be thread-safe. However, the default RNG is thread-safe as of Julia 1.3 (using a per-thread RNG up to version 1.6, and per-task thereafter).","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"The provided RNGs can generate uniform random numbers of the following types: Float16, Float32, Float64, BigFloat, Bool, Int8, UInt8, Int16, UInt16, Int32, UInt32, Int64, UInt64, Int128, UInt128, BigInt (or complex numbers of those types). Random floating point numbers are generated uniformly in 0 1). As BigInt represents unbounded integers, the interval must be specified (e.g. rand(big.(1:6))).","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Additionally, normal and exponential distributions are implemented for some AbstractFloat and Complex types, see randn and randexp for details.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"To generate random numbers from other distributions, see the Distributions.jl package.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"warning: Warning\nBecause the precise way in which random numbers are generated is considered an implementation detail, bug fixes and speed improvements may change the stream of numbers that are generated after a version change. Relying on a specific seed or generated stream of numbers during unit testing is thus discouraged - consider testing properties of the methods in question instead.","category":"page"},{"location":"stdlib/Random.html#Random-numbers-module","page":"Random Numbers","title":"Random numbers module","text":"","category":"section"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Random.Random","category":"page"},{"location":"stdlib/Random.html#Random.Random","page":"Random Numbers","title":"Random.Random","text":"Random\n\nSupport for generating random numbers. Provides rand, randn, AbstractRNG, MersenneTwister, and RandomDevice.\n\n\n\n\n\n","category":"module"},{"location":"stdlib/Random.html#Random-generation-functions","page":"Random Numbers","title":"Random generation functions","text":"","category":"section"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Random.rand\nRandom.rand!\nRandom.bitrand\nRandom.randn\nRandom.randn!\nRandom.randexp\nRandom.randexp!\nRandom.randstring","category":"page"},{"location":"stdlib/Random.html#Base.rand","page":"Random Numbers","title":"Base.rand","text":"rand([rng=default_rng()], [S], [dims...])\n\nPick a random element or array of random elements from the set of values specified by S; S can be\n\nan indexable collection (for example 1:9 or ('x', \"y\", :z))\nan AbstractDict or AbstractSet object\na string (considered as a collection of characters), or\na type from the list below, corresponding to the specified set of values\nconcrete integer types sample from typemin(S):typemax(S) (excepting BigInt which is not supported)\nconcrete floating point types sample from [0, 1)\nconcrete complex types Complex{T} if T is a sampleable type take their real and imaginary components independently from the set of values corresponding to T, but are not supported if T is not sampleable.\nall <:AbstractChar types sample from the set of valid Unicode scalars\na user-defined type and set of values; for implementation guidance please see Hooking into the Random API\na tuple type of known size and where each parameter of S is itself a sampleable type; return a value of type S. Note that tuple types such as Tuple{Vararg{T}} (unknown size) and Tuple{1:2} (parameterized with a value) are not supported\na Pair type, e.g. Pair{X, Y} such that rand is defined for X and Y, in which case random pairs are produced.\n\nS defaults to Float64. When only one argument is passed besides the optional rng and is a Tuple, it is interpreted as a collection of values (S) and not as dims.\n\nSee also randn for normally distributed numbers, and rand! and randn! for the in-place equivalents.\n\ncompat: Julia 1.1\nSupport for S as a tuple requires at least Julia 1.1.\n\ncompat: Julia 1.11\nSupport for S as a Tuple type requires at least Julia 1.11.\n\nExamples\n\njulia> rand(Int, 2)\n2-element Array{Int64,1}:\n 1339893410598768192\n 1575814717733606317\n\njulia> using Random\n\njulia> rand(Xoshiro(0), Dict(1=>2, 3=>4))\n3 => 4\n\njulia> rand((2, 3))\n3\n\njulia> rand(Float64, (2, 3))\n2×3 Array{Float64,2}:\n 0.999717  0.0143835  0.540787\n 0.696556  0.783855   0.938235\n\nnote: Note\nThe complexity of rand(rng, s::Union{AbstractDict,AbstractSet}) is linear in the length of s, unless an optimized method with constant complexity is available, which is the case for Dict, Set and dense BitSets. For more than a few calls, use rand(rng, collect(s)) instead, or either rand(rng, Dict(s)) or rand(rng, Set(s)) as appropriate.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Random.html#Random.rand!","page":"Random Numbers","title":"Random.rand!","text":"rand!([rng=default_rng()], A, [S=eltype(A)])\n\nPopulate the array A with random values. If S is specified (S can be a type or a collection, cf. rand for details), the values are picked randomly from S. This is equivalent to copyto!(A, rand(rng, S, size(A))) but without allocating a new array.\n\nExamples\n\njulia> rand!(Xoshiro(123), zeros(5))\n5-element Vector{Float64}:\n 0.521213795535383\n 0.5868067574533484\n 0.8908786980927811\n 0.19090669902576285\n 0.5256623915420473\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Random.html#Random.bitrand","page":"Random Numbers","title":"Random.bitrand","text":"bitrand([rng=default_rng()], [dims...])\n\nGenerate a BitArray of random boolean values.\n\nExamples\n\njulia> bitrand(Xoshiro(123), 10)\n10-element BitVector:\n 0\n 1\n 0\n 1\n 0\n 1\n 0\n 0\n 1\n 1\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Random.html#Base.randn","page":"Random Numbers","title":"Base.randn","text":"randn([rng=default_rng()], [T=Float64], [dims...])\n\nGenerate a normally-distributed random number of type T with mean 0 and standard deviation 1. Given the optional dims argument(s), generate an array of size dims of such numbers. Julia's standard library supports randn for any floating-point type that implements rand, e.g. the Base types Float16, Float32, Float64 (the default), and BigFloat, along with their Complex counterparts.\n\n(When T is complex, the values are drawn from the circularly symmetric complex normal distribution of variance 1, corresponding to real and imaginary parts having independent normal distribution with mean zero and variance 1/2).\n\nSee also randn! to act in-place.\n\nExamples\n\nGenerating a single random number (with the default Float64 type):\n\njulia> randn()\n-0.942481877315864\n\nGenerating a matrix of normal random numbers (with the default Float64 type):\n\njulia> randn(2,3)\n2×3 Matrix{Float64}:\n  1.18786   -0.678616   1.49463\n -0.342792  -0.134299  -1.45005\n\nSetting up of the random number generator rng with a user-defined seed (for reproducible numbers) and using it to generate a random Float32 number or a matrix of ComplexF32 random numbers:\n\njulia> using Random\n\njulia> rng = Xoshiro(123);\n\njulia> randn(rng, Float32)\n-0.6457307f0\n\njulia> randn(rng, ComplexF32, (2, 3))\n2×3 Matrix{ComplexF32}:\n  -1.03467-1.14806im  0.693657+0.056538im   0.291442+0.419454im\n -0.153912+0.34807im    1.0954-0.948661im  -0.543347-0.0538589im\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Random.html#Random.randn!","page":"Random Numbers","title":"Random.randn!","text":"randn!([rng=default_rng()], A::AbstractArray) -> A\n\nFill the array A with normally-distributed (mean 0, standard deviation 1) random numbers. Also see the rand function.\n\nExamples\n\njulia> randn!(Xoshiro(123), zeros(5))\n5-element Vector{Float64}:\n -0.6457306721039767\n -1.4632513788889214\n -1.6236037455860806\n -0.21766510678354617\n  0.4922456865251828\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Random.html#Random.randexp","page":"Random Numbers","title":"Random.randexp","text":"randexp([rng=default_rng()], [T=Float64], [dims...])\n\nGenerate a random number of type T according to the exponential distribution with scale 1. Optionally generate an array of such random numbers. The Base module currently provides an implementation for the types Float16, Float32, and Float64 (the default).\n\nExamples\n\njulia> rng = Xoshiro(123);\n\njulia> randexp(rng, Float32)\n1.1757717f0\n\njulia> randexp(rng, 3, 3)\n3×3 Matrix{Float64}:\n 1.37766  0.456653  0.236418\n 3.40007  0.229917  0.0684921\n 0.48096  0.577481  0.71835\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Random.html#Random.randexp!","page":"Random Numbers","title":"Random.randexp!","text":"randexp!([rng=default_rng()], A::AbstractArray) -> A\n\nFill the array A with random numbers following the exponential distribution (with scale 1).\n\nExamples\n\njulia> randexp!(Xoshiro(123), zeros(5))\n5-element Vector{Float64}:\n 1.1757716836348473\n 1.758884569451514\n 1.0083623637301151\n 0.3510644315565272\n 0.6348266443720407\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Random.html#Random.randstring","page":"Random Numbers","title":"Random.randstring","text":"randstring([rng=default_rng()], [chars], [len=8])\n\nCreate a random string of length len, consisting of characters from chars, which defaults to the set of upper- and lower-case letters and the digits 0-9. The optional rng argument specifies a random number generator, see Random Numbers.\n\nExamples\n\njulia> Random.seed!(3); randstring()\n\"Lxz5hUwn\"\n\njulia> randstring(Xoshiro(3), 'a':'z', 6)\n\"iyzcsm\"\n\njulia> randstring(\"ACGT\")\n\"TGCTCCTC\"\n\nnote: Note\nchars can be any collection of characters, of type Char or UInt8 (more efficient), provided rand can randomly pick characters from it.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Random.html#Subsequences,-permutations-and-shuffling","page":"Random Numbers","title":"Subsequences, permutations and shuffling","text":"","category":"section"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Random.randsubseq\nRandom.randsubseq!\nRandom.randperm\nRandom.randperm!\nRandom.randcycle\nRandom.randcycle!\nRandom.shuffle\nRandom.shuffle!","category":"page"},{"location":"stdlib/Random.html#Random.randsubseq","page":"Random Numbers","title":"Random.randsubseq","text":"randsubseq([rng=default_rng(),] A, p) -> Vector\n\nReturn a vector consisting of a random subsequence of the given array A, where each element of A is included (in order) with independent probability p. (Complexity is linear in p*length(A), so this function is efficient even if p is small and A is large.) Technically, this process is known as \"Bernoulli sampling\" of A.\n\nExamples\n\njulia> randsubseq(Xoshiro(123), 1:8, 0.3)\n2-element Vector{Int64}:\n 4\n 7\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Random.html#Random.randsubseq!","page":"Random Numbers","title":"Random.randsubseq!","text":"randsubseq!([rng=default_rng(),] S, A, p)\n\nLike randsubseq, but the results are stored in S (which is resized as needed).\n\nExamples\n\njulia> S = Int64[];\n\njulia> randsubseq!(Xoshiro(123), S, 1:8, 0.3)\n2-element Vector{Int64}:\n 4\n 7\n\njulia> S\n2-element Vector{Int64}:\n 4\n 7\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Random.html#Random.randperm","page":"Random Numbers","title":"Random.randperm","text":"randperm([rng=default_rng(),] n::Integer)\n\nConstruct a random permutation of length n. The optional rng argument specifies a random number generator (see Random Numbers). The element type of the result is the same as the type of n.\n\nTo randomly permute an arbitrary vector, see shuffle or shuffle!.\n\ncompat: Julia 1.1\nIn Julia 1.1 randperm returns a vector v with eltype(v) == typeof(n) while in Julia 1.0 eltype(v) == Int.\n\nExamples\n\njulia> randperm(Xoshiro(123), 4)\n4-element Vector{Int64}:\n 1\n 4\n 2\n 3\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Random.html#Random.randperm!","page":"Random Numbers","title":"Random.randperm!","text":"randperm!([rng=default_rng(),] A::Array{<:Integer})\n\nConstruct in A a random permutation of length length(A). The optional rng argument specifies a random number generator (see Random Numbers). To randomly permute an arbitrary vector, see shuffle or shuffle!.\n\nExamples\n\njulia> randperm!(Xoshiro(123), Vector{Int}(undef, 4))\n4-element Vector{Int64}:\n 1\n 4\n 2\n 3\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Random.html#Random.randcycle","page":"Random Numbers","title":"Random.randcycle","text":"randcycle([rng=default_rng(),] n::Integer)\n\nConstruct a random cyclic permutation of length n. The optional rng argument specifies a random number generator, see Random Numbers. The element type of the result is the same as the type of n.\n\nHere, a \"cyclic permutation\" means that all of the elements lie within a single cycle.  If n > 0, there are (n-1) possible cyclic permutations, which are sampled uniformly.  If n == 0, randcycle returns an empty vector.\n\nrandcycle! is an in-place variant of this function.\n\ncompat: Julia 1.1\nIn Julia 1.1 and above, randcycle returns a vector v with eltype(v) == typeof(n) while in Julia 1.0 eltype(v) == Int.\n\nExamples\n\njulia> randcycle(Xoshiro(123), 6)\n6-element Vector{Int64}:\n 5\n 4\n 2\n 6\n 3\n 1\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Random.html#Random.randcycle!","page":"Random Numbers","title":"Random.randcycle!","text":"randcycle!([rng=default_rng(),] A::Array{<:Integer})\n\nConstruct in A a random cyclic permutation of length n = length(A). The optional rng argument specifies a random number generator, see Random Numbers.\n\nHere, a \"cyclic permutation\" means that all of the elements lie within a single cycle. If A is nonempty (n > 0), there are (n-1) possible cyclic permutations, which are sampled uniformly.  If A is empty, randcycle! leaves it unchanged.\n\nrandcycle is a variant of this function that allocates a new vector.\n\nExamples\n\njulia> randcycle!(Xoshiro(123), Vector{Int}(undef, 6))\n6-element Vector{Int64}:\n 5\n 4\n 2\n 6\n 3\n 1\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Random.html#Random.shuffle","page":"Random Numbers","title":"Random.shuffle","text":"shuffle([rng=default_rng(),] v::AbstractArray)\n\nReturn a randomly permuted copy of v. The optional rng argument specifies a random number generator (see Random Numbers). To permute v in-place, see shuffle!. To obtain randomly permuted indices, see randperm.\n\nExamples\n\njulia> shuffle(Xoshiro(123), Vector(1:10))\n10-element Vector{Int64}:\n  5\n  4\n  2\n  3\n  6\n 10\n  8\n  1\n  9\n  7\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Random.html#Random.shuffle!","page":"Random Numbers","title":"Random.shuffle!","text":"shuffle!([rng=default_rng(),] v::AbstractArray)\n\nIn-place version of shuffle: randomly permute v in-place, optionally supplying the random-number generator rng.\n\nExamples\n\njulia> shuffle!(Xoshiro(123), Vector(1:10))\n10-element Vector{Int64}:\n  5\n  4\n  2\n  3\n  6\n 10\n  8\n  1\n  9\n  7\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Random.html#Generators-(creation-and-seeding)","page":"Random Numbers","title":"Generators (creation and seeding)","text":"","category":"section"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Random.default_rng\nRandom.seed!\nRandom.AbstractRNG\nRandom.TaskLocalRNG\nRandom.Xoshiro\nRandom.MersenneTwister\nRandom.RandomDevice","category":"page"},{"location":"stdlib/Random.html#Random.default_rng","page":"Random Numbers","title":"Random.default_rng","text":"Random.default_rng() -> rng\n\nReturn the default global random number generator (RNG), which is used by rand-related functions when no explicit RNG is provided.\n\nWhen the Random module is loaded, the default RNG is randomly seeded, via Random.seed!(): this means that each time a new julia session is started, the first call to rand() produces a different result, unless seed!(seed) is called first.\n\nIt is thread-safe: distinct threads can safely call rand-related functions on default_rng() concurrently, e.g. rand(default_rng()).\n\nnote: Note\nThe type of the default RNG is an implementation detail. Across different versions of Julia, you should not expect the default RNG to always have the same type, nor that it will produce the same stream of random numbers for a given seed.\n\ncompat: Julia 1.3\nThis function was introduced in Julia 1.3.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Random.html#Random.seed!","page":"Random Numbers","title":"Random.seed!","text":"seed!([rng=default_rng()], seed) -> rng\nseed!([rng=default_rng()]) -> rng\n\nReseed the random number generator: rng will give a reproducible sequence of numbers if and only if a seed is provided. Some RNGs don't accept a seed, like RandomDevice. After the call to seed!, rng is equivalent to a newly created object initialized with the same seed. The types of accepted seeds depend on the type of rng, but in general, integer seeds should work.\n\nIf rng is not specified, it defaults to seeding the state of the shared task-local generator.\n\nExamples\n\njulia> Random.seed!(1234);\n\njulia> x1 = rand(2)\n2-element Vector{Float64}:\n 0.32597672886359486\n 0.5490511363155669\n\njulia> Random.seed!(1234);\n\njulia> x2 = rand(2)\n2-element Vector{Float64}:\n 0.32597672886359486\n 0.5490511363155669\n\njulia> x1 == x2\ntrue\n\njulia> rng = Xoshiro(1234); rand(rng, 2) == x1\ntrue\n\njulia> Xoshiro(1) == Random.seed!(rng, 1)\ntrue\n\njulia> rand(Random.seed!(rng), Bool) # not reproducible\ntrue\n\njulia> rand(Random.seed!(rng), Bool) # not reproducible either\nfalse\n\njulia> rand(Xoshiro(), Bool) # not reproducible either\ntrue\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Random.html#Random.AbstractRNG","page":"Random Numbers","title":"Random.AbstractRNG","text":"AbstractRNG\n\nSupertype for random number generators such as MersenneTwister and RandomDevice.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Random.html#Random.TaskLocalRNG","page":"Random Numbers","title":"Random.TaskLocalRNG","text":"TaskLocalRNG\n\nThe TaskLocalRNG has state that is local to its task, not its thread. It is seeded upon task creation, from the state of its parent task, but without advancing the state of the parent's RNG.\n\nAs an upside, the TaskLocalRNG is pretty fast, and permits reproducible multithreaded simulations (barring race conditions), independent of scheduler decisions. As long as the number of threads is not used to make decisions on task creation, simulation results are also independent of the number of available threads / CPUs. The random stream should not depend on hardware specifics, up to endianness and possibly word size.\n\nUsing or seeding the RNG of any other task than the one returned by current_task() is undefined behavior: it will work most of the time, and may sometimes fail silently.\n\nWhen seeding TaskLocalRNG() with seed!, the passed seed, if any, may be any integer.\n\ncompat: Julia 1.11\nSeeding TaskLocalRNG() with a negative integer seed requires at least Julia 1.11.\n\ncompat: Julia 1.10\nTask creation no longer advances the parent task's RNG state as of Julia 1.10.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Random.html#Random.Xoshiro","page":"Random Numbers","title":"Random.Xoshiro","text":"Xoshiro(seed::Union{Integer, AbstractString})\nXoshiro()\n\nXoshiro256++ is a fast pseudorandom number generator described by David Blackman and Sebastiano Vigna in \"Scrambled Linear Pseudorandom Number Generators\", ACM Trans. Math. Softw., 2021. Reference implementation is available at https://prng.di.unimi.it\n\nApart from the high speed, Xoshiro has a small memory footprint, making it suitable for applications where many different random states need to be held for long time.\n\nJulia's Xoshiro implementation has a bulk-generation mode; this seeds new virtual PRNGs from the parent, and uses SIMD to generate in parallel (i.e. the bulk stream consists of multiple interleaved xoshiro instances). The virtual PRNGs are discarded once the bulk request has been serviced (and should cause no heap allocations).\n\nIf no seed is provided, a randomly generated one is created (using entropy from the system). See the seed! function for reseeding an already existing Xoshiro object.\n\ncompat: Julia 1.11\nPassing a negative integer seed requires at least Julia 1.11.\n\nExamples\n\njulia> using Random\n\njulia> rng = Xoshiro(1234);\n\njulia> x1 = rand(rng, 2)\n2-element Vector{Float64}:\n 0.32597672886359486\n 0.5490511363155669\n\njulia> rng = Xoshiro(1234);\n\njulia> x2 = rand(rng, 2)\n2-element Vector{Float64}:\n 0.32597672886359486\n 0.5490511363155669\n\njulia> x1 == x2\ntrue\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Random.html#Random.MersenneTwister","page":"Random Numbers","title":"Random.MersenneTwister","text":"MersenneTwister(seed)\nMersenneTwister()\n\nCreate a MersenneTwister RNG object. Different RNG objects can have their own seeds, which may be useful for generating different streams of random numbers. The seed may be an integer, a string, or a vector of UInt32 integers. If no seed is provided, a randomly generated one is created (using entropy from the system). See the seed! function for reseeding an already existing MersenneTwister object.\n\ncompat: Julia 1.11\nPassing a negative integer seed requires at least Julia 1.11.\n\nExamples\n\njulia> rng = MersenneTwister(123);\n\njulia> x1 = rand(rng, 2)\n2-element Vector{Float64}:\n 0.37453777969575874\n 0.8735343642013971\n\njulia> x2 = rand(MersenneTwister(123), 2)\n2-element Vector{Float64}:\n 0.37453777969575874\n 0.8735343642013971\n\njulia> x1 == x2\ntrue\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Random.html#Random.RandomDevice","page":"Random Numbers","title":"Random.RandomDevice","text":"RandomDevice()\n\nCreate a RandomDevice RNG object. Two such objects will always generate different streams of random numbers. The entropy is obtained from the operating system.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Random.html#rand-api-hook","page":"Random Numbers","title":"Hooking into the Random API","text":"","category":"section"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"There are two mostly orthogonal ways to extend Random functionalities:","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"generating random values of custom types\ncreating new generators","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"The API for 1) is quite functional, but is relatively recent so it may still have to evolve in subsequent releases of the Random module. For example, it's typically sufficient to implement one rand method in order to have all other usual methods work automatically.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"The API for 2) is still rudimentary, and may require more work than strictly necessary from the implementor, in order to support usual types of generated values.","category":"page"},{"location":"stdlib/Random.html#Generating-random-values-of-custom-types","page":"Random Numbers","title":"Generating random values of custom types","text":"","category":"section"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Generating random values for some distributions may involve various trade-offs. Pre-computed values, such as an alias table for discrete distributions, or “squeezing” functions for univariate distributions, can speed up sampling considerably. How much information should be pre-computed can depend on the number of values we plan to draw from a distribution. Also, some random number generators can have certain properties that various algorithms may want to exploit.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"The Random module defines a customizable framework for obtaining random values that can address these issues. Each invocation of rand generates a sampler which can be customized with the above trade-offs in mind, by adding methods to Sampler, which in turn can dispatch on the random number generator, the object that characterizes the distribution, and a suggestion for the number of repetitions. Currently, for the latter, Val{1} (for a single sample) and Val{Inf} (for an arbitrary number) are used, with Random.Repetition an alias for both.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"The object returned by Sampler is then used to generate the random values. When implementing the random generation interface for a value X that can be sampled from, the implementor should define the method","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"rand(rng, sampler)","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"for the particular sampler returned by Sampler(rng, X, repetition).","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Samplers can be arbitrary values that implement rand(rng, sampler), but for most applications the following predefined samplers may be sufficient:","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"SamplerType{T}() can be used for implementing samplers that draw from type T (e.g. rand(Int)). This is the default returned by Sampler for types.\nSamplerTrivial(self) is a simple wrapper for self, which can be accessed with []. This is the recommended sampler when no pre-computed information is needed (e.g. rand(1:3)), and is the default returned by Sampler for values.\nSamplerSimple(self, data) also contains the additional data field, which can be used to store arbitrary pre-computed values, which should be computed in a custom method of Sampler.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"We provide examples for each of these. We assume here that the choice of algorithm is independent of the RNG, so we use AbstractRNG in our signatures.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Random.Sampler\nRandom.SamplerType\nRandom.SamplerTrivial\nRandom.SamplerSimple","category":"page"},{"location":"stdlib/Random.html#Random.Sampler","page":"Random Numbers","title":"Random.Sampler","text":"Sampler(rng, x, repetition = Val(Inf))\n\nReturn a sampler object that can be used to generate random values from rng for x.\n\nWhen sp = Sampler(rng, x, repetition), rand(rng, sp) will be used to draw random values, and should be defined accordingly.\n\nrepetition can be Val(1) or Val(Inf), and should be used as a suggestion for deciding the amount of precomputation, if applicable.\n\nRandom.SamplerType and Random.SamplerTrivial are default fallbacks for types and values, respectively. Random.SamplerSimple can be used to store pre-computed values without defining extra types for only this purpose.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Random.html#Random.SamplerType","page":"Random Numbers","title":"Random.SamplerType","text":"SamplerType{T}()\n\nA sampler for types, containing no other information. The default fallback for Sampler when called with types.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Random.html#Random.SamplerTrivial","page":"Random Numbers","title":"Random.SamplerTrivial","text":"SamplerTrivial(x)\n\nCreate a sampler that just wraps the given value x. This is the default fall-back for values. The eltype of this sampler is equal to eltype(x).\n\nThe recommended use case is sampling from values without precomputed data.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Random.html#Random.SamplerSimple","page":"Random Numbers","title":"Random.SamplerSimple","text":"SamplerSimple(x, data)\n\nCreate a sampler that wraps the given value x and the data. The eltype of this sampler is equal to eltype(x).\n\nThe recommended use case is sampling from values with precomputed data.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Decoupling pre-computation from actually generating the values is part of the API, and is also available to the user. As an example, assume that rand(rng, 1:20) has to be called repeatedly in a loop: the way to take advantage of this decoupling is as follows:","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"rng = Xoshiro()\nsp = Random.Sampler(rng, 1:20) # or Random.Sampler(Xoshiro, 1:20)\nfor x in X\n    n = rand(rng, sp) # similar to n = rand(rng, 1:20)\n    # use n\nend","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"This is the mechanism that is also used in the standard library, e.g. by the default implementation of random array generation (like in rand(1:20, 10)).","category":"page"},{"location":"stdlib/Random.html#Generating-values-from-a-type","page":"Random Numbers","title":"Generating values from a type","text":"","category":"section"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Given a type T, it's currently assumed that if rand(T) is defined, an object of type T will be produced. SamplerType is the default sampler for types. In order to define random generation of values of type T, the rand(rng::AbstractRNG, ::Random.SamplerType{T}) method should be defined, and should return values what rand(rng, T) is expected to return.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Let's take the following example: we implement a Die type, with a variable number n of sides, numbered from 1 to n. We want rand(Die) to produce a Die with a random number of up to 20 sides (and at least 4):","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"struct Die\n    nsides::Int # number of sides\nend\n\nRandom.rand(rng::AbstractRNG, ::Random.SamplerType{Die}) = Die(rand(rng, 4:20))\n\n# output\n","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Scalar and array methods for Die now work as expected:","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"julia> rand(Die)\nDie(5)\n\njulia> rand(Xoshiro(0), Die)\nDie(10)\n\njulia> rand(Die, 3)\n3-element Vector{Die}:\n Die(9)\n Die(15)\n Die(14)\n\njulia> a = Vector{Die}(undef, 3); rand!(a)\n3-element Vector{Die}:\n Die(19)\n Die(7)\n Die(17)","category":"page"},{"location":"stdlib/Random.html#A-simple-sampler-without-pre-computed-data","page":"Random Numbers","title":"A simple sampler without pre-computed data","text":"","category":"section"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Here we define a sampler for a collection. If no pre-computed data is required, it can be implemented with a SamplerTrivial sampler, which is in fact the default fallback for values.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"In order to define random generation out of objects of type S, the following method should be defined: rand(rng::AbstractRNG, sp::Random.SamplerTrivial{S}). Here, sp simply wraps an object of type S, which can be accessed via sp[]. Continuing the Die example, we want now to define rand(d::Die) to produce an Int corresponding to one of d's sides:","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"julia> Random.rand(rng::AbstractRNG, d::Random.SamplerTrivial{Die}) = rand(rng, 1:d[].nsides);\n\njulia> rand(Die(4))\n1\n\njulia> rand(Die(4), 3)\n3-element Vector{Any}:\n 2\n 3\n 3","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Given a collection type S, it's currently assumed that if rand(::S) is defined, an object of type eltype(S) will be produced. In the last example, a Vector{Any} is produced; the reason is that eltype(Die) == Any. The remedy is to define Base.eltype(::Type{Die}) = Int.","category":"page"},{"location":"stdlib/Random.html#Generating-values-for-an-AbstractFloat-type","page":"Random Numbers","title":"Generating values for an AbstractFloat type","text":"","category":"section"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"AbstractFloat types are special-cased, because by default random values are not produced in the whole type domain, but rather in [0,1). The following method should be implemented for T <: AbstractFloat: Random.rand(::AbstractRNG, ::Random.SamplerTrivial{Random.CloseOpen01{T}})","category":"page"},{"location":"stdlib/Random.html#An-optimized-sampler-with-pre-computed-data","page":"Random Numbers","title":"An optimized sampler with pre-computed data","text":"","category":"section"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Consider a discrete distribution, where numbers 1:n are drawn with given probabilities that sum to one. When many values are needed from this distribution, the fastest method is using an alias table. We don't provide the algorithm for building such a table here, but suppose it is available in make_alias_table(probabilities) instead, and draw_number(rng, alias_table) can be used to draw a random number from it.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Suppose that the distribution is described by","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"struct DiscreteDistribution{V <: AbstractVector}\n    probabilities::V\nend","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"and that we always want to build an alias table, regardless of the number of values needed (we learn how to customize this below). The methods","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Random.eltype(::Type{<:DiscreteDistribution}) = Int\n\nfunction Random.Sampler(::Type{<:AbstractRNG}, distribution::DiscreteDistribution, ::Repetition)\n    SamplerSimple(distribution, make_alias_table(distribution.probabilities))\nend","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"should be defined to return a sampler with pre-computed data, then","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"function rand(rng::AbstractRNG, sp::SamplerSimple{<:DiscreteDistribution})\n    draw_number(rng, sp.data)\nend","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"will be used to draw the values.","category":"page"},{"location":"stdlib/Random.html#Custom-sampler-types","page":"Random Numbers","title":"Custom sampler types","text":"","category":"section"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"The SamplerSimple type is sufficient for most use cases with precomputed data. However, in order to demonstrate how to use custom sampler types, here we implement something similar to SamplerSimple.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Going back to our Die example: rand(::Die) uses random generation from a range, so there is an opportunity for this optimization. We call our custom sampler SamplerDie.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"import Random: Sampler, rand\n\nstruct SamplerDie <: Sampler{Int} # generates values of type Int\n    die::Die\n    sp::Sampler{Int} # this is an abstract type, so this could be improved\nend\n\nSampler(RNG::Type{<:AbstractRNG}, die::Die, r::Random.Repetition) =\n    SamplerDie(die, Sampler(RNG, 1:die.nsides, r))\n# the `r` parameter will be explained later on\n\nrand(rng::AbstractRNG, sp::SamplerDie) = rand(rng, sp.sp)","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"It's now possible to get a sampler with sp = Sampler(rng, die), and use sp instead of die in any rand call involving rng. In the simplistic example above, die doesn't need to be stored in SamplerDie but this is often the case in practice.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Of course, this pattern is so frequent that the helper type used above, namely Random.SamplerSimple, is available, saving us the definition of SamplerDie: we could have implemented our decoupling with:","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Sampler(RNG::Type{<:AbstractRNG}, die::Die, r::Random.Repetition) =\n    SamplerSimple(die, Sampler(RNG, 1:die.nsides, r))\n\nrand(rng::AbstractRNG, sp::SamplerSimple{Die}) = rand(rng, sp.data)","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Here, sp.data refers to the second parameter in the call to the SamplerSimple constructor (in this case equal to Sampler(rng, 1:die.nsides, r)), while the Die object can be accessed via sp[].","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Like SamplerDie, any custom sampler must be a subtype of Sampler{T} where T is the type of the generated values. Note that SamplerSimple(x, data) isa Sampler{eltype(x)}, so this constrains what the first argument to SamplerSimple can be (it's recommended to use SamplerSimple like in the Die example, where x is simply forwarded while defining a Sampler method). Similarly, SamplerTrivial(x) isa Sampler{eltype(x)}.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Another helper type is currently available for other cases, Random.SamplerTag, but is considered as internal API, and can break at any time without proper deprecations.","category":"page"},{"location":"stdlib/Random.html#Using-distinct-algorithms-for-scalar-or-array-generation","page":"Random Numbers","title":"Using distinct algorithms for scalar or array generation","text":"","category":"section"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"In some cases, whether one wants to generate only a handful of values or a large number of values will have an impact on the choice of algorithm. This is handled with the third parameter of the Sampler constructor. Let's assume we defined two helper types for Die, say SamplerDie1 which should be used to generate only few random values, and SamplerDieMany for many values. We can use those types as follows:","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Sampler(RNG::Type{<:AbstractRNG}, die::Die, ::Val{1}) = SamplerDie1(...)\nSampler(RNG::Type{<:AbstractRNG}, die::Die, ::Val{Inf}) = SamplerDieMany(...)","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Of course, rand must also be defined on those types (i.e. rand(::AbstractRNG, ::SamplerDie1) and rand(::AbstractRNG, ::SamplerDieMany)). Note that, as usual, SamplerTrivial and SamplerSimple can be used if custom types are not necessary.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Note: Sampler(rng, x) is simply a shorthand for Sampler(rng, x, Val(Inf)), and Random.Repetition is an alias for Union{Val{1}, Val{Inf}}.","category":"page"},{"location":"stdlib/Random.html#Creating-new-generators","page":"Random Numbers","title":"Creating new generators","text":"","category":"section"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"The API is not clearly defined yet, but as a rule of thumb:","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"any rand method producing \"basic\" types (isbitstype integer and floating types in Base) should be defined for this specific RNG, if they are needed;\nother documented rand methods accepting an AbstractRNG should work out of the box, (provided the methods from 1) what are relied on are implemented), but can of course be specialized for this RNG if there is room for optimization;\ncopy for pseudo-RNGs should return an independent copy that generates the exact same random sequence as the original from that point when called in the same way. When this is not feasible (e.g. hardware-based RNGs), copy must not be implemented.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Concerning 1), a rand method may happen to work automatically, but it's not officially supported and may break without warnings in a subsequent release.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"To define a new rand method for an hypothetical MyRNG generator, and a value specification s (e.g. s == Int, or s == 1:10) of type S==typeof(s) or S==Type{s} if s is a type, the same two methods as we saw before must be defined:","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Sampler(::Type{MyRNG}, ::S, ::Repetition), which returns an object of type say SamplerS\nrand(rng::MyRNG, sp::SamplerS)","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"It can happen that Sampler(rng::AbstractRNG, ::S, ::Repetition) is already defined in the Random module. It would then be possible to skip step 1) in practice (if one wants to specialize generation for this particular RNG type), but the corresponding SamplerS type is considered as internal detail, and may be changed without warning.","category":"page"},{"location":"stdlib/Random.html#Specializing-array-generation","page":"Random Numbers","title":"Specializing array generation","text":"","category":"section"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"In some cases, for a given RNG type, generating an array of random values can be more efficient with a specialized method than by merely using the decoupling technique explained before. This is for example the case for MersenneTwister, which natively writes random values in an array.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"To implement this specialization for MyRNG and for a specification s, producing elements of type S, the following method can be defined: rand!(rng::MyRNG, a::AbstractArray{S}, ::SamplerS), where SamplerS is the type of the sampler returned by Sampler(MyRNG, s, Val(Inf)). Instead of AbstractArray, it's possible to implement the functionality only for a subtype, e.g. Array{S}. The non-mutating array method of rand will automatically call this specialization internally.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"DocTestSetup = nothing","category":"page"},{"location":"stdlib/Random.html#Reproducibility","page":"Random Numbers","title":"Reproducibility","text":"","category":"section"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"By using an RNG parameter initialized with a given seed, you can reproduce the same pseudorandom number sequence when running your program multiple times. However, a minor release of Julia (e.g. 1.3 to 1.4) may change the sequence of pseudorandom numbers generated from a specific seed, in particular if MersenneTwister is used. (Even if the sequence produced by a low-level function like rand does not change, the output of higher-level functions like randsubseq may change due to algorithm updates.) Rationale: guaranteeing that pseudorandom streams never change prohibits many algorithmic improvements.","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"If you need to guarantee exact reproducibility of random data, it is advisable to simply save the data (e.g. as a supplementary attachment in a scientific publication). (You can also, of course, specify a particular Julia version and package manifest, especially if you require bit reproducibility.)","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"Software tests that rely on specific \"random\" data should also generally either save the data, embed it into the test code, or use third-party packages like StableRNGs.jl. On the other hand, tests that should pass for most random data (e.g. testing A \\ (A*x) ≈ x for a random matrix A = randn(n,n)) can use an RNG with a fixed seed to ensure that simply running the test many times does not encounter a failure due to very improbable data (e.g. an extremely ill-conditioned matrix).","category":"page"},{"location":"stdlib/Random.html","page":"Random Numbers","title":"Random Numbers","text":"The statistical distribution from which random samples are drawn is guaranteed to be the same across any minor Julia releases.","category":"page"},{"location":"base/reflection.html#Reflection-and-introspection","page":"Reflection and introspection","title":"Reflection and introspection","text":"","category":"section"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"Julia provides a variety of runtime reflection capabilities.","category":"page"},{"location":"base/reflection.html#Module-bindings","page":"Reflection and introspection","title":"Module bindings","text":"","category":"section"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"The public names for a Module are available using names(m::Module), which will return an array of Symbol elements representing the public bindings. names(m::Module, all = true) returns symbols for all bindings in m, regardless of public status.","category":"page"},{"location":"base/reflection.html#DataType-fields","page":"Reflection and introspection","title":"DataType fields","text":"","category":"section"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"The names of DataType fields may be interrogated using fieldnames. For example, given the following type, fieldnames(Point) returns a tuple of Symbols representing the field names:","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"julia> struct Point\n           x::Int\n           y\n       end\n\njulia> fieldnames(Point)\n(:x, :y)","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"The type of each field in a Point object is stored in the types field of the Point variable itself:","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"julia> Point.types\nsvec(Int64, Any)","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"While x is annotated as an Int, y was unannotated in the type definition, therefore y defaults to the Any type.","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"Types are themselves represented as a structure called DataType:","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"julia> typeof(Point)\nDataType","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"Note that fieldnames(DataType) gives the names for each field of DataType itself, and one of these fields is the types field observed in the example above.","category":"page"},{"location":"base/reflection.html#Subtypes","page":"Reflection and introspection","title":"Subtypes","text":"","category":"section"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"The direct subtypes of any DataType may be listed using subtypes. For example, the abstract DataType AbstractFloat has four (concrete) subtypes:","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"julia> InteractiveUtils.subtypes(AbstractFloat)\n5-element Vector{Any}:\n BigFloat\n Core.BFloat16\n Float16\n Float32\n Float64","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"Any abstract subtype will also be included in this list, but further subtypes thereof will not; recursive application of subtypes may be used to inspect the full type tree.","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"Note that subtypes is located inside InteractiveUtils but is automatically exported when using the REPL.","category":"page"},{"location":"base/reflection.html#DataType-layout","page":"Reflection and introspection","title":"DataType layout","text":"","category":"section"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"The internal representation of a DataType is critically important when interfacing with C code and several functions are available to inspect these details. isbitstype(T::DataType) returns true if T is stored with C-compatible alignment. fieldoffset(T::DataType, i::Integer) returns the (byte) offset for field i relative to the start of the type.","category":"page"},{"location":"base/reflection.html#Function-methods","page":"Reflection and introspection","title":"Function methods","text":"","category":"section"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"The methods of any generic function may be listed using methods. The method dispatch table may be searched for methods accepting a given type using methodswith.","category":"page"},{"location":"base/reflection.html#Expansion-and-lowering","page":"Reflection and introspection","title":"Expansion and lowering","text":"","category":"section"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"As discussed in the Metaprogramming section, the macroexpand function gives the unquoted and interpolated expression (Expr) form for a given macro. To use macroexpand, quote the expression block itself (otherwise, the macro will be evaluated and the result will be passed instead!). For example:","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"julia> InteractiveUtils.macroexpand(@__MODULE__, :(@edit println(\"\")) )\n:(InteractiveUtils.edit(println, (Base.typesof)(\"\")))","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"The functions Base.Meta.show_sexpr and dump are used to display S-expr style views and depth-nested detail views for any expression.","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"Finally, the Meta.lower function gives the lowered form of any expression and is of particular interest for understanding how language constructs map to primitive operations such as assignments, branches, and calls:","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"julia> Meta.lower(@__MODULE__, :( [1+2, sin(0.5)] ))\n:($(Expr(:thunk, CodeInfo(\n    @ none within `top-level scope`\n1 ─ %1 = 1 + 2\n│   %2 = sin(0.5)\n│   %3 = Base.vect(%1, %2)\n└──      return %3\n))))","category":"page"},{"location":"base/reflection.html#Intermediate-and-compiled-representations","page":"Reflection and introspection","title":"Intermediate and compiled representations","text":"","category":"section"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"Inspecting the lowered form for functions requires selection of the specific method to display, because generic functions may have many methods with different type signatures. For this purpose, method-specific code-lowering is available using code_lowered, and the type-inferred form is available using code_typed. code_warntype adds highlighting to the output of code_typed.","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"Closer to the machine, the LLVM intermediate representation of a function may be printed using by code_llvm, and finally the compiled machine code is available using code_native (this will trigger JIT compilation/code generation for any function which has not previously been called).","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"For convenience, there are macro versions of the above functions which take standard function calls and expand argument types automatically:","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"julia> @code_llvm +(1,1)\n;  @ int.jl:87 within `+`\n; Function Attrs: sspstrong uwtable\ndefine i64 @\"julia_+_476\"(i64 signext %0, i64 signext %1) #0 {\ntop:\n  %2 = add i64 %1, %0\n  ret i64 %2\n}","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"For more information see @code_lowered, @code_typed, @code_warntype, @code_llvm, and @code_native.","category":"page"},{"location":"base/reflection.html#Printing-of-debug-information","page":"Reflection and introspection","title":"Printing of debug information","text":"","category":"section"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"The aforementioned functions and macros take the keyword argument debuginfo that controls the level debug information printed.","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"julia> InteractiveUtils.@code_typed debuginfo=:source +(1,1)\nCodeInfo(\n    @ int.jl:87 within `+`\n1 ─ %1 = Base.add_int(x, y)::Int64\n└──      return %1\n) => Int64","category":"page"},{"location":"base/reflection.html","page":"Reflection and introspection","title":"Reflection and introspection","text":"Possible values for debuginfo are: :none, :source, and :default. Per default debug information is not printed, but that can be changed by setting Base.IRShow.default_debuginfo[] = :source.","category":"page"},{"location":"manual/profile.html#Profiling","page":"Profiling","title":"Profiling","text":"","category":"section"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"The Profile module provides tools to help developers improve the performance of their code. When used, it takes measurements on running code, and produces output that helps you understand how much time is spent on individual line(s). The most common usage is to identify \"bottlenecks\" as targets for optimization.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Profile implements what is known as a \"sampling\" or statistical profiler.  It works by periodically taking a backtrace during the execution of any task. Each backtrace captures the currently-running function and line number, plus the complete chain of function calls that led to this line, and hence is a \"snapshot\" of the current state of execution.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"If much of your run time is spent executing a particular line of code, this line will show up frequently in the set of all backtraces. In other words, the \"cost\" of a given line–or really, the cost of the sequence of function calls up to and including this line–is proportional to how often it appears in the set of all backtraces.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"A sampling profiler does not provide complete line-by-line coverage, because the backtraces occur at intervals (by default, 1 ms on Unix systems and 10 ms on Windows, although the actual scheduling is subject to operating system load). Moreover, as discussed further below, because samples are collected at a sparse subset of all execution points, the data collected by a sampling profiler is subject to statistical noise.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Despite these limitations, sampling profilers have substantial strengths:","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"You do not have to make any modifications to your code to take timing measurements.\nIt can profile into Julia's core code and even (optionally) into C and Fortran libraries.\nBy running \"infrequently\" there is very little performance overhead; while profiling, your code can run at nearly native speed.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"For these reasons, it's recommended that you try using the built-in sampling profiler before considering any alternatives.","category":"page"},{"location":"manual/profile.html#Basic-usage","page":"Profiling","title":"Basic usage","text":"","category":"section"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Let's work with a simple test case:","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"julia> function myfunc()\n           A = rand(200, 200, 400)\n           maximum(A)\n       end","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"It's a good idea to first run the code you intend to profile at least once (unless you want to profile Julia's JIT-compiler):","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"julia> myfunc() # run once to force compilation","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Now we're ready to profile this function:","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"julia> using Profile\n\njulia> @profile myfunc()","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"To see the profiling results, there are several graphical browsers. One \"family\" of visualizers is based on FlameGraphs.jl, with each family member providing a different user interface:","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"VS Code is a full IDE with built-in support for profile visualization\nProfileView.jl is a stand-alone visualizer based on GTK\nProfileVega.jl uses VegaLight and integrates well with Jupyter notebooks\nStatProfilerHTML.jl produces HTML and presents some additional summaries, and also integrates well with Jupyter notebooks\nProfileSVG.jl renders SVG\nPProf.jl serves a local website for inspecting graphs, flamegraphs and more\nProfileCanvas.jl is a HTML canvas based profile viewer UI, used by the Julia VS Code extension, but can also generate interactive HTML files.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"An entirely independent approach to profile visualization is PProf.jl, which uses the external pprof tool.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Here, though, we'll use the text-based display that comes with the standard library:","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"julia> Profile.print()\n80 ./event.jl:73; (::Base.REPL.##1#2{Base.REPL.REPLBackend})()\n 80 ./REPL.jl:97; macro expansion\n  80 ./REPL.jl:66; eval_user_input(::Any, ::Base.REPL.REPLBackend)\n   80 ./boot.jl:235; eval(::Module, ::Any)\n    80 ./<missing>:?; anonymous\n     80 ./profile.jl:23; macro expansion\n      52 ./REPL[1]:2; myfunc()\n       38 ./random.jl:431; rand!(::MersenneTwister, ::Array{Float64,3}, ::Int64, ::Type{B...\n        38 ./dSFMT.jl:84; dsfmt_fill_array_close_open!(::Base.dSFMT.DSFMT_state, ::Ptr{F...\n       14 ./random.jl:278; rand\n        14 ./random.jl:277; rand\n         14 ./random.jl:366; rand\n          14 ./random.jl:369; rand\n      28 ./REPL[1]:3; myfunc()\n       28 ./reduce.jl:270; _mapreduce(::Base.#identity, ::Base.#scalarmax, ::IndexLinear,...\n        3  ./reduce.jl:426; mapreduce_impl(::Base.#identity, ::Base.#scalarmax, ::Array{F...\n        25 ./reduce.jl:428; mapreduce_impl(::Base.#identity, ::Base.#scalarmax, ::Array{F...","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Each line of this display represents a particular spot (line number) in the code. Indentation is used to indicate the nested sequence of function calls, with more-indented lines being deeper in the sequence of calls. In each line, the first \"field\" is the number of backtraces (samples) taken at this line or in any functions executed by this line. The second field is the file name and line number and the third field is the function name. Note that the specific line numbers may change as Julia's code changes; if you want to follow along, it's best to run this example yourself.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"In this example, we can see that the top level function called is in the file event.jl. This is the function that runs the REPL when you launch Julia. If you examine line 97 of REPL.jl, you'll see this is where the function eval_user_input() is called. This is the function that evaluates what you type at the REPL, and since we're working interactively these functions were invoked when we entered @profile myfunc(). The next line reflects actions taken in the @profile macro.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"The first line shows that 80 backtraces were taken at line 73 of event.jl, but it's not that this line was \"expensive\" on its own: the third line reveals that all 80 of these backtraces were actually triggered inside its call to eval_user_input, and so on. To find out which operations are actually taking the time, we need to look deeper in the call chain.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"The first \"important\" line in this output is this one:","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"52 ./REPL[1]:2; myfunc()","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"REPL refers to the fact that we defined myfunc in the REPL, rather than putting it in a file; if we had used a file, this would show the file name. The [1] shows that the function myfunc was the first expression evaluated in this REPL session. Line 2 of myfunc() contains the call to rand, and there were 52 (out of 80) backtraces that occurred at this line. Below that, you can see a call to dsfmt_fill_array_close_open! inside dSFMT.jl.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"A little further down, you see:","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"28 ./REPL[1]:3; myfunc()","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Line 3 of myfunc contains the call to maximum, and there were 28 (out of 80) backtraces taken here. Below that, you can see the specific places in base/reduce.jl that carry out the time-consuming operations in the maximum function for this type of input data.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Overall, we can tentatively conclude that generating the random numbers is approximately twice as expensive as finding the maximum element. We could increase our confidence in this result by collecting more samples:","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"julia> @profile (for i = 1:100; myfunc(); end)\n\njulia> Profile.print()\n[....]\n 3821 ./REPL[1]:2; myfunc()\n  3511 ./random.jl:431; rand!(::MersenneTwister, ::Array{Float64,3}, ::Int64, ::Type...\n   3511 ./dSFMT.jl:84; dsfmt_fill_array_close_open!(::Base.dSFMT.DSFMT_state, ::Ptr...\n  310  ./random.jl:278; rand\n   [....]\n 2893 ./REPL[1]:3; myfunc()\n  2893 ./reduce.jl:270; _mapreduce(::Base.#identity, ::Base.#scalarmax, ::IndexLinea...\n   [....]","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"In general, if you have N samples collected at a line, you can expect an uncertainty on the order of sqrt(N) (barring other sources of noise, like how busy the computer is with other tasks). The major exception to this rule is garbage collection, which runs infrequently but tends to be quite expensive. (Since Julia's garbage collector is written in C, such events can be detected using the C=true output mode described below, or by using ProfileView.jl.)","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"This illustrates the default \"tree\" dump; an alternative is the \"flat\" dump, which accumulates counts independent of their nesting:","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"julia> Profile.print(format=:flat)\n Count File          Line Function\n  6714 ./<missing>     -1 anonymous\n  6714 ./REPL.jl       66 eval_user_input(::Any, ::Base.REPL.REPLBackend)\n  6714 ./REPL.jl       97 macro expansion\n  3821 ./REPL[1]        2 myfunc()\n  2893 ./REPL[1]        3 myfunc()\n  6714 ./REPL[7]        1 macro expansion\n  6714 ./boot.jl      235 eval(::Module, ::Any)\n  3511 ./dSFMT.jl      84 dsfmt_fill_array_close_open!(::Base.dSFMT.DSFMT_s...\n  6714 ./event.jl      73 (::Base.REPL.##1#2{Base.REPL.REPLBackend})()\n  6714 ./profile.jl    23 macro expansion\n  3511 ./random.jl    431 rand!(::MersenneTwister, ::Array{Float64,3}, ::In...\n   310 ./random.jl    277 rand\n   310 ./random.jl    278 rand\n   310 ./random.jl    366 rand\n   310 ./random.jl    369 rand\n  2893 ./reduce.jl    270 _mapreduce(::Base.#identity, ::Base.#scalarmax, :...\n     5 ./reduce.jl    420 mapreduce_impl(::Base.#identity, ::Base.#scalarma...\n   253 ./reduce.jl    426 mapreduce_impl(::Base.#identity, ::Base.#scalarma...\n  2592 ./reduce.jl    428 mapreduce_impl(::Base.#identity, ::Base.#scalarma...\n    43 ./reduce.jl    429 mapreduce_impl(::Base.#identity, ::Base.#scalarma...","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"If your code has recursion, one potentially-confusing point is that a line in a \"child\" function can accumulate more counts than there are total backtraces. Consider the following function definitions:","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"dumbsum(n::Integer) = n == 1 ? 1 : 1 + dumbsum(n-1)\ndumbsum3() = dumbsum(3)","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"If you were to profile dumbsum3, and a backtrace was taken while it was executing dumbsum(1), the backtrace would look like this:","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"dumbsum3\n    dumbsum(3)\n        dumbsum(2)\n            dumbsum(1)","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Consequently, this child function gets 3 counts, even though the parent only gets one. The \"tree\" representation makes this much clearer, and for this reason (among others) is probably the most useful way to view the results.","category":"page"},{"location":"manual/profile.html#Accumulation-and-clearing","page":"Profiling","title":"Accumulation and clearing","text":"","category":"section"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Results from @profile accumulate in a buffer; if you run multiple pieces of code under @profile, then Profile.print() will show you the combined results. This can be very useful, but sometimes you want to start fresh; you can do so with Profile.clear().","category":"page"},{"location":"manual/profile.html#Options-for-controlling-the-display-of-profile-results","page":"Profiling","title":"Options for controlling the display of profile results","text":"","category":"section"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Profile.print has more options than we've described so far. Let's see the full declaration:","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"function print(io::IO = stdout, data = fetch(); kwargs...)","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Let's first discuss the two positional arguments, and later the keyword arguments:","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"io – Allows you to save the results to a buffer, e.g. a file, but the default is to print to stdout (the console).\ndata – Contains the data you want to analyze; by default that is obtained from Profile.fetch(), which pulls out the backtraces from a pre-allocated buffer. For example, if you want to profile the profiler, you could say:\ndata = copy(Profile.fetch())\nProfile.clear()\n@profile Profile.print(stdout, data) # Prints the previous results\nProfile.print()                      # Prints results from Profile.print()","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"The keyword arguments can be any combination of:","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"format – Introduced above, determines whether backtraces are printed  with (default, :tree) or without (:flat) indentation indicating tree  structure.\nC – If true, backtraces from C and Fortran code are shown (normally they are excluded). Try running the introductory example with Profile.print(C = true). This can be extremely helpful in deciding whether it's Julia code or C code that is causing a bottleneck; setting C = true also improves the interpretability of the nesting, at the cost of longer profile dumps.\ncombine – Some lines of code contain multiple operations; for example, s += A[i] contains both an array reference (A[i]) and a sum operation. These correspond to different lines in the generated machine code, and hence there may be two or more different addresses captured during backtraces on this line. combine = true lumps them together, and is probably what you typically want, but you can generate an output separately for each unique instruction pointer with combine = false.\nmaxdepth – Limits frames at a depth higher than maxdepth in the :tree format.\nsortedby – Controls the order in :flat format. :filefuncline (default) sorts by the source line, whereas :count sorts in order of number of collected samples.\nnoisefloor – Limits frames that are below the heuristic noise floor of the sample (only applies to format :tree). A suggested value to try for this is 2.0 (the default is 0). This parameter hides samples for which n <= noisefloor * √N, where n is the number of samples on this line, and N is the number of samples for the callee.\nmincount – Limits frames with less than mincount occurrences.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"File/function names are sometimes truncated (with ...), and indentation is truncated with a +n at the beginning, where n is the number of extra spaces that would have been inserted, had there been room. If you want a complete profile of deeply-nested code, often a good idea is to save to a file using a wide displaysize in an IOContext:","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"open(\"/tmp/prof.txt\", \"w\") do s\n    Profile.print(IOContext(s, :displaysize => (24, 500)))\nend","category":"page"},{"location":"manual/profile.html#Configuration","page":"Profiling","title":"Configuration","text":"","category":"section"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"@profile just accumulates backtraces, and the analysis happens when you call Profile.print(). For a long-running computation, it's entirely possible that the pre-allocated buffer for storing backtraces will be filled. If that happens, the backtraces stop but your computation continues. As a consequence, you may miss some important profiling data (you will get a warning when that happens).","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"You can obtain and configure the relevant parameters this way:","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Profile.init() # returns the current settings\nProfile.init(n = 10^7, delay = 0.01)","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"n is the total number of instruction pointers you can store, with a default value of 10^6. If your typical backtrace is 20 instruction pointers, then you can collect 50000 backtraces, which suggests a statistical uncertainty of less than 1%. This may be good enough for most applications.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Consequently, you are more likely to need to modify delay, expressed in seconds, which sets the amount of time that Julia gets between snapshots to perform the requested computations. A very long-running job might not need frequent backtraces. The default setting is delay = 0.001. Of course, you can decrease the delay as well as increase it; however, the overhead of profiling grows once the delay becomes similar to the amount of time needed to take a backtrace (~30 microseconds on the author's laptop).","category":"page"},{"location":"manual/profile.html#Memory-allocation-analysis","page":"Profiling","title":"Memory allocation analysis","text":"","category":"section"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"One of the most common techniques to improve performance is to reduce memory allocation. Julia provides several tools to measure this:","category":"page"},{"location":"manual/profile.html#@time","page":"Profiling","title":"@time","text":"","category":"section"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"The total amount of allocation can be measured with @time, @allocated and @allocations, and specific lines triggering allocation can often be inferred from profiling via the cost of garbage collection that these lines incur. However, sometimes it is more efficient to directly measure the amount of memory allocated by each line of code.","category":"page"},{"location":"manual/profile.html#GC-Logging","page":"Profiling","title":"GC Logging","text":"","category":"section"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"While @time logs high-level stats about memory usage and garbage collection over the course of evaluating an expression, it can be useful to log each garbage collection event, to get an intuitive sense of how often the garbage collector is running, how long it's running each time, and how much garbage it collects each time. This can be enabled with GC.enable_logging(true), which causes Julia to log to stderr every time a garbage collection happens.","category":"page"},{"location":"manual/profile.html#allocation-profiler","page":"Profiling","title":"Allocation Profiler","text":"","category":"section"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"compat: Julia 1.8\nThis functionality requires at least Julia 1.8.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"The allocation profiler records the stack trace, type, and size of each allocation while it is running. It can be invoked with Profile.Allocs.@profile.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"This information about the allocations is returned as an array of Alloc objects, wrapped in an AllocResults object. The best way to visualize these is currently with the PProf.jl and ProfileCanvas.jl packages, which can visualize the call stacks which are making the most allocations.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"The allocation profiler does have significant overhead, so a sample_rate argument can be passed to speed it up by making it skip some allocations. Passing sample_rate=1.0 will make it record everything (which is slow); sample_rate=0.1 will record only 10% of the allocations (faster), etc.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"compat: Julia 1.11\nOlder versions of Julia could not capture types in all cases. In older versions of Julia, if you see an allocation of type Profile.Allocs.UnknownType, it means that the profiler doesn't know what type of object was allocated. This mainly happened when the allocation was coming from generated code produced by the compiler. See issue #43688 for more info.Since Julia 1.11, all allocations should have a type reported.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"For more details on how to use this tool, please see the following talk from JuliaCon 2022: https://www.youtube.com/watch?v=BFvpwC8hEWQ","category":"page"},{"location":"manual/profile.html#Allocation-Profiler-Example","page":"Profiling","title":"Allocation Profiler Example","text":"","category":"section"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"In this simple example, we use PProf to visualize the alloc profile. You could use another visualization tool instead. We collect the profile (specifying a sample rate), then we visualize it.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"using Profile, PProf\nProfile.Allocs.clear()\nProfile.Allocs.@profile sample_rate=0.0001 my_function()\nPProf.Allocs.pprof()","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Here is a more in-depth example, showing how we can tune the sample rate. A good number of samples to aim for is around 1 - 10 thousand. Too many, and the profile visualizer can get overwhelmed, and profiling will be slow. Too few, and you don't have a representative sample.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"julia> import Profile\n\njulia> @time my_function()  # Estimate allocations from a (second-run) of the function\n  0.110018 seconds (1.50 M allocations: 58.725 MiB, 17.17% gc time)\n500000\n\njulia> Profile.Allocs.clear()\n\njulia> Profile.Allocs.@profile sample_rate=0.001 begin   # 1.5 M * 0.001 = ~1.5K allocs.\n           my_function()\n       end\n500000\n\njulia> prof = Profile.Allocs.fetch();  # If you want, you can also manually inspect the results.\n\njulia> length(prof.allocs)  # Confirm we have expected number of allocations.\n1515\n\njulia> using PProf  # Now, visualize with an external tool, like PProf or ProfileCanvas.\n\njulia> PProf.Allocs.pprof(prof; from_c=false)  # You can optionally pass in a previously fetched profile result.\nAnalyzing 1515 allocation samples... 100%|████████████████████████████████| Time: 0:00:00\nMain binary filename not available.\nServing web UI on http://localhost:62261\n\"alloc-profile.pb.gz\"","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Then you can view the profile by navigating to http://localhost:62261, and the profile is saved to disk. See PProf package for more options.","category":"page"},{"location":"manual/profile.html#Allocation-Profiling-Tips","page":"Profiling","title":"Allocation Profiling Tips","text":"","category":"section"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"As stated above, aim for around 1-10 thousand samples in your profile.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Note that we are uniformly sampling in the space of all allocations, and are not weighting our samples by the size of the allocation. So a given allocation profile may not give a representative profile of where most bytes are allocated in your program, unless you had set sample_rate=1.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Allocations can come from users directly constructing objects, but can also come from inside the runtime or be inserted into compiled code to handle type instability. Looking at the \"source code\" view can be helpful to isolate them, and then other external tools such as Cthulhu.jl can be useful for identifying the cause of the allocation.","category":"page"},{"location":"manual/profile.html#Allocation-Profile-Visualization-Tools","page":"Profiling","title":"Allocation Profile Visualization Tools","text":"","category":"section"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"There are several profiling visualization tools now that can all display Allocation Profiles. Here is a small list of some of the main ones we know about:","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"PProf.jl\nProfileCanvas.jl\nVSCode's built-in profile visualizer (@profview_allocs) [docs needed]\nViewing the results directly in the REPL\nYou can inspect the results in the REPL via Profile.Allocs.fetch(), to view the stacktrace and type of each allocation.","category":"page"},{"location":"manual/profile.html#Line-by-Line-Allocation-Tracking","page":"Profiling","title":"Line-by-Line Allocation Tracking","text":"","category":"section"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"An alternative way to measure allocations is to start Julia with the --track-allocation=<setting> command-line option, for which you can choose none (the default, do not measure allocation), user (measure memory allocation everywhere except Julia's core code), or all (measure memory allocation at each line of Julia code). Allocation gets measured for each line of compiled code. When you quit Julia, the cumulative results are written to text files with .mem appended after the file name, residing in the same directory as the source file. Each line lists the total number of bytes allocated. The Coverage package contains some elementary analysis tools, for example to sort the lines in order of number of bytes allocated.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"In interpreting the results, there are a few important details. Under the user setting, the first line of any function directly called from the REPL will exhibit allocation due to events that happen in the REPL code itself. More significantly, JIT-compilation also adds to allocation counts, because much of Julia's compiler is written in Julia (and compilation usually requires memory allocation). The recommended procedure is to force compilation by executing all the commands you want to analyze, then call Profile.clear_malloc_data() to reset all allocation counters.  Finally, execute the desired commands and quit Julia to trigger the generation of the .mem files.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"note: Note\n--track-allocation changes code generation to log the allocations, and so the allocations may be different than what happens without the option. We recommend using the allocation profiler instead.","category":"page"},{"location":"manual/profile.html#External-Profiling","page":"Profiling","title":"External Profiling","text":"","category":"section"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Currently Julia supports Intel VTune, OProfile and perf as external profiling tools.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Depending on the tool you choose, compile with USE_INTEL_JITEVENTS, USE_OPROFILE_JITEVENTS and USE_PERF_JITEVENTS set to 1 in Make.user. Multiple flags are supported.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Before running Julia set the environment variable ENABLE_JITPROFILING to 1.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Now you have a multitude of ways to employ those tools! For example with OProfile you can try a simple recording :","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":">ENABLE_JITPROFILING=1 sudo operf -Vdebug ./julia test/fastmath.jl\n>opreport -l `which ./julia`","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Or similarly with perf :","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"$ ENABLE_JITPROFILING=1 perf record -o /tmp/perf.data --call-graph dwarf -k 1 ./julia /test/fastmath.jl\n$ perf inject --jit --input /tmp/perf.data --output /tmp/perf-jit.data\n$ perf report --call-graph -G -i /tmp/perf-jit.data","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"There are many more interesting things that you can measure about your program, to get a comprehensive list please read the Linux perf examples page.","category":"page"},{"location":"manual/profile.html","page":"Profiling","title":"Profiling","text":"Remember that perf saves for each execution a perf.data file that, even for small programs, can get quite large. Also the perf LLVM module saves temporarily debug objects in ~/.debug/jit, remember to clean that folder frequently.","category":"page"},{"location":"stdlib/LibCURL.html#LibCURL","page":"LibCURL","title":"LibCURL","text":"","category":"section"},{"location":"stdlib/LibCURL.html","page":"LibCURL","title":"LibCURL","text":"This is a simple Julia wrapper around http://curl.haxx.se/libcurl/ generated using Clang.jl.  Please see the libcurl API documentation for help on how to use this package.","category":"page"},{"location":"stdlib/StyledStrings.html#stdlib-styledstrings","page":"StyledStrings","title":"StyledStrings","text":"","category":"section"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"CurrentModule = StyledStrings\nDocTestSetup = quote\n    using StyledStrings\nend","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"note: Note\nThe API for StyledStrings and AnnotatedStrings is considered experimental and is subject to change between Julia versions.","category":"page"},{"location":"stdlib/StyledStrings.html#stdlib-styledstrings-styling","page":"StyledStrings","title":"Styling","text":"","category":"section"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"When working with strings, formatting and styling often appear as a secondary concern.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"For instance, when printing to a terminal you might want to sprinkle ANSI escape sequences in the output, when outputting HTML styling constructs (<span style=\"...\">, etc.) serve a similar purpose, and so on. It is possible to simply insert the raw styling constructs into the string next to the content itself, but it quickly becomes apparent that this is not well suited for anything but the most basic use cases. Not all terminals support the same ANSI codes, the styling constructs need to be painstakingly removed when calculating the width of already-styled content, and that's before you even get into handling multiple output formats.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"Instead of leaving this headache to be widely experienced downstream, it is tackled head-on by the introduction of a special string type (AnnotatedString). This string type wraps any other AbstractString type and allows for formatting information to be applied to regions (e.g. characters 1 through to 7 are bold and red).","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"Regions of a string are styled by applying Faces (think \"typeface\") to them — a structure that holds styling information. As a convenience, faces in the global faces dictionary (e.g. shadow) can just be named instead of giving the Face directly.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"Along with these capabilities, we also provide a convenient way for constructing AnnotatedStrings, detailed in Styled String Literals.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"using StyledStrings\nstyled\"{yellow:hello} {blue:there}\"","category":"page"},{"location":"stdlib/StyledStrings.html#man-annotated-strings","page":"StyledStrings","title":"Annotated Strings","text":"","category":"section"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"It is sometimes useful to be able to hold metadata relating to regions of a string. A AnnotatedString wraps another string and allows for regions of it to be annotated with labelled values (:label => value). All generic string operations are applied to the underlying string. However, when possible, styling information is preserved. This means you can manipulate a AnnotatedString —taking substrings, padding them, concatenating them with other strings— and the metadata annotations will \"come along for the ride\".","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"This string type is fundamental to the StyledStrings stdlib, which uses :face-labelled annotations to hold styling information.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"When concatenating a AnnotatedString, take care to use annotatedstring instead of string if you want to keep the string annotations.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"julia> str = AnnotatedString(\"hello there\", [(1:5, :word, :greeting), (7:11, :label, 1)])\n\"hello there\"\n\njulia> length(str)\n11\n\njulia> lpad(str, 14)\n\"   hello there\"\n\njulia> typeof(lpad(str, 7))\nAnnotatedString{String}\n\njulia> str2 = AnnotatedString(\" julia\", [(2:6, :face, :magenta)])\n\" julia\"\n\njulia> annotatedstring(str, str2)\n\"hello there julia\"\n\njulia> str * str2 == annotatedstring(str, str2) # *-concatenation works\ntrue","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"The annotations of a AnnotatedString can be accessed and modified via the annotations and annotate! functions.","category":"page"},{"location":"stdlib/StyledStrings.html#Styling-via-[AnnotatedString](@ref-Base.AnnotatedString)s","page":"StyledStrings","title":"Styling via AnnotatedStrings","text":"","category":"section"},{"location":"stdlib/StyledStrings.html#stdlib-styledstrings-faces","page":"StyledStrings","title":"Faces","text":"","category":"section"},{"location":"stdlib/StyledStrings.html#The-Face-type","page":"StyledStrings","title":"The Face type","text":"","category":"section"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"A Face specifies details of a typeface that text can be set in. It covers a set of basic attributes that generalize well across different formats, namely:","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"font\nheight\nweight\nslant\nforeground\nbackground\nunderline\nstrikethrough\ninverse\ninherit","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"For details on the particular forms these attributes take, see the Face docstring, but of particular interest is inherit as it allows you to inherit attributes from other Faces.","category":"page"},{"location":"stdlib/StyledStrings.html#The-global-faces-dictionary","page":"StyledStrings","title":"The global faces dictionary","text":"","category":"section"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"To make referring to particular styles more convenient, there is a global Dict{Symbol, Face} that allows for Faces to be referred to simply by name. Packages can add faces to this dictionary via the addface! function, and the loaded faces can be easily customized.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"warning: Appropriate face naming\nAny package registering new faces should ensure that they are prefixed by the package name, i.e. follow the format mypackage_myface. This is important for predictability, and to prevent name clashes.Furthermore, packages should take care to use (and introduce) semantic faces (like code) over direct colours and styles (like cyan). This is helpful in a number of ways, from making the intent in usage more obvious, aiding composability, and making user customisation more intuitive.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"There are two set of exemptions to the package-prefix rule:","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"the set of basic faces that are part of the default value of the faces dictionary\nfaces introduced by Julia's own standard library, namely JuliaSyntaxHighlighting","category":"page"},{"location":"stdlib/StyledStrings.html#stdlib-styledstrings-basic-faces","page":"StyledStrings","title":"Basic faces","text":"","category":"section"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"Basic faces are intended to represent a general idea that is widely applicable.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"For setting some text with a certain attribute, we have the bold, light, italic, underline, strikethrough, and inverse faces.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"There are also named faces for the 16 terminal colors: black, red, green, yellow, blue, magenta, cyan, white, bright_black/grey/gray, bright_red, bright_green, bright_blue, bright_magenta, bright_cyan, and bright_white.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"For shadowed text (i.e. dim but there) there is the shadow face. To indicate a selected region, there is the region face. Similarly for emphasis and highlighting the emphasis and highlight faces are defined. There is also code for code-like text.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"For visually indicating the severity of messages, the error, warning, success, info, note, and tip faces are defined.","category":"page"},{"location":"stdlib/StyledStrings.html#stdlib-styledstrings-face-toml","page":"StyledStrings","title":"Customisation of faces (Faces.toml)","text":"","category":"section"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"It is good for the name faces in the global face dictionary to be customizable. Theming and aesthetics are nice, and it is important for accessibility reasons too. A TOML file can be parsed into a list of Face specifications that are merged with the pre-existing entry in the face dictionary.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"A Face is represented in TOML like so:","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"[facename]\nattribute = \"value\"\n...\n\n[package.facename]\nattribute = \"value\"","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"For example, if the shadow face is too hard to read it can be made brighter like so:","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"[shadow]\nforeground = \"white\"","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"On initialization, the config/faces.toml file under the first Julia depot (usually ~/.julia) is loaded.","category":"page"},{"location":"stdlib/StyledStrings.html#Applying-faces-to-a-AnnotatedString","page":"StyledStrings","title":"Applying faces to a AnnotatedString","text":"","category":"section"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"By convention, the :face attributes of a AnnotatedString hold information on the Faces that currently apply. This can be given in multiple forms, as a single Symbol naming a Faces in the global face dictionary, a Face itself, or a vector of either.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"The show(::IO, ::MIME\"text/plain\", ::AnnotatedString) and show(::IO, ::MIME\"text/html\", ::AnnotatedString) methods both look at the :face attributes and merge them all together when determining the overall styling.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"We can supply :face attributes to a AnnotatedString during construction, add them to the properties list afterwards, or use the convenient Styled String literals.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"str1 = AnnotatedString(\"blue text\", [(1:9, :face, :blue)])\nstr2 = styled\"{blue:blue text}\"\nstr1 == str2\nsprint(print, str1, context = :color => true)\nsprint(show, MIME(\"text/html\"), str1, context = :color => true)","category":"page"},{"location":"stdlib/StyledStrings.html#stdlib-styledstring-literals","page":"StyledStrings","title":"Styled String Literals","text":"","category":"section"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"To ease construction of AnnotatedStrings with Faces applied, the styled\"...\" styled string literal allows for the content and attributes to be easily expressed together via a custom grammar.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"Within a styled\"...\" literal, curly braces are considered special characters and must be escaped in normal usage (\\{, \\}). This allows them to be used to express annotations with (nestable) {annotations...:text} constructs.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"The annotations... component is a comma-separated list of three types of annotations.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"Face names\nInline Face expressions (key=val,...)\nkey=value pairs","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"Interpolation is possible everywhere except for inline face keys.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"For more information on the grammar, see the extended help of the styled\"...\" docstring.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"As an example, we can demonstrate the list of built-in faces mentioned above like so:","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"julia> println(styled\"\nThe basic font-style attributes are {bold:bold}, {light:light}, {italic:italic},\n{underline:underline}, and {strikethrough:strikethrough}.\n\nIn terms of color, we have named faces for the 16 standard terminal colors:\n {black:■} {red:■} {green:■} {yellow:■} {blue:■} {magenta:■} {cyan:■} {white:■}\n {bright_black:■} {bright_red:■} {bright_green:■} {bright_yellow:■} {bright_blue:■} {bright_magenta:■} {bright_cyan:■} {bright_white:■}\n\nSince {code:bright_black} is effectively grey, we define two aliases for it:\n{code:grey} and {code:gray} to allow for regional spelling differences.\n\nTo flip the foreground and background colors of some text, you can use the\n{code:inverse} face, for example: {magenta:some {inverse:inverse} text}.\n\nThe intent-based basic faces are {shadow:shadow} (for dim but visible text),\n{region:region} for selections, {emphasis:emphasis}, and {highlight:highlight}.\nAs above, {code:code} is used for code-like text.\n\nLastly, we have the 'message severity' faces: {error:error}, {warning:warning},\n{success:success}, {info:info}, {note:note}, and {tip:tip}.\n\nRemember that all these faces (and any user or package-defined ones) can\narbitrarily nest and overlap, {region,tip:like {bold,italic:so}}.\")","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"Documenter doesn't properly represent all the styling above, so I've converted it manually to HTML and LaTeX.","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"<pre>\n The basic font-style attributes are <span style=\"font-weight: 700;\">bold</span>, <span style=\"font-weight: 300;\">light</span>, <span style=\"font-style: italic;\">italic</span>,\n <span style=\"text-decoration: underline;\">underline</span>, and <span style=\"text-decoration: line-through\">strikethrough</span>.\n\n In terms of color, we have named faces for the 16 standard terminal colors:\n  <span style=\"color: #1c1a23;\">■</span> <span style=\"color: #a51c2c;\">■</span> <span style=\"color: #25a268;\">■</span> <span style=\"color: #e5a509;\">■</span> <span style=\"color: #195eb3;\">■</span> <span style=\"color: #803d9b;\">■</span> <span style=\"color: #0097a7;\">■</span> <span style=\"color: #dddcd9;\">■</span>\n  <span style=\"color: #76757a;\">■</span> <span style=\"color: #ed333b;\">■</span> <span style=\"color: #33d079;\">■</span> <span style=\"color: #f6d22c;\">■</span> <span style=\"color: #3583e4;\">■</span> <span style=\"color: #bf60ca;\">■</span> <span style=\"color: #26c6da;\">■</span> <span style=\"color: #f6f5f4;\">■</span>\n\n Since <span style=\"color: #0097a7;\">bright_black</span> is effectively grey, we define two aliases for it:\n <span style=\"color: #0097a7;\">grey</span> and <span style=\"color: #0097a7;\">gray</span> to allow for regional spelling differences.\n\n To flip the foreground and background colors of some text, you can use the\n <span style=\"color: #0097a7;\">inverse</span> face, for example: <span style=\"color: #803d9b;\">some </span><span style=\"background-color: #803d9b;\">inverse</span><span style=\"color: #803d9b;\"> text</span>.\n\n The intent-based basic faces are <span style=\"color: #76757a;\">shadow</span> (for dim but visible text),\n <span style=\"background-color: #3a3a3a;\">region</span> for selections, <span style=\"color: #195eb3;\">emphasis</span>, and <span style=\"background-color: #195eb3;\">highlight</span>.\n As above, <span style=\"color: #0097a7;\">code</span> is used for code-like text.\n\n Lastly, we have the 'message severity' faces: <span style=\"color: #ed333b;\">error</span>, <span style=\"color: #e5a509;\">warning</span>,\n <span style=\"color: #25a268;\">success</span>, <span style=\"color: #26c6da;\">info</span>, <span style=\"color: #76757a;\">note</span>, and <span style=\"color: #33d079;\">tip</span>.\n\n Remember that all these faces (and any user or package-defined ones) can\n arbitrarily nest and overlap, <span style=\"color: #33d079;background-color: #3a3a3a;\">like <span style=\"font-weight: 700;font-style: italic;\">so</span></span>.</pre>","category":"page"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"\\begingroup\n\\ttfamily\n\\setlength{\\parindent}{0pt}\n\\setlength{\\parskip}{\\baselineskip}\n\nThe basic font-style attributes are {\\fontseries{b}\\selectfont bold}, {\\fontseries{l}\\selectfont light}, {\\fontshape{it}\\selectfont italic},\\\\\n\\underline{underline}, and {strikethrough}.\n\nIn terms of color, we have named faces for the 16 standard terminal colors:\\\\\n{\\color[HTML]{1c1a23}\\(\\blacksquare\\)} {\\color[HTML]{a51c2c}\\(\\blacksquare\\)} {\\color[HTML]{25a268}\\(\\blacksquare\\)}\n{\\color[HTML]{e5a509}\\(\\blacksquare\\)} {\\color[HTML]{195eb3}\\(\\blacksquare\\)} {\\color[HTML]{803d9b}\\(\\blacksquare\\)}\n{\\color[HTML]{0097a7}\\(\\blacksquare\\)} {\\color[HTML]{dddcd9}\\(\\blacksquare\\)} \\\\\n{\\color[HTML]{76757a}\\(\\blacksquare\\)} {\\color[HTML]{ed333b}\\(\\blacksquare\\)} {\\color[HTML]{33d079}\\(\\blacksquare\\)} {\\color[HTML]{f6d22c}\\(\\blacksquare\\)} {\\color[HTML]{3583e4}\\(\\blacksquare\\)} {\\color[HTML]{bf60ca}\\(\\blacksquare\\)} {\\color[HTML]{26c6da}\\(\\blacksquare\\)} {\\color[HTML]{f6f5f4}\\(\\blacksquare\\)}\n\nSince {\\color[HTML]{0097a7}bright\\_black} is effectively grey, we define two aliases for it:\\\\\n{\\color[HTML]{0097a7}grey} and {\\color[HTML]{0097a7}gray} to allow for regional spelling differences.\n\nTo flip the foreground and background colors of some text, you can use the\\\\\n{\\color[HTML]{0097a7}inverse} face, for example: {\\color[HTML]{803d9b}some \\colorbox[HTML]{803d9b}{\\color[HTML]{000000}inverse} text}.\n\nThe intent-based basic faces are {\\color[HTML]{76757a}shadow} (for dim but visible text),\\\\\n\\colorbox[HTML]{3a3a3a}{region} for selections, {\\color[HTML]{195eb3}emphasis}, and \\colorbox[HTML]{195eb3}{highlight}.\\\\\nAs above, {\\color[HTML]{0097a7}code} is used for code-like text.\n\nLastly, we have the 'message severity' faces: {\\color[HTML]{ed333b}error}, {\\color[HTML]{e5a509}warning},\\\\\n{\\color[HTML]{25a268}success}, {\\color[HTML]{26c6da}info}, {\\color[HTML]{76757a}note}, and {\\color[HTML]{33d079}tip}.\n\nRemember that all these faces (and any user or package-defined ones) can\\\\\narbitrarily nest and overlap, \\colorbox[HTML]{3a3a3a}{\\color[HTML]{33d079}like\n  {\\fontseries{b}\\fontshape{it}\\selectfont so}}.\n\\endgroup","category":"page"},{"location":"stdlib/StyledStrings.html#stdlib-styledstrings-api","page":"StyledStrings","title":"API reference","text":"","category":"section"},{"location":"stdlib/StyledStrings.html#Styling-and-Faces","page":"StyledStrings","title":"Styling and Faces","text":"","category":"section"},{"location":"stdlib/StyledStrings.html","page":"StyledStrings","title":"StyledStrings","text":"StyledStrings.@styled_str\nStyledStrings.styled\nStyledStrings.Face\nStyledStrings.addface!\nStyledStrings.withfaces\nStyledStrings.SimpleColor\nStyledStrings.parse(::Type{StyledStrings.SimpleColor}, ::String)\nStyledStrings.tryparse(::Type{StyledStrings.SimpleColor}, ::String)\nStyledStrings.merge(::StyledStrings.Face, ::StyledStrings.Face)","category":"page"},{"location":"stdlib/StyledStrings.html#StyledStrings.StyledMarkup.@styled_str","page":"StyledStrings","title":"StyledStrings.StyledMarkup.@styled_str","text":"@styled_str -> AnnotatedString\n\nConstruct a styled string. Within the string, {<specs>:<content>} structures apply the formatting to <content>, according to the list of comma-separated specifications <specs>. Each spec can either take the form of a face name, an inline face specification, or a key=value pair. The value must be wrapped by {...} should it contain any of the characters ,=:{}.\n\nString interpolation with $ functions in the same way as regular strings, except quotes need to be escaped. Faces, keys, and values can also be interpolated with $.\n\nExample\n\nstyled\"The {bold:{italic:quick} {(foreground=#cd853f):brown} fox} jumped over the {link={https://en.wikipedia.org/wiki/Laziness}:lazy} dog\"\n\nExtended help\n\nThis macro can be described by the following EBNF grammar:\n\nstyledstring = { styled | interpolated | escaped | plain } ;\n\nspecialchar = '{' | '}' | '$' | '\\\"' ;\nanychar = [\\u0-\\u1fffff] ;\nplain = { anychar - specialchar } ;\nescaped = '\\\\', specialchar ;\n\ninterpolated = '$', ? expr ? | '$(', ? expr ?, ')' ;\n\nstyled = '{', ws, annotations, ':', content, '}' ;\ncontent = { interpolated | plain | escaped | styled } ;\nannotations = annotation | annotations, ws, ',', ws, annotation ;\nannotation = face | inlineface | keyvalue ;\nws = { ' ' | '\\t' | '\\n' } ; (* whitespace *)\n\nface = facename | interpolated ;\nfacename = [A-Za-z0-9_]+ ;\n\ninlineface = '(', ws, [ faceprop ], { ws, ',', faceprop }, ws, ')' ;\nfaceprop = [a-z]+, ws, '=', ws, ( [^,)]+ | interpolated) ;\n\nkeyvalue = key, ws, '=', ws, value ;\nkey = ( [^\\0${}=,:], [^\\0=,:]* ) | interpolated ;\nvalue = simplevalue | curlybraced | interpolated ;\ncurlybraced = '{' { escaped | plain } '}' ;\nsimplevalue = [^${},:], [^,:]* ;\n\nAn extra stipulation not encoded in the above grammar is that plain should be a valid input to unescape_string, with specialchar kept.\n\nThe above grammar for inlineface is simplified, as the actual implementation is a bit more sophisticated. The full behaviour is given below.\n\nfaceprop = ( 'face', ws, '=', ws, ( ? string ? | interpolated ) ) |\n           ( 'height', ws, '=', ws, ( ? number ? | interpolated ) ) |\n           ( 'weight', ws, '=', ws, ( symbol | interpolated ) ) |\n           ( 'slant', ws, '=', ws, ( symbol | interpolated ) ) |\n           ( ( 'foreground' | 'fg' | 'background' | 'bg' ),\n               ws, '=', ws, ( simplecolor | interpolated ) ) |\n           ( 'underline', ws, '=', ws, ( underline | interpolated ) ) |\n           ( 'strikethrough', ws, '=', ws, ( bool | interpolated ) ) |\n           ( 'inverse', ws, '=', ws, ( bool | interpolated ) ) |\n           ( 'inherit', ws, '=', ws, ( inherit | interpolated ) ) ;\n\nnothing = 'nothing' ;\nbool = 'true' | 'false' ;\nsymbol = [^ ,)]+ ;\nhexcolor = ('#' | '0x'), [0-9a-f]{6} ;\nsimplecolor = hexcolor | symbol | nothing ;\n\nunderline = nothing | bool | simplecolor | underlinestyled;\nunderlinestyled = '(', ws, ('' | nothing | simplecolor | interpolated), ws,\n                  ',', ws, ( symbol | interpolated ), ws ')' ;\n\ninherit = ( '[', inheritval, { ',', inheritval }, ']' ) | inheritval;\ninheritval = ws, ':'?, symbol ;\n\n\n\n\n\n","category":"macro"},{"location":"stdlib/StyledStrings.html#StyledStrings.StyledMarkup.styled","page":"StyledStrings","title":"StyledStrings.StyledMarkup.styled","text":"styled(content::AbstractString) -> AnnotatedString\n\nConstruct a styled string. Within the string, {<specs>:<content>} structures apply the formatting to <content>, according to the list of comma-separated specifications <specs>. Each spec can either take the form of a face name, an inline face specification, or a key=value pair. The value must be wrapped by {...} should it contain any of the characters ,=:{}.\n\nThis is a functional equivalent of the @styled_str macro, just without interpolation capabilities.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/StyledStrings.html#StyledStrings.Face","page":"StyledStrings","title":"StyledStrings.Face","text":"A Face is a collection of graphical attributes for displaying text. Faces control how text is displayed in the terminal, and possibly other places too.\n\nMost of the time, a Face will be stored in the global faces dicts as a unique association with a face name Symbol, and will be most often referred to by this name instead of the Face object itself.\n\nAttributes\n\nAll attributes can be set via the keyword constructor, and default to nothing.\n\nheight (an Int or Float64): The height in either deci-pt (when an Int), or as a factor of the base size (when a Float64).\nweight (a Symbol): One of the symbols (from faintest to densest) :thin, :extralight, :light, :semilight, :normal, :medium, :semibold, :bold, :extrabold, or :black. In terminals any weight greater than :normal is displayed as bold, and in terminals that support variable-brightness text, any weight less than :normal is displayed as faint.\nslant (a Symbol): One of the symbols :italic, :oblique, or :normal.\nforeground (a SimpleColor): The text foreground color.\nbackground (a SimpleColor): The text background color.\nunderline, the text underline, which takes one of the following forms:\na Bool: Whether the text should be underlined or not.\n\na SimpleColor: The text should be underlined with this color.\n\na Tuple{Nothing, Symbol}: The text should be underlined using the style set by the Symbol, one of :straight, :double, :curly, :dotted, or :dashed.\n\na Tuple{SimpleColor, Symbol}: The text should be underlined in the specified SimpleColor, and using the style specified by the Symbol, as before.\nstrikethrough (a Bool): Whether the text should be struck through.\ninverse (a Bool): Whether the foreground and background colors should be inverted.\ninherit (a Vector{Symbol}): Names of faces to inherit from, with earlier faces taking priority. All faces inherit from the :default face.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/StyledStrings.html#StyledStrings.addface!","page":"StyledStrings","title":"StyledStrings.addface!","text":"addface!(name::Symbol => default::Face)\n\nCreate a new face by the name name. So long as no face already exists by this name, default is added to both FACES.default and (a copy of) to FACES.current, with the current value returned.\n\nShould the face name already exist, nothing is returned.\n\nExamples\n\njulia> addface!(:mypkg_myface => Face(slant=:italic, underline=true))\nFace (sample)\n         slant: italic\n     underline: true\n\n\n\n\n\n","category":"function"},{"location":"stdlib/StyledStrings.html#StyledStrings.withfaces","page":"StyledStrings","title":"StyledStrings.withfaces","text":"withfaces(f, kv::Pair...)\nwithfaces(f, kvpair_itr)\n\nExecute f with FACES.current temporarily modified by zero or more :name => val arguments kv, or kvpair_itr which produces kv-form values.\n\nwithfaces is generally used via the withfaces(kv...) do ... end syntax. A value of nothing can be used to temporarily unset a face (if it has been set). When withfaces returns, the original FACES.current has been restored.\n\nExamples\n\njulia> withfaces(:yellow => Face(foreground=:red), :green => :blue) do\n           println(styled\"{yellow:red} and {green:blue} mixed make {magenta:purple}\")\n       end\nred and blue mixed make purple\n\n\n\n\n\n","category":"function"},{"location":"stdlib/StyledStrings.html#StyledStrings.SimpleColor","page":"StyledStrings","title":"StyledStrings.SimpleColor","text":"struct SimpleColor\n\nA basic representation of a color, intended for string styling purposes. It can either contain a named color (like :red), or an RGBTuple which is a NamedTuple specifying an r, g, b color with a bit-depth of 8.\n\nConstructors\n\nSimpleColor(name::Symbol)  # e.g. :red\nSimpleColor(rgb::RGBTuple) # e.g. (r=1, b=2, g=3)\nSimpleColor(r::Integer, b::Integer, b::Integer)\nSimpleColor(rgb::UInt32)   # e.g. 0x123456\n\nAlso see tryparse(SimpleColor, rgb::String).\n\n\n\n\n\n","category":"type"},{"location":"stdlib/StyledStrings.html#Base.parse-Tuple{Type{StyledStrings.SimpleColor}, String}","page":"StyledStrings","title":"Base.parse","text":"parse(::Type{SimpleColor}, rgb::String)\n\nAn analogue of tryparse(SimpleColor, rgb::String) (which see), that raises an error instead of returning nothing.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/StyledStrings.html#Base.tryparse-Tuple{Type{StyledStrings.SimpleColor}, String}","page":"StyledStrings","title":"Base.tryparse","text":"tryparse(::Type{SimpleColor}, rgb::String)\n\nAttempt to parse rgb as a SimpleColor. If rgb starts with # and has a length of 7, it is converted into a RGBTuple-backed SimpleColor. If rgb starts with a-z, rgb is interpreted as a color name and converted to a Symbol-backed SimpleColor.\n\nOtherwise, nothing is returned.\n\nExamples\n\njulia> tryparse(SimpleColor, \"blue\")\nSimpleColor(blue)\n\njulia> tryparse(SimpleColor, \"#9558b2\")\nSimpleColor(#9558b2)\n\njulia> tryparse(SimpleColor, \"#nocolor\")\n\n\n\n\n\n","category":"method"},{"location":"stdlib/StyledStrings.html#Base.merge-Tuple{StyledStrings.Face, StyledStrings.Face}","page":"StyledStrings","title":"Base.merge","text":"merge(initial::Face, others::Face...)\n\nMerge the properties of the initial face and others, with later faces taking priority.\n\n\n\n\n\n","category":"method"},{"location":"manual/variables.html#man-variables","page":"Variables","title":"Variables","text":"","category":"section"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"A variable, in Julia, is a name associated (or bound) to a value. It's useful when you want to store a value (that you obtained after some math, for example) for later use. For example:","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"# Assign the value 10 to the variable x\njulia> x = 10\n10\n\n# Doing math with x's value\njulia> x + 1\n11\n\n# Reassign x's value\njulia> x = 1 + 1\n2\n\n# You can assign values of other types, like strings of text\njulia> x = \"Hello World!\"\n\"Hello World!\"","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"Julia provides an extremely flexible system for naming variables. Variable names are case-sensitive, and have no semantic meaning (that is, the language will not treat variables differently based on their names).","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"julia> x = 1.0\n1.0\n\njulia> y = -3\n-3\n\njulia> Z = \"My string\"\n\"My string\"\n\njulia> customary_phrase = \"Hello world!\"\n\"Hello world!\"\n\njulia> UniversalDeclarationOfHumanRightsStart = \"人人生而自由，在尊严和权利上一律平等。\"\n\"人人生而自由，在尊严和权利上一律平等。\"","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"Unicode names (in UTF-8 encoding) are allowed:","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"julia> δ = 0.00001\n1.0e-5\n\njulia> 안녕하세요 = \"Hello\"\n\"Hello\"","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"In the Julia REPL and several other Julia editing environments, you can type many Unicode math symbols by typing the backslashed LaTeX symbol name followed by tab. For example, the variable name δ can be entered by typing \\delta-tab, or even α̂⁽²⁾ by \\alpha-tab-\\hat- tab-\\^(2)-tab. (If you find a symbol somewhere, e.g. in someone else's code, that you don't know how to type, the REPL help will tell you: just type ? and then paste the symbol.)","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"Julia will even let you shadow existing exported constants and functions with local ones (although this is not recommended to avoid potential confusions):","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"julia> pi = 3\n3\n\njulia> pi\n3\n\njulia> sqrt = 4\n4\n\njulia> length() = 5\nlength (generic function with 1 method)\n\njulia> Base.length\nlength (generic function with 79 methods)","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"However, if you try to redefine a built-in constant or function already in use, Julia will give you an error:","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"julia> pi\nπ = 3.1415926535897...\n\njulia> pi = 3\nERROR: cannot assign a value to imported variable Base.pi from module Main\n\njulia> sqrt(100)\n10.0\n\njulia> sqrt = 4\nERROR: cannot assign a value to imported variable Base.sqrt from module Main","category":"page"},{"location":"manual/variables.html#man-allowed-variable-names","page":"Variables","title":"Allowed Variable Names","text":"","category":"section"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"Variable names must begin with a letter (A-Z or a-z), underscore, or a subset of Unicode code points greater than 00A0; in particular, Unicode character categories Lu/Ll/Lt/Lm/Lo/Nl (letters), Sc/So (currency and other symbols), and a few other letter-like characters (e.g. a subset of the Sm math symbols) are allowed. Subsequent characters may also include ! and digits (0-9 and other characters in categories Nd/No), as well as other Unicode code points: diacritics and other modifying marks (categories Mn/Mc/Me/Sk), some punctuation connectors (category Pc), primes, and a few other characters.","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"Operators like + are also valid identifiers, but are parsed specially. In some contexts, operators can be used just like variables; for example (+) refers to the addition function, and (+) = f will reassign it. Most of the Unicode infix operators (in category Sm), such as ⊕, are parsed as infix operators and are available for user-defined methods (e.g. you can use const ⊗ = kron to define ⊗ as an infix Kronecker product).  Operators can also be suffixed with modifying marks, primes, and sub/superscripts, e.g. +̂ₐ″ is parsed as an infix operator with the same precedence as +. A space is required between an operator that ends with a subscript/superscript letter and a subsequent variable name. For example, if +ᵃ is an operator, then +ᵃx must be written as +ᵃ x to distinguish it from + ᵃx where ᵃx is the variable name.","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"A particular class of variable names is one that contains only underscores. These identifiers are write-only. I.e. they can only be assigned values, which are immediately discarded, and their values cannot be used in any way.","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"julia> x, ___ = size([2 2; 1 1])\n(2, 2)\n\njulia> y = ___\nERROR: syntax: all-underscore identifiers are write-only and their values cannot be used in expressions\n\njulia> println(___)\nERROR: syntax: all-underscore identifiers are write-only and their values cannot be used in expressions","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"The only explicitly disallowed names for variables are the names of the built-in Keywords:","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"julia> else = false\nERROR: syntax: unexpected \"else\"\n\njulia> try = \"No\"\nERROR: syntax: unexpected \"=\"","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"Some Unicode characters are considered to be equivalent in identifiers. Different ways of entering Unicode combining characters (e.g., accents) are treated as equivalent (specifically, Julia identifiers are NFC. Julia also includes a few non-standard equivalences for characters that are visually similar and are easily entered by some input methods. The Unicode characters ɛ (U+025B: Latin small letter open e) and µ (U+00B5: micro sign) are treated as equivalent to the corresponding Greek letters. The middle dot · (U+00B7) and the Greek interpunct · (U+0387) are both treated as the mathematical dot operator ⋅ (U+22C5). The minus sign − (U+2212) is treated as equivalent to the hyphen-minus sign - (U+002D).","category":"page"},{"location":"manual/variables.html#man-assignment-expressions","page":"Variables","title":"Assignment expressions and assignment versus mutation","text":"","category":"section"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"An assignment variable = value \"binds\" the name variable to the value computed on the right-hand side, and the whole assignment is treated by Julia as an expression equal to the right-hand-side value.  This means that assignments can be chained (the same value assigned to multiple variables with variable1 = variable2 = value) or used in other expressions, and is also why their result is shown in the REPL as the value of the right-hand side.  (In general, the REPL displays the value of whatever expression you evaluate.)  For example, here the value 4 of b = 2+2 is used in another arithmetic operation and assignment:","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"julia> a = (b = 2+2) + 3\n7\n\njulia> a\n7\n\njulia> b\n4","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"A common confusion is the distinction between assignment (giving a new \"name\" to a value) and mutation (changing a value).  If you run a = 2 followed by a = 3, you have changed the \"name\" a to refer to a new value 3 … you haven't changed the number 2, so 2+2 will still give 4 and not 6!   This distinction becomes more clear when dealing with mutable types like arrays, whose contents can be changed:","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"julia> a = [1,2,3] # an array of 3 integers\n3-element Vector{Int64}:\n 1\n 2\n 3\n\njulia> b = a   # both b and a are names for the same array!\n3-element Vector{Int64}:\n 1\n 2\n 3","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"Here, the line b = a does not make a copy of the array a, it simply binds the name b to the same array a: both b and a \"point\" to one array [1,2,3] in memory. In contrast, an assignment a[i] = value changes the contents of the array, and the modified array will be visible through both the names a and b:","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"julia> a[1] = 42     # change the first element\n42\n\njulia> a = 3.14159   # a is now the name of a different object\n3.14159\n\njulia> b   # b refers to the original array object, which has been mutated\n3-element Vector{Int64}:\n 42\n  2\n  3","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"That is, a[i] = value (an alias for setindex!) mutates an existing array object in memory, accessible via either a or b.  Subsequently setting a = 3.14159 does not change this array, it simply binds a to a different object; the array is still accessible via b. Another common syntax to mutate an existing object is a.field = value (an alias for setproperty!), which can be used to change a mutable struct.  There is also mutation via dot assignment, for example b .= 5:7 (which mutates our array b in-place to contain [5,6,7]), as part of Julia's vectorized \"dot\" syntax.","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"When you call a function in Julia, it behaves as if you assigned the argument values to new variable names corresponding to the function arguments, as discussed in Argument-Passing Behavior.  (By convention, functions that mutate one or more of their arguments have names ending with !.)","category":"page"},{"location":"manual/variables.html#Stylistic-Conventions","page":"Variables","title":"Stylistic Conventions","text":"","category":"section"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"While Julia imposes few restrictions on valid names, it has become useful to adopt the following conventions:","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"Names of variables are in lower case.\nWord separation can be indicated by underscores ('_'), but use of underscores is discouraged unless the name would be hard to read otherwise.\nNames of Types and Modules begin with a capital letter and word separation is shown with upper camel case instead of underscores.\nNames of functions and macros are in lower case, without underscores.\nFunctions that write to their arguments have names that end in !. These are sometimes called \"mutating\" or \"in-place\" functions because they are intended to produce changes in their arguments after the function is called, not just return a value.","category":"page"},{"location":"manual/variables.html","page":"Variables","title":"Variables","text":"For more information about stylistic conventions, see the Style Guide.","category":"page"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/NEWS.md\"","category":"page"},{"location":"NEWS.html#Julia-v1.11-Release-Notes","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"","category":"section"},{"location":"NEWS.html#New-language-features","page":"Julia v1.11 Release Notes","title":"New language features","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"New Memory type that provides a lower-level container as an alternative to Array. Memory has less overhead and a faster constructor, making it a good choice for situations that do not need all the features of Array (e.g. multiple dimensions). Most of the Array type is now implemented in Julia on top of Memory, leading to significant speedups for several functions (e.g. push!) as well as more maintainable code (#51319).\npublic is a new keyword. Symbols marked with public are considered public API. Symbols marked with export are now also treated as public API. The difference between public and export is that public names do not become available when using a package/module (#50105).\nScopedValue implements dynamic scope with inheritance across tasks (#50958).\nManifest.toml files can now be renamed in the format Manifest-v{major}.{minor}.toml to be preferentially picked up by the given julia version. i.e. in the same folder, a Manifest-v1.11.toml would be used by v1.11 and Manifest.toml by every other julia version. This makes managing environments for multiple julia versions at the same time easier (#43845).\nSupport for Unicode 15.1 (#51799).","category":"page"},{"location":"NEWS.html#Language-changes","page":"Julia v1.11 Release Notes","title":"Language changes","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"During precompilation, atexit hooks now run before saving the output file. This allows users to safely tear down background state (such as closing Timers and sending disconnect notifications to heartbeat tasks) and cleanup other resources when the program wants to begin exiting.\nCode coverage and malloc tracking is no longer generated during the package precompilation stage. Further, during these modes pkgimage caches are now used for packages that are not being tracked. This means that coverage testing (the default for julia-actions/julia-runtest) will by default use pkgimage caches for all other packages than the package being tested, likely meaning faster test execution (#52123).\nSpecifying a path in JULIA_DEPOT_PATH now results in the expansion of empty strings to omit the default user depot (#51448).\nPrecompilation cache files are now relocatable and their validity is now verified through a content hash of their source files instead of their mtime (#49866).\nExtensions may now depend on other extensions, if their triggers include all triggers of any extension they wish to depend upon (+ at least one other trigger). Ext-to-ext dependencies that don't meet this requirement are now blocked from using Base.get_extension during pre- compilation, to prevent extension cycles #55557.","category":"page"},{"location":"NEWS.html#Compiler/Runtime-improvements","page":"Julia v1.11 Release Notes","title":"Compiler/Runtime improvements","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"Updated GC heuristics to count allocated pages instead of individual objects (#50144).\nAdded support for annotating Base.@assume_effects on code blocks (#52400).","category":"page"},{"location":"NEWS.html#Command-line-option-changes","page":"Julia v1.11 Release Notes","title":"Command-line option changes","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"The entry point for Julia has been standardized to Main.main(args). This must be explicitly opted into using the @main macro (see the docstring for further details). When opted-in, and julia is invoked to run a script or expression (i.e. using julia script.jl or julia -e expr), julia will subsequently run the Main.main function automatically. This is intended to unify script and compilation workflows, where code loading may happen in the compiler and execution of Main.main may happen in the resulting executable. For interactive use, there is no semantic difference between defining a main function and executing the code directly at the end of the script (#50974).\nThe --compiled-modules and --pkgimages flags can now be set to existing, which will cause Julia to consider loading existing cache files, but not to create new ones (#50586, #52573).\nThe --project argument now accepts @script to give a path to a directory with a Project.toml relative to the passed script file. --project=@script/foo for the foo subdirectory. If no path is given after (i.e. --project=@script) then (like --project=@.) the directory and its parents are searched for a Project.toml (#50864 and #53352)","category":"page"},{"location":"NEWS.html#Multi-threading-changes","page":"Julia v1.11 Release Notes","title":"Multi-threading changes","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"Threads.@threads now supports the :greedy scheduler, intended for non-uniform workloads (#52096).\nA new public (but unexported) struct Base.Lockable{T, L<:AbstractLock} makes it easy to bundle a resource and its lock together (#52898).","category":"page"},{"location":"NEWS.html#Build-system-changes","page":"Julia v1.11 Release Notes","title":"Build system changes","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"There is a new Makefile to build Julia and LLVM using the profile-guided and link-time optimizations (PGO and LTO) strategies, see contrib/pgo-lto/Makefile (#45641).","category":"page"},{"location":"NEWS.html#New-library-functions","page":"Julia v1.11 Release Notes","title":"New library functions","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"Three new types around the idea of text with \"annotations\" (Pair{Symbol, Any} entries, e.g. :lang => \"en\" or :face => :magenta). These annotations are preserved across operations (e.g. string concatenation with *) when possible.\nAnnotatedString is a new AbstractString type. It wraps an underlying string and allows for annotations to be attached to regions of the string. This type is used extensively in the new StyledStrings standard library to hold styling information.\nAnnotatedChar is a new AbstractChar type. It wraps another char and holds a list of annotations that apply to it.\nAnnotatedIOBuffer is a new IO type that mimics an IOBuffer, but has specialised read/write methods for annotated content. This can be thought of both as a \"string builder\" of sorts and also as glue between annotated and unannotated content.\nin!(x, s::AbstractSet) will return whether x is in s, and insert x in s if not (#45156, #51636).\nThe new Libc.mkfifo function wraps the mkfifo C function on Unix platforms (#34587).\nlogrange(start, stop; length) makes a range of constant ratio, instead of constant step (#39071)\ncopyuntil(out, io, delim) and copyline(out, io) copy data into an out::IO stream (#48273).\neachrsplit(string, pattern) iterates split substrings right to left (#51646).\nSys.username() can be used to return the current user's username (#51897).\nSys.isreadable(), Sys.iswritable() can be used to check if the current user has access permissions that permit reading and writing, respectively. (#53320).\nGC.logging_enabled() can be used to test whether GC logging has been enabled via GC.enable_logging (#51647).\nIdSet is now exported from Base and considered public (#53262).\n@time now reports a count of any lock conflicts where a ReentrantLock had to wait, plus a new macro @lock_conflicts which returns that count (#52883).\nThe new macro Base.Cartesian.@ncallkw is analogous to Base.Cartesian.@ncall, but allows adding keyword arguments to the function call (#51501).\nNew function Docs.hasdoc(module, symbol) tells whether a name has a docstring (#52139).\nNew function Docs.undocumented_names(module) returns a module's undocumented public names (#52413).","category":"page"},{"location":"NEWS.html#New-library-features","page":"Julia v1.11 Release Notes","title":"New library features","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"invmod(n, T) where T is a native integer type now computes the modular inverse of n in the modular integer ring that T defines (#52180).\ninvmod(n) is an abbreviation for invmod(n, typeof(n)) for native integer types (#52180).\nreplace(string, pattern...) now supports an optional IO argument to write the output to a stream rather than returning a string (#48625).\nNew methods allequal(f, itr) and allunique(f, itr) taking a predicate function (#47679).\nsizehint!(s, n) now supports an optional shrink argument to disable shrinking (#51929).\nPassing an IOBuffer as a stdout argument for Process spawn now works as expected, synchronized with wait or success, so a Base.BufferStream is no longer required there for correctness to avoid data races (#52461).\nAfter a process exits, closewrite will no longer be automatically called on the stream passed to it. Call wait on the process instead to ensure the content is fully written, then call closewrite manually to avoid data races, or use the callback form of open to have all that handled automatically (#52461).\n@timed now additionally returns the elapsed compilation and recompilation time (#52889).\nfilter can now act on a NamedTuple (#50795).\nIterators.cycle(iter, n) runs over iter a fixed number of times, instead of forever (#47354).\nzero(::AbstractArray) now applies recursively, so zero([[1,2],[3,4,5]]) now produces the additive identity [[0,0],[0,0,0]] rather than erroring (#38064).\ninclude_dependency(path; track_content=true) allows switching from using mtime to hashing of the precompilation dependency in order to restore relocatability of precompilation caches (#51798).","category":"page"},{"location":"NEWS.html#Standard-library-changes","page":"Julia v1.11 Release Notes","title":"Standard library changes","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"The fallback method write(::IO, ::AbstractArray) used to recursively call write on each element, but now writes the in-memory representation of each value. For example, write(io, 'a':'b') now writes 4 bytes for each character, instead of writing the UTF-8 representation of each character. The new format is compatible with that used by Array, making it possible to use read! to get the data back (#42593).\nIt's not possible to define length for stateful iterators in a generally consistent manner. The potential for silently incorrect results for Stateful iterators is addressed by deleting the length(::Stateful) method. The last type parameter of Stateful is gone, too. Issue: (#47790), PR: (#51747).","category":"page"},{"location":"NEWS.html#Package-Manager","page":"Julia v1.11 Release Notes","title":"Package Manager","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"It is now possible to specify \"sources\" for packages in a [sources] section in Project.toml. This can be used to add non-registered normal or test dependencies.\nPkg now obeys [compat] bounds for julia and raises an error if the version of the running Julia binary is incompatible with the bounds in Project.toml. Pkg has always obeyed this compat when working with Registry packages. This change affects mostly local packages\npkg> add and Pkg.add will now add compat entries for new direct dependencies if the active environment is a package (has a name and uuid entry).\nDependencies can now be directly added as weak deps or extras via the pkg> add --weak/extra Foo or Pkg.add(\"Foo\", target=:weakdeps/:extras) forms.","category":"page"},{"location":"NEWS.html#StyledStrings","page":"Julia v1.11 Release Notes","title":"StyledStrings","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"A new standard library for handling styling in a more comprehensive and structured way (#49586).\nThe new Faces struct serves as a container for text styling information (think typeface, as well as color and decoration), and comes with a framework to provide a convenient, extensible (via addface!), and customisable (with a user's Faces.toml and loadfaces!) approach to styled content (#49586).\nThe new @styled_str string macro provides a convenient way of creating a AnnotatedString with various faces or other attributes applied (#49586).","category":"page"},{"location":"NEWS.html#Libdl","page":"Julia v1.11 Release Notes","title":"Libdl","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"A new LazyLibrary type is exported from Libdl for use in building chained lazy library loads, primarily to be used within JLLs (#50074).","category":"page"},{"location":"NEWS.html#LinearAlgebra","page":"Julia v1.11 Release Notes","title":"LinearAlgebra","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"cbrt(::AbstractMatrix{<:Real}) is now defined and returns real-valued matrix cube roots of real-valued matrices (#50661).\neigvals/eigen(A, bunchkaufman(B)) and eigvals/eigen(A, lu(B)), which utilize the Bunchkaufman (LDL) and LU decomposition of B,  respectively, now efficiently compute the generalized eigenvalues (eigen: and eigenvectors) of A and B. Note: The second  argument is the output of bunchkaufman or lu (#50471).\nThere is now a specialized dispatch for eigvals/eigen(::Hermitian{<:Tridiagonal}) which performs a similarity transformation to create a real symmetric tridiagonal matrix, and solve that using the LAPACK routines (#49546).\nStructured matrices now retain either the axes of the parent (for Symmetric/Hermitian/AbstractTriangular/UpperHessenberg), or that of the principal diagonal (for banded matrices) (#52480).\nbunchkaufman and bunchkaufman! now work for any AbstractFloat, Rational and their complex variants. bunchkaufman now supports Integer types, by making an internal conversion to Rational{BigInt}. Added new function inertia that computes the inertia of the diagonal factor given by the BunchKaufman factorization object of a real symmetric or Hermitian matrix. For complex symmetric matrices, inertia only computes the number of zero eigenvalues of the diagonal factor (#51487).\nPackages that specialize matrix-matrix mul! with a method signature of the form mul!(::AbstractMatrix, ::MyMatrix, ::AbstractMatrix, ::Number, ::Number) no longer encounter method ambiguities when interacting with LinearAlgebra. Previously, ambiguities used to arise when multiplying a MyMatrix with a structured matrix type provided by LinearAlgebra, such as AbstractTriangular, which used to necessitate additional methods to resolve such ambiguities. Similar sources of ambiguities have also been removed for matrix-vector mul! operations (#52837).\nlu and issuccess(::LU) now accept an allowsingular keyword argument. When set to true, a valid factorization with rank-deficient U factor will be treated as success instead of throwing an error. Such factorizations are now shown by printing the factors together with a \"rank-deficient\" note rather than printing a \"Failed Factorization\" message (#52957).","category":"page"},{"location":"NEWS.html#Random","page":"Julia v1.11 Release Notes","title":"Random","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"rand now supports sampling over Tuple types (#35856, #50251).\nrand now supports sampling over Pair types (#28705).\nWhen seeding RNGs provided by Random, negative integer seeds can now be used (#51416).\nSeedable random number generators from Random can now be seeded by a string, e.g. seed!(rng, \"a random seed\") (#51527).","category":"page"},{"location":"NEWS.html#REPL","page":"Julia v1.11 Release Notes","title":"REPL","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"Tab complete hints now show in lighter text while typing in the repl. To disable set Base.active_repl.options.hint_tab_completes = false interactively, or in startup.jl:\nif VERSION >= v\"1.11.0-0\"\n  atreplinit() do repl\n      repl.options.hint_tab_completes = false\n  end\nend\n(#51229).\nMeta-M with an empty prompt now toggles the contextual module between the previous non-Main contextual module and Main so that switching back and forth is simple (#51616, #52670).","category":"page"},{"location":"NEWS.html#Dates","page":"Julia v1.11 Release Notes","title":"Dates","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"The undocumented function adjust is no longer exported but is now documented (#53092).","category":"page"},{"location":"NEWS.html#Statistics","page":"Julia v1.11 Release Notes","title":"Statistics","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"Statistics is now an upgradeable standard library (#46501).","category":"page"},{"location":"NEWS.html#Distributed","page":"Julia v1.11 Release Notes","title":"Distributed","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"pmap now defaults to using a CachingPool (#33892).","category":"page"},{"location":"NEWS.html#Deprecated-or-removed","page":"Julia v1.11 Release Notes","title":"Deprecated or removed","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"Base.map, Iterators.map, and foreach lost their single-argument methods (#52631).","category":"page"},{"location":"NEWS.html#External-dependencies","page":"Julia v1.11 Release Notes","title":"External dependencies","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"The libuv library has been updated from a base of v1.44.2 to v1.48.0 (#49937).\ntput is no longer called to check terminal capabilities; it has been replaced with a pure-Julia terminfo parser (#50797).\nThe terminal info database, terminfo, is now vendored by default, providing a better REPL user experience when terminfo is not available on the system. Julia can be built without vendoring the database using the Makefile option WITH_TERMINFO=0. (#55411)","category":"page"},{"location":"NEWS.html#Tooling-Improvements","page":"Julia v1.11 Release Notes","title":"Tooling Improvements","text":"","category":"section"},{"location":"NEWS.html","page":"Julia v1.11 Release Notes","title":"Julia v1.11 Release Notes","text":"CI now performs limited automatic typo detection on all PRs. If you merge a PR with a failing typo CI check, then the reported typos will be automatically ignored in future CI runs on PRs that edit those same files (#51704).","category":"page"},{"location":"stdlib/InteractiveUtils.html","page":"Interactive Utilities","title":"Interactive Utilities","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/stdlib/InteractiveUtils/docs/src/index.md\"","category":"page"},{"location":"stdlib/InteractiveUtils.html#man-interactive-utils","page":"Interactive Utilities","title":"Interactive Utilities","text":"","category":"section"},{"location":"stdlib/InteractiveUtils.html","page":"Interactive Utilities","title":"Interactive Utilities","text":"The InteractiveUtils module provides utilities for interactive use of Julia, such as code introspection and clipboard access. It is intended for interactive work and is loaded automatically in interactive mode.","category":"page"},{"location":"stdlib/InteractiveUtils.html","page":"Interactive Utilities","title":"Interactive Utilities","text":"InteractiveUtils.apropos\nInteractiveUtils.varinfo\nInteractiveUtils.versioninfo\nInteractiveUtils.methodswith\nInteractiveUtils.subtypes\nInteractiveUtils.supertypes\nInteractiveUtils.edit(::AbstractString, ::Integer)\nInteractiveUtils.edit(::Any)\nInteractiveUtils.@edit\nInteractiveUtils.define_editor\nInteractiveUtils.less(::AbstractString)\nInteractiveUtils.less(::Any)\nInteractiveUtils.@less\nInteractiveUtils.@which\nInteractiveUtils.@functionloc\nInteractiveUtils.@code_lowered\nInteractiveUtils.@code_typed\nInteractiveUtils.code_warntype\nInteractiveUtils.@code_warntype\nInteractiveUtils.code_llvm\nInteractiveUtils.@code_llvm\nInteractiveUtils.code_native\nInteractiveUtils.@code_native\nInteractiveUtils.@time_imports\nInteractiveUtils.clipboard","category":"page"},{"location":"stdlib/InteractiveUtils.html#Base.Docs.apropos","page":"Interactive Utilities","title":"Base.Docs.apropos","text":"apropos([io::IO=stdout], pattern::Union{AbstractString,Regex})\n\nSearch available docstrings for entries containing pattern.\n\nWhen pattern is a string, case is ignored. Results are printed to io.\n\napropos can be called from the help mode in the REPL by wrapping the query in double quotes:\n\nhelp?> \"pattern\"\n\n\n\n\n\n","category":"function"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.varinfo","page":"Interactive Utilities","title":"InteractiveUtils.varinfo","text":"varinfo(m::Module=Main, pattern::Regex=r\"\"; all=false, imported=false, recursive=false, sortby::Symbol=:name, minsize::Int=0)\n\nReturn a markdown table giving information about public global variables in a module, optionally restricted to those matching pattern.\n\nThe memory consumption estimate is an approximate lower bound on the size of the internal structure of the object.\n\nall : also list non-public objects defined in the module, deprecated objects, and compiler-generated objects.\nimported : also list objects explicitly imported from other modules.\nrecursive : recursively include objects in sub-modules, observing the same settings in each.\nsortby : the column to sort results by. Options are :name (default), :size, and :summary.\nminsize : only includes objects with size at least minsize bytes. Defaults to 0.\n\nThe output of varinfo is intended for display purposes only.  See also names to get an array of symbols defined in a module, which is suitable for more general manipulations.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.versioninfo","page":"Interactive Utilities","title":"InteractiveUtils.versioninfo","text":"versioninfo(io::IO=stdout; verbose::Bool=false)\n\nPrint information about the version of Julia in use. The output is controlled with boolean keyword arguments:\n\nverbose: print all additional information\n\nwarning: Warning\nThe output of this function may contain sensitive information. Before sharing the output, please review the output and remove any data that should not be shared publicly.\n\nSee also: VERSION.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.methodswith","page":"Interactive Utilities","title":"InteractiveUtils.methodswith","text":"methodswith(typ[, module or function]; supertypes::Bool=false])\n\nReturn an array of methods with an argument of type typ.\n\nThe optional second argument restricts the search to a particular module or function (the default is all top-level modules).\n\nIf keyword supertypes is true, also return arguments with a parent type of typ, excluding type Any.\n\nSee also: methods.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.subtypes","page":"Interactive Utilities","title":"InteractiveUtils.subtypes","text":"subtypes(T::DataType)\n\nReturn a list of immediate subtypes of DataType T. Note that all currently loaded subtypes are included, including those not visible in the current module.\n\nSee also supertype, supertypes, methodswith.\n\nExamples\n\njulia> subtypes(Integer)\n3-element Vector{Any}:\n Bool\n Signed\n Unsigned\n\n\n\n\n\n","category":"function"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.supertypes","page":"Interactive Utilities","title":"InteractiveUtils.supertypes","text":"supertypes(T::Type)\n\nReturn a tuple (T, ..., Any) of T and all its supertypes, as determined by successive calls to the supertype function, listed in order of <: and terminated by Any.\n\nSee also subtypes.\n\nExamples\n\njulia> supertypes(Int)\n(Int64, Signed, Integer, Real, Number, Any)\n\n\n\n\n\n","category":"function"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.edit-Tuple{AbstractString, Integer}","page":"Interactive Utilities","title":"InteractiveUtils.edit","text":"edit(path::AbstractString, line::Integer=0, column::Integer=0)\n\nEdit a file or directory optionally providing a line number to edit the file at. Return to the julia prompt when you quit the editor. The editor can be changed by setting JULIA_EDITOR, VISUAL or EDITOR as an environment variable.\n\ncompat: Julia 1.9\nThe column argument requires at least Julia 1.9.\n\nSee also InteractiveUtils.define_editor.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.edit-Tuple{Any}","page":"Interactive Utilities","title":"InteractiveUtils.edit","text":"edit(function, [types])\nedit(module)\n\nEdit the definition of a function, optionally specifying a tuple of types to indicate which method to edit. For modules, open the main source file. The module needs to be loaded with using or import first.\n\ncompat: Julia 1.1\nedit on modules requires at least Julia 1.1.\n\nTo ensure that the file can be opened at the given line, you may need to call InteractiveUtils.define_editor first.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.@edit","page":"Interactive Utilities","title":"InteractiveUtils.@edit","text":"@edit\n\nEvaluates the arguments to the function or macro call, determines their types, and calls the edit function on the resulting expression.\n\nSee also: @less, @which.\n\n\n\n\n\n","category":"macro"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.define_editor","page":"Interactive Utilities","title":"InteractiveUtils.define_editor","text":"define_editor(fn, pattern; wait=false)\n\nDefine a new editor matching pattern that can be used to open a file (possibly at a given line number) using fn.\n\nThe fn argument is a function that determines how to open a file with the given editor. It should take four arguments, as follows:\n\ncmd - a base command object for the editor\npath - the path to the source file to open\nline - the line number to open the editor at\ncolumn - the column number to open the editor at\n\nEditors which cannot open to a specific line with a command or a specific column may ignore the line and/or column argument. The fn callback must return either an appropriate Cmd object to open a file or nothing to indicate that they cannot edit this file. Use nothing to indicate that this editor is not appropriate for the current environment and another editor should be attempted. It is possible to add more general editing hooks that need not spawn external commands by pushing a callback directly to the vector EDITOR_CALLBACKS.\n\nThe pattern argument is a string, regular expression, or an array of strings and regular expressions. For the fn to be called, one of the patterns must match the value of EDITOR, VISUAL or JULIA_EDITOR. For strings, the string must equal the basename of the first word of the editor command, with its extension, if any, removed. E.g. \"vi\" doesn't match \"vim -g\" but matches \"/usr/bin/vi -m\"; it also matches vi.exe. If pattern is a regex it is matched against all of the editor command as a shell-escaped string. An array pattern matches if any of its items match. If multiple editors match, the one added most recently is used.\n\nBy default julia does not wait for the editor to close, running it in the background. However, if the editor is terminal based, you will probably want to set wait=true and julia will wait for the editor to close before resuming.\n\nIf one of the editor environment variables is set, but no editor entry matches it, the default editor entry is invoked:\n\n(cmd, path, line, column) -> `$cmd $path`\n\nNote that many editors are already defined. All of the following commands should already work:\n\nemacs\nemacsclient\nvim\nnvim\nnano\nmicro\nkak\nhelix\ntextmate\nmate\nkate\nsubl\natom\nnotepad++\nVisual Studio Code\nopen\npycharm\nbbedit\n\nExamples\n\nThe following defines the usage of terminal-based emacs:\n\ndefine_editor(\n    r\"\\bemacs\\b.*\\s(-nw|--no-window-system)\\b\", wait=true) do cmd, path, line\n    `$cmd +$line $path`\nend\n\ncompat: Julia 1.4\ndefine_editor was introduced in Julia 1.4.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.less-Tuple{AbstractString}","page":"Interactive Utilities","title":"InteractiveUtils.less","text":"less(file::AbstractString, [line::Integer])\n\nShow a file using the default pager, optionally providing a starting line number. Returns to the julia prompt when you quit the pager.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.less-Tuple{Any}","page":"Interactive Utilities","title":"InteractiveUtils.less","text":"less(function, [types])\n\nShow the definition of a function using the default pager, optionally specifying a tuple of types to indicate which method to see.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.@less","page":"Interactive Utilities","title":"InteractiveUtils.@less","text":"@less\n\nEvaluates the arguments to the function or macro call, determines their types, and calls the less function on the resulting expression.\n\nSee also: @edit, @which, @code_lowered.\n\n\n\n\n\n","category":"macro"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.@which","page":"Interactive Utilities","title":"InteractiveUtils.@which","text":"@which\n\nApplied to a function or macro call, it evaluates the arguments to the specified call, and returns the Method object for the method that would be called for those arguments. Applied to a variable, it returns the module in which the variable was bound. It calls out to the which function.\n\nSee also: @less, @edit.\n\n\n\n\n\n","category":"macro"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.@functionloc","page":"Interactive Utilities","title":"InteractiveUtils.@functionloc","text":"@functionloc\n\nApplied to a function or macro call, it evaluates the arguments to the specified call, and returns a tuple (filename,line) giving the location for the method that would be called for those arguments. It calls out to the functionloc function.\n\n\n\n\n\n","category":"macro"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.@code_lowered","page":"Interactive Utilities","title":"InteractiveUtils.@code_lowered","text":"@code_lowered\n\nEvaluates the arguments to the function or macro call, determines their types, and calls code_lowered on the resulting expression.\n\nSee also: code_lowered, @code_warntype, @code_typed, @code_llvm, @code_native.\n\n\n\n\n\n","category":"macro"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.@code_typed","page":"Interactive Utilities","title":"InteractiveUtils.@code_typed","text":"@code_typed\n\nEvaluates the arguments to the function or macro call, determines their types, and calls code_typed on the resulting expression. Use the optional argument optimize with\n\n@code_typed optimize=true foo(x)\n\nto control whether additional optimizations, such as inlining, are also applied.\n\nSee also: code_typed, @code_warntype, @code_lowered, @code_llvm, @code_native.\n\n\n\n\n\n","category":"macro"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.code_warntype","page":"Interactive Utilities","title":"InteractiveUtils.code_warntype","text":"code_warntype([io::IO], f, types; debuginfo=:default)\n\nPrints lowered and type-inferred ASTs for the methods matching the given generic function and type signature to io which defaults to stdout. The ASTs are annotated in such a way as to cause \"non-leaf\" types which may be problematic for performance to be emphasized (if color is available, displayed in red). This serves as a warning of potential type instability.\n\nNot all non-leaf types are particularly problematic for performance, and the performance characteristics of a particular type is an implementation detail of the compiler. code_warntype will err on the side of coloring types red if they might be a performance concern, so some types may be colored red even if they do not impact performance. Small unions of concrete types are usually not a concern, so these are highlighted in yellow.\n\nKeyword argument debuginfo may be one of :source or :none (default), to specify the verbosity of code comments.\n\nSee the @code_warntype section in the Performance Tips page of the manual for more information.\n\nSee also: @code_warntype, code_typed, code_lowered, code_llvm, code_native.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.@code_warntype","page":"Interactive Utilities","title":"InteractiveUtils.@code_warntype","text":"@code_warntype\n\nEvaluates the arguments to the function or macro call, determines their types, and calls code_warntype on the resulting expression.\n\nSee also: code_warntype, @code_typed, @code_lowered, @code_llvm, @code_native.\n\n\n\n\n\n","category":"macro"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.code_llvm","page":"Interactive Utilities","title":"InteractiveUtils.code_llvm","text":"code_llvm([io=stdout,], f, types; raw=false, dump_module=false, optimize=true, debuginfo=:default)\n\nPrints the LLVM bitcodes generated for running the method matching the given generic function and type signature to io.\n\nIf the optimize keyword is unset, the code will be shown before LLVM optimizations. All metadata and dbg.* calls are removed from the printed bitcode. For the full IR, set the raw keyword to true. To dump the entire module that encapsulates the function (with declarations), set the dump_module keyword to true. Keyword argument debuginfo may be one of source (default) or none, to specify the verbosity of code comments.\n\nSee also: @code_llvm, code_warntype, code_typed, code_lowered, code_native.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.@code_llvm","page":"Interactive Utilities","title":"InteractiveUtils.@code_llvm","text":"@code_llvm\n\nEvaluates the arguments to the function or macro call, determines their types, and calls code_llvm on the resulting expression. Set the optional keyword arguments raw, dump_module, debuginfo, optimize by putting them and their value before the function call, like this:\n\n@code_llvm raw=true dump_module=true debuginfo=:default f(x)\n@code_llvm optimize=false f(x)\n\noptimize controls whether additional optimizations, such as inlining, are also applied. raw makes all metadata and dbg.* calls visible. debuginfo may be one of :source (default) or :none,  to specify the verbosity of code comments. dump_module prints the entire module that encapsulates the function.\n\nSee also: code_llvm, @code_warntype, @code_typed, @code_lowered, @code_native.\n\n\n\n\n\n","category":"macro"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.code_native","page":"Interactive Utilities","title":"InteractiveUtils.code_native","text":"code_native([io=stdout,], f, types; syntax=:intel, debuginfo=:default, binary=false, dump_module=true)\n\nPrints the native assembly instructions generated for running the method matching the given generic function and type signature to io.\n\nSet assembly syntax by setting syntax to :intel (default) for intel syntax or :att for AT&T syntax.\nSpecify verbosity of code comments by setting debuginfo to :source (default) or :none.\nIf binary is true, also print the binary machine code for each instruction precedented by an abbreviated address.\nIf dump_module is false, do not print metadata such as rodata or directives.\nIf raw is false, uninteresting instructions (like the safepoint function prologue) are elided.\n\nSee also: @code_native, code_warntype, code_typed, code_lowered, code_llvm.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.@code_native","page":"Interactive Utilities","title":"InteractiveUtils.@code_native","text":"@code_native\n\nEvaluates the arguments to the function or macro call, determines their types, and calls code_native on the resulting expression.\n\nSet any of the optional keyword arguments syntax, debuginfo, binary or dump_module by putting it before the function call, like this:\n\n@code_native syntax=:intel debuginfo=:default binary=true dump_module=false f(x)\n\nSet assembly syntax by setting syntax to :intel (default) for Intel syntax or :att for AT&T syntax.\nSpecify verbosity of code comments by setting debuginfo to :source (default) or :none.\nIf binary is true, also print the binary machine code for each instruction precedented by an abbreviated address.\nIf dump_module is false, do not print metadata such as rodata or directives.\n\nSee also: code_native, @code_warntype, @code_typed, @code_lowered, @code_llvm.\n\n\n\n\n\n","category":"macro"},{"location":"stdlib/InteractiveUtils.html#Base.@time_imports","page":"Interactive Utilities","title":"Base.@time_imports","text":"@time_imports\n\nA macro to execute an expression and produce a report of any time spent importing packages and their dependencies. Any compilation time will be reported as a percentage, and how much of which was recompilation, if any.\n\nOne line is printed per package or package extension. The duration shown is the time to import that package itself, not including the time to load any of its dependencies.\n\nOn Julia 1.9+ package extensions will show as Parent → Extension.\n\nnote: Note\nDuring the load process a package sequentially imports all of its dependencies, not just its direct dependencies.\n\njulia> @time_imports using CSV\n     50.7 ms  Parsers 17.52% compilation time\n      0.2 ms  DataValueInterfaces\n      1.6 ms  DataAPI\n      0.1 ms  IteratorInterfaceExtensions\n      0.1 ms  TableTraits\n     17.5 ms  Tables\n     26.8 ms  PooledArrays\n    193.7 ms  SentinelArrays 75.12% compilation time\n      8.6 ms  InlineStrings\n     20.3 ms  WeakRefStrings\n      2.0 ms  TranscodingStreams\n      1.4 ms  Zlib_jll\n      1.8 ms  CodecZlib\n      0.8 ms  Compat\n     13.1 ms  FilePathsBase 28.39% compilation time\n   1681.2 ms  CSV 92.40% compilation time\n\ncompat: Julia 1.8\nThis macro requires at least Julia 1.8\n\n\n\n\n\n","category":"macro"},{"location":"stdlib/InteractiveUtils.html#InteractiveUtils.clipboard","page":"Interactive Utilities","title":"InteractiveUtils.clipboard","text":"clipboard(x)\n\nSend a printed form of x to the operating system clipboard (\"copy\").\n\n\n\n\n\nclipboard() -> String\n\nReturn a string with the contents of the operating system clipboard (\"paste\").\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Serialization.html","page":"Serialization","title":"Serialization","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/stdlib/Serialization/docs/src/index.md\"","category":"page"},{"location":"stdlib/Serialization.html#Serialization","page":"Serialization","title":"Serialization","text":"","category":"section"},{"location":"stdlib/Serialization.html","page":"Serialization","title":"Serialization","text":"Provides serialization of Julia objects.","category":"page"},{"location":"stdlib/Serialization.html","page":"Serialization","title":"Serialization","text":"Serialization.serialize\nSerialization.deserialize\nSerialization.writeheader","category":"page"},{"location":"stdlib/Serialization.html#Serialization.serialize","page":"Serialization","title":"Serialization.serialize","text":"serialize(stream::IO, value)\n\nWrite an arbitrary value to a stream in an opaque format, such that it can be read back by deserialize. The read-back value will be as identical as possible to the original, but note that Ptr values are serialized as all-zero bit patterns (NULL).\n\nAn 8-byte identifying header is written to the stream first. To avoid writing the header, construct a Serializer and use it as the first argument to serialize instead. See also Serialization.writeheader.\n\nThe data format can change in minor (1.x) Julia releases, but files written by prior 1.x versions will remain readable. The main exception to this is when the definition of a type in an external package changes. If that occurs, it may be necessary to specify an explicit compatible version of the affected package in your environment. Renaming functions, even private functions, inside packages can also put existing files out of sync. Anonymous functions require special care: because their names are automatically generated, minor code changes can cause them to be renamed. Serializing anonymous functions should be avoided in files intended for long-term storage.\n\nIn some cases, the word size (32- or 64-bit) of the reading and writing machines must match. In rarer cases the OS or architecture must also match, for example when using packages that contain platform-dependent code.\n\n\n\n\n\nserialize(filename::AbstractString, value)\n\nOpen a file and serialize the given value to it.\n\ncompat: Julia 1.1\nThis method is available as of Julia 1.1.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Serialization.html#Serialization.deserialize","page":"Serialization","title":"Serialization.deserialize","text":"deserialize(stream)\n\nRead a value written by serialize. deserialize assumes the binary data read from stream is correct and has been serialized by a compatible implementation of serialize. deserialize is designed for simplicity and performance, and so does not validate the data read. Malformed data can result in process termination. The caller must ensure the integrity and correctness of data read from stream.\n\n\n\n\n\ndeserialize(filename::AbstractString)\n\nOpen a file and deserialize its contents.\n\ncompat: Julia 1.1\nThis method is available as of Julia 1.1.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Serialization.html#Serialization.writeheader","page":"Serialization","title":"Serialization.writeheader","text":"Serialization.writeheader(s::AbstractSerializer)\n\nWrite an identifying header to the specified serializer. The header consists of 8 bytes as follows:\n\nOffset Description\n0 tag byte (0x37)\n1-2 signature bytes \"JL\"\n3 protocol version\n4 bits 0-1: endianness: 0 = little, 1 = big\n4 bits 2-3: platform: 0 = 32-bit, 1 = 64-bit\n5-7 reserved\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Future.html","page":"Future","title":"Future","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/stdlib/Future/docs/src/index.md\"","category":"page"},{"location":"stdlib/Future.html#Future","page":"Future","title":"Future","text":"","category":"section"},{"location":"stdlib/Future.html","page":"Future","title":"Future","text":"The Future module implements future behavior of already existing functions, which will replace the current version in a future release of Julia.","category":"page"},{"location":"stdlib/Future.html","page":"Future","title":"Future","text":"Future.copy!\nFuture.randjump","category":"page"},{"location":"stdlib/Future.html#Future.copy!","page":"Future","title":"Future.copy!","text":"Future.copy!(dst, src) -> dst\n\nCopy src into dst.\n\ncompat: Julia 1.1\nThis function has moved to Base with Julia 1.1, consider using copy!(dst, src) instead. Future.copy! will be deprecated in the future.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Future.html#Future.randjump","page":"Future","title":"Future.randjump","text":"randjump(r::MersenneTwister, steps::Integer) -> MersenneTwister\n\nCreate an initialized MersenneTwister object, whose state is moved forward (without generating numbers) from r by steps steps. One such step corresponds to the generation of two Float64 numbers. For each different value of steps, a large polynomial has to be generated internally. One is already pre-computed for steps=big(10)^20.\n\n\n\n\n\n","category":"function"},{"location":"manual/documentation.html#man-documentation","page":"Documentation","title":"Documentation","text":"","category":"section"},{"location":"manual/documentation.html#Accessing-Documentation","page":"Documentation","title":"Accessing Documentation","text":"","category":"section"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Documentation can be accessed at the REPL or in IJulia by typing ? followed by the name of a function or macro, and pressing Enter. For example,","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"?cos\n?@time\n?r\"\"","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"will show documentation for the relevant function, macro or string macro respectively. Most Julia environments provide a way to access documentation directly:","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"VS Code shows documentation when you hover over a function name. You can also use the Julia panel in the sidebar to search for documentation.\nIn Pluto, open the \"Live Docs\" panel on the bottom right.\nIn Juno using Ctrl-J, Ctrl-D will show the documentation for the object under the cursor.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Docs.hasdoc(module, name)::Bool tells whether a name has a docstring. Docs.undocumented_names(module; all) returns the undocumented names in a module.","category":"page"},{"location":"manual/documentation.html#Writing-Documentation","page":"Documentation","title":"Writing Documentation","text":"","category":"section"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Julia enables package developers and users to document functions, types and other objects easily via a built-in documentation system.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"The basic syntax is simple: any string appearing just before an object (function, macro, type or instance) will be interpreted as documenting it (these are called docstrings). Note that no blank lines or comments may intervene between a docstring and the documented object. Here is a basic example:","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"\"Tell whether there are too foo items in the array.\"\nfoo(xs::Array) = ...","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Documentation is interpreted as Markdown, so you can use indentation and code fences to delimit code examples from text. Technically, any object can be associated with any other as metadata; Markdown happens to be the default, but one can construct other string macros and pass them to the @doc macro just as well.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"note: Note\nMarkdown support is implemented in the Markdown standard library and for a full list of supported syntax see the documentation.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Here is a more complex example, still using Markdown:","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"\"\"\"\n    bar(x[, y])\n\nCompute the Bar index between `x` and `y`.\n\nIf `y` is unspecified, compute the Bar index between all pairs of columns of `x`.\n\n# Examples\n```julia-repl\njulia> bar([1, 2], [1, 2])\n1\n```\n\"\"\"\nfunction bar(x, y) ...","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"As in the example above, we recommend following some simple conventions when writing documentation:","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Always show the signature of a function at the top of the documentation, with a four-space indent so that it is printed as Julia code.\nThis can be identical to the signature present in the Julia code (like mean(x::AbstractArray)), or a simplified form. Optional arguments should be represented with their default values (i.e. f(x, y=1)) when possible, following the actual Julia syntax. Optional arguments which do not have a default value should be put in brackets (i.e. f(x[, y]) and f(x[, y[, z]])). An alternative solution is to use several lines: one without optional arguments, the other(s) with them. This solution can also be used to document several related methods of a given function. When a function accepts many keyword arguments, only include a <keyword arguments> placeholder in the signature (i.e. f(x; <keyword arguments>)), and give the complete list under an # Arguments section (see point 4 below).\nInclude a single one-line sentence describing what the function does or what the object represents after the simplified signature block. If needed, provide more details in a second paragraph, after a blank line.\nThe one-line sentence should use the imperative form (\"Do this\", \"Return that\") instead of the third person (do not write \"Returns the length...\") when documenting functions. It should end with a period. If the meaning of a function cannot be summarized easily, splitting it into separate composable parts could be beneficial (this should not be taken as an absolute requirement for every single case though).\nDo not repeat yourself.\nSince the function name is given by the signature, there is no need to start the documentation with \"The function bar...\": go straight to the point. Similarly, if the signature specifies the types of the arguments, mentioning them in the description is redundant.\nOnly provide an argument list when really necessary.\nFor simple functions, it is often clearer to mention the role of the arguments directly in the description of the function's purpose. An argument list would only repeat information already provided elsewhere. However, providing an argument list can be a good idea for complex functions with many arguments (in particular keyword arguments). In that case, insert it after the general description of the function, under an # Arguments header, with one - bullet for each argument. The list should mention the types and default values (if any) of the arguments:\n\"\"\"\n...\n# Arguments\n- `n::Integer`: the number of elements to compute.\n- `dim::Integer=1`: the dimensions along which to perform the computation.\n...\n\"\"\"\nProvide hints to related functions.\nSometimes there are functions of related functionality. To increase discoverability please provide a short list of these in a See also paragraph.\nSee also [`bar!`](@ref), [`baz`](@ref), [`baaz`](@ref).\nInclude any code examples in an # Examples section.\nExamples should, whenever possible, be written as doctests. A doctest is a fenced code block (see Code blocks) starting with ```jldoctest and contains any number of julia> prompts together with inputs and expected outputs that mimic the Julia REPL.\nnote: Note\nDoctests are enabled by Documenter.jl. For more detailed documentation see Documenter's manual.\nFor example in the following docstring a variable a is defined and the expected result, as printed in a Julia REPL, appears afterwards:\n\"\"\"\nSome nice documentation here.\n\n# Examples\n```jldoctest\njulia> a = [1 2; 3 4]\n2×2 Array{Int64,2}:\n 1  2\n 3  4\n```\n\"\"\"\nwarning: Warning\nCalling rand and other RNG-related functions should be avoided in doctests since they will not produce consistent outputs during different Julia sessions. If you would like to show some random number generation related functionality, one option is to explicitly construct and seed your own RNG object (see Random) and pass it to the functions you are doctesting.Operating system word size (Int32 or Int64) as well as path separator differences (/ or \\) will also affect the reproducibility of some doctests.Note that whitespace in your doctest is significant! The doctest will fail if you misalign the output of pretty-printing an array, for example.\nYou can then run make -C doc doctest=true to run all the doctests in the Julia Manual and API documentation, which will ensure that your example works.\nTo indicate that the output result is truncated, you may write [...] at the line where checking should stop. This is useful to hide a stacktrace (which contains non-permanent references to lines of julia code) when the doctest shows that an exception is thrown, for example:\n```jldoctest\njulia> div(1, 0)\nERROR: DivideError: integer division error\n[...]\n```\nExamples that are untestable should be written within fenced code blocks starting with ```julia so that they are highlighted correctly in the generated documentation.\ntip: Tip\nWherever possible examples should be self-contained and runnable so that readers are able to try them out without having to include any dependencies.\nUse backticks to identify code and equations.\nJulia identifiers and code excerpts should always appear between backticks ` to enable highlighting. Equations in the LaTeX syntax can be inserted between double backticks ``. Use Unicode characters rather than their LaTeX escape sequence, i.e. ``α = 1`` rather than ``\\\\alpha = 1``.\nPlace the starting and ending \"\"\" characters on lines by themselves.\nThat is, write:\n\"\"\"\n...\n\n...\n\"\"\"\nf(x, y) = ...\nrather than:\n\"\"\"...\n\n...\"\"\"\nf(x, y) = ...\nThis makes it clearer where docstrings start and end.\nRespect the line length limit used in the surrounding code.\nDocstrings are edited using the same tools as code. Therefore, the same conventions should apply. It is recommended that lines are at most 92 characters wide.\nProvide information allowing custom types to implement the function in an # Implementation section. These implementation details are intended for developers rather than users, explaining e.g. which functions should be overridden and which functions automatically use appropriate fallbacks. Such details are best kept separate from the main description of the function's behavior.\nFor long docstrings, consider splitting the documentation with an # Extended help header. The typical help-mode will show only the material above the header; you can access the full help by adding a '?' at the beginning of the expression (i.e., \"??foo\" rather than \"?foo\").","category":"page"},{"location":"manual/documentation.html#Functions-and-Methods","page":"Documentation","title":"Functions & Methods","text":"","category":"section"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Functions in Julia may have multiple implementations, known as methods. While it's good practice for generic functions to have a single purpose, Julia allows methods to be documented individually if necessary. In general, only the most generic method should be documented, or even the function itself (i.e. the object created without any methods by function bar end). Specific methods should only be documented if their behaviour differs from the more generic ones. In any case, they should not repeat the information provided elsewhere. For example:","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"\"\"\"\n    *(x, y, z...)\n\nMultiplication operator. `x * y * z *...` calls this function with multiple\narguments, i.e. `*(x, y, z...)`.\n\"\"\"\nfunction *(x, y, z...)\n    # ... [implementation sold separately] ...\nend\n\n\"\"\"\n    *(x::AbstractString, y::AbstractString, z::AbstractString...)\n\nWhen applied to strings, concatenates them.\n\"\"\"\nfunction *(x::AbstractString, y::AbstractString, z::AbstractString...)\n    # ... [insert secret sauce here] ...\nend\n\nhelp?> *\nsearch: * .*\n\n  *(x, y, z...)\n\n  Multiplication operator. x * y * z *... calls this function with multiple\n  arguments, i.e. *(x,y,z...).\n\n  *(x::AbstractString, y::AbstractString, z::AbstractString...)\n\n  When applied to strings, concatenates them.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"When retrieving documentation for a generic function, the metadata for each method is concatenated with the catdoc function, which can of course be overridden for custom types.","category":"page"},{"location":"manual/documentation.html#Advanced-Usage","page":"Documentation","title":"Advanced Usage","text":"","category":"section"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"The @doc macro associates its first argument with its second in a per-module dictionary called META.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"To make it easier to write documentation, the parser treats the macro name @doc specially: if a call to @doc has one argument, but another expression appears after a single line break, then that additional expression is added as an argument to the macro. Therefore the following syntax is parsed as a 2-argument call to @doc:","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"@doc raw\"\"\"\n...\n\"\"\"\nf(x) = x","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"This makes it possible to use expressions other than normal string literals (such as the raw\"\" string macro) as a docstring.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"When used for retrieving documentation, the @doc macro (or equally, the doc function) will search all META dictionaries for metadata relevant to the given object and return it. The returned object (some Markdown content, for example) will by default display itself intelligently. This design also makes it easy to use the doc system in a programmatic way; for example, to re-use documentation between different versions of a function:","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"@doc \"...\" foo!\n@doc (@doc foo!) foo","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Or for use with Julia's metaprogramming functionality:","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"for (f, op) in ((:add, :+), (:subtract, :-), (:multiply, :*), (:divide, :/))\n    @eval begin\n        $f(a, b) = $op(a, b)\n    end\nend\n@doc \"`add(a, b)` adds `a` and `b` together\" add\n@doc \"`subtract(a, b)` subtracts `b` from `a`\" subtract","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Documentation in non-toplevel blocks, such as begin, if, for, let, and inner constructors, should be added to the documentation system via @doc as well. For example:","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"if condition()\n    @doc \"...\"\n    f(x) = x\nend","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"will add documentation to f(x) when condition() is true. Note that even if f(x) goes out of scope at the end of a block, its documentation will remain.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"It is possible to make use of metaprogramming to assist in the creation of documentation. When using string-interpolation within the docstring you will need to use an extra $ as shown with $($name):","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"for func in (:day, :dayofmonth)\n    name = string(func)\n    @eval begin\n        @doc \"\"\"\n            $($name)(dt::TimeType) -> Int64\n\n        The day of month of a `Date` or `DateTime` as an `Int64`.\n        \"\"\" $func(dt::Dates.TimeType)\n    end\nend","category":"page"},{"location":"manual/documentation.html#Dynamic-documentation","page":"Documentation","title":"Dynamic documentation","text":"","category":"section"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Sometimes the appropriate documentation for an instance of a type depends on the field values of that instance, rather than just on the type itself. In these cases, you can add a method to Docs.getdoc for your custom type that returns the documentation on a per-instance basis. For instance,","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"struct MyType\n    value::Int\nend\n\nDocs.getdoc(t::MyType) = \"Documentation for MyType with value $(t.value)\"\n\nx = MyType(1)\ny = MyType(2)","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"?x will display \"Documentation for MyType with value 1\" while ?y will display \"Documentation for MyType with value 2\".","category":"page"},{"location":"manual/documentation.html#Syntax-Guide","page":"Documentation","title":"Syntax Guide","text":"","category":"section"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"This guide provides a comprehensive overview of how to attach documentation to all Julia syntax constructs for which providing documentation is possible.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"In the following examples \"...\" is used to illustrate an arbitrary docstring.","category":"page"},{"location":"manual/documentation.html#and-\\-characters","page":"Documentation","title":"$ and \\ characters","text":"","category":"section"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"The $ and \\ characters are still parsed as string interpolation or start of an escape sequence in docstrings too. The raw\"\" string macro together with the @doc macro can be used to avoid having to escape them. This is handy when the docstrings include LaTeX or Julia source code examples containing interpolation:","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"@doc raw\"\"\"\n```math\n\\LaTeX\n```\n\"\"\"\nfunction f end","category":"page"},{"location":"manual/documentation.html#Functions-and-Methods-2","page":"Documentation","title":"Functions and Methods","text":"","category":"section"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"\"...\"\nfunction f end\n\n\"...\"\nf","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to the function f. The first version is the preferred syntax, however both are equivalent.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"\"...\"\nf(x) = x\n\n\"...\"\nfunction f(x)\n    return x\nend\n\n\"...\"\nf(x)","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to the method f(::Any).","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"\"...\"\nf(x, y = 1) = x + y","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to two Methods, namely f(::Any) and f(::Any, ::Any).","category":"page"},{"location":"manual/documentation.html#Macros","page":"Documentation","title":"Macros","text":"","category":"section"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"\"...\"\nmacro m(x) end","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to the @m(::Any) macro definition.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"\"...\"\n:(@m1)\n\n\"...\"\nmacro m2 end","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to the macros named @m1 and @m2.","category":"page"},{"location":"manual/documentation.html#Types","page":"Documentation","title":"Types","text":"","category":"section"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"\"...\"\nabstract type T1 end\n\n\"...\"\nmutable struct T2\n    ...\nend\n\n\"...\"\nstruct T3\n    ...\nend","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Adds the docstring \"...\" to types T1, T2, and T3.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"\"...\"\nT1\n\n\"...\"\nT2\n\n\"...\"\nT3","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Adds the docstring \"...\" to types T1, T2, and T3. The previous version is the preferred syntax, however both are equivalent.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"\"...\"\nstruct T\n    \"x\"\n    x\n    \"y\"\n    y\n\n    @doc \"Inner constructor\"\n    function T()\n        new(...)\n    end\nend","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to type T, \"x\" to field T.x, \"y\" to field T.y, and \"Inner constructor\" to the inner constructor T(). Also applicable to mutable struct types.","category":"page"},{"location":"manual/documentation.html#Modules","page":"Documentation","title":"Modules","text":"","category":"section"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"\"...\"\nmodule M end\n\nmodule M\n\n\"...\"\nM\n\nend","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to the Module M. Adding the docstring above the Module is the preferred syntax, however both are equivalent.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"\"...\"\nbaremodule M\n# ...\nend\n\nbaremodule M\n\nimport Base: @doc\n\n\"...\"\nf(x) = x\n\nend","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Documenting a baremodule by placing a docstring above the expression automatically imports @doc into the module. These imports must be done manually when the module expression is not documented.","category":"page"},{"location":"manual/documentation.html#Global-Variables","page":"Documentation","title":"Global Variables","text":"","category":"section"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"\"...\"\nconst a = 1\n\n\"...\"\nb = 2\n\n\"...\"\nglobal c = 3","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to the Bindings a, b, and c.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Bindings are used to store a reference to a particular Symbol in a Module without storing the referenced value itself.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"note: Note\nWhen a const definition is only used to define an alias of another definition, such as is the case with the function div and its alias ÷ in Base, do not document the alias and instead document the actual function.If the alias is documented and not the real definition then the docsystem (? mode) will not return the docstring attached to the alias when the real definition is searched for.For example you should write\"...\"\nf(x) = x + 1\nconst alias = frather thanf(x) = x + 1\n\"...\"\nconst alias = f","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"\"...\"\nsym","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to the value associated with sym. However, it is preferred that sym is documented where it is defined.","category":"page"},{"location":"manual/documentation.html#Multiple-Objects","page":"Documentation","title":"Multiple Objects","text":"","category":"section"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"\"...\"\na, b","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to a and b each of which should be a documentable expression. This syntax is equivalent to","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"\"...\"\na\n\n\"...\"\nb","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Any number of expressions many be documented together in this way. This syntax can be useful when two functions are related, such as non-mutating and mutating versions f and f!.","category":"page"},{"location":"manual/documentation.html#Macro-generated-code","page":"Documentation","title":"Macro-generated code","text":"","category":"section"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"\"...\"\n@m expression","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to the expression generated by expanding @m expression. This allows for expressions decorated with @inline, @noinline, @generated, or any other macro to be documented in the same way as undecorated expressions.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Macro authors should take note that only macros that generate a single expression will automatically support docstrings. If a macro returns a block containing multiple subexpressions then the subexpression that should be documented must be marked using the @__doc__ macro.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"The @enum macro makes use of @__doc__ to allow for documenting Enums. Examining its definition should serve as an example of how to use @__doc__ correctly.","category":"page"},{"location":"manual/documentation.html","page":"Documentation","title":"Documentation","text":"Core.@__doc__","category":"page"},{"location":"manual/documentation.html#Core.@__doc__","page":"Documentation","title":"Core.@__doc__","text":"@__doc__(ex)\n\nLow-level macro used to mark expressions returned by a macro that should be documented. If more than one expression is marked then the same docstring is applied to each expression.\n\nmacro example(f)\n    quote\n        $(f)() = 0\n        @__doc__ $(f)(x) = 1\n        $(f)(x, y) = 2\n    end |> esc\nend\n\n@__doc__ has no effect when a macro that uses it is not documented.\n\n\n\n\n\n","category":"macro"},{"location":"manual/noteworthy-differences.html#Noteworthy-Differences-from-other-Languages","page":"Noteworthy Differences from other Languages","title":"Noteworthy Differences from other Languages","text":"","category":"section"},{"location":"manual/noteworthy-differences.html#Noteworthy-differences-from-MATLAB","page":"Noteworthy Differences from other Languages","title":"Noteworthy differences from MATLAB","text":"","category":"section"},{"location":"manual/noteworthy-differences.html","page":"Noteworthy Differences from other Languages","title":"Noteworthy Differences from other Languages","text":"Although MATLAB users may find Julia's syntax familiar, Julia is not a MATLAB clone. There are major syntactic and functional differences. The following are some noteworthy differences that may trip up Julia users accustomed to MATLAB:","category":"page"},{"location":"manual/noteworthy-differences.html","page":"Noteworthy Differences from other Languages","title":"Noteworthy Differences from other Languages","text":"Julia arrays are indexed with square brackets, A[i,j].\nJulia arrays are not copied when assigned to another variable. After A = B, changing elements of B will modify A as well. To avoid this, use A = copy(B).\nJulia values are not copied when passed to a function. If a function modifies an array, the changes will be visible in the caller.\nJulia does not automatically grow arrays in an assignment statement. Whereas in MATLAB a(4) = 3.2 can create the array a = [0 0 0 3.2] and a(5) = 7 can grow it into a = [0 0 0 3.2 7], the corresponding Julia statement a[5] = 7 throws an error if the length of a is less than 5 or if this statement is the first use of the identifier a. Julia has push! and append!, which grow Vectors much more efficiently than MATLAB's a(end+1) = val.\nThe imaginary unit sqrt(-1) is represented in Julia as im, not i or j as in MATLAB.\nIn Julia, literal numbers without a decimal point (such as 42) create integers instead of floating point numbers. As a result, some operations can throw a domain error if they expect a float; for example, julia> a = -1; 2^a throws a domain error, as the result is not an integer (see the FAQ entry on domain errors for details).\nIn Julia, multiple values are returned and assigned as tuples, e.g. (a, b) = (1, 2) or a, b = 1, 2. MATLAB's nargout, which is often used in MATLAB to do optional work based on the number of returned values, does not exist in Julia. Instead, users can use optional and keyword arguments to achieve similar capabilities.\nJulia has true one-dimensional arrays. Column vectors are of size N, not Nx1. For example, rand(N) makes a 1-dimensional array.\nIn Julia, [x,y,z] will always construct a 3-element array containing x, y and z.\nTo concatenate in the first (\"vertical\") dimension use either vcat(x,y,z) or separate with semicolons ([x; y; z]).\nTo concatenate in the second (\"horizontal\") dimension use either hcat(x,y,z) or separate with spaces ([x y z]).\nTo construct block matrices (concatenating in the first two dimensions), use either hvcat or combine spaces and semicolons ([a b; c d]).\nIn Julia, a:b and a:b:c construct AbstractRange objects. To construct a full vector like in MATLAB, use collect(a:b). Generally, there is no need to call collect though. An AbstractRange object will act like a normal array in most cases but is more efficient because it lazily computes its values. This pattern of creating specialized objects instead of full arrays is used frequently, and is also seen in functions such as range, or with iterators such as enumerate, and zip. The special objects can mostly be used as if they were normal arrays.\nFunctions in Julia return values from their last expression or the return keyword instead of listing the names of variables to return in the function definition (see The return Keyword for details).\nA Julia script may contain any number of functions, and all definitions will be externally visible when the file is loaded. Function definitions can be loaded from files outside the current working directory.\nIn Julia, reductions such as sum, prod, and maximum are performed over every element of an array when called with a single argument, as in sum(A), even if A has more than one dimension.\nIn Julia, parentheses must be used to call a function with zero arguments, like in rand().\nJulia discourages the use of semicolons to end statements. The results of statements are not automatically printed (except at the interactive prompt), and lines of code do not need to end with semicolons. println or @printf can be used to print specific output.\nIn Julia, if A and B are arrays, logical comparison operations like A == B do not return an array of booleans. Instead, use A .== B, and similarly for the other boolean operators like <, >.\nIn Julia, the operators &, |, and ⊻ (xor) perform the bitwise operations equivalent to and, or, and xor respectively in MATLAB, and have precedence similar to Python's bitwise operators (unlike C). They can operate on scalars or element-wise across arrays and can be used to combine logical arrays, but note the difference in order of operations: parentheses may be required (e.g., to select elements of A equal to 1 or 2 use (A .== 1) .| (A .== 2)).\nIn Julia, the elements of a collection can be passed as arguments to a function using the splat operator ..., as in xs=[1,2]; f(xs...).\nJulia's svd returns singular values as a vector instead of as a dense diagonal matrix.\nIn Julia, ... is not used to continue lines of code. Instead, incomplete expressions automatically continue onto the next line.\nIn both Julia and MATLAB, the variable ans is set to the value of the last expression issued in an interactive session. In Julia, unlike MATLAB, ans is not set when Julia code is run in non-interactive mode.\nJulia's structs do not support dynamically adding fields at runtime, unlike MATLAB's classes. Instead, use a Dict. Dict in Julia isn't ordered.\nIn Julia each module has its own global scope/namespace, whereas in MATLAB there is just one global scope.\nIn MATLAB, an idiomatic way to remove unwanted values is to use logical indexing, like in the expression x(x>3) or in the statement x(x>3) = [] to modify x in-place. In contrast, Julia provides the higher order functions filter and filter!, allowing users to write filter(z->z>3, x) and filter!(z->z>3, x) as alternatives to the corresponding transliterations x[x.>3] and x = x[x.>3]. Using filter! reduces the use of temporary arrays.\nThe analogue of extracting (or \"dereferencing\") all elements of a cell array, e.g. in vertcat(A{:}) in MATLAB, is written using the splat operator in Julia, e.g. as vcat(A...).\nIn Julia, the adjoint function performs conjugate transposition; in MATLAB, adjoint provides the \"adjugate\" or classical adjoint, which is the transpose of the matrix of cofactors.\nIn Julia, a^b^c is evaluated a^(b^c) while in MATLAB it's (a^b)^c.","category":"page"},{"location":"manual/noteworthy-differences.html#Noteworthy-differences-from-R","page":"Noteworthy Differences from other Languages","title":"Noteworthy differences from R","text":"","category":"section"},{"location":"manual/noteworthy-differences.html","page":"Noteworthy Differences from other Languages","title":"Noteworthy Differences from other Languages","text":"One of Julia's goals is to provide an effective language for data analysis and statistical programming. For users coming to Julia from R, these are some noteworthy differences:","category":"page"},{"location":"manual/noteworthy-differences.html","page":"Noteworthy Differences from other Languages","title":"Noteworthy Differences from other Languages","text":"Julia's single quotes enclose characters, not strings.\nJulia can create substrings by indexing into strings. In R, strings must be converted into character vectors before creating substrings.\nIn Julia, like Python but unlike R, strings can be created with triple quotes \"\"\" ... \"\"\". This syntax is convenient for constructing strings that contain line breaks.\nIn Julia, varargs are specified using the splat operator ..., which always follows the name of a specific variable, unlike R, for which ... can occur in isolation.\nIn Julia, modulus is mod(a, b), not a %% b. % in Julia is the remainder operator.\nJulia constructs vectors using brackets. Julia's [1, 2, 3] is the equivalent of R's c(1, 2, 3).\nIn Julia, not all data structures support logical indexing. Furthermore, logical indexing in Julia is supported only with vectors of length equal to the object being indexed. For example:\nIn R, c(1, 2, 3, 4)[c(TRUE, FALSE)] is equivalent to c(1, 3).\nIn R, c(1, 2, 3, 4)[c(TRUE, FALSE, TRUE, FALSE)] is equivalent to c(1, 3).\nIn Julia, [1, 2, 3, 4][[true, false]] throws a BoundsError.\nIn Julia, [1, 2, 3, 4][[true, false, true, false]] produces [1, 3].\nLike many languages, Julia does not always allow operations on vectors of different lengths, unlike R where the vectors only need to share a common index range.  For example, c(1, 2, 3, 4) + c(1, 2) is valid R but the equivalent [1, 2, 3, 4] + [1, 2] will throw an error in Julia.\nJulia allows an optional trailing comma when that comma does not change the meaning of code. This can cause confusion among R users when indexing into arrays. For example, x[1,] in R would return the first row of a matrix; in Julia, however, the comma is ignored, so x[1,] == x[1], and will return the first element. To extract a row, be sure to use :, as in x[1,:].\nJulia's map takes the function first, then its arguments, unlike lapply(<structure>, function, ...) in R. Similarly Julia's equivalent of apply(X, MARGIN, FUN, ...) in R is mapslices where the function is the first argument.\nMultivariate apply in R, e.g. mapply(choose, 11:13, 1:3), can be written as broadcast(binomial, 11:13, 1:3) in Julia. Equivalently Julia offers a shorter dot syntax for vectorizing functions binomial.(11:13, 1:3).\nJulia uses end to denote the end of conditional blocks, like if, loop blocks, like while/ for, and functions. In lieu of the one-line if ( cond ) statement, Julia allows statements of the form if cond; statement; end, cond && statement and !cond || statement. Assignment statements in the latter two syntaxes must be explicitly wrapped in parentheses, e.g. cond && (x = value).\nIn Julia, <-, <<- and -> are not assignment operators.\nJulia's -> creates an anonymous function.\nJulia's * operator can perform matrix multiplication, unlike in R. If A and B are matrices, then A * B denotes a matrix multiplication in Julia, equivalent to R's A %*% B. In R, this same notation would perform an element-wise (Hadamard) product. To get the element-wise multiplication operation, you need to write A .* B in Julia.\nJulia performs matrix transposition using the transpose function and conjugated transposition using the ' operator or the adjoint function. Julia's transpose(A) is therefore equivalent to R's t(A). Additionally a non-recursive transpose in Julia is provided by the permutedims function.\nJulia does not require parentheses when writing if statements or for/while loops: use for i in [1, 2, 3] instead of for (i in c(1, 2, 3)) and if i == 1 instead of if (i == 1).\nJulia does not treat the numbers 0 and 1 as Booleans. You cannot write if (1) in Julia, because if statements accept only booleans. Instead, you can write if true, if Bool(1), or if 1==1.\nJulia does not provide nrow and ncol. Instead, use size(M, 1) for nrow(M) and size(M, 2) for ncol(M).\nJulia is careful to distinguish scalars, vectors and matrices.  In R, 1 and c(1) are the same. In Julia, they cannot be used interchangeably.\nJulia's diag and diagm are not like R's.\nJulia cannot assign to the results of function calls on the left hand side of an assignment operation: you cannot write diag(M) = fill(1, n).\nJulia discourages populating the main namespace with functions. Most statistical functionality for Julia is found in packages under the JuliaStats organization. For example:\nFunctions pertaining to probability distributions are provided by the Distributions package.\nThe DataFrames package provides data frames.\nGeneralized linear models are provided by the GLM package.\nJulia provides tuples and real hash tables, but not R-style lists. When returning multiple items, you should typically use a tuple or a named tuple: instead of list(a = 1, b = 2), use (1, 2) or (a=1, b=2).\nJulia encourages users to write their own types, which are easier to use than S3 or S4 objects in R. Julia's multiple dispatch system means that table(x::TypeA) and table(x::TypeB) act like R's table.TypeA(x) and table.TypeB(x).\nIn Julia, values are not copied when assigned or passed to a function. If a function modifies an array, the changes will be visible in the caller. This is very different from R and allows new functions to operate on large data structures much more efficiently.\nIn Julia, vectors and matrices are concatenated using hcat, vcat and hvcat, not c, rbind and cbind like in R.\nIn Julia, a range like a:b is not shorthand for a vector like in R, but is a specialized AbstractRange object that is used for iteration. To convert a range into a vector, use collect(a:b).\nThe : operator has a different precedence in R and Julia. In particular, in Julia arithmetic operators have higher precedence than the : operator, whereas the reverse is true in R. For example, 1:n-1 in Julia is equivalent to 1:(n-1) in R.\nJulia's max and min are the equivalent of pmax and pmin respectively in R, but both arguments need to have the same dimensions.  While maximum and minimum replace max and min in R, there are important differences.\nJulia's sum, prod, maximum, and minimum are different from their counterparts in R. They all accept an optional keyword argument dims, which indicates the dimensions, over which the operation is carried out.  For instance, let A = [1 2; 3 4] in Julia and B <- rbind(c(1,2),c(3,4)) be the same matrix in R.  Then sum(A) gives the same result as sum(B), but sum(A, dims=1) is a row vector containing the sum over each column and sum(A, dims=2) is a column vector containing the sum over each row. This contrasts to the behavior of R, where separate colSums(B) and rowSums(B) functions provide these functionalities. If the dims keyword argument is a vector, then it specifies all the dimensions over which the sum is performed, while retaining the dimensions of the summed array, e.g. sum(A, dims=(1,2)) == hcat(10). It should be noted that there is no error checking regarding the second argument.\nJulia has several functions that can mutate their arguments. For example, it has both sort and sort!.\nIn R, performance requires vectorization. In Julia, almost the opposite is true: the best performing code is often achieved by using devectorized loops.\nJulia is eagerly evaluated and does not support R-style lazy evaluation. For most users, this means that there are very few unquoted expressions or column names.\nJulia does not support the NULL type. The closest equivalent is nothing, but it behaves like a scalar value rather than like a list. Use x === nothing instead of is.null(x).\nIn Julia, missing values are represented by the missing object rather than by NA. Use ismissing(x) (or ismissing.(x) for element-wise operation on vectors) instead of is.na(x). The skipmissing function is generally used instead of na.rm=TRUE (though in some particular cases functions take a skipmissing argument).\nJulia lacks the equivalent of R's assign or get.\nIn Julia, return does not require parentheses.\nIn R, an idiomatic way to remove unwanted values is to use logical indexing, like in the expression x[x>3] or in the statement x = x[x>3] to modify x in-place. In contrast, Julia provides the higher order functions filter and filter!, allowing users to write filter(z->z>3, x) and filter!(z->z>3, x) as alternatives to the corresponding transliterations x[x.>3] and x = x[x.>3]. Using filter! reduces the use of temporary arrays.","category":"page"},{"location":"manual/noteworthy-differences.html#Noteworthy-differences-from-Python","page":"Noteworthy Differences from other Languages","title":"Noteworthy differences from Python","text":"","category":"section"},{"location":"manual/noteworthy-differences.html","page":"Noteworthy Differences from other Languages","title":"Noteworthy Differences from other Languages","text":"Julia's for, if, while, etc. blocks are terminated by the end keyword. Indentation level is not significant as it is in Python. Unlike Python, Julia has no pass keyword.\nStrings are denoted by double quotation marks (\"text\") in Julia (with three double quotation marks for multi-line strings), whereas in Python they can be denoted either by single ('text') or double quotation marks (\"text\"). Single quotation marks are used for characters in Julia ('c').\nString concatenation is done with * in Julia, not + like in Python. Analogously, string repetition is done with ^, not *. Implicit string concatenation of string literals like in Python (e.g. 'ab' 'cd' == 'abcd') is not done in Julia.\nPython Lists—flexible but slow—correspond to the Julia Vector{Any} type or more generally Vector{T} where T is some non-concrete element type. \"Fast\" arrays like NumPy arrays that store elements in-place (i.e., dtype is np.float64, [('f1', np.uint64), ('f2', np.int32)], etc.) can be represented by Array{T} where T is a concrete, immutable element type. This includes built-in types like Float64, Int32, Int64 but also more complex types like Tuple{UInt64,Float64} and many user-defined types as well.\nIn Julia, indexing of arrays, strings, etc. is 1-based not 0-based.\nJulia's slice indexing includes the last element, unlike in Python. a[2:3] in Julia is a[1:3] in Python.\nUnlike Python, Julia allows AbstractArrays with arbitrary indexes. Python's special interpretation of negative indexing, a[-1] and a[-2], should be written a[end] and a[end-1] in Julia.\nJulia requires end for indexing until the last element. x[1:] in Python is equivalent to x[2:end] in Julia.\nIn Julia, : before any object creates a Symbol or quotes an expression; so, x[:5] is same as x[5]. If you want to get the first n elements of an array, then use range indexing.\nJulia's range indexing has the format of x[start:step:stop], whereas Python's format is x[start:(stop+1):step]. Hence, x[0:10:2] in Python is equivalent to x[1:2:10] in Julia. Similarly, x[::-1] in Python, which refers to the reversed array, is equivalent to x[end:-1:1] in Julia.\nIn Julia, ranges can be constructed independently as start:step:stop, the same syntax it uses in array-indexing.  The range function is also supported.\nIn Julia, indexing a matrix with arrays like X[[1,2], [1,3]] refers to a sub-matrix that contains the intersections of the first and second rows with the first and third columns. In Python, X[[1,2], [1,3]] refers to a vector that contains the values of cell [1,1] and [2,3] in the matrix. X[[1,2], [1,3]] in Julia is equivalent with X[np.ix_([0,1],[0,2])] in Python. X[[0,1], [0,2]] in Python is equivalent with X[[CartesianIndex(1,1), CartesianIndex(2,3)]] in Julia.\nJulia has no line continuation syntax: if, at the end of a line, the input so far is a complete expression, it is considered done; otherwise the input continues. One way to force an expression to continue is to wrap it in parentheses.\nJulia arrays are column-major (Fortran-ordered) whereas NumPy arrays are row-major (C-ordered) by default. To get optimal performance when looping over arrays, the order of the loops should be reversed in Julia relative to NumPy (see relevant section of Performance Tips).\nJulia's updating operators (e.g. +=, -=, ...) are not in-place whereas NumPy's are. This means A = [1, 1]; B = A; B += [3, 3] doesn't change values in A, it rather rebinds the name B to the result of the right-hand side B = B + 3, which is a new array. For in-place operation, use B .+= 3 (see also dot operators), explicit loops, or InplaceOps.jl.\nJulia evaluates default values of function arguments every time the method is invoked, unlike in Python where the default values are evaluated only once when the function is defined. For example, the function f(x=rand()) = x returns a new random number every time it is invoked without argument. On the other hand, the function g(x=[1,2]) = push!(x,3) returns [1,2,3] every time it is called as g().\nIn Julia, keyword arguments must be passed using keywords, unlike Python in which it is usually possible to pass them positionally. Attempting to pass a keyword argument positionally alters the method signature leading to a MethodError or calling of the wrong method.\nIn Julia % is the remainder operator, whereas in Python it is the modulus.\nIn Julia, the commonly used Int type corresponds to the machine integer type (Int32 or Int64), unlike in Python, where int is an arbitrary length integer. This means in Julia the Int type will overflow, such that 2^64 == 0. If you need larger values use another appropriate type, such as Int128, BigInt or a floating point type like Float64.\nThe imaginary unit sqrt(-1) is represented in Julia as im, not j as in Python.\nIn Julia, the exponentiation operator is ^, not ** as in Python.\nJulia uses nothing of type Nothing to represent a null value, whereas Python uses None of type NoneType.\nIn Julia, the standard operators over a matrix type are matrix operations, whereas, in Python, the standard operators are element-wise operations. When both A and B are matrices, A * B in Julia performs matrix multiplication, not element-wise multiplication as in Python. A * B in Julia is equivalent with A @ B in Python, whereas A * B in Python is equivalent with A .* B in Julia.\nThe adjoint operator ' in Julia returns an adjoint of a vector (a lazy representation of row vector), whereas the transpose operator .T over a vector in Python returns the original vector (non-op).\nIn Julia, a function may contain multiple concrete implementations (called methods), which are selected via multiple dispatch based on the types of all arguments to the call, as compared to functions in Python, which have a single implementation and no polymorphism (as opposed to Python method calls which use a different syntax and allows dispatch on the receiver of the method).\nThere are no classes in Julia. Instead there are structures (mutable or immutable), containing data but no methods.\nCalling a method of a class instance in Python (x = MyClass(*args); x.f(y)) corresponds to a function call in Julia, e.g. x = MyType(args...); f(x, y). In general, multiple dispatch is more flexible and powerful than the Python class system.\nJulia structures may have exactly one abstract supertype, whereas Python classes can inherit from one or more (abstract or concrete) superclasses.\nThe logical Julia program structure (Packages and Modules) is independent of the file structure, whereas the Python code structure is defined by directories (Packages) and files (Modules).\nIn Julia, it is idiomatic to split the text of large modules into multiple files, without introducing a new module per file. The code is reassembled inside a single module in a main file via include. While the Python equivalent (exec) is not typical for this use (it will silently clobber prior definitions), Julia programs are defined as a unit at the module level with using or import, which will only get executed once when first needed–like include in Python. Within those modules, the individual files that make up that module are loaded with include by listing them once in the intended order.\nThe ternary operator x > 0 ? 1 : -1 in Julia corresponds to a conditional expression in Python 1 if x > 0 else -1.\nIn Julia the @ symbol refers to a macro, whereas in Python it refers to a decorator.\nException handling in Julia is done using try — catch — finally, instead of try — except — finally. In contrast to Python, it is not recommended to use exception handling as part of the normal workflow in Julia (compared with Python, Julia is faster at ordinary control flow but slower at exception-catching).\nIn Julia loops are fast, there is no need to write \"vectorized\" code for performance reasons.\nBe careful with non-constant global variables in Julia, especially in tight loops. Since you can write close-to-metal code in Julia (unlike Python), the effect of globals can be drastic (see Performance Tips).\nIn Julia, rounding and truncation are explicit. Python's int(3.7) should be floor(Int, 3.7) or Int(floor(3.7)) and is distinguished from round(Int, 3.7). floor(x) and round(x) on their own return an integer value of the same type as x rather than always returning Int.\nIn Julia, parsing is explicit. Python's float(\"3.7\") would be parse(Float64, \"3.7\") in Julia.\nIn Python, the majority of values can be used in logical contexts (e.g. if \"a\": means the following block is executed, and if \"\": means it is not). In Julia, you need explicit conversion to Bool (e.g. if \"a\" throws an exception). If you want to test for a non-empty string in Julia, you would explicitly write if !isempty(\"\").  Perhaps surprisingly, in Python if \"False\" and bool(\"False\") both evaluate to True (because \"False\" is a non-empty string); in Julia, parse(Bool, \"false\") returns false.\nIn Julia, a new local scope is introduced by most code blocks, including loops and try — catch — finally. Note that comprehensions (list, generator, etc.) introduce a new local scope both in Python and Julia, whereas if blocks do not introduce a new local scope in both languages.","category":"page"},{"location":"manual/noteworthy-differences.html#Noteworthy-differences-from-C/C","page":"Noteworthy Differences from other Languages","title":"Noteworthy differences from C/C++","text":"","category":"section"},{"location":"manual/noteworthy-differences.html","page":"Noteworthy Differences from other Languages","title":"Noteworthy Differences from other Languages","text":"Julia arrays are indexed with square brackets, and can have more than one dimension A[i,j]. This syntax is not just syntactic sugar for a reference to a pointer or address as in C/C++. See the manual entry about array construction.\nIn Julia, indexing of arrays, strings, etc. is 1-based not 0-based.\nJulia arrays are not copied when assigned to another variable. After A = B, changing elements of B will modify A as well. Updating operators like += do not operate in-place, they are equivalent to A = A + B which rebinds the left-hand side to the result of the right-hand side expression.\nJulia arrays are column major (Fortran ordered) whereas C/C++ arrays are row major ordered by default. To get optimal performance when looping over arrays, the order of the loops should be reversed in Julia relative to C/C++ (see relevant section of Performance Tips).\nJulia values are not copied when assigned or passed to a function. If a function modifies an array, the changes will be visible in the caller.\nIn Julia, whitespace is significant, unlike C/C++, so care must be taken when adding/removing whitespace from a Julia program.\nIn Julia, literal numbers without a decimal point (such as 42) create signed integers, of type Int, but literals too large to fit in the machine word size will automatically be promoted to a larger size type, such as Int64 (if Int is Int32), Int128, or the arbitrarily large BigInt type. There are no numeric literal suffixes, such as L, LL, U, UL, ULL to indicate unsigned and/or signed vs. unsigned. Decimal literals are always signed, and hexadecimal literals (which start with 0x like C/C++), are unsigned, unless when they encode more than 128 bits, in which case they are of type BigInt. Hexadecimal literals also, unlike C/C++/Java and unlike decimal literals in Julia, have a type based on the length of the literal, including leading 0s. For example, 0x0 and 0x00 have type UInt8, 0x000 and 0x0000 have type UInt16, then literals with 5 to 8 hex digits have type UInt32, 9 to 16 hex digits type UInt64, 17 to 32 hex digits type UInt128, and more that 32 hex digits type BigInt. This needs to be taken into account when defining hexadecimal masks, for example ~0xf == 0xf0 is very different from ~0x000f == 0xfff0. 64 bit Float64 and 32 bit Float32 bit literals are expressed as 1.0 and 1.0f0 respectively. Floating point literals are rounded (and not promoted to the BigFloat type) if they can not be exactly represented.  Floating point literals are closer in behavior to C/C++. Octal (prefixed with 0o) and binary (prefixed with 0b) literals are also treated as unsigned (or BigInt for more than 128 bits).\nIn Julia, the division operator / returns a floating point number when both operands are of integer type.  To perform integer division, use div or ÷.\nIndexing an Array with floating point types is generally an error in Julia. The Julia equivalent of the C expression a[i / 2] is a[i ÷ 2 + 1], where i is of integer type.\nString literals can be delimited with either \"  or \"\"\", \"\"\" delimited literals can contain \" characters without quoting it like \"\\\"\". String literals can have values of other variables or expressions interpolated into them, indicated by $variablename or $(expression), which evaluates the variable name or the expression in the context of the function.\n// indicates a Rational number, and not a single-line comment (which is # in Julia)\n#= indicates the start of a multiline comment, and =# ends it.\nFunctions in Julia return values from their last expression(s) or the return keyword.  Multiple values can be returned from functions and assigned as tuples, e.g. (a, b) = myfunction() or a, b = myfunction(), instead of having to pass pointers to values as one would have to do in C/C++ (i.e. a = myfunction(&b).\nJulia does not require the use of semicolons to end statements. The results of expressions are not automatically printed (except at the interactive prompt, i.e. the REPL), and lines of code do not need to end with semicolons. println or @printf can be used to print specific output. In the REPL, ; can be used to suppress output. ; also has a different meaning within [ ], something to watch out for. ; can be used to separate expressions on a single line, but are not strictly necessary in many cases, and are more an aid to readability.\nIn Julia, the operator ⊻ (xor) performs the bitwise XOR operation, i.e. ^ in C/C++.  Also, the bitwise operators do not have the same precedence as C/C++, so parenthesis may be required.\nJulia's ^ is exponentiation (pow), not bitwise XOR as in C/C++ (use ⊻, or xor, in Julia)\nJulia has two right-shift operators, >> and >>>.  >> performs an arithmetic shift, >>> always performs a logical shift, unlike C/C++, where the meaning of >> depends on the type of the value being shifted.\nJulia's -> creates an anonymous function, it does not access a member via a pointer.\nJulia does not require parentheses when writing if statements or for/while loops: use for i in [1, 2, 3] instead of for (int i=1; i <= 3; i++) and if i == 1 instead of if (i == 1).\nJulia does not treat the numbers 0 and 1 as Booleans. You cannot write if (1) in Julia, because if statements accept only booleans. Instead, you can write if true, if Bool(1), or if 1==1.\nJulia uses end to denote the end of conditional blocks, like if, loop blocks, like while/ for, and functions. In lieu of the one-line if ( cond ) statement, Julia allows statements of the form if cond; statement; end, cond && statement and !cond || statement. Assignment statements in the latter two syntaxes must be explicitly wrapped in parentheses, e.g. cond && (x = value), because of the operator precedence.\nJulia has no line continuation syntax: if, at the end of a line, the input so far is a complete expression, it is considered done; otherwise the input continues. One way to force an expression to continue is to wrap it in parentheses.\nJulia macros operate on parsed expressions, rather than the text of the program, which allows them to perform sophisticated transformations of Julia code. Macro names start with the @ character, and have both a function-like syntax, @mymacro(arg1, arg2, arg3), and a statement-like syntax, @mymacro arg1 arg2 arg3. The forms are interchangeable; the function-like form is particularly useful if the macro appears within another expression, and is often clearest. The statement-like form is often used to annotate blocks, as in the distributed for construct: @distributed for i in 1:n; #= body =#; end. Where the end of the macro construct may be unclear, use the function-like form.\nJulia has an enumeration type, expressed using the macro @enum(name, value1, value2, ...) For example: @enum(Fruit, banana=1, apple, pear)\nBy convention, functions that modify their arguments have a ! at the end of the name, for example push!.\nIn C++, by default, you have static dispatch, i.e. you need to annotate a function as virtual, in order to have dynamic dispatch. On the other hand, in Julia every method is \"virtual\" (although it's more general than that since methods are dispatched on every argument type, not only this, using the most-specific-declaration rule).","category":"page"},{"location":"manual/noteworthy-differences.html#Julia-C/C:-Namespaces","page":"Noteworthy Differences from other Languages","title":"Julia ⇔ C/C++: Namespaces","text":"","category":"section"},{"location":"manual/noteworthy-differences.html","page":"Noteworthy Differences from other Languages","title":"Noteworthy Differences from other Languages","text":"C/C++ namespaces correspond roughly to Julia modules.\nThere are no private globals or fields in Julia.  Everything is publicly accessible through fully qualified paths (or relative paths, if desired).\nusing MyNamespace::myfun (C++) corresponds roughly to import MyModule: myfun (Julia).\nusing namespace MyNamespace (C++) corresponds roughly to using MyModule (Julia)\nIn Julia, only exported symbols are made available to the calling module.\nIn C++, only elements found in the included (public) header files are made available.\nCaveat: import/using keywords (Julia) also load modules (see below).\nCaveat: import/using (Julia) works only at the global scope level (modules)\nIn C++, using namespace X works within arbitrary scopes (ex: function scope).","category":"page"},{"location":"manual/noteworthy-differences.html#Julia-C/C:-Module-loading","page":"Noteworthy Differences from other Languages","title":"Julia ⇔ C/C++: Module loading","text":"","category":"section"},{"location":"manual/noteworthy-differences.html","page":"Noteworthy Differences from other Languages","title":"Noteworthy Differences from other Languages","text":"When you think of a C/C++ \"library\", you are likely looking for a Julia \"package\".\nCaveat: C/C++ libraries often house multiple \"software modules\" whereas Julia \"packages\" typically house one.\nReminder: Julia modules are global scopes (not necessarily \"software modules\").\nInstead of build/make scripts, Julia uses \"Project Environments\" (sometimes called either \"Project\" or \"Environment\").\nBuild scripts are only needed for more complex applications (like those needing to compile or download C/C++ executables).\nTo develop application or project in Julia, you can initialize its root directory as a \"Project Environment\", and house application-specific code/packages there. This provides good control over project dependencies, and future reproducibility.\nAvailable packages are added to a \"Project Environment\" with the Pkg.add() function or Pkg REPL mode. (This does not load said package, however).\nThe list of available packages (direct dependencies) for a \"Project Environment\" are saved in its Project.toml file.\nThe full dependency information for a \"Project Environment\" is auto-generated & saved in its Manifest.toml file by Pkg.resolve().\nPackages (\"software modules\") available to the \"Project Environment\" are loaded with import or using.\nIn C/C++, you #include <moduleheader> to get object/function declarations, and link in libraries when you build the executable.\nIn Julia, calling using/import again just brings the existing module into scope, but does not load it again (similar to adding the non-standard #pragma once to C/C++).\nDirectory-based package repositories (Julia) can be made available by adding repository paths to the Base.LOAD_PATH array.\nPackages from directory-based repositories do not require the Pkg.add() tool prior to being loaded with import or using. They are simply available to the project.\nDirectory-based package repositories are the quickest solution to developing local libraries of \"software modules\".","category":"page"},{"location":"manual/noteworthy-differences.html#Julia-C/C:-Assembling-modules","page":"Noteworthy Differences from other Languages","title":"Julia ⇔ C/C++: Assembling modules","text":"","category":"section"},{"location":"manual/noteworthy-differences.html","page":"Noteworthy Differences from other Languages","title":"Noteworthy Differences from other Languages","text":"In C/C++, .c/.cpp files are compiled & added to a library with build/make scripts.\nIn Julia, import [PkgName]/using [PkgName] statements load [PkgName].jl located in a package's [PkgName]/src/ subdirectory.\nIn turn, [PkgName].jl typically loads associated source files with calls to include \"[someotherfile].jl\".\ninclude \"./path/to/somefile.jl\" (Julia) is very similar to #include \"./path/to/somefile.jl\" (C/C++).\nHowever include \"...\" (Julia) is not used to include header files (not required).\nDo not use include \"...\" (Julia) to load code from other \"software modules\" (use import/using instead).\ninclude \"path/to/some/module.jl\" (Julia) would instantiate multiple versions of the same code in different modules (creating distinct types (etc.) with the same names).\ninclude \"somefile.jl\" is typically used to assemble multiple files within the same Julia package (\"software module\"). It is therefore relatively straightforward to ensure file are included only once (No #ifdef confusion).","category":"page"},{"location":"manual/noteworthy-differences.html#Julia-C/C:-Module-interface","page":"Noteworthy Differences from other Languages","title":"Julia ⇔ C/C++: Module interface","text":"","category":"section"},{"location":"manual/noteworthy-differences.html","page":"Noteworthy Differences from other Languages","title":"Noteworthy Differences from other Languages","text":"C++ exposes interfaces using \"public\" .h/.hpp files whereas Julia modules mark specific symbols that are intended for their users as publicor exported.\nOften, Julia modules simply add functionality by generating new \"methods\" to existing functions (ex: Base.push!).\nDevelopers of Julia packages therefore cannot rely on header files for interface documentation.\nInterfaces for Julia packages are typically described using docstrings, README.md, static web pages, ...\nSome developers choose not to export all symbols required to use their package/module, but should still mark unexported user facing symbols as public.\nUsers might be expected to access these components by qualifying functions/structs/... with the package/module name (ex: MyModule.run_this_task(...)).","category":"page"},{"location":"manual/noteworthy-differences.html#Julia-C/C:-Quick-reference","page":"Noteworthy Differences from other Languages","title":"Julia ⇔ C/C++: Quick reference","text":"","category":"section"},{"location":"manual/noteworthy-differences.html","page":"Noteworthy Differences from other Languages","title":"Noteworthy Differences from other Languages","text":"Software Concept Julia C/C++\nunnamed scope begin ... end { ... }\nfunction scope function x() ... end int x() { ... }\nglobal scope module MyMod ... end namespace MyNS { ... }\nsoftware module A Julia \"package\" .h/.hpp files<br>+compiled somelib.a\nassembling<br>software modules SomePkg.jl: ...<br>import(\"subfile1.jl\")<br>import(\"subfile2.jl\")<br>... $(AR) *.o &rArr; somelib.a\nimport<br>software module import SomePkg #include <somelib><br>+link in somelib.a\nmodule library LOAD_PATH[], *Git repository,<br>**custom package registry more .h/.hpp files<br>+bigger compiled somebiglib.a","category":"page"},{"location":"manual/noteworthy-differences.html","page":"Noteworthy Differences from other Languages","title":"Noteworthy Differences from other Languages","text":"* The Julia package manager supports registering multiple packages from a single Git repository.<br> * This allows users to house a library of related packages in a single repository.<br> ** Julia registries are primarily designed to provide versioning \\& distribution of packages.<br> ** Custom package registries can be used to create a type of module library.","category":"page"},{"location":"manual/noteworthy-differences.html#Noteworthy-differences-from-Common-Lisp","page":"Noteworthy Differences from other Languages","title":"Noteworthy differences from Common Lisp","text":"","category":"section"},{"location":"manual/noteworthy-differences.html","page":"Noteworthy Differences from other Languages","title":"Noteworthy Differences from other Languages","text":"Julia uses 1-based indexing for arrays by default, and it can also handle arbitrary index offsets.\nFunctions and variables share the same namespace (“Lisp-1”).\nThere is a Pair type, but it is not meant to be used as a COMMON-LISP:CONS. Various iterable collections can be used interchangeably in most parts of the language (eg splatting, tuples, etc). Tuples are the closest to Common Lisp lists for short collections of heterogeneous elements. Use NamedTuples in place of alists. For larger collections of homogeneous types, Arrays and Dicts should be used.\nThe typical Julia workflow for prototyping also uses continuous manipulation of the image, implemented with the Revise.jl package.\nFor performance, Julia prefers that operations have type stability. Where Common Lisp abstracts away from the underlying machine operations, Julia cleaves closer to them. For example:\nInteger division using / always returns a floating-point result, even if the computation is exact.\n// always returns a rational result\n÷ always returns a (truncated) integer result\nBignums are supported, but conversion is not automatic; ordinary integers overflow.\nComplex numbers are supported, but to get complex results, you need complex inputs.\nThere are multiple Complex and Rational types, with different component types.\nModules (namespaces) can be hierarchical. import and using have a dual role: they load the code and make it available in the namespace. import for only the module name is possible (roughly equivalent to ASDF:LOAD-OP). Slot names don't need to be exported separately. Global variables can't be assigned to from outside the module (except with eval(mod, :(var = val)) as an escape hatch).\nMacros start with @, and are not as seamlessly integrated into the language as Common Lisp; consequently, macro usage is not as widespread as in the latter. A form of hygiene for macros is supported by the language. Because of the different surface syntax, there is no equivalent to COMMON-LISP:&BODY.\nAll functions are generic and use multiple dispatch. Argument lists don't have to follow the same template, which leads to a powerful idiom (see do). Optional and keyword arguments are handled differently. Method ambiguities are not resolved like in the Common Lisp Object System, necessitating the definition of a more specific method for the intersection.\nSymbols do not belong to any package, and do not contain any values per se. M.var evaluates the symbol var in the module M.\nA functional programming style is fully supported by the language, including closures, but isn't always the idiomatic solution for Julia. Some workarounds may be necessary for performance when modifying captured variables.","category":"page"},{"location":"stdlib/LibGit2.html","page":"LibGit2","title":"LibGit2","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/stdlib/LibGit2/docs/src/index.md\"","category":"page"},{"location":"stdlib/LibGit2.html#LibGit2","page":"LibGit2","title":"LibGit2","text":"","category":"section"},{"location":"stdlib/LibGit2.html","page":"LibGit2","title":"LibGit2","text":"The LibGit2 module provides bindings to libgit2, a portable C library that implements core functionality for the Git version control system. These bindings are currently used to power Julia's package manager. It is expected that this module will eventually be moved into a separate package.","category":"page"},{"location":"stdlib/LibGit2.html#Functionality","page":"LibGit2","title":"Functionality","text":"","category":"section"},{"location":"stdlib/LibGit2.html","page":"LibGit2","title":"LibGit2","text":"Some of this documentation assumes some prior knowledge of the libgit2 API. For more information on some of the objects and methods referenced here, consult the upstream libgit2 API reference.","category":"page"},{"location":"stdlib/LibGit2.html","page":"LibGit2","title":"LibGit2","text":"LibGit2.Buffer\nLibGit2.CheckoutOptions\nLibGit2.CloneOptions\nLibGit2.DescribeOptions\nLibGit2.DescribeFormatOptions\nLibGit2.DiffDelta\nLibGit2.DiffFile\nLibGit2.DiffOptionsStruct\nLibGit2.FetchHead\nLibGit2.FetchOptions\nLibGit2.GitAnnotated\nLibGit2.GitBlame\nLibGit2.GitBlob\nLibGit2.GitCommit\nLibGit2.GitConfig\nLibGit2.GitHash\nLibGit2.GitObject\nLibGit2.GitRemote\nLibGit2.GitRemoteAnon\nLibGit2.GitRepo\nLibGit2.GitRepoExt\nLibGit2.GitRevWalker\nLibGit2.GitShortHash\nLibGit2.GitSignature\nLibGit2.GitStatus\nLibGit2.GitTag\nLibGit2.GitTree\nLibGit2.IndexEntry\nLibGit2.IndexTime\nLibGit2.BlameOptions\nLibGit2.MergeOptions\nLibGit2.ProxyOptions\nLibGit2.PushOptions\nLibGit2.RebaseOperation\nLibGit2.RebaseOptions\nLibGit2.RemoteCallbacks\nLibGit2.SignatureStruct\nLibGit2.StatusEntry\nLibGit2.StatusOptions\nLibGit2.StrArrayStruct\nLibGit2.TimeStruct\nLibGit2.addfile\nLibGit2.add!\nLibGit2.add_fetch!\nLibGit2.add_push!\nLibGit2.addblob!\nLibGit2.author\nLibGit2.authors\nLibGit2.branch\nLibGit2.branch!\nLibGit2.checkout!\nLibGit2.clone\nLibGit2.commit\nLibGit2.committer\nLibGit2.count\nLibGit2.counthunks\nLibGit2.create_branch\nLibGit2.credentials_callback\nLibGit2.credentials_cb\nLibGit2.default_signature\nLibGit2.delete_branch\nLibGit2.diff_files\nLibGit2.entryid\nLibGit2.entrytype\nLibGit2.fetch\nLibGit2.fetchheads\nLibGit2.fetch_refspecs\nLibGit2.fetchhead_foreach_cb\nLibGit2.merge_base\nLibGit2.merge!(::LibGit2.GitRepo; ::Any...)\nLibGit2.merge!(::LibGit2.GitRepo, ::Vector{LibGit2.GitAnnotated}; ::LibGit2.MergeOptions, ::LibGit2.CheckoutOptions)\nLibGit2.merge!(::LibGit2.GitRepo, ::Vector{LibGit2.GitAnnotated}, ::Bool; ::LibGit2.MergeOptions, ::LibGit2.CheckoutOptions)\nLibGit2.ffmerge!\nLibGit2.fullname\nLibGit2.features\nLibGit2.filename\nLibGit2.filemode\nLibGit2.gitdir\nLibGit2.git_url\nLibGit2.@githash_str\nLibGit2.head\nLibGit2.head!\nLibGit2.head_oid\nLibGit2.headname\nLibGit2.init\nLibGit2.is_ancestor_of\nLibGit2.isbinary\nLibGit2.iscommit\nLibGit2.isdiff\nLibGit2.isdirty\nLibGit2.isorphan\nLibGit2.isset\nLibGit2.iszero\nLibGit2.lookup_branch\nLibGit2.map\nLibGit2.mirror_callback\nLibGit2.mirror_cb\nLibGit2.message\nLibGit2.merge_analysis\nLibGit2.name\nLibGit2.need_update\nLibGit2.objtype\nLibGit2.path\nLibGit2.peel\nLibGit2.posixpath\nLibGit2.push\nLibGit2.push!(::LibGit2.GitRevWalker, ::LibGit2.GitHash)\nLibGit2.push_head!\nLibGit2.push_refspecs\nLibGit2.raw\nLibGit2.read_tree!\nLibGit2.rebase!\nLibGit2.ref_list\nLibGit2.reftype\nLibGit2.remotes\nLibGit2.remove!\nLibGit2.reset\nLibGit2.reset!\nLibGit2.restore\nLibGit2.revcount\nLibGit2.set_remote_url\nLibGit2.shortname\nLibGit2.snapshot\nLibGit2.split_cfg_entry\nLibGit2.status\nLibGit2.stage\nLibGit2.tag_create\nLibGit2.tag_delete\nLibGit2.tag_list\nLibGit2.target\nLibGit2.toggle\nLibGit2.transact\nLibGit2.treewalk\nLibGit2.upstream\nLibGit2.update!\nLibGit2.url\nLibGit2.version\nLibGit2.with\nLibGit2.with_warn\nLibGit2.workdir\nLibGit2.GitObject(::LibGit2.GitTreeEntry)\nLibGit2.UserPasswordCredential\nLibGit2.SSHCredential\nLibGit2.isfilled\nLibGit2.CachedCredentials\nLibGit2.CredentialPayload\nLibGit2.approve\nLibGit2.reject\nLibGit2.Consts.GIT_CONFIG","category":"page"},{"location":"stdlib/LibGit2.html#LibGit2.Buffer","page":"LibGit2","title":"LibGit2.Buffer","text":"LibGit2.Buffer\n\nA data buffer for exporting data from libgit2. Matches the git_buf struct.\n\nWhen fetching data from LibGit2, a typical usage would look like:\n\nbuf_ref = Ref(Buffer())\n@check ccall(..., (Ptr{Buffer},), buf_ref)\n# operation on buf_ref\nfree(buf_ref)\n\nIn particular, note that LibGit2.free should be called afterward on the Ref object.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.CheckoutOptions","page":"LibGit2","title":"LibGit2.CheckoutOptions","text":"LibGit2.CheckoutOptions\n\nMatches the git_checkout_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\ncheckout_strategy: determine how to handle conflicts and whether to force the  checkout/recreate missing files.\ndisable_filters: if nonzero, do not apply filters like CLRF (to convert file newlines between UNIX and DOS).\ndir_mode: read/write/access mode for any directories involved in the checkout. Default is 0755.\nfile_mode: read/write/access mode for any files involved in the checkout.  Default is 0755 or 0644, depending on the blob.\nfile_open_flags: bitflags used to open any files during the checkout.\nnotify_flags: Flags for what sort of conflicts the user should be notified about.\nnotify_cb: An optional callback function to notify the user if a checkout conflict occurs.  If this function returns a non-zero value, the checkout will be cancelled.\nnotify_payload: Payload for the notify callback function.\nprogress_cb: An optional callback function to display checkout progress.\nprogress_payload: Payload for the progress callback.\npaths: If not empty, describes which paths to search during the checkout.  If empty, the checkout will occur over all files in the repository.\nbaseline: Expected content of the workdir, captured in a (pointer to a)  GitTree. Defaults to the state of the tree at HEAD.\nbaseline_index: Expected content of the workdir, captured in a (pointer to a)  GitIndex. Defaults to the state of the index at HEAD.\ntarget_directory: If not empty, checkout to this directory instead of the workdir.\nancestor_label: In case of conflicts, the name of the common ancestor side.\nour_label: In case of conflicts, the name of \"our\" side.\ntheir_label: In case of conflicts, the name of \"their\" side.\nperfdata_cb: An optional callback function to display performance data.\nperfdata_payload: Payload for the performance callback.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.CloneOptions","page":"LibGit2","title":"LibGit2.CloneOptions","text":"LibGit2.CloneOptions\n\nMatches the git_clone_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\ncheckout_opts: The options for performing the checkout of the remote as part of the clone.\nfetch_opts: The options for performing the pre-checkout fetch of the remote as part of the clone.\nbare: If 0, clone the full remote repository. If non-zero, perform a bare clone, in which  there is no local copy of the source files in the repository and the gitdir and workdir  are the same.\nlocalclone: Flag whether to clone a local object database or do a fetch. The default is to let git decide.  It will not use the git-aware transport for a local clone, but will use it for URLs which begin with file://.\ncheckout_branch: The name of the branch to checkout. If an empty string, the default branch of the  remote will be checked out.\nrepository_cb: An optional callback which will be used to create the new repository into which  the clone is made.\nrepository_cb_payload: The payload for the repository callback.\nremote_cb: An optional callback used to create the GitRemote before making the clone from it.\nremote_cb_payload: The payload for the remote callback.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.DescribeOptions","page":"LibGit2","title":"LibGit2.DescribeOptions","text":"LibGit2.DescribeOptions\n\nMatches the git_describe_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nmax_candidates_tags: consider this many most recent tags in refs/tags to describe a commit.  Defaults to 10 (so that the 10 most recent tags would be examined to see if they describe a commit).\ndescribe_strategy: whether to consider all entries in refs/tags (equivalent to git-describe --tags)  or all entries in refs/ (equivalent to git-describe --all). The default is to only show annotated tags.  If Consts.DESCRIBE_TAGS is passed, all tags, annotated or not, will be considered.  If Consts.DESCRIBE_ALL is passed, any ref in refs/ will be considered.\npattern: only consider tags which match pattern. Supports glob expansion.\nonly_follow_first_parent: when finding the distance from a matching reference to the described  object, only consider the distance from the first parent.\nshow_commit_oid_as_fallback: if no matching reference can be found which describes a commit, show the  commit's GitHash instead of throwing an error (the default behavior).\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.DescribeFormatOptions","page":"LibGit2","title":"LibGit2.DescribeFormatOptions","text":"LibGit2.DescribeFormatOptions\n\nMatches the git_describe_format_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nabbreviated_size: lower bound on the size of the abbreviated GitHash to use, defaulting to 7.\nalways_use_long_format: set to 1 to use the long format for strings even if a short format can be used.\ndirty_suffix: if set, this will be appended to the end of the description string if the workdir is dirty.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.DiffDelta","page":"LibGit2","title":"LibGit2.DiffDelta","text":"LibGit2.DiffDelta\n\nDescription of changes to one entry. Matches the git_diff_delta struct.\n\nThe fields represent:\n\nstatus: One of Consts.DELTA_STATUS, indicating whether the file has been added/modified/deleted.\nflags: Flags for the delta and the objects on each side. Determines whether to treat the file(s)  as binary/text, whether they exist on each side of the diff, and whether the object ids are known  to be correct.\nsimilarity: Used to indicate if a file has been renamed or copied.\nnfiles: The number of files in the delta (for instance, if the delta  was run on a submodule commit id, it may contain more than one file).\nold_file: A DiffFile containing information about the file(s) before the changes.\nnew_file: A DiffFile containing information about the file(s) after the changes.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.DiffFile","page":"LibGit2","title":"LibGit2.DiffFile","text":"LibGit2.DiffFile\n\nDescription of one side of a delta. Matches the git_diff_file struct.\n\nThe fields represent:\n\nid: the GitHash of the item in the diff. If the item is empty on this  side of the diff (for instance, if the diff is of the removal of a file), this will  be GitHash(0).\npath: a NULL terminated path to the item relative to the working directory of the repository.\nsize: the size of the item in bytes.\nflags: a combination of the git_diff_flag_t  flags. The ith bit of this integer sets the ith flag.\nmode: the stat mode for the item.\nid_abbrev: only present in LibGit2 versions newer than or equal to 0.25.0.  The length of the id field when converted using string. Usually equal to OID_HEXSZ (40).\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.DiffOptionsStruct","page":"LibGit2","title":"LibGit2.DiffOptionsStruct","text":"LibGit2.DiffOptionsStruct\n\nMatches the git_diff_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nflags: flags controlling which files will appear in the diff. Defaults to DIFF_NORMAL.\nignore_submodules: whether to look at files in submodules or not. Defaults to SUBMODULE_IGNORE_UNSPECIFIED, which means the submodule's configuration will control  whether it appears in the diff or not.\npathspec: path to files to include in the diff. Default is to use all files in the repository.\nnotify_cb: optional callback which will notify the user of changes to the diff as file deltas are  added to it.\nprogress_cb: optional callback which will display diff progress. Only relevant on libgit2 versions  at least as new as 0.24.0.\npayload: the payload to pass to notify_cb and progress_cb.\ncontext_lines: the number of unchanged lines used to define the edges of a hunk.  This is also the number of lines which will be shown before/after a hunk to provide  context. Default is 3.\ninterhunk_lines: the maximum number of unchanged lines between two separate  hunks allowed before the hunks will be combined. Default is 0.\nid_abbrev: sets the length of the abbreviated GitHash to print.  Default is 7.\nmax_size: the maximum file size of a blob. Above this size, it will be treated  as a binary blob. The default is 512 MB.\nold_prefix: the virtual file directory in which to place old files on one side  of the diff. Default is \"a\".\nnew_prefix: the virtual file directory in which to place new files on one side  of the diff. Default is \"b\".\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.FetchHead","page":"LibGit2","title":"LibGit2.FetchHead","text":"LibGit2.FetchHead\n\nContains the information about HEAD during a fetch, including the name and URL of the branch fetched from, the oid of the HEAD, and whether the fetched HEAD has been merged locally.\n\nThe fields represent:\n\nname: The name in the local reference database of the fetch head, for example,  \"refs/heads/master\".\nurl: The URL of the fetch head.\noid: The GitHash of the tip of the fetch head.\nismerge: Boolean flag indicating whether the changes at the  remote have been merged into the local copy yet or not. If true, the local  copy is up to date with the remote fetch head.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.FetchOptions","page":"LibGit2","title":"LibGit2.FetchOptions","text":"LibGit2.FetchOptions\n\nMatches the git_fetch_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\ncallbacks: remote callbacks to use during the fetch.\nprune: whether to perform a prune after the fetch or not. The default is to  use the setting from the GitConfig.\nupdate_fetchhead: whether to update the FetchHead after the fetch.  The default is to perform the update, which is the normal git behavior.\ndownload_tags: whether to download tags present at the remote or not. The default  is to request the tags for objects which are being downloaded anyway from the server.\nproxy_opts: options for connecting to the remote through a proxy. See ProxyOptions.  Only present on libgit2 versions newer than or equal to 0.25.0.\ncustom_headers: any extra headers needed for the fetch. Only present on libgit2 versions  newer than or equal to 0.24.0.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.GitAnnotated","page":"LibGit2","title":"LibGit2.GitAnnotated","text":"GitAnnotated(repo::GitRepo, commit_id::GitHash)\nGitAnnotated(repo::GitRepo, ref::GitReference)\nGitAnnotated(repo::GitRepo, fh::FetchHead)\nGitAnnotated(repo::GitRepo, committish::AbstractString)\n\nAn annotated git commit carries with it information about how it was looked up and why, so that rebase or merge operations have more information about the context of the commit. Conflict files contain information about the source/target branches in the merge which are conflicting, for instance. An annotated commit can refer to the tip of a remote branch, for instance when a FetchHead is passed, or to a branch head described using GitReference.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.GitBlame","page":"LibGit2","title":"LibGit2.GitBlame","text":"GitBlame(repo::GitRepo, path::AbstractString; options::BlameOptions=BlameOptions())\n\nConstruct a GitBlame object for the file at path, using change information gleaned from the history of repo. The GitBlame object records who changed which chunks of the file when, and how. options controls how to separate the contents of the file and which commits to probe - see BlameOptions for more information.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.GitBlob","page":"LibGit2","title":"LibGit2.GitBlob","text":"GitBlob(repo::GitRepo, hash::AbstractGitHash)\nGitBlob(repo::GitRepo, spec::AbstractString)\n\nReturn a GitBlob object from repo specified by hash/spec.\n\nhash is a full (GitHash) or partial (GitShortHash) hash.\nspec is a textual specification: see the git docs for a full list.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.GitCommit","page":"LibGit2","title":"LibGit2.GitCommit","text":"GitCommit(repo::GitRepo, hash::AbstractGitHash)\nGitCommit(repo::GitRepo, spec::AbstractString)\n\nReturn a GitCommit object from repo specified by hash/spec.\n\nhash is a full (GitHash) or partial (GitShortHash) hash.\nspec is a textual specification: see the git docs for a full list.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.GitConfig","page":"LibGit2","title":"LibGit2.GitConfig","text":"GitConfig(path::AbstractString, level::Consts.GIT_CONFIG=Consts.CONFIG_LEVEL_APP, force::Bool=false)\n\nCreate a new GitConfig by loading configuration information from the file at path. See addfile for more information about the level, repo and force options.\n\n\n\n\n\nGitConfig(repo::GitRepo)\n\nGet the stored configuration for the git repository repo. If repo does not have a specific configuration file set, the default git configuration will be used.\n\n\n\n\n\nGitConfig(level::Consts.GIT_CONFIG=Consts.CONFIG_LEVEL_DEFAULT)\n\nGet the default git configuration by loading the global and system configuration files into a prioritized configuration. This can be used to access default configuration options outside a specific git repository.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.GitHash","page":"LibGit2","title":"LibGit2.GitHash","text":"GitHash\n\nA git object identifier, based on the sha-1 hash. It is a 20 byte string (40 hex digits) used to identify a GitObject in a repository.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.GitObject","page":"LibGit2","title":"LibGit2.GitObject","text":"GitObject(repo::GitRepo, hash::AbstractGitHash)\nGitObject(repo::GitRepo, spec::AbstractString)\n\nReturn the specified object (GitCommit, GitBlob, GitTree or GitTag) from repo specified by hash/spec.\n\nhash is a full (GitHash) or partial (GitShortHash) hash.\nspec is a textual specification: see the git docs for a full list.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.GitRemote","page":"LibGit2","title":"LibGit2.GitRemote","text":"GitRemote(repo::GitRepo, rmt_name::AbstractString, rmt_url::AbstractString) -> GitRemote\n\nLook up a remote git repository using its name and URL. Uses the default fetch refspec.\n\nExamples\n\nrepo = LibGit2.init(repo_path)\nremote = LibGit2.GitRemote(repo, \"upstream\", repo_url)\n\n\n\n\n\nGitRemote(repo::GitRepo, rmt_name::AbstractString, rmt_url::AbstractString, fetch_spec::AbstractString) -> GitRemote\n\nLook up a remote git repository using the repository's name and URL, as well as specifications for how to fetch from the remote (e.g. which remote branch to fetch from).\n\nExamples\n\nrepo = LibGit2.init(repo_path)\nrefspec = \"+refs/heads/mybranch:refs/remotes/origin/mybranch\"\nremote = LibGit2.GitRemote(repo, \"upstream\", repo_url, refspec)\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.GitRemoteAnon","page":"LibGit2","title":"LibGit2.GitRemoteAnon","text":"GitRemoteAnon(repo::GitRepo, url::AbstractString) -> GitRemote\n\nLook up a remote git repository using only its URL, not its name.\n\nExamples\n\nrepo = LibGit2.init(repo_path)\nremote = LibGit2.GitRemoteAnon(repo, repo_url)\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.GitRepo","page":"LibGit2","title":"LibGit2.GitRepo","text":"LibGit2.GitRepo(path::AbstractString)\n\nOpen a git repository at path.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.GitRepoExt","page":"LibGit2","title":"LibGit2.GitRepoExt","text":"LibGit2.GitRepoExt(path::AbstractString, flags::Cuint = Cuint(Consts.REPOSITORY_OPEN_DEFAULT))\n\nOpen a git repository at path with extended controls (for instance, if the current user must be a member of a special access group to read path).\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.GitRevWalker","page":"LibGit2","title":"LibGit2.GitRevWalker","text":"GitRevWalker(repo::GitRepo)\n\nA GitRevWalker walks through the revisions (i.e. commits) of a git repository repo. It is a collection of the commits in the repository, and supports iteration and calls to LibGit2.map and LibGit2.count (for instance, LibGit2.count could be used to determine what percentage of commits in a repository were made by a certain author).\n\ncnt = LibGit2.with(LibGit2.GitRevWalker(repo)) do walker\n    LibGit2.count((oid,repo)->(oid == commit_oid1), walker, oid=commit_oid1, by=LibGit2.Consts.SORT_TIME)\nend\n\nHere, LibGit2.count finds the number of commits along the walk with a certain GitHash. Since the GitHash is unique to a commit, cnt will be 1.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.GitShortHash","page":"LibGit2","title":"LibGit2.GitShortHash","text":"GitShortHash(hash::GitHash, len::Integer)\n\nA shortened git object identifier, which can be used to identify a git object when it is unique, consisting of the initial len hexadecimal digits of hash (the remaining digits are ignored).\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.GitSignature","page":"LibGit2","title":"LibGit2.GitSignature","text":"LibGit2.GitSignature\n\nThis is a Julia wrapper around a pointer to a git_signature object.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.GitStatus","page":"LibGit2","title":"LibGit2.GitStatus","text":"LibGit2.GitStatus(repo::GitRepo; status_opts=StatusOptions())\n\nCollect information about the status of each file in the git repository repo (e.g. is the file modified, staged, etc.). status_opts can be used to set various options, for instance whether or not to look at untracked files or whether to include submodules or not. See StatusOptions for more information.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.GitTag","page":"LibGit2","title":"LibGit2.GitTag","text":"GitTag(repo::GitRepo, hash::AbstractGitHash)\nGitTag(repo::GitRepo, spec::AbstractString)\n\nReturn a GitTag object from repo specified by hash/spec.\n\nhash is a full (GitHash) or partial (GitShortHash) hash.\nspec is a textual specification: see the git docs for a full list.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.GitTree","page":"LibGit2","title":"LibGit2.GitTree","text":"GitTree(repo::GitRepo, hash::AbstractGitHash)\nGitTree(repo::GitRepo, spec::AbstractString)\n\nReturn a GitTree object from repo specified by hash/spec.\n\nhash is a full (GitHash) or partial (GitShortHash) hash.\nspec is a textual specification: see the git docs for a full list.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.IndexEntry","page":"LibGit2","title":"LibGit2.IndexEntry","text":"LibGit2.IndexEntry\n\nIn-memory representation of a file entry in the index. Matches the git_index_entry struct.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.IndexTime","page":"LibGit2","title":"LibGit2.IndexTime","text":"LibGit2.IndexTime\n\nMatches the git_index_time struct.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.BlameOptions","page":"LibGit2","title":"LibGit2.BlameOptions","text":"LibGit2.BlameOptions\n\nMatches the git_blame_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nflags: one of Consts.BLAME_NORMAL or Consts.BLAME_FIRST_PARENT (the other blame flags  are not yet implemented by libgit2).\nmin_match_characters: the minimum number of alphanumeric characters which much change in a commit in order for the change to be associated with that commit. The default is 20. Only takes effect if one of the Consts.BLAME_*_COPIES flags are used, which libgit2 does not implement yet.\nnewest_commit: the GitHash of the newest commit from which to look at changes.\noldest_commit: the GitHash of the oldest commit from which to look at changes.\nmin_line: the first line of the file from which to starting blaming. The default is 1.\nmax_line: the last line of the file to which to blame. The default is 0, meaning the last line of the file.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.MergeOptions","page":"LibGit2","title":"LibGit2.MergeOptions","text":"LibGit2.MergeOptions\n\nMatches the git_merge_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nflags: an enum for flags describing merge behavior.  Defined in git_merge_flag_t.  The corresponding Julia enum is GIT_MERGE and has values:\nMERGE_FIND_RENAMES: detect if a file has been renamed between the common ancestor and the \"ours\" or \"theirs\" side of the merge. Allows merges where a file has been renamed.\nMERGE_FAIL_ON_CONFLICT: exit immediately if a conflict is found rather than trying to resolve it.\nMERGE_SKIP_REUC: do not write the REUC extension on the index resulting from the merge.\nMERGE_NO_RECURSIVE: if the commits being merged have multiple merge bases, use the first one, rather than trying to recursively merge the bases.\nrename_threshold: how similar two files must to consider one a rename of the other. This is an integer that sets the percentage similarity. The default is 50.\ntarget_limit: the maximum number of files to compare with to look for renames. The default is 200.\nmetric: optional custom function to use to determine the similarity between two files for rename detection.\nrecursion_limit: the upper limit on the number of merges of common ancestors to perform to try to build a new virtual merge base for the merge. The default is no limit. This field is only present on libgit2 versions newer than 0.24.0.\ndefault_driver: the merge driver to use if both sides have changed. This field is only present on libgit2 versions newer than 0.25.0.\nfile_favor: how to handle conflicting file contents for the text driver.\nMERGE_FILE_FAVOR_NORMAL: if both sides of the merge have changes to a section,  make a note of the conflict in the index which git checkout will use to create  a merge file, which the user can then reference to resolve the conflicts. This is  the default.\nMERGE_FILE_FAVOR_OURS: if both sides of the merge have changes to a section,  use the version in the \"ours\" side of the merge in the index.\nMERGE_FILE_FAVOR_THEIRS: if both sides of the merge have changes to a section,  use the version in the \"theirs\" side of the merge in the index.\nMERGE_FILE_FAVOR_UNION: if both sides of the merge have changes to a section,  include each unique line from both sides in the file which is put into the index.\nfile_flags: guidelines for merging files.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.ProxyOptions","page":"LibGit2","title":"LibGit2.ProxyOptions","text":"LibGit2.ProxyOptions\n\nOptions for connecting through a proxy.\n\nMatches the git_proxy_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nproxytype: an enum for the type of proxy to use.  Defined in git_proxy_t.  The corresponding Julia enum is GIT_PROXY and has values:\nPROXY_NONE: do not attempt the connection through a proxy.\nPROXY_AUTO: attempt to figure out the proxy configuration from the git configuration.\nPROXY_SPECIFIED: connect using the URL given in the url field of this struct.\nDefault is to auto-detect the proxy type.\nurl: the URL of the proxy.\ncredential_cb: a pointer to a callback function which will be called if the remote requires authentication to connect.\ncertificate_cb: a pointer to a callback function which will be called if certificate verification fails. This lets the user decide whether or not to keep connecting. If the function returns 1, connecting will be allowed. If it returns 0, the connection will not be allowed. A negative value can be used to return errors.\npayload: the payload to be provided to the two callback functions.\n\nExamples\n\njulia> fo = LibGit2.FetchOptions(\n           proxy_opts = LibGit2.ProxyOptions(url = Cstring(\"https://my_proxy_url.com\")))\n\njulia> fetch(remote, \"master\", options=fo)\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.PushOptions","page":"LibGit2","title":"LibGit2.PushOptions","text":"LibGit2.PushOptions\n\nMatches the git_push_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nparallelism: if a pack file must be created, this variable sets the number of worker  threads which will be spawned by the packbuilder. If 0, the packbuilder will auto-set  the number of threads to use. The default is 1.\ncallbacks: the callbacks (e.g. for authentication with the remote) to use for the push.\nproxy_opts: only relevant if the LibGit2 version is greater than or equal to 0.25.0.  Sets options for using a proxy to communicate with a remote. See ProxyOptions  for more information.\ncustom_headers: only relevant if the LibGit2 version is greater than or equal to 0.24.0.  Extra headers needed for the push operation.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.RebaseOperation","page":"LibGit2","title":"LibGit2.RebaseOperation","text":"LibGit2.RebaseOperation\n\nDescribes a single instruction/operation to be performed during the rebase. Matches the git_rebase_operation struct.\n\nThe fields represent:\n\noptype: the type of rebase operation currently being performed. The options are:\nREBASE_OPERATION_PICK: cherry-pick the commit in question.\nREBASE_OPERATION_REWORD: cherry-pick the commit in question, but rewrite its message using the prompt.\nREBASE_OPERATION_EDIT: cherry-pick the commit in question, but allow the user to edit the commit's contents and its message.\nREBASE_OPERATION_SQUASH: squash the commit in question into the previous commit. The commit messages of the two commits will be merged.\nREBASE_OPERATION_FIXUP: squash the commit in question into the previous commit. Only the commit message of the previous commit will be used.\nREBASE_OPERATION_EXEC: do not cherry-pick a commit. Run a command and continue if the command exits successfully.\nid: the GitHash of the commit being worked on during this rebase step.\nexec: in case REBASE_OPERATION_EXEC is used, the command to run during this step (for instance, running the test suite after each commit).\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.RebaseOptions","page":"LibGit2","title":"LibGit2.RebaseOptions","text":"LibGit2.RebaseOptions\n\nMatches the git_rebase_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nquiet: inform other git clients helping with/working on the rebase that the rebase should be done \"quietly\". Used for interoperability. The default is 1.\ninmemory: start an in-memory rebase. Callers working on the rebase can go through its steps and commit any changes, but cannot rewind HEAD or update the repository. The workdir will not be modified. Only present on libgit2 versions newer than or equal to 0.24.0.\nrewrite_notes_ref: name of the reference to notes to use to rewrite the commit notes as the rebase is finished.\nmerge_opts: merge options controlling how the trees will be merged at each rebase step.  Only present on libgit2 versions newer than or equal to 0.24.0.\ncheckout_opts: checkout options for writing files when initializing the rebase, stepping through it, and aborting it. See CheckoutOptions for more information.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.RemoteCallbacks","page":"LibGit2","title":"LibGit2.RemoteCallbacks","text":"LibGit2.RemoteCallbacks\n\nCallback settings. Matches the git_remote_callbacks struct.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.SignatureStruct","page":"LibGit2","title":"LibGit2.SignatureStruct","text":"LibGit2.SignatureStruct\n\nAn action signature (e.g. for committers, taggers, etc). Matches the git_signature struct.\n\nThe fields represent:\n\nname: The full name of the committer or author of the commit.\nemail: The email at which the committer/author can be contacted.\nwhen: a TimeStruct indicating when the commit was  authored/committed into the repository.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.StatusEntry","page":"LibGit2","title":"LibGit2.StatusEntry","text":"LibGit2.StatusEntry\n\nProviding the differences between the file as it exists in HEAD and the index, and providing the differences between the index and the working directory. Matches the git_status_entry struct.\n\nThe fields represent:\n\nstatus: contains the status flags for the file, indicating if it is current, or has been changed in some way in the index or work tree.\nhead_to_index: a pointer to a DiffDelta which encapsulates the difference(s) between the file as it exists in HEAD and in the index.\nindex_to_workdir: a pointer to a DiffDelta which encapsulates the difference(s) between the file as it exists in the index and in the workdir.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.StatusOptions","page":"LibGit2","title":"LibGit2.StatusOptions","text":"LibGit2.StatusOptions\n\nOptions to control how git_status_foreach_ext() will issue callbacks. Matches the git_status_opt_t struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nshow: a flag for which files to examine and in which order. The default is Consts.STATUS_SHOW_INDEX_AND_WORKDIR.\nflags: flags for controlling any callbacks used in a status call.\npathspec: an array of paths to use for path-matching. The behavior of the path-matching will vary depending on the values of show and flags.\nThe baseline is the tree to be used for comparison to the working directory and index; defaults to HEAD.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.StrArrayStruct","page":"LibGit2","title":"LibGit2.StrArrayStruct","text":"LibGit2.StrArrayStruct\n\nA LibGit2 representation of an array of strings. Matches the git_strarray struct.\n\nWhen fetching data from LibGit2, a typical usage would look like:\n\nsa_ref = Ref(StrArrayStruct())\n@check ccall(..., (Ptr{StrArrayStruct},), sa_ref)\nres = convert(Vector{String}, sa_ref[])\nfree(sa_ref)\n\nIn particular, note that LibGit2.free should be called afterward on the Ref object.\n\nConversely, when passing a vector of strings to LibGit2, it is generally simplest to rely on implicit conversion:\n\nstrs = String[...]\n@check ccall(..., (Ptr{StrArrayStruct},), strs)\n\nNote that no call to free is required as the data is allocated by Julia.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.TimeStruct","page":"LibGit2","title":"LibGit2.TimeStruct","text":"LibGit2.TimeStruct\n\nTime in a signature. Matches the git_time struct.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.addfile","page":"LibGit2","title":"LibGit2.addfile","text":"addfile(cfg::GitConfig, path::AbstractString,\n        level::Consts.GIT_CONFIG=Consts.CONFIG_LEVEL_APP,\n        repo::Union{GitRepo, Nothing} = nothing,\n        force::Bool=false)\n\nAdd an existing git configuration file located at path to the current GitConfig cfg. If the file does not exist, it will be created.\n\nlevel sets the git configuration priority level and is determined by\n\nConsts.GIT_CONFIG.\n\nrepo is an optional repository to allow parsing of conditional includes.\nIf force is false and a configuration for the given priority level already exists,\n\naddfile will error. If force is true, the existing configuration will be replaced by the one in the file at path.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.add!","page":"LibGit2","title":"LibGit2.add!","text":"add!(repo::GitRepo, files::AbstractString...; flags::Cuint = Consts.INDEX_ADD_DEFAULT)\nadd!(idx::GitIndex, files::AbstractString...; flags::Cuint = Consts.INDEX_ADD_DEFAULT)\n\nAdd all the files with paths specified by files to the index idx (or the index of the repo). If the file already exists, the index entry will be updated. If the file does not exist already, it will be newly added into the index. files may contain glob patterns which will be expanded and any matching files will be added (unless INDEX_ADD_DISABLE_PATHSPEC_MATCH is set, see below). If a file has been ignored (in .gitignore or in the config), it will not be added, unless it is already being tracked in the index, in which case it will be updated. The keyword argument flags is a set of bit-flags which control the behavior with respect to ignored files:\n\nConsts.INDEX_ADD_DEFAULT - default, described above.\nConsts.INDEX_ADD_FORCE - disregard the existing ignore rules and force addition of the file to the index even if it is already ignored.\nConsts.INDEX_ADD_CHECK_PATHSPEC - cannot be used at the same time as INDEX_ADD_FORCE. Check that each file in files which exists on disk is not in the ignore list. If one of the files is ignored, the function will return EINVALIDSPEC.\nConsts.INDEX_ADD_DISABLE_PATHSPEC_MATCH - turn off glob matching, and only add files to the index which exactly match the paths specified in files.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.add_fetch!","page":"LibGit2","title":"LibGit2.add_fetch!","text":"add_fetch!(repo::GitRepo, rmt::GitRemote, fetch_spec::String)\n\nAdd a fetch refspec for the specified rmt. This refspec will contain information about which branch(es) to fetch from.\n\nExamples\n\njulia> LibGit2.add_fetch!(repo, remote, \"upstream\");\n\njulia> LibGit2.fetch_refspecs(remote)\nString[\"+refs/heads/*:refs/remotes/upstream/*\"]\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.add_push!","page":"LibGit2","title":"LibGit2.add_push!","text":"add_push!(repo::GitRepo, rmt::GitRemote, push_spec::String)\n\nAdd a push refspec for the specified rmt. This refspec will contain information about which branch(es) to push to.\n\nExamples\n\njulia> LibGit2.add_push!(repo, remote, \"refs/heads/master\");\n\njulia> remote = LibGit2.get(LibGit2.GitRemote, repo, branch);\n\njulia> LibGit2.push_refspecs(remote)\nString[\"refs/heads/master\"]\n\nnote: Note\nYou may need to close and reopen the GitRemote in question after updating its push refspecs in order for the change to take effect and for calls to push to work.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.addblob!","page":"LibGit2","title":"LibGit2.addblob!","text":"LibGit2.addblob!(repo::GitRepo, path::AbstractString)\n\nRead the file at path and adds it to the object database of repo as a loose blob. Return the GitHash of the resulting blob.\n\nExamples\n\nhash_str = string(commit_oid)\nblob_file = joinpath(repo_path, \".git\", \"objects\", hash_str[1:2], hash_str[3:end])\nid = LibGit2.addblob!(repo, blob_file)\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.author","page":"LibGit2","title":"LibGit2.author","text":"author(c::GitCommit)\n\nReturn the Signature of the author of the commit c. The author is the person who made changes to the relevant file(s). See also committer.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.authors","page":"LibGit2","title":"LibGit2.authors","text":"authors(repo::GitRepo) -> Vector{Signature}\n\nReturn all authors of commits to the repo repository.\n\nExamples\n\nrepo = LibGit2.GitRepo(repo_path)\nrepo_file = open(joinpath(repo_path, test_file), \"a\")\n\nprintln(repo_file, commit_msg)\nflush(repo_file)\nLibGit2.add!(repo, test_file)\nsig = LibGit2.Signature(\"TEST\", \"TEST@TEST.COM\", round(time(), 0), 0)\ncommit_oid1 = LibGit2.commit(repo, \"commit1\"; author=sig, committer=sig)\nprintln(repo_file, randstring(10))\nflush(repo_file)\nLibGit2.add!(repo, test_file)\ncommit_oid2 = LibGit2.commit(repo, \"commit2\"; author=sig, committer=sig)\n\n# will be a Vector of [sig, sig]\nauths = LibGit2.authors(repo)\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.branch","page":"LibGit2","title":"LibGit2.branch","text":"branch(repo::GitRepo)\n\nEquivalent to git branch. Create a new branch from the current HEAD.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.branch!","page":"LibGit2","title":"LibGit2.branch!","text":"branch!(repo::GitRepo, branch_name::AbstractString, commit::AbstractString=\"\"; kwargs...)\n\nCheckout a new git branch in the repo repository. commit is the GitHash, in string form, which will be the start of the new branch. If commit is an empty string, the current HEAD will be used.\n\nThe keyword arguments are:\n\ntrack::AbstractString=\"\": the name of the remote branch this new branch should track, if any. If empty (the default), no remote branch will be tracked.\nforce::Bool=false: if true, branch creation will be forced.\nset_head::Bool=true: if true, after the branch creation finishes the branch head will be set as the HEAD of repo.\n\nEquivalent to git checkout [-b|-B] <branch_name> [<commit>] [--track <track>].\n\nExamples\n\nrepo = LibGit2.GitRepo(repo_path)\nLibGit2.branch!(repo, \"new_branch\", set_head=false)\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.checkout!","page":"LibGit2","title":"LibGit2.checkout!","text":"checkout!(repo::GitRepo, commit::AbstractString=\"\"; force::Bool=true)\n\nEquivalent to git checkout [-f] --detach <commit>. Checkout the git commit commit (a GitHash in string form) in repo. If force is true, force the checkout and discard any current changes. Note that this detaches the current HEAD.\n\nExamples\n\nrepo = LibGit2.GitRepo(repo_path)\nopen(joinpath(LibGit2.path(repo), \"file1\"), \"w\") do f\n    write(f, \"111\n\")\nend\nLibGit2.add!(repo, \"file1\")\ncommit_oid = LibGit2.commit(repo, \"add file1\")\nopen(joinpath(LibGit2.path(repo), \"file1\"), \"w\") do f\n    write(f, \"112\n\")\nend\n# would fail without the force=true\n# since there are modifications to the file\nLibGit2.checkout!(repo, string(commit_oid), force=true)\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.clone","page":"LibGit2","title":"LibGit2.clone","text":"clone(repo_url::AbstractString, repo_path::AbstractString, clone_opts::CloneOptions)\n\nClone the remote repository at repo_url (which can be a remote URL or a path on the local filesystem) to repo_path (which must be a path on the local filesystem). Options for the clone, such as whether to perform a bare clone or not, are set by CloneOptions.\n\nExamples\n\nrepo_url = \"https://github.com/JuliaLang/Example.jl\"\nrepo = LibGit2.clone(repo_url, \"/home/me/projects/Example\")\n\n\n\n\n\nclone(repo_url::AbstractString, repo_path::AbstractString; kwargs...)\n\nClone a remote repository located at repo_url to the local filesystem location repo_path.\n\nThe keyword arguments are:\n\nbranch::AbstractString=\"\": which branch of the remote to clone, if not the default repository branch (usually master).\nisbare::Bool=false: if true, clone the remote as a bare repository, which will make repo_path itself the git directory instead of repo_path/.git. This means that a working tree cannot be checked out. Plays the role of the git CLI argument --bare.\nremote_cb::Ptr{Cvoid}=C_NULL: a callback which will be used to create the remote before it is cloned. If C_NULL (the default), no attempt will be made to create the remote - it will be assumed to already exist.\ncredentials::Creds=nothing: provides credentials and/or settings when authenticating against a private repository.\ncallbacks::Callbacks=Callbacks(): user provided callbacks and payloads.\n\nEquivalent to git clone [-b <branch>] [--bare] <repo_url> <repo_path>.\n\nExamples\n\nrepo_url = \"https://github.com/JuliaLang/Example.jl\"\nrepo1 = LibGit2.clone(repo_url, \"test_path\")\nrepo2 = LibGit2.clone(repo_url, \"test_path\", isbare=true)\njulia_url = \"https://github.com/JuliaLang/julia\"\njulia_repo = LibGit2.clone(julia_url, \"julia_path\", branch=\"release-0.6\")\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.commit","page":"LibGit2","title":"LibGit2.commit","text":"commit(repo::GitRepo, msg::AbstractString; kwargs...) -> GitHash\n\nWrapper around git_commit_create. Create a commit in the repository repo. msg is the commit message. Return the OID of the new commit.\n\nThe keyword arguments are:\n\nrefname::AbstractString=Consts.HEAD_FILE: if not NULL, the name of the reference to update to point to the new commit. For example, \"HEAD\" will update the HEAD of the current branch. If the reference does not yet exist, it will be created.\nauthor::Signature = Signature(repo) is a Signature containing information about the person who authored the commit.\ncommitter::Signature = Signature(repo) is a Signature containing information about the person who committed the commit to the repository. Not necessarily the same as author, for instance if author emailed a patch to committer who committed it.\ntree_id::GitHash = GitHash() is a git tree to use to create the commit, showing its ancestry and relationship with any other history. tree must belong to repo.\nparent_ids::Vector{GitHash}=GitHash[] is a list of commits by GitHash to use as parent commits for the new one, and may be empty. A commit might have multiple parents if it is a merge commit, for example.\n\n\n\n\n\nLibGit2.commit(rb::GitRebase, sig::GitSignature)\n\nCommit the current patch to the rebase rb, using sig as the committer. Is silent if the commit has already been applied.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.committer","page":"LibGit2","title":"LibGit2.committer","text":"committer(c::GitCommit)\n\nReturn the Signature of the committer of the commit c. The committer is the person who committed the changes originally authored by the author, but need not be the same as the author, for example, if the author emailed a patch to a committer who committed it.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.count","page":"LibGit2","title":"LibGit2.count","text":"LibGit2.count(f::Function, walker::GitRevWalker; oid::GitHash=GitHash(), by::Cint=Consts.SORT_NONE, rev::Bool=false)\n\nUsing the GitRevWalker walker to \"walk\" over every commit in the repository's history, find the number of commits which return true when f is applied to them. The keyword arguments are:     * oid: The GitHash of the commit to begin the walk from. The default is to use       push_head! and therefore the HEAD commit and all its ancestors.     * by: The sorting method. The default is not to sort. Other options are to sort by       topology (LibGit2.Consts.SORT_TOPOLOGICAL), to sort forwards in time       (LibGit2.Consts.SORT_TIME, most ancient first) or to sort backwards in time       (LibGit2.Consts.SORT_REVERSE, most recent first).     * rev: Whether to reverse the sorted order (for instance, if topological sorting is used).\n\nExamples\n\ncnt = LibGit2.with(LibGit2.GitRevWalker(repo)) do walker\n    LibGit2.count((oid, repo)->(oid == commit_oid1), walker, oid=commit_oid1, by=LibGit2.Consts.SORT_TIME)\nend\n\nLibGit2.count finds the number of commits along the walk with a certain GitHash commit_oid1, starting the walk from that commit and moving forwards in time from it. Since the GitHash is unique to a commit, cnt will be 1.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.counthunks","page":"LibGit2","title":"LibGit2.counthunks","text":"counthunks(blame::GitBlame)\n\nReturn the number of distinct \"hunks\" with a file. A hunk may contain multiple lines. A hunk is usually a piece of a file that was added/changed/removed together, for example, a function added to a source file or an inner loop that was optimized out of that function later.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.create_branch","page":"LibGit2","title":"LibGit2.create_branch","text":"LibGit2.create_branch(repo::GitRepo, bname::AbstractString, commit_obj::GitCommit; force::Bool=false)\n\nCreate a new branch in the repository repo with name bname, which points to commit commit_obj (which has to be part of repo). If force is true, overwrite an existing branch named bname if it exists. If force is false and a branch already exists named bname, this function will throw an error.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.credentials_callback","page":"LibGit2","title":"LibGit2.credentials_callback","text":"credential_callback(...) -> Cint\n\nA LibGit2 credential callback function which provides different credential acquisition functionality w.r.t. a connection protocol. The payload_ptr is required to contain a LibGit2.CredentialPayload object which will keep track of state and settings.\n\nThe allowed_types contains a bitmask of LibGit2.Consts.GIT_CREDTYPE values specifying which authentication methods should be attempted.\n\nCredential authentication is done in the following order (if supported):\n\nSSH agent\nSSH private/public key pair\nUsername/password plain text\n\nIf a user is presented with a credential prompt they can abort the prompt by typing ^D (pressing the control key together with the d key).\n\nNote: Due to the specifics of the libgit2 authentication procedure, when authentication fails, this function is called again without any indication whether authentication was successful or not. To avoid an infinite loop from repeatedly using the same faulty credentials, we will keep track of state using the payload.\n\nFor addition details see the LibGit2 guide on authenticating against a server.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.credentials_cb","page":"LibGit2","title":"LibGit2.credentials_cb","text":"C function pointer for credentials_callback\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.default_signature","page":"LibGit2","title":"LibGit2.default_signature","text":"Return signature object. Free it after use.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.delete_branch","page":"LibGit2","title":"LibGit2.delete_branch","text":"LibGit2.delete_branch(branch::GitReference)\n\nDelete the branch pointed to by branch.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.diff_files","page":"LibGit2","title":"LibGit2.diff_files","text":"diff_files(repo::GitRepo, branch1::AbstractString, branch2::AbstractString; kwarg...) -> Vector{AbstractString}\n\nShow which files have changed in the git repository repo between branches branch1 and branch2.\n\nThe keyword argument is:\n\nfilter::Set{Consts.DELTA_STATUS}=Set([Consts.DELTA_ADDED, Consts.DELTA_MODIFIED, Consts.DELTA_DELETED])), and it sets options for the diff. The default is to show files added, modified, or deleted.\n\nReturn only the names of the files which have changed, not their contents.\n\nExamples\n\nLibGit2.branch!(repo, \"branch/a\")\nLibGit2.branch!(repo, \"branch/b\")\n# add a file to repo\nopen(joinpath(LibGit2.path(repo),\"file\"),\"w\") do f\n    write(f, \"hello repo\n\")\nend\nLibGit2.add!(repo, \"file\")\nLibGit2.commit(repo, \"add file\")\n# returns [\"file\"]\nfilt = Set([LibGit2.Consts.DELTA_ADDED])\nfiles = LibGit2.diff_files(repo, \"branch/a\", \"branch/b\", filter=filt)\n# returns [] because existing files weren't modified\nfilt = Set([LibGit2.Consts.DELTA_MODIFIED])\nfiles = LibGit2.diff_files(repo, \"branch/a\", \"branch/b\", filter=filt)\n\nEquivalent to git diff --name-only --diff-filter=<filter> <branch1> <branch2>.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.entryid","page":"LibGit2","title":"LibGit2.entryid","text":"entryid(te::GitTreeEntry)\n\nReturn the GitHash of the object to which te refers.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.entrytype","page":"LibGit2","title":"LibGit2.entrytype","text":"entrytype(te::GitTreeEntry)\n\nReturn the type of the object to which te refers. The result will be one of the types which objtype returns, e.g. a GitTree or GitBlob.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.fetch","page":"LibGit2","title":"LibGit2.fetch","text":"fetch(rmt::GitRemote, refspecs; options::FetchOptions=FetchOptions(), msg=\"\")\n\nFetch from the specified rmt remote git repository, using refspecs to determine which remote branch(es) to fetch. The keyword arguments are:\n\noptions: determines the options for the fetch, e.g. whether to prune afterwards. See FetchOptions for more information.\nmsg: a message to insert into the reflogs.\n\n\n\n\n\nfetch(repo::GitRepo; kwargs...)\n\nFetches updates from an upstream of the repository repo.\n\nThe keyword arguments are:\n\nremote::AbstractString=\"origin\": which remote, specified by name, of repo to fetch from. If this is empty, the URL will be used to construct an anonymous remote.\nremoteurl::AbstractString=\"\": the URL of remote. If not specified, will be assumed based on the given name of remote.\nrefspecs=AbstractString[]: determines properties of the fetch.\ncredentials=nothing: provides credentials and/or settings when authenticating against a private remote.\ncallbacks=Callbacks(): user provided callbacks and payloads.\n\nEquivalent to git fetch [<remoteurl>|<repo>] [<refspecs>].\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.fetchheads","page":"LibGit2","title":"LibGit2.fetchheads","text":"fetchheads(repo::GitRepo) -> Vector{FetchHead}\n\nReturn the list of all the fetch heads for repo, each represented as a FetchHead, including their names, URLs, and merge statuses.\n\nExamples\n\njulia> fetch_heads = LibGit2.fetchheads(repo);\n\njulia> fetch_heads[1].name\n\"refs/heads/master\"\n\njulia> fetch_heads[1].ismerge\ntrue\n\njulia> fetch_heads[2].name\n\"refs/heads/test_branch\"\n\njulia> fetch_heads[2].ismerge\nfalse\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.fetch_refspecs","page":"LibGit2","title":"LibGit2.fetch_refspecs","text":"fetch_refspecs(rmt::GitRemote) -> Vector{String}\n\nGet the fetch refspecs for the specified rmt. These refspecs contain information about which branch(es) to fetch from.\n\nExamples\n\njulia> remote = LibGit2.get(LibGit2.GitRemote, repo, \"upstream\");\n\njulia> LibGit2.add_fetch!(repo, remote, \"upstream\");\n\njulia> LibGit2.fetch_refspecs(remote)\nString[\"+refs/heads/*:refs/remotes/upstream/*\"]\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.fetchhead_foreach_cb","page":"LibGit2","title":"LibGit2.fetchhead_foreach_cb","text":"C function pointer for fetchhead_foreach_callback\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.merge_base","page":"LibGit2","title":"LibGit2.merge_base","text":"merge_base(repo::GitRepo, one::AbstractString, two::AbstractString) -> GitHash\n\nFind a merge base (a common ancestor) between the commits one and two. one and two may both be in string form. Return the GitHash of the merge base.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.merge!-Tuple{GitRepo}","page":"LibGit2","title":"LibGit2.merge!","text":"merge!(repo::GitRepo; kwargs...) -> Bool\n\nPerform a git merge on the repository repo, merging commits with diverging history into the current branch. Return true if the merge succeeded, false if not.\n\nThe keyword arguments are:\n\ncommittish::AbstractString=\"\": Merge the named commit(s) in committish.\nbranch::AbstractString=\"\": Merge the branch branch and all its commits since it diverged from the current branch.\nfastforward::Bool=false: If fastforward is true, only merge if the merge is a fast-forward (the current branch head is an ancestor of the commits to be merged), otherwise refuse to merge and return false. This is equivalent to the git CLI option --ff-only.\nmerge_opts::MergeOptions=MergeOptions(): merge_opts specifies options for the merge, such as merge strategy in case of conflicts.\ncheckout_opts::CheckoutOptions=CheckoutOptions(): checkout_opts specifies options for the checkout step.\n\nEquivalent to git merge [--ff-only] [<committish> | <branch>].\n\nnote: Note\nIf you specify a branch, this must be done in reference format, since the string will be turned into a GitReference. For example, if you wanted to merge branch branch_a, you would call merge!(repo, branch=\"refs/heads/branch_a\").\n\n\n\n\n\n","category":"method"},{"location":"stdlib/LibGit2.html#LibGit2.merge!-Tuple{GitRepo, Vector{LibGit2.GitAnnotated}}","page":"LibGit2","title":"LibGit2.merge!","text":"merge!(repo::GitRepo, anns::Vector{GitAnnotated}; kwargs...) -> Bool\n\nMerge changes from the annotated commits (captured as GitAnnotated objects) anns into the HEAD of the repository repo. The keyword arguments are:\n\nmerge_opts::MergeOptions = MergeOptions(): options for how to perform the merge, including whether fastforwarding is allowed. See MergeOptions for more information.\ncheckout_opts::CheckoutOptions = CheckoutOptions(): options for how to perform the checkout. See CheckoutOptions for more information.\n\nanns may refer to remote or local branch heads. Return true if the merge is successful, otherwise return false (for instance, if no merge is possible because the branches have no common ancestor).\n\nExamples\n\nupst_ann = LibGit2.GitAnnotated(repo, \"branch/a\")\n\n# merge the branch in\nLibGit2.merge!(repo, [upst_ann])\n\n\n\n\n\n","category":"method"},{"location":"stdlib/LibGit2.html#LibGit2.merge!-Tuple{GitRepo, Vector{LibGit2.GitAnnotated}, Bool}","page":"LibGit2","title":"LibGit2.merge!","text":"merge!(repo::GitRepo, anns::Vector{GitAnnotated}, fastforward::Bool; kwargs...) -> Bool\n\nMerge changes from the annotated commits (captured as GitAnnotated objects) anns into the HEAD of the repository repo. If fastforward is true, only a fastforward merge is allowed. In this case, if conflicts occur, the merge will fail. Otherwise, if fastforward is false, the merge may produce a conflict file which the user will need to resolve.\n\nThe keyword arguments are:\n\nmerge_opts::MergeOptions = MergeOptions(): options for how to perform the merge, including whether fastforwarding is allowed. See MergeOptions for more information.\ncheckout_opts::CheckoutOptions = CheckoutOptions(): options for how to perform the checkout. See CheckoutOptions for more information.\n\nanns may refer to remote or local branch heads. Return true if the merge is successful, otherwise return false (for instance, if no merge is possible because the branches have no common ancestor).\n\nExamples\n\nupst_ann_1 = LibGit2.GitAnnotated(repo, \"branch/a\")\n\n# merge the branch in, fastforward\nLibGit2.merge!(repo, [upst_ann_1], true)\n\n# merge conflicts!\nupst_ann_2 = LibGit2.GitAnnotated(repo, \"branch/b\")\n# merge the branch in, try to fastforward\nLibGit2.merge!(repo, [upst_ann_2], true) # will return false\nLibGit2.merge!(repo, [upst_ann_2], false) # will return true\n\n\n\n\n\n","category":"method"},{"location":"stdlib/LibGit2.html#LibGit2.ffmerge!","page":"LibGit2","title":"LibGit2.ffmerge!","text":"ffmerge!(repo::GitRepo, ann::GitAnnotated)\n\nFastforward merge changes into current HEAD. This is only possible if the commit referred to by ann is descended from the current HEAD (e.g. if pulling changes from a remote branch which is simply ahead of the local branch tip).\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.fullname","page":"LibGit2","title":"LibGit2.fullname","text":"LibGit2.fullname(ref::GitReference)\n\nReturn the name of the reference pointed to by the symbolic reference ref. If ref is not a symbolic reference, return an empty string.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.features","page":"LibGit2","title":"LibGit2.features","text":"features()\n\nReturn a list of git features the current version of libgit2 supports, such as threading or using HTTPS or SSH.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.filename","page":"LibGit2","title":"LibGit2.filename","text":"filename(te::GitTreeEntry)\n\nReturn the filename of the object on disk to which te refers.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.filemode","page":"LibGit2","title":"LibGit2.filemode","text":"filemode(te::GitTreeEntry) -> Cint\n\nReturn the UNIX filemode of the object on disk to which te refers as an integer.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.gitdir","page":"LibGit2","title":"LibGit2.gitdir","text":"LibGit2.gitdir(repo::GitRepo)\n\nReturn the location of the \"git\" files of repo:\n\nfor normal repositories, this is the location of the .git folder.\nfor bare repositories, this is the location of the repository itself.\n\nSee also workdir, path.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.git_url","page":"LibGit2","title":"LibGit2.git_url","text":"LibGit2.git_url(; kwargs...) -> String\n\nCreate a string based upon the URL components provided. When the scheme keyword is not provided the URL produced will use the alternative scp-like syntax.\n\nKeywords\n\nscheme::AbstractString=\"\": the URL scheme which identifies the protocol to be used. For HTTP use \"http\", SSH use \"ssh\", etc. When scheme is not provided the output format will be \"ssh\" but using the scp-like syntax.\nusername::AbstractString=\"\": the username to use in the output if provided.\npassword::AbstractString=\"\": the password to use in the output if provided.\nhost::AbstractString=\"\": the hostname to use in the output. A hostname is required to be specified.\nport::Union{AbstractString,Integer}=\"\": the port number to use in the output if provided. Cannot be specified when using the scp-like syntax.\npath::AbstractString=\"\": the path to use in the output if provided.\n\nwarning: Warning\nAvoid using passwords in URLs. Unlike the credential objects, Julia is not able to securely zero or destroy the sensitive data after use and the password may remain in memory; possibly to be exposed by an uninitialized memory.\n\nExamples\n\njulia> LibGit2.git_url(username=\"git\", host=\"github.com\", path=\"JuliaLang/julia.git\")\n\"git@github.com:JuliaLang/julia.git\"\n\njulia> LibGit2.git_url(scheme=\"https\", host=\"github.com\", path=\"/JuliaLang/julia.git\")\n\"https://github.com/JuliaLang/julia.git\"\n\njulia> LibGit2.git_url(scheme=\"ssh\", username=\"git\", host=\"github.com\", port=2222, path=\"JuliaLang/julia.git\")\n\"ssh://git@github.com:2222/JuliaLang/julia.git\"\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.@githash_str","page":"LibGit2","title":"LibGit2.@githash_str","text":"@githash_str -> AbstractGitHash\n\nConstruct a git hash object from the given string, returning a GitShortHash if the string is shorter than 40 hexadecimal digits, otherwise a GitHash.\n\nExamples\n\njulia> LibGit2.githash\"d114feb74ce633\"\nGitShortHash(\"d114feb74ce633\")\n\njulia> LibGit2.githash\"d114feb74ce63307afe878a5228ad014e0289a85\"\nGitHash(\"d114feb74ce63307afe878a5228ad014e0289a85\")\n\n\n\n\n\n","category":"macro"},{"location":"stdlib/LibGit2.html#LibGit2.head","page":"LibGit2","title":"LibGit2.head","text":"LibGit2.head(repo::GitRepo) -> GitReference\n\nReturn a GitReference to the current HEAD of repo.\n\n\n\n\n\nhead(pkg::AbstractString) -> String\n\nReturn current HEAD GitHash of the pkg repo as a string.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.head!","page":"LibGit2","title":"LibGit2.head!","text":"LibGit2.head!(repo::GitRepo, ref::GitReference) -> GitReference\n\nSet the HEAD of repo to the object pointed to by ref.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.head_oid","page":"LibGit2","title":"LibGit2.head_oid","text":"LibGit2.head_oid(repo::GitRepo) -> GitHash\n\nLookup the object id of the current HEAD of git repository repo.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.headname","page":"LibGit2","title":"LibGit2.headname","text":"LibGit2.headname(repo::GitRepo)\n\nLookup the name of the current HEAD of git repository repo. If repo is currently detached, return the name of the HEAD it's detached from.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.init","page":"LibGit2","title":"LibGit2.init","text":"LibGit2.init(path::AbstractString, bare::Bool=false) -> GitRepo\n\nOpen a new git repository at path. If bare is false, the working tree will be created in path/.git. If bare is true, no working directory will be created.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.is_ancestor_of","page":"LibGit2","title":"LibGit2.is_ancestor_of","text":"is_ancestor_of(a::AbstractString, b::AbstractString, repo::GitRepo) -> Bool\n\nReturn true if a, a GitHash in string form, is an ancestor of b, a GitHash in string form.\n\nExamples\n\njulia> repo = GitRepo(repo_path);\n\njulia> LibGit2.add!(repo, test_file1);\n\njulia> commit_oid1 = LibGit2.commit(repo, \"commit1\");\n\njulia> LibGit2.add!(repo, test_file2);\n\njulia> commit_oid2 = LibGit2.commit(repo, \"commit2\");\n\njulia> LibGit2.is_ancestor_of(string(commit_oid1), string(commit_oid2), repo)\ntrue\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.isbinary","page":"LibGit2","title":"LibGit2.isbinary","text":"isbinary(blob::GitBlob) -> Bool\n\nUse a heuristic to guess if a file is binary: searching for NULL bytes and looking for a reasonable ratio of printable to non-printable characters among the first 8000 bytes.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.iscommit","page":"LibGit2","title":"LibGit2.iscommit","text":"iscommit(id::AbstractString, repo::GitRepo) -> Bool\n\nCheck if commit id (which is a GitHash in string form) is in the repository.\n\nExamples\n\njulia> repo = GitRepo(repo_path);\n\njulia> LibGit2.add!(repo, test_file);\n\njulia> commit_oid = LibGit2.commit(repo, \"add test_file\");\n\njulia> LibGit2.iscommit(string(commit_oid), repo)\ntrue\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.isdiff","page":"LibGit2","title":"LibGit2.isdiff","text":"LibGit2.isdiff(repo::GitRepo, treeish::AbstractString, pathspecs::AbstractString=\"\"; cached::Bool=false)\n\nChecks if there are any differences between the tree specified by treeish and the tracked files in the working tree (if cached=false) or the index (if cached=true). pathspecs are the specifications for options for the diff.\n\nExamples\n\nrepo = LibGit2.GitRepo(repo_path)\nLibGit2.isdiff(repo, \"HEAD\") # should be false\nopen(joinpath(repo_path, new_file), \"a\") do f\n    println(f, \"here's my cool new file\")\nend\nLibGit2.isdiff(repo, \"HEAD\") # now true\n\nEquivalent to git diff-index <treeish> [-- <pathspecs>].\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.isdirty","page":"LibGit2","title":"LibGit2.isdirty","text":"LibGit2.isdirty(repo::GitRepo, pathspecs::AbstractString=\"\"; cached::Bool=false) -> Bool\n\nCheck if there have been any changes to tracked files in the working tree (if cached=false) or the index (if cached=true). pathspecs are the specifications for options for the diff.\n\nExamples\n\nrepo = LibGit2.GitRepo(repo_path)\nLibGit2.isdirty(repo) # should be false\nopen(joinpath(repo_path, new_file), \"a\") do f\n    println(f, \"here's my cool new file\")\nend\nLibGit2.isdirty(repo) # now true\nLibGit2.isdirty(repo, new_file) # now true\n\nEquivalent to git diff-index HEAD [-- <pathspecs>].\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.isorphan","page":"LibGit2","title":"LibGit2.isorphan","text":"LibGit2.isorphan(repo::GitRepo)\n\nCheck if the current branch is an \"orphan\" branch, i.e. has no commits. The first commit to this branch will have no parents.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.isset","page":"LibGit2","title":"LibGit2.isset","text":"isset(val::Integer, flag::Integer)\n\nTest whether the bits of val indexed by flag are set (1) or unset (0).\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.iszero","page":"LibGit2","title":"LibGit2.iszero","text":"iszero(id::GitHash) -> Bool\n\nDetermine whether all hexadecimal digits of the given GitHash are zero.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.lookup_branch","page":"LibGit2","title":"LibGit2.lookup_branch","text":"lookup_branch(repo::GitRepo, branch_name::AbstractString, remote::Bool=false) -> Union{GitReference, Nothing}\n\nDetermine if the branch specified by branch_name exists in the repository repo. If remote is true, repo is assumed to be a remote git repository. Otherwise, it is part of the local filesystem.\n\nReturn either a GitReference to the requested branch if it exists, or nothing if not.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.map","page":"LibGit2","title":"LibGit2.map","text":"LibGit2.map(f::Function, walker::GitRevWalker; oid::GitHash=GitHash(), range::AbstractString=\"\", by::Cint=Consts.SORT_NONE, rev::Bool=false)\n\nUsing the GitRevWalker walker to \"walk\" over every commit in the repository's history, apply f to each commit in the walk. The keyword arguments are:     * oid: The GitHash of the commit to begin the walk from. The default is to use       push_head! and therefore the HEAD commit and all its ancestors.     * range: A range of GitHashs in the format oid1..oid2. f will be       applied to all commits between the two.     * by: The sorting method. The default is not to sort. Other options are to sort by       topology (LibGit2.Consts.SORT_TOPOLOGICAL), to sort forwards in time       (LibGit2.Consts.SORT_TIME, most ancient first) or to sort backwards in time       (LibGit2.Consts.SORT_REVERSE, most recent first).     * rev: Whether to reverse the sorted order (for instance, if topological sorting is used).\n\nExamples\n\noids = LibGit2.with(LibGit2.GitRevWalker(repo)) do walker\n    LibGit2.map((oid, repo)->string(oid), walker, by=LibGit2.Consts.SORT_TIME)\nend\n\nHere, LibGit2.map visits each commit using the GitRevWalker and finds its GitHash.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.mirror_callback","page":"LibGit2","title":"LibGit2.mirror_callback","text":"Mirror callback function\n\nFunction sets +refs/*:refs/* refspecs and mirror flag for remote reference.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.mirror_cb","page":"LibGit2","title":"LibGit2.mirror_cb","text":"C function pointer for mirror_callback\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.message","page":"LibGit2","title":"LibGit2.message","text":"message(c::GitCommit, raw::Bool=false)\n\nReturn the commit message describing the changes made in commit c. If raw is false, return a slightly \"cleaned up\" message (which has any leading newlines removed). If raw is true, the message is not stripped of any such newlines.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.merge_analysis","page":"LibGit2","title":"LibGit2.merge_analysis","text":"merge_analysis(repo::GitRepo, anns::Vector{GitAnnotated}) -> analysis, preference\n\nRun analysis on the branches pointed to by the annotated branch tips anns and determine under what circumstances they can be merged. For instance, if anns[1] is simply an ancestor of ann[2], then merge_analysis will report that a fast-forward merge is possible.\n\nReturn two outputs, analysis and preference. analysis has several possible values:     * MERGE_ANALYSIS_NONE: it is not possible to merge the elements of anns.     * MERGE_ANALYSIS_NORMAL: a regular merge, when HEAD and the commits that the       user wishes to merge have all diverged from a common ancestor. In this case the       changes have to be resolved and conflicts may occur.     * MERGE_ANALYSIS_UP_TO_DATE: all the input commits the user wishes to merge can       be reached from HEAD, so no merge needs to be performed.     * MERGE_ANALYSIS_FASTFORWARD: the input commit is a descendant of HEAD and so no       merge needs to be performed - instead, the user can simply checkout the       input commit(s).     * MERGE_ANALYSIS_UNBORN: the HEAD of the repository refers to a commit which does not       exist. It is not possible to merge, but it may be possible to checkout the input       commits. preference also has several possible values:     * MERGE_PREFERENCE_NONE: the user has no preference.     * MERGE_PREFERENCE_NO_FASTFORWARD: do not allow any fast-forward merges.     * MERGE_PREFERENCE_FASTFORWARD_ONLY: allow only fast-forward merges and no       other type (which may introduce conflicts). preference can be controlled through the repository or global git configuration.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.name","page":"LibGit2","title":"LibGit2.name","text":"LibGit2.name(ref::GitReference)\n\nReturn the full name of ref.\n\n\n\n\n\nname(rmt::GitRemote)\n\nGet the name of a remote repository, for instance \"origin\". If the remote is anonymous (see GitRemoteAnon) the name will be an empty string \"\".\n\nExamples\n\njulia> repo_url = \"https://github.com/JuliaLang/Example.jl\";\n\njulia> repo = LibGit2.clone(cache_repo, \"test_directory\");\n\njulia> remote = LibGit2.GitRemote(repo, \"origin\", repo_url);\n\njulia> name(remote)\n\"origin\"\n\n\n\n\n\nLibGit2.name(tag::GitTag)\n\nThe name of tag (e.g. \"v0.5\").\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.need_update","page":"LibGit2","title":"LibGit2.need_update","text":"need_update(repo::GitRepo)\n\nEquivalent to git update-index. Return true if repo needs updating.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.objtype","page":"LibGit2","title":"LibGit2.objtype","text":"objtype(obj_type::Consts.OBJECT)\n\nReturn the type corresponding to the enum value.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.path","page":"LibGit2","title":"LibGit2.path","text":"LibGit2.path(repo::GitRepo)\n\nReturn the base file path of the repository repo.\n\nfor normal repositories, this will typically be the parent directory of the \".git\" directory (note: this may be different than the working directory, see workdir for more details).\nfor bare repositories, this is the location of the \"git\" files.\n\nSee also gitdir, workdir.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.peel","page":"LibGit2","title":"LibGit2.peel","text":"peel([T,] ref::GitReference)\n\nRecursively peel ref until an object of type T is obtained. If no T is provided, then ref will be peeled until an object other than a GitTag is obtained.\n\nA GitTag will be peeled to the object it references.\nA GitCommit will be peeled to a GitTree.\n\nnote: Note\nOnly annotated tags can be peeled to GitTag objects. Lightweight tags (the default) are references under refs/tags/ which point directly to GitCommit objects.\n\n\n\n\n\npeel([T,] obj::GitObject)\n\nRecursively peel obj until an object of type T is obtained. If no T is provided, then obj will be peeled until the type changes.\n\nA GitTag will be peeled to the object it references.\nA GitCommit will be peeled to a GitTree.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.posixpath","page":"LibGit2","title":"LibGit2.posixpath","text":"LibGit2.posixpath(path)\n\nStandardise the path string path to use POSIX separators.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.push","page":"LibGit2","title":"LibGit2.push","text":"push(rmt::GitRemote, refspecs; force::Bool=false, options::PushOptions=PushOptions())\n\nPush to the specified rmt remote git repository, using refspecs to determine which remote branch(es) to push to. The keyword arguments are:\n\nforce: if true, a force-push will occur, disregarding conflicts.\noptions: determines the options for the push, e.g. which proxy headers to use. See PushOptions for more information.\n\nnote: Note\nYou can add information about the push refspecs in two other ways: by setting an option in the repository's GitConfig (with push.default as the key) or by calling add_push!. Otherwise you will need to explicitly specify a push refspec in the call to push for it to have any effect, like so: LibGit2.push(repo, refspecs=[\"refs/heads/master\"]).\n\n\n\n\n\npush(repo::GitRepo; kwargs...)\n\nPushes updates to an upstream of repo.\n\nThe keyword arguments are:\n\nremote::AbstractString=\"origin\": the name of the upstream remote to push to.\nremoteurl::AbstractString=\"\": the URL of remote.\nrefspecs=AbstractString[]: determines properties of the push.\nforce::Bool=false: determines if the push will be a force push,  overwriting the remote branch.\ncredentials=nothing: provides credentials and/or settings when authenticating against  a private remote.\ncallbacks=Callbacks(): user provided callbacks and payloads.\n\nEquivalent to git push [<remoteurl>|<repo>] [<refspecs>].\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.push!-Tuple{LibGit2.GitRevWalker, LibGit2.GitHash}","page":"LibGit2","title":"LibGit2.push!","text":"LibGit2.push!(w::GitRevWalker, cid::GitHash)\n\nStart the GitRevWalker walker at commit cid. This function can be used to apply a function to all commits since a certain year, by passing the first commit of that year as cid and then passing the resulting w to LibGit2.map.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/LibGit2.html#LibGit2.push_head!","page":"LibGit2","title":"LibGit2.push_head!","text":"LibGit2.push_head!(w::GitRevWalker)\n\nPush the HEAD commit and its ancestors onto the GitRevWalker w. This ensures that HEAD and all its ancestor commits will be encountered during the walk.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.push_refspecs","page":"LibGit2","title":"LibGit2.push_refspecs","text":"push_refspecs(rmt::GitRemote) -> Vector{String}\n\nGet the push refspecs for the specified rmt. These refspecs contain information about which branch(es) to push to.\n\nExamples\n\njulia> remote = LibGit2.get(LibGit2.GitRemote, repo, \"upstream\");\n\njulia> LibGit2.add_push!(repo, remote, \"refs/heads/master\");\n\njulia> close(remote);\n\njulia> remote = LibGit2.get(LibGit2.GitRemote, repo, \"upstream\");\n\njulia> LibGit2.push_refspecs(remote)\nString[\"refs/heads/master\"]\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.raw","page":"LibGit2","title":"LibGit2.raw","text":"raw(id::GitHash) -> Vector{UInt8}\n\nObtain the raw bytes of the GitHash as a vector of length 20.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.read_tree!","page":"LibGit2","title":"LibGit2.read_tree!","text":"LibGit2.read_tree!(idx::GitIndex, tree::GitTree)\nLibGit2.read_tree!(idx::GitIndex, treehash::AbstractGitHash)\n\nRead the tree tree (or the tree pointed to by treehash in the repository owned by idx) into the index idx. The current index contents will be replaced.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.rebase!","page":"LibGit2","title":"LibGit2.rebase!","text":"LibGit2.rebase!(repo::GitRepo, upstream::AbstractString=\"\", newbase::AbstractString=\"\")\n\nAttempt an automatic merge rebase of the current branch, from upstream if provided, or otherwise from the upstream tracking branch. newbase is the branch to rebase onto. By default this is upstream.\n\nIf any conflicts arise which cannot be automatically resolved, the rebase will abort, leaving the repository and working tree in its original state, and the function will throw a GitError. This is roughly equivalent to the following command line statement:\n\ngit rebase --merge [<upstream>]\nif [ -d \".git/rebase-merge\" ]; then\n    git rebase --abort\nfi\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.ref_list","page":"LibGit2","title":"LibGit2.ref_list","text":"LibGit2.ref_list(repo::GitRepo) -> Vector{String}\n\nGet a list of all reference names in the repo repository.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.reftype","page":"LibGit2","title":"LibGit2.reftype","text":"LibGit2.reftype(ref::GitReference) -> Cint\n\nReturn a Cint corresponding to the type of ref:\n\n0 if the reference is invalid\n1 if the reference is an object id\n2 if the reference is symbolic\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.remotes","page":"LibGit2","title":"LibGit2.remotes","text":"LibGit2.remotes(repo::GitRepo)\n\nReturn a vector of the names of the remotes of repo.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.remove!","page":"LibGit2","title":"LibGit2.remove!","text":"remove!(repo::GitRepo, files::AbstractString...)\nremove!(idx::GitIndex, files::AbstractString...)\n\nRemove all the files with paths specified by files in the index idx (or the index of the repo).\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.reset","page":"LibGit2","title":"LibGit2.reset","text":"reset(val::Integer, flag::Integer)\n\nUnset the bits of val indexed by flag, returning them to 0.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.reset!","page":"LibGit2","title":"LibGit2.reset!","text":"reset!(payload, [config]) -> CredentialPayload\n\nReset the payload state back to the initial values so that it can be used again within the credential callback. If a config is provided the configuration will also be updated.\n\n\n\n\n\nUpdates some entries, determined by the pathspecs, in the index from the target commit tree.\n\n\n\n\n\nSets the current head to the specified commit oid and optionally resets the index and working tree to match.\n\n\n\n\n\ngit reset [<committish>] [–] <pathspecs>... \n\n\n\n\n\nreset!(repo::GitRepo, id::GitHash, mode::Cint=Consts.RESET_MIXED)\n\nReset the repository repo to its state at id, using one of three modes set by mode:\n\nConsts.RESET_SOFT - move HEAD to id.\nConsts.RESET_MIXED - default, move HEAD to id and reset the index to id.\nConsts.RESET_HARD - move HEAD to id, reset the index to id, and discard all working changes.\n\nExamples\n\n# fetch changes\nLibGit2.fetch(repo)\nisfile(joinpath(repo_path, our_file)) # will be false\n\n# fastforward merge the changes\nLibGit2.merge!(repo, fastforward=true)\n\n# because there was not any file locally, but there is\n# a file remotely, we need to reset the branch\nhead_oid = LibGit2.head_oid(repo)\nnew_head = LibGit2.reset!(repo, head_oid, LibGit2.Consts.RESET_HARD)\n\nIn this example, the remote which is being fetched from does have a file called our_file in its index, which is why we must reset.\n\nEquivalent to git reset [--soft | --mixed | --hard] <id>.\n\nExamples\n\nrepo = LibGit2.GitRepo(repo_path)\nhead_oid = LibGit2.head_oid(repo)\nopen(joinpath(repo_path, \"file1\"), \"w\") do f\n    write(f, \"111\n\")\nend\nLibGit2.add!(repo, \"file1\")\nmode = LibGit2.Consts.RESET_HARD\n# will discard the changes to file1\n# and unstage it\nnew_head = LibGit2.reset!(repo, head_oid, mode)\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.restore","page":"LibGit2","title":"LibGit2.restore","text":"restore(s::State, repo::GitRepo)\n\nReturn a repository repo to a previous State s, for example the HEAD of a branch before a merge attempt. s can be generated using the snapshot function.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.revcount","page":"LibGit2","title":"LibGit2.revcount","text":"LibGit2.revcount(repo::GitRepo, commit1::AbstractString, commit2::AbstractString)\n\nList the number of revisions between commit1 and commit2 (committish OIDs in string form). Since commit1 and commit2 may be on different branches, revcount performs a \"left-right\" revision list (and count), returning a tuple of Ints - the number of left and right commits, respectively. A left (or right) commit refers to which side of a symmetric difference in a tree the commit is reachable from.\n\nEquivalent to git rev-list --left-right --count <commit1> <commit2>.\n\nExamples\n\nrepo = LibGit2.GitRepo(repo_path)\nrepo_file = open(joinpath(repo_path, test_file), \"a\")\nprintln(repo_file, \"hello world\")\nflush(repo_file)\nLibGit2.add!(repo, test_file)\ncommit_oid1 = LibGit2.commit(repo, \"commit 1\")\nprintln(repo_file, \"hello world again\")\nflush(repo_file)\nLibGit2.add!(repo, test_file)\ncommit_oid2 = LibGit2.commit(repo, \"commit 2\")\nLibGit2.revcount(repo, string(commit_oid1), string(commit_oid2))\n\nThis will return (-1, 0).\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.set_remote_url","page":"LibGit2","title":"LibGit2.set_remote_url","text":"set_remote_url(repo::GitRepo, remote_name, url)\nset_remote_url(repo::String, remote_name, url)\n\nSet both the fetch and push url for remote_name for the GitRepo or the git repository located at path. Typically git repos use \"origin\" as the remote name.\n\nExamples\n\nrepo_path = joinpath(tempdir(), \"Example\")\nrepo = LibGit2.init(repo_path)\nLibGit2.set_remote_url(repo, \"upstream\", \"https://github.com/JuliaLang/Example.jl\")\nLibGit2.set_remote_url(repo_path, \"upstream2\", \"https://github.com/JuliaLang/Example2.jl\")\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.shortname","page":"LibGit2","title":"LibGit2.shortname","text":"LibGit2.shortname(ref::GitReference)\n\nReturn a shortened version of the name of ref that's \"human-readable\".\n\njulia> repo = GitRepo(path_to_repo);\n\njulia> branch_ref = LibGit2.head(repo);\n\njulia> LibGit2.name(branch_ref)\n\"refs/heads/master\"\n\njulia> LibGit2.shortname(branch_ref)\n\"master\"\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.snapshot","page":"LibGit2","title":"LibGit2.snapshot","text":"snapshot(repo::GitRepo) -> State\n\nTake a snapshot of the current state of the repository repo, storing the current HEAD, index, and any uncommitted work. The output State can be used later during a call to restore to return the repository to the snapshotted state.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.split_cfg_entry","page":"LibGit2","title":"LibGit2.split_cfg_entry","text":"LibGit2.split_cfg_entry(ce::LibGit2.ConfigEntry) -> Tuple{String,String,String,String}\n\nBreak the ConfigEntry up to the following pieces: section, subsection, name, and value.\n\nExamples\n\nGiven the git configuration file containing:\n\n[credential \"https://example.com\"]\n    username = me\n\nThe ConfigEntry would look like the following:\n\njulia> entry\nConfigEntry(\"credential.https://example.com.username\", \"me\")\n\njulia> LibGit2.split_cfg_entry(entry)\n(\"credential\", \"https://example.com\", \"username\", \"me\")\n\nRefer to the git config syntax documentation for more details.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.status","page":"LibGit2","title":"LibGit2.status","text":"LibGit2.status(repo::GitRepo, path::String) -> Union{Cuint, Cvoid}\n\nLookup the status of the file at path in the git repository repo. For instance, this can be used to check if the file at path has been modified and needs to be staged and committed.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.stage","page":"LibGit2","title":"LibGit2.stage","text":"stage(ie::IndexEntry) -> Cint\n\nGet the stage number of ie. The stage number 0 represents the current state of the working tree, but other numbers can be used in the case of a merge conflict. In such a case, the various stage numbers on an IndexEntry describe which side(s) of the conflict the current state of the file belongs to. Stage 0 is the state before the attempted merge, stage 1 is the changes which have been made locally, stages 2 and larger are for changes from other branches (for instance, in the case of a multi-branch \"octopus\" merge, stages 2, 3, and 4 might be used).\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.tag_create","page":"LibGit2","title":"LibGit2.tag_create","text":"LibGit2.tag_create(repo::GitRepo, tag::AbstractString, commit; kwargs...)\n\nCreate a new git tag tag (e.g. \"v0.5\") in the repository repo, at the commit commit.\n\nThe keyword arguments are:\n\nmsg::AbstractString=\"\": the message for the tag.\nforce::Bool=false: if true, existing references will be overwritten.\nsig::Signature=Signature(repo): the tagger's signature.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.tag_delete","page":"LibGit2","title":"LibGit2.tag_delete","text":"LibGit2.tag_delete(repo::GitRepo, tag::AbstractString)\n\nRemove the git tag tag from the repository repo.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.tag_list","page":"LibGit2","title":"LibGit2.tag_list","text":"LibGit2.tag_list(repo::GitRepo) -> Vector{String}\n\nGet a list of all tags in the git repository repo.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.target","page":"LibGit2","title":"LibGit2.target","text":"LibGit2.target(tag::GitTag)\n\nThe GitHash of the target object of tag.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.toggle","page":"LibGit2","title":"LibGit2.toggle","text":"toggle(val::Integer, flag::Integer)\n\nFlip the bits of val indexed by flag, so that if a bit is 0 it will be 1 after the toggle, and vice-versa.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.transact","page":"LibGit2","title":"LibGit2.transact","text":"transact(f::Function, repo::GitRepo)\n\nApply function f to the git repository repo, taking a snapshot before applying f. If an error occurs within f, repo will be returned to its snapshot state using restore. The error which occurred will be rethrown, but the state of repo will not be corrupted.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.treewalk","page":"LibGit2","title":"LibGit2.treewalk","text":"treewalk(f, tree::GitTree, post::Bool=false)\n\nTraverse the entries in tree and its subtrees in post or pre order. Preorder means beginning at the root and then traversing the leftmost subtree (and recursively on down through that subtree's leftmost subtrees) and moving right through the subtrees. Postorder means beginning at the bottom of the leftmost subtree, traversing upwards through it, then traversing the next right subtree (again beginning at the bottom) and finally visiting the tree root last of all.\n\nThe function parameter f should have following signature:\n\n(String, GitTreeEntry) -> Cint\n\nA negative value returned from f stops the tree walk. A positive value means that the entry will be skipped if post is false.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.upstream","page":"LibGit2","title":"LibGit2.upstream","text":"upstream(ref::GitReference) -> Union{GitReference, Nothing}\n\nDetermine if the branch containing ref has a specified upstream branch.\n\nReturn either a GitReference to the upstream branch if it exists, or nothing if the requested branch does not have an upstream counterpart.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.update!","page":"LibGit2","title":"LibGit2.update!","text":"update!(repo::GitRepo, files::AbstractString...)\nupdate!(idx::GitIndex, files::AbstractString...)\n\nUpdate all the files with paths specified by files in the index idx (or the index of the repo). Match the state of each file in the index with the current state on disk, removing it if it has been removed on disk, or updating its entry in the object database.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.url","page":"LibGit2","title":"LibGit2.url","text":"url(rmt::GitRemote)\n\nGet the fetch URL of a remote git repository.\n\nExamples\n\njulia> repo_url = \"https://github.com/JuliaLang/Example.jl\";\n\njulia> repo = LibGit2.init(mktempdir());\n\njulia> remote = LibGit2.GitRemote(repo, \"origin\", repo_url);\n\njulia> LibGit2.url(remote)\n\"https://github.com/JuliaLang/Example.jl\"\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.version","page":"LibGit2","title":"LibGit2.version","text":"version() -> VersionNumber\n\nReturn the version of libgit2 in use, as a VersionNumber.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.with","page":"LibGit2","title":"LibGit2.with","text":"with(f::Function, obj)\n\nResource management helper function. Applies f to obj, making sure to call close on obj after f successfully returns or throws an error. Ensures that allocated git resources are finalized as soon as they are no longer needed.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.with_warn","page":"LibGit2","title":"LibGit2.with_warn","text":"with_warn(f::Function, ::Type{T}, args...)\n\nResource management helper function. Apply f to args, first constructing an instance of type T from args. Makes sure to call close on the resulting object after f successfully returns or throws an error. Ensures that allocated git resources are finalized as soon as they are no longer needed. If an error is thrown by f, a warning is shown containing the error.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.workdir","page":"LibGit2","title":"LibGit2.workdir","text":"LibGit2.workdir(repo::GitRepo)\n\nReturn the location of the working directory of repo. This will throw an error for bare repositories.\n\nnote: Note\nThis will typically be the parent directory of gitdir(repo), but can be different in some cases: e.g. if either the core.worktree configuration variable or the GIT_WORK_TREE environment variable is set.\n\nSee also gitdir, path.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.GitObject-Tuple{LibGit2.GitTreeEntry}","page":"LibGit2","title":"LibGit2.GitObject","text":"(::Type{T})(te::GitTreeEntry) where T<:GitObject\n\nGet the git object to which te refers and return it as its actual type (the type entrytype would show), for instance a GitBlob or GitTag.\n\nExamples\n\ntree = LibGit2.GitTree(repo, \"HEAD^{tree}\")\ntree_entry = tree[1]\nblob = LibGit2.GitBlob(tree_entry)\n\n\n\n\n\n","category":"method"},{"location":"stdlib/LibGit2.html#LibGit2.UserPasswordCredential","page":"LibGit2","title":"LibGit2.UserPasswordCredential","text":"Credential that support only user and password parameters\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.SSHCredential","page":"LibGit2","title":"LibGit2.SSHCredential","text":"SSH credential type\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.isfilled","page":"LibGit2","title":"LibGit2.isfilled","text":"isfilled(cred::AbstractCredential) -> Bool\n\nVerifies that a credential is ready for use in authentication.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.CachedCredentials","page":"LibGit2","title":"LibGit2.CachedCredentials","text":"Caches credential information for re-use\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.CredentialPayload","page":"LibGit2","title":"LibGit2.CredentialPayload","text":"LibGit2.CredentialPayload\n\nRetains the state between multiple calls to the credential callback for the same URL. A CredentialPayload instance is expected to be reset! whenever it will be used with a different URL.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/LibGit2.html#LibGit2.approve","page":"LibGit2","title":"LibGit2.approve","text":"approve(payload::CredentialPayload; shred::Bool=true) -> Nothing\n\nStore the payload credential for re-use in a future authentication. Should only be called when authentication was successful.\n\nThe shred keyword controls whether sensitive information in the payload credential field should be destroyed. Should only be set to false during testing.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.reject","page":"LibGit2","title":"LibGit2.reject","text":"reject(payload::CredentialPayload; shred::Bool=true) -> Nothing\n\nDiscard the payload credential from begin re-used in future authentication. Should only be called when authentication was unsuccessful.\n\nThe shred keyword controls whether sensitive information in the payload credential field should be destroyed. Should only be set to false during testing.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/LibGit2.html#LibGit2.Consts.GIT_CONFIG","page":"LibGit2","title":"LibGit2.Consts.GIT_CONFIG","text":"Priority level of a config file.\n\nThese priority levels correspond to the natural escalation logic (from higher to lower) when searching for config entries in git.\n\nCONFIG_LEVEL_DEFAULT - Open the global, XDG and system configuration files if any available.\nCONFIG_LEVEL_PROGRAMDATA - System-wide on Windows, for compatibility with portable git\nCONFIG_LEVEL_SYSTEM - System-wide configuration file; /etc/gitconfig on Linux systems\nCONFIG_LEVEL_XDG - XDG compatible configuration file; typically ~/.config/git/config\nCONFIG_LEVEL_GLOBAL - User-specific configuration file (also called Global configuration file); typically ~/.gitconfig\nCONFIG_LEVEL_LOCAL - Repository specific configuration file; $WORK_DIR/.git/config on non-bare repos\nCONFIG_LEVEL_APP - Application specific configuration file; freely defined by applications\nCONFIG_HIGHEST_LEVEL - Represents the highest level available config file (i.e. the most specific config file available that actually is loaded)\n\n\n\n\n\n","category":"type"},{"location":"base/punctuation.html#man-punctuation","page":"Punctuation","title":"Punctuation","text":"","category":"section"},{"location":"base/punctuation.html","page":"Punctuation","title":"Punctuation","text":"Extended documentation for mathematical symbols & functions is here.","category":"page"},{"location":"base/punctuation.html","page":"Punctuation","title":"Punctuation","text":"symbol meaning\n@ the at-sign marks a macro invocation; optionally followed by an argument list\n! an exclamation mark is a prefix operator for logical negation (\"not\")\na! function names that end with an exclamation mark modify one or more of their arguments by convention\n# the number sign (or hash or pound) character begins single line comments\n#= when followed by an equals sign, it begins a multi-line comment (these are nestable)\n=# end a multi-line comment by immediately preceding the number sign with an equals sign\n$ the dollar sign is used for string and expression interpolation\n% the percent symbol is the remainder operator\n^ the caret is the exponentiation operator\n& single ampersand is bitwise and\n&& double ampersands is short-circuiting boolean and\n| single pipe character is bitwise or\n|| double pipe characters is short-circuiting boolean or\n⊻ the unicode xor character is bitwise exclusive or\n~ the tilde is an operator for bitwise not\n' a trailing apostrophe is the adjoint (that is, the complex transpose) operator Aᴴ\n* the asterisk is used for multiplication, including matrix multiplication and string concatenation\n/ forward slash divides the argument on its left by the one on its right\n\\ backslash operator divides the argument on its right by the one on its left, commonly used to solve matrix equations\n() parentheses with no arguments constructs an empty Tuple\n(a,...) parentheses with comma-separated arguments constructs a tuple containing its arguments\n(a=1,...) parentheses with comma-separated assignments constructs a NamedTuple\n(x;y) parentheses can also be used to group one or more semicolon separated expressions\na[] array indexing (calling getindex or setindex!)\n[,] vector literal constructor (calling vect)\n[;] vertical concatenation (calling vcat or hvcat)\n[    ] with space-separated expressions, horizontal concatenation (calling hcat or hvcat)\nT{ } curly braces following a type list that type's parameters\n{} curly braces can also be used to group multiple where expressions in function declarations\n; semicolons separate statements, begin a list of keyword arguments in function declarations or calls, or are used to separate array literals for vertical concatenation\n, commas separate function arguments or tuple or array components\n? the question mark delimits the ternary conditional operator (used like: conditional ? if_true : if_false)\n\" \" the single double-quote character delimits String literals\n\"\"\" \"\"\" three double-quote characters delimits string literals that may contain \" and ignore leading indentation\n' ' the single-quote character delimits Char (that is, character) literals\n` ` the backtick character delimits external process (Cmd) literals\nA... triple periods are a postfix operator that \"splat\" their arguments' contents into many arguments of a function call or declare a varargs function that \"slurps\" up many arguments into a single tuple\na.b single periods access named fields in objects/modules (calling getproperty or setproperty!)\nf.() periods may also prefix parentheses (like f.(...)) or infix operators (like .+) to perform the function element-wise (calling broadcast)\na:b colons (:) used as a binary infix operator construct a range from a to b (inclusive) with fixed step size 1\na:s:b colons (:) used as a ternary infix operator construct a range from a to b (inclusive) with step size s\n: when used by themselves, Colons represent all indices within a dimension, frequently combined with indexing\n:: double-colons represent a type annotation or typeassert, depending on context, frequently used when declaring function arguments\n:( ) quoted expression\n:a Symbol a\n<: subtype operator\n>: supertype operator (reverse of subtype operator)\n= single equals sign is assignment\n== double equals sign is value equality comparison\n=== triple equals sign is programmatically identical equality comparison\n=> right arrow using an equals sign defines a Pair typically used to populate dictionaries\n-> right arrow using a hyphen defines an anonymous function on a single line\n|> pipe operator passes output from the left argument to input of the right argument, usually a function\n∘ function composition operator (typed with \\circ{tab}) combines two functions as though they are a single larger function\n_ underscores may be assigned values which will not be saved, often used to ignore multiple return values or create repetitive comprehensions","category":"page"},{"location":"devdocs/build/linux.html#Linux","page":"Linux","title":"Linux","text":"","category":"section"},{"location":"devdocs/build/linux.html","page":"Linux","title":"Linux","text":"GCC version 4.7 or later is required to build Julia.\nTo use external shared libraries not in the system library search path, set USE_SYSTEM_XXX=1 and LDFLAGS=-Wl,-rpath,/path/to/dir/contains/libXXX.so in Make.user.\nInstead of setting LDFLAGS, putting the library directory into the environment variable LD_LIBRARY_PATH (at both compile and run time) also works.\nThe USE_SYSTEM_* flags should be used with caution. These are meant only for troubleshooting, porting, and packaging, where package maintainers work closely with the Julia developers to make sure that Julia is built correctly. Production use cases should use the officially provided binaries. Issues arising from the use of these flags will generally not be accepted.\nSee also the external dependencies.","category":"page"},{"location":"devdocs/build/linux.html#Architecture-Customization","page":"Linux","title":"Architecture Customization","text":"","category":"section"},{"location":"devdocs/build/linux.html","page":"Linux","title":"Linux","text":"Julia can be built for a non-generic architecture by configuring the ARCH Makefile variable in a Make.user file. See the appropriate section of Make.inc for additional customization options, such as MARCH and JULIA_CPU_TARGET.","category":"page"},{"location":"devdocs/build/linux.html","page":"Linux","title":"Linux","text":"For example, to build for Pentium 4, set MARCH=pentium4 and install the necessary system libraries for linking. On Ubuntu, these may include lib32gfortran-6-dev, lib32gcc1, and lib32stdc++6, among others.","category":"page"},{"location":"devdocs/build/linux.html","page":"Linux","title":"Linux","text":"You can also set MARCH=native in Make.user for a maximum-performance build customized for the current machine CPU.","category":"page"},{"location":"devdocs/build/linux.html#Linux-Build-Troubleshooting","page":"Linux","title":"Linux Build Troubleshooting","text":"","category":"section"},{"location":"devdocs/build/linux.html","page":"Linux","title":"Linux","text":"Problem Possible Solution\nOpenBLAS build failure Set one of the following build options in Make.user and build again: <ul><li> OPENBLAS_TARGET_ARCH=BARCELONA (AMD CPUs) or OPENBLAS_TARGET_ARCH=NEHALEM (Intel CPUs)<ul>Set OPENBLAS_DYNAMIC_ARCH = 0 to disable compiling multiple architectures in a single binary.</ul></li><li> OPENBLAS_NO_AVX2 = 1 disables AVX2 instructions, allowing OpenBLAS to compile with OPENBLAS_DYNAMIC_ARCH = 1 using old versions of binutils </li><li> USE_SYSTEM_BLAS=1 uses the system provided libblas <ul><li>Set LIBBLAS=-lopenblas and LIBBLASNAME=libopenblas to force the use of the system provided OpenBLAS when multiple BLAS versions are installed. </li></ul></li></ul><p> If you get an error that looks like ../kernel/x86_64/dgemm_kernel_4x4_haswell.S:1709: Error: no such instruction: `vpermpd $ 0xb1,%ymm0,%ymm0', then you need to set OPENBLAS_DYNAMIC_ARCH = 0 or OPENBLAS_NO_AVX2 = 1, or you need a newer version of binutils (2.18 or newer). (Issue #7653)</p><p> If the linker cannot find gfortran and you get an error like julia /usr/bin/x86_64-linux-gnu-ld: cannot find -lgfortran, check the path with gfortran -print-file-name=libgfortran.so and use the output to export something similar to this: export LDFLAGS=-L/usr/lib/gcc/x86_64-linux-gnu/8/. See Issue #6150.</p>\nIllegal Instruction error Check if your CPU supports AVX while your OS does not (e.g. through virtualization, as described in this issue).","category":"page"},{"location":"manual/multi-threading.html#man-multithreading","page":"Multi-Threading","title":"Multi-Threading","text":"","category":"section"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Visit this blog post for a presentation of Julia multi-threading features.","category":"page"},{"location":"manual/multi-threading.html#Starting-Julia-with-multiple-threads","page":"Multi-Threading","title":"Starting Julia with multiple threads","text":"","category":"section"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"By default, Julia starts up with a single thread of execution. This can be verified by using the command Threads.nthreads():","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"julia> Threads.nthreads()\n1","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"The number of execution threads is controlled either by using the -t/--threads command line argument or by using the JULIA_NUM_THREADS environment variable. When both are specified, then -t/--threads takes precedence.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"The number of threads can either be specified as an integer (--threads=4) or as auto (--threads=auto), where auto tries to infer a useful default number of threads to use (see Command-line Options for more details).","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"compat: Julia 1.5\nThe -t/--threads command line argument requires at least Julia 1.5. In older versions you must use the environment variable instead.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"compat: Julia 1.7\nUsing auto as value of the environment variable JULIA_NUM_THREADS requires at least Julia 1.7. In older versions, this value is ignored.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Lets start Julia with 4 threads:","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"$ julia --threads 4","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Let's verify there are 4 threads at our disposal.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"julia> Threads.nthreads()\n4","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"But we are currently on the master thread. To check, we use the function Threads.threadid","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"julia> Threads.threadid()\n1","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"note: Note\nIf you prefer to use the environment variable you can set it as follows in Bash (Linux/macOS):export JULIA_NUM_THREADS=4C shell on Linux/macOS, CMD on Windows:set JULIA_NUM_THREADS=4Powershell on Windows:$env:JULIA_NUM_THREADS=4Note that this must be done before starting Julia.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"note: Note\nThe number of threads specified with -t/--threads is propagated to worker processes that are spawned using the -p/--procs or --machine-file command line options. For example, julia -p2 -t2 spawns 1 main process with 2 worker processes, and all three processes have 2 threads enabled. For more fine grained control over worker threads use addprocs and pass -t/--threads as exeflags.","category":"page"},{"location":"manual/multi-threading.html#Multiple-GC-Threads","page":"Multi-Threading","title":"Multiple GC Threads","text":"","category":"section"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"The Garbage Collector (GC) can use multiple threads. The amount used is either half the number of compute worker threads or configured by either the --gcthreads command line argument or by using the JULIA_NUM_GC_THREADS environment variable.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"compat: Julia 1.10\nThe --gcthreads command line argument requires at least Julia 1.10.","category":"page"},{"location":"manual/multi-threading.html#man-threadpools","page":"Multi-Threading","title":"Threadpools","text":"","category":"section"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"When a program's threads are busy with many tasks to run, tasks may experience delays which may negatively affect the responsiveness and interactivity of the program. To address this, you can specify that a task is interactive when you Threads.@spawn it:","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"using Base.Threads\n@spawn :interactive f()","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Interactive tasks should avoid performing high latency operations, and if they are long duration tasks, should yield frequently.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Julia may be started with one or more threads reserved to run interactive tasks:","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"$ julia --threads 3,1","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"The environment variable JULIA_NUM_THREADS can also be used similarly:","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"export JULIA_NUM_THREADS=3,1","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"This starts Julia with 3 threads in the :default threadpool and 1 thread in the :interactive threadpool:","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"julia> using Base.Threads\n\njulia> nthreadpools()\n2\n\njulia> threadpool() # the main thread is in the interactive thread pool\n:interactive\n\njulia> nthreads(:default)\n3\n\njulia> nthreads(:interactive)\n1\n\njulia> nthreads()\n3","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"note: Note\nThe zero-argument version of nthreads returns the number of threads in the default pool.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"note: Note\nDepending on whether Julia has been started with interactive threads, the main thread is either in the default or interactive thread pool.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Either or both numbers can be replaced with the word auto, which causes Julia to choose a reasonable default.","category":"page"},{"location":"manual/multi-threading.html#The-@threads-Macro","page":"Multi-Threading","title":"The @threads Macro","text":"","category":"section"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Let's work a simple example using our native threads. Let us create an array of zeros:","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"julia> a = zeros(10)\n10-element Vector{Float64}:\n 0.0\n 0.0\n 0.0\n 0.0\n 0.0\n 0.0\n 0.0\n 0.0\n 0.0\n 0.0","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Let us operate on this array simultaneously using 4 threads. We'll have each thread write its thread ID into each location.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Julia supports parallel loops using the Threads.@threads macro. This macro is affixed in front of a for loop to indicate to Julia that the loop is a multi-threaded region:","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"julia> Threads.@threads for i = 1:10\n           a[i] = Threads.threadid()\n       end","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"The iteration space is split among the threads, after which each thread writes its thread ID to its assigned locations:","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"julia> a\n10-element Vector{Float64}:\n 1.0\n 1.0\n 1.0\n 2.0\n 2.0\n 2.0\n 3.0\n 3.0\n 4.0\n 4.0","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Note that Threads.@threads does not have an optional reduction parameter like @distributed.","category":"page"},{"location":"manual/multi-threading.html#Using-@threads-without-data-races","page":"Multi-Threading","title":"Using @threads without data-races","text":"","category":"section"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"The concept of a data-race is elaborated on in \"Communication and data races between threads\". For now, just known that a data race can result in incorrect results and dangerous errors.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Lets say we want to make the function sum_single below multithreaded.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"julia> function sum_single(a)\n           s = 0\n           for i in a\n               s += i\n           end\n           s\n       end\nsum_single (generic function with 1 method)\n\njulia> sum_single(1:1_000_000)\n500000500000","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Simply adding @threads exposes a data race with multiple threads reading and writing s at the same time.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"julia> function sum_multi_bad(a)\n           s = 0\n           Threads.@threads for i in a\n               s += i\n           end\n           s\n       end\nsum_multi_bad (generic function with 1 method)\n\njulia> sum_multi_bad(1:1_000_000)\n70140554652","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Note that the result is not 500000500000 as it should be, and will most likely change each evaluation.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"To fix this, buffers that are specific to the task may be used to segment the sum into chunks that are race-free. Here sum_single is reused, with its own internal buffer s. The input vector a is split into nthreads() chunks for parallel work. We then use Threads.@spawn to create tasks that individually sum each chunk. Finally, we sum the results from each task using sum_single again:","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"julia> function sum_multi_good(a)\n           chunks = Iterators.partition(a, length(a) ÷ Threads.nthreads())\n           tasks = map(chunks) do chunk\n               Threads.@spawn sum_single(chunk)\n           end\n           chunk_sums = fetch.(tasks)\n           return sum_single(chunk_sums)\n       end\nsum_multi_good (generic function with 1 method)\n\njulia> sum_multi_good(1:1_000_000)\n500000500000","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"note: Note\nBuffers should not be managed based on threadid() i.e. buffers = zeros(Threads.nthreads()) because concurrent tasks can yield, meaning multiple concurrent tasks may use the same buffer on a given thread, introducing risk of data races. Further, when more than one thread is available tasks may change thread at yield points, which is known as task migration.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Another option is the use of atomic operations on variables shared across tasks/threads, which may be more performant depending on the characteristics of the operations.","category":"page"},{"location":"manual/multi-threading.html#man-communication-and-data-races","page":"Multi-Threading","title":"Communication and data-races between threads","text":"","category":"section"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Although Julia's threads can communicate through shared memory, it is notoriously difficult to write correct and data-race free multi-threaded code. Julia's Channels are thread-safe and may be used to communicate safely. There are also sections below that explain how to use locks and atomics to avoid data-races.","category":"page"},{"location":"manual/multi-threading.html#Data-race-freedom","page":"Multi-Threading","title":"Data-race freedom","text":"","category":"section"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"You are entirely responsible for ensuring that your program is data-race free, and nothing promised here can be assumed if you do not observe that requirement. The observed results may be highly unintuitive.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"If data-races are introduced, Julia is not memory safe. Be very careful about reading any data if another thread might write to it, as it could result in segmentation faults or worse. Below are a couple of unsafe ways to access global variables from different threads:","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Thread 1:\nglobal b = false\nglobal a = rand()\nglobal b = true\n\nThread 2:\nwhile !b; end\nbad_read1(a) # it is NOT safe to access `a` here!\n\nThread 3:\nwhile !@isdefined(a); end\nbad_read2(a) # it is NOT safe to access `a` here","category":"page"},{"location":"manual/multi-threading.html#man-using-locks","page":"Multi-Threading","title":"Using locks to avoid data-races","text":"","category":"section"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"An important tool to avoid data-races, and thereby write thread-safe code, is the concept of a \"lock\". A lock can be locked and unlocked. If a thread has locked a lock, and not unlocked it, it is said to \"hold\" the lock. If there is only one lock, and we write code the requires holding the lock to access some data, we can ensure that multiple threads will never access the same data simultaneously. Note that the link between a lock and a variable is made by the programmer, and not the program.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"For example, we can create a lock my_lock, and lock it while we mutate a variable my_variable. This is done most simply with the @lock macro:","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"julia> my_lock = ReentrantLock();\n\njulia> my_variable = [1, 2, 3];\n\njulia> @lock my_lock my_variable[1] = 100\n100","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"By using a similar pattern with the same lock and variable, but on another thread, the operations are free from data-races.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"We could have performed the operation above with the functional version of lock, in the following two ways:","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"julia> lock(my_lock) do\n           my_variable[1] = 100\n       end\n100\n\njulia> begin\n           lock(my_lock)\n           try\n               my_variable[1] = 100\n           finally\n               unlock(my_lock)\n           end\n       end\n100","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"All three options are equivalent. Note how the final version requires an explicit try-block to ensure that the lock is always unlocked, whereas the first two version do this internally. One should always use the lock pattern above when changing data (such as assigning to a global or closure variable) accessed by other threads. Failing to do this could have unforeseen and serious consequences.","category":"page"},{"location":"manual/multi-threading.html#man-atomic-operations","page":"Multi-Threading","title":"Atomic Operations","text":"","category":"section"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Julia supports accessing and modifying values atomically, that is, in a thread-safe way to avoid race conditions. A value (which must be of a primitive type) can be wrapped as Threads.Atomic to indicate it must be accessed in this way. Here we can see an example:","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"julia> i = Threads.Atomic{Int}(0);\n\njulia> ids = zeros(4);\n\njulia> old_is = zeros(4);\n\njulia> Threads.@threads for id in 1:4\n           old_is[id] = Threads.atomic_add!(i, id)\n           ids[id] = id\n       end\n\njulia> old_is\n4-element Vector{Float64}:\n 0.0\n 1.0\n 7.0\n 3.0\n\njulia> i[]\n 10\n\njulia> ids\n4-element Vector{Float64}:\n 1.0\n 2.0\n 3.0\n 4.0","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Had we tried to do the addition without the atomic tag, we might have gotten the wrong answer due to a race condition. An example of what would happen if we didn't avoid the race:","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"julia> using Base.Threads\n\njulia> Threads.nthreads()\n4\n\njulia> acc = Ref(0)\nBase.RefValue{Int64}(0)\n\njulia> @threads for i in 1:1000\n          acc[] += 1\n       end\n\njulia> acc[]\n926\n\njulia> acc = Atomic{Int64}(0)\nAtomic{Int64}(0)\n\njulia> @threads for i in 1:1000\n          atomic_add!(acc, 1)\n       end\n\njulia> acc[]\n1000","category":"page"},{"location":"manual/multi-threading.html#man-atomics","page":"Multi-Threading","title":"Per-field atomics","text":"","category":"section"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"We can also use atomics on a more granular level using the @atomic, @atomicswap, @atomicreplace macros, and @atomiconce macros.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Specific details of the memory model and other details of the design are written in the Julia Atomics Manifesto, which will later be published formally.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Any field in a struct declaration can be decorated with @atomic, and then any write must be marked with @atomic also, and must use one of the defined atomic orderings (:monotonic, :acquire, :release, :acquire_release, or :sequentially_consistent). Any read of an atomic field can also be annotated with an atomic ordering constraint, or will be done with monotonic (relaxed) ordering if unspecified.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"compat: Julia 1.7\nPer-field atomics requires at least Julia 1.7.","category":"page"},{"location":"manual/multi-threading.html#Side-effects-and-mutable-function-arguments","page":"Multi-Threading","title":"Side effects and mutable function arguments","text":"","category":"section"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"When using multi-threading we have to be careful when using functions that are not pure as we might get a wrong answer. For instance functions that have a name ending with ! by convention modify their arguments and thus are not pure.","category":"page"},{"location":"manual/multi-threading.html#@threadcall","page":"Multi-Threading","title":"@threadcall","text":"","category":"section"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"External libraries, such as those called via ccall, pose a problem for Julia's task-based I/O mechanism. If a C library performs a blocking operation, that prevents the Julia scheduler from executing any other tasks until the call returns. (Exceptions are calls into custom C code that call back into Julia, which may then yield, or C code that calls jl_yield(), the C equivalent of yield.)","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"The @threadcall macro provides a way to avoid stalling execution in such a scenario. It schedules a C function for execution in a separate thread. A threadpool with a default size of 4 is used for this. The size of the threadpool is controlled via environment variable UV_THREADPOOL_SIZE. While waiting for a free thread, and during function execution once a thread is available, the requesting task (on the main Julia event loop) yields to other tasks. Note that @threadcall does not return until the execution is complete. From a user point of view, it is therefore a blocking call like other Julia APIs.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"It is very important that the called function does not call back into Julia, as it will segfault.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"@threadcall may be removed/changed in future versions of Julia.","category":"page"},{"location":"manual/multi-threading.html#Caveats","page":"Multi-Threading","title":"Caveats","text":"","category":"section"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"At this time, most operations in the Julia runtime and standard libraries can be used in a thread-safe manner, if the user code is data-race free. However, in some areas work on stabilizing thread support is ongoing. Multi-threaded programming has many inherent difficulties, and if a program using threads exhibits unusual or undesirable behavior (e.g. crashes or mysterious results), thread interactions should typically be suspected first.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"There are a few specific limitations and warnings to be aware of when using threads in Julia:","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Base collection types require manual locking if used simultaneously by multiple threads where at least one thread modifies the collection (common examples include push! on arrays, or inserting items into a Dict).\nThe schedule used by @spawn is nondeterministic and should not be relied on.\nCompute-bound, non-memory-allocating tasks can prevent garbage collection from running in other threads that are allocating memory. In these cases it may be necessary to insert a manual call to GC.safepoint() to allow GC to run. This limitation will be removed in the future.\nAvoid running top-level operations, e.g. include, or eval of type, method, and module definitions in parallel.\nBe aware that finalizers registered by a library may break if threads are enabled. This may require some transitional work across the ecosystem before threading can be widely adopted with confidence. See the section on the safe use of finalizers for further details.","category":"page"},{"location":"manual/multi-threading.html#man-task-migration","page":"Multi-Threading","title":"Task Migration","text":"","category":"section"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"After a task starts running on a certain thread it may move to a different thread if the task yields.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Such tasks may have been started with @spawn or @threads, although the :static schedule option for @threads does freeze the threadid.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"This means that in most cases threadid() should not be treated as constant within a task, and therefore should not be used to index into a vector of buffers or stateful objects.","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"compat: Julia 1.7\nTask migration was introduced in Julia 1.7. Before this tasks always remained on the same thread that they were started on.","category":"page"},{"location":"manual/multi-threading.html#man-finalizers","page":"Multi-Threading","title":"Safe use of Finalizers","text":"","category":"section"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"Because finalizers can interrupt any code, they must be very careful in how they interact with any global state. Unfortunately, the main reason that finalizers are used is to update global state (a pure function is generally rather pointless as a finalizer). This leads us to a bit of a conundrum. There are a few approaches to dealing with this problem:","category":"page"},{"location":"manual/multi-threading.html","page":"Multi-Threading","title":"Multi-Threading","text":"When single-threaded, code could call the internal jl_gc_enable_finalizers C function to prevent finalizers from being scheduled inside a critical region. Internally, this is used inside some functions (such as our C locks) to prevent recursion when doing certain operations (incremental package loading, codegen, etc.). The combination of a lock and this flag can be used to make finalizers safe.\nA second strategy, employed by Base in a couple places, is to explicitly delay a finalizer until it may be able to acquire its lock non-recursively. The following example demonstrates how this strategy could be applied to Distributed.finalize_ref:\nfunction finalize_ref(r::AbstractRemoteRef)\n    if r.where > 0 # Check if the finalizer is already run\n        if islocked(client_refs) || !trylock(client_refs)\n            # delay finalizer for later if we aren't free to acquire the lock\n            finalizer(finalize_ref, r)\n            return nothing\n        end\n        try # `lock` should always be followed by `try`\n            if r.where > 0 # Must check again here\n                # Do actual cleanup here\n                r.where = 0\n            end\n        finally\n            unlock(client_refs)\n        end\n    end\n    nothing\nend\nA related third strategy is to use a yield-free queue. We don't currently have a lock-free queue implemented in Base, but Base.IntrusiveLinkedListSynchronized{T} is suitable. This can frequently be a good strategy to use for code with event loops. For example, this strategy is employed by Gtk.jl to manage lifetime ref-counting. In this approach, we don't do any explicit work inside the finalizer, and instead add it to a queue to run at a safer time. In fact, Julia's task scheduler already uses this, so defining the finalizer as x -> @spawn do_cleanup(x) is one example of this approach. Note however that this doesn't control which thread do_cleanup runs on, so do_cleanup would still need to acquire a lock. That doesn't need to be true if you implement your own queue, as you can explicitly only drain that queue from your thread.","category":"page"},{"location":"manual/methods.html#Methods","page":"Methods","title":"Methods","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Recall from Functions that a function is an object that maps a tuple of arguments to a return value, or throws an exception if no appropriate value can be returned. It is common for the same conceptual function or operation to be implemented quite differently for different types of arguments: adding two integers is very different from adding two floating-point numbers, both of which are distinct from adding an integer to a floating-point number. Despite their implementation differences, these operations all fall under the general concept of \"addition\". Accordingly, in Julia, these behaviors all belong to a single object: the + function.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"To facilitate using many different implementations of the same concept smoothly, functions need not be defined all at once, but can rather be defined piecewise by providing specific behaviors for certain combinations of argument types and counts. A definition of one possible behavior for a function is called a method. Thus far, we have presented only examples of functions defined with a single method, applicable to all types of arguments. However, the signatures of method definitions can be annotated to indicate the types of arguments in addition to their number, and more than a single method definition may be provided. When a function is applied to a particular tuple of arguments, the most specific method applicable to those arguments is applied. Thus, the overall behavior of a function is a patchwork of the behaviors of its various method definitions. If the patchwork is well designed, even though the implementations of the methods may be quite different, the outward behavior of the function will appear seamless and consistent.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"The choice of which method to execute when a function is applied is called dispatch. Julia allows the dispatch process to choose which of a function's methods to call based on the number of arguments given, and on the types of all of the function's arguments. This is different than traditional object-oriented languages, where dispatch occurs based only on the first argument, which often has a special argument syntax, and is sometimes implied rather than explicitly written as an argument. [1] Using all of a function's arguments to choose which method should be invoked, rather than just the first, is known as multiple dispatch. Multiple dispatch is particularly useful for mathematical code, where it makes little sense to artificially deem the operations to \"belong\" to one argument more than any of the others: does the addition operation in x + y belong to x any more than it does to y? The implementation of a mathematical operator generally depends on the types of all of its arguments. Even beyond mathematical operations, however, multiple dispatch ends up being a powerful and convenient paradigm for structuring and organizing programs.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"[1]: In C++ or Java, for example, in a method call like obj.meth(arg1,arg2), the object obj \"receives\" the method call and is implicitly passed to the method via the this keyword, rather than as an explicit method argument. When the current this object is the receiver of a method call, it can be omitted altogether, writing just meth(arg1,arg2), with this implied as the receiving object.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"note: Note\nAll the examples in this chapter assume that you are defining methods for a function in the same module. If you want to add methods to a function in another module, you have to import it or use the name qualified with module names. See the section on namespace management.","category":"page"},{"location":"manual/methods.html#Defining-Methods","page":"Methods","title":"Defining Methods","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Until now, we have, in our examples, defined only functions with a single method having unconstrained argument types. Such functions behave just like they would in traditional dynamically typed languages. Nevertheless, we have used multiple dispatch and methods almost continually without being aware of it: all of Julia's standard functions and operators, like the aforementioned + function, have many methods defining their behavior over various possible combinations of argument type and count.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"When defining a function, one can optionally constrain the types of parameters it is applicable to, using the :: type-assertion operator, introduced in the section on Composite Types:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> f(x::Float64, y::Float64) = 2x + y\nf (generic function with 1 method)","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"This function definition applies only to calls where x and y are both values of type Float64:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> f(2.0, 3.0)\n7.0","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Applying it to any other types of arguments will result in a MethodError:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> f(2.0, 3)\nERROR: MethodError: no method matching f(::Float64, ::Int64)\nThe function `f` exists, but no method is defined for this combination of argument types.\n\nClosest candidates are:\n  f(::Float64, !Matched::Float64)\n   @ Main none:1\n\nStacktrace:\n[...]\n\njulia> f(Float32(2.0), 3.0)\nERROR: MethodError: no method matching f(::Float32, ::Float64)\nThe function `f` exists, but no method is defined for this combination of argument types.\n\nClosest candidates are:\n  f(!Matched::Float64, ::Float64)\n   @ Main none:1\n\nStacktrace:\n[...]\n\njulia> f(2.0, \"3.0\")\nERROR: MethodError: no method matching f(::Float64, ::String)\nThe function `f` exists, but no method is defined for this combination of argument types.\n\nClosest candidates are:\n  f(::Float64, !Matched::Float64)\n   @ Main none:1\n\nStacktrace:\n[...]\n\njulia> f(\"2.0\", \"3.0\")\nERROR: MethodError: no method matching f(::String, ::String)\nThe function `f` exists, but no method is defined for this combination of argument types.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"As you can see, the arguments must be precisely of type Float64. Other numeric types, such as integers or 32-bit floating-point values, are not automatically converted to 64-bit floating-point, nor are strings parsed as numbers. Because Float64 is a concrete type and concrete types cannot be subclassed in Julia, such a definition can only be applied to arguments that are exactly of type Float64. It may often be useful, however, to write more general methods where the declared parameter types are abstract:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> f(x::Number, y::Number) = 2x - y\nf (generic function with 2 methods)\n\njulia> f(2.0, 3)\n1.0","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"This method definition applies to any pair of arguments that are instances of Number. They need not be of the same type, so long as they are each numeric values. The problem of handling disparate numeric types is delegated to the arithmetic operations in the expression 2x - y.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"To define a function with multiple methods, one simply defines the function multiple times, with different numbers and types of arguments. The first method definition for a function creates the function object, and subsequent method definitions add new methods to the existing function object. The most specific method definition matching the number and types of the arguments will be executed when the function is applied. Thus, the two method definitions above, taken together, define the behavior for f over all pairs of instances of the abstract type Number – but with a different behavior specific to pairs of Float64 values. If one of the arguments is a 64-bit float but the other one is not, then the f(Float64,Float64) method cannot be called and the more general f(Number,Number) method must be used:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> f(2.0, 3.0)\n7.0\n\njulia> f(2, 3.0)\n1.0\n\njulia> f(2.0, 3)\n1.0\n\njulia> f(2, 3)\n1","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"The 2x + y definition is only used in the first case, while the 2x - y definition is used in the others. No automatic casting or conversion of function arguments is ever performed: all conversion in Julia is non-magical and completely explicit. Conversion and Promotion, however, shows how clever application of sufficiently advanced technology can be indistinguishable from magic. [Clarke61]","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"For non-numeric values, and for fewer or more than two arguments, the function f remains undefined, and applying it will still result in a MethodError:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> f(\"foo\", 3)\nERROR: MethodError: no method matching f(::String, ::Int64)\nThe function `f` exists, but no method is defined for this combination of argument types.\n\nClosest candidates are:\n  f(!Matched::Number, ::Number)\n   @ Main none:1\n  f(!Matched::Float64, !Matched::Float64)\n   @ Main none:1\n\nStacktrace:\n[...]\n\njulia> f()\nERROR: MethodError: no method matching f()\nThe function `f` exists, but no method is defined for this combination of argument types.\n\nClosest candidates are:\n  f(!Matched::Float64, !Matched::Float64)\n   @ Main none:1\n  f(!Matched::Number, !Matched::Number)\n   @ Main none:1\n\nStacktrace:\n[...]","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"You can easily see which methods exist for a function by entering the function object itself in an interactive session:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> f\nf (generic function with 2 methods)","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"This output tells us that f is a function object with two methods. To find out what the signatures of those methods are, use the methods function:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> methods(f)\n# 2 methods for generic function \"f\" from Main:\n [1] f(x::Float64, y::Float64)\n     @ none:1\n [2] f(x::Number, y::Number)\n     @ none:1","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"which shows that f has two methods, one taking two Float64 arguments and one taking arguments of type Number. It also indicates the file and line number where the methods were defined: because these methods were defined at the REPL, we get the apparent line number none:1.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"In the absence of a type declaration with ::, the type of a method parameter is Any by default, meaning that it is unconstrained since all values in Julia are instances of the abstract type Any. Thus, we can define a catch-all method for f like so:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> f(x,y) = println(\"Whoa there, Nelly.\")\nf (generic function with 3 methods)\n\njulia> methods(f)\n# 3 methods for generic function \"f\" from Main:\n [1] f(x::Float64, y::Float64)\n     @ none:1\n [2] f(x::Number, y::Number)\n     @ none:1\n [3] f(x, y)\n     @ none:1\n\njulia> f(\"foo\", 1)\nWhoa there, Nelly.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"This catch-all is less specific than any other possible method definition for a pair of parameter values, so it will only be called on pairs of arguments to which no other method definition applies.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Note that in the signature of the third method, there is no type specified for the arguments x and y. This is a shortened way of expressing f(x::Any, y::Any).","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Although it seems a simple concept, multiple dispatch on the types of values is perhaps the single most powerful and central feature of the Julia language. Core operations typically have dozens of methods:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> methods(+)\n# 180 methods for generic function \"+\":\n[1] +(x::Bool, z::Complex{Bool}) in Base at complex.jl:227\n[2] +(x::Bool, y::Bool) in Base at bool.jl:89\n[3] +(x::Bool) in Base at bool.jl:86\n[4] +(x::Bool, y::T) where T<:AbstractFloat in Base at bool.jl:96\n[5] +(x::Bool, z::Complex) in Base at complex.jl:234\n[6] +(a::Float16, b::Float16) in Base at float.jl:373\n[7] +(x::Float32, y::Float32) in Base at float.jl:375\n[8] +(x::Float64, y::Float64) in Base at float.jl:376\n[9] +(z::Complex{Bool}, x::Bool) in Base at complex.jl:228\n[10] +(z::Complex{Bool}, x::Real) in Base at complex.jl:242\n[11] +(x::Char, y::Integer) in Base at char.jl:40\n[12] +(c::BigInt, x::BigFloat) in Base.MPFR at mpfr.jl:307\n[13] +(a::BigInt, b::BigInt, c::BigInt, d::BigInt, e::BigInt) in Base.GMP at gmp.jl:392\n[14] +(a::BigInt, b::BigInt, c::BigInt, d::BigInt) in Base.GMP at gmp.jl:391\n[15] +(a::BigInt, b::BigInt, c::BigInt) in Base.GMP at gmp.jl:390\n[16] +(x::BigInt, y::BigInt) in Base.GMP at gmp.jl:361\n[17] +(x::BigInt, c::Union{UInt16, UInt32, UInt64, UInt8}) in Base.GMP at gmp.jl:398\n...\n[180] +(a, b, c, xs...) in Base at operators.jl:424","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Multiple dispatch together with the flexible parametric type system give Julia its ability to abstractly express high-level algorithms decoupled from implementation details.","category":"page"},{"location":"manual/methods.html#man-method-specializations","page":"Methods","title":"Method specializations","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"When you create multiple methods of the same function, this is sometimes called \"specialization.\" In this case, you're specializing the function by adding additional methods to it: each new method is a new specialization of the function. As shown above, these specializations are returned by methods.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"There's another kind of specialization that occurs without programmer intervention: Julia's compiler can automatically specialize the method for the specific argument types used. Such specializations are not listed by methods, as this doesn't create new Methods, but tools like @code_typed allow you to inspect such specializations.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"For example, if you create a method","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"mysum(x::Real, y::Real) = x + y","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"you've given the function mysum one new method (possibly its only method), and that method takes any pair of Real number inputs. But if you then execute","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> mysum(1, 2)\n3\n\njulia> mysum(1.0, 2.0)\n3.0","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Julia will compile mysum twice, once for x::Int, y::Int and again for x::Float64, y::Float64. The point of compiling twice is performance: the methods that get called for + (which mysum uses) vary depending on the specific types of x and y, and by compiling different specializations Julia can do all the method lookup ahead of time. This allows the program to run much more quickly, since it does not have to bother with method lookup while it is running. Julia's automatic specialization allows you to write generic algorithms and expect that the compiler will generate efficient, specialized code to handle each case you need.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"In cases where the number of potential specializations might be effectively unlimited, Julia may avoid this default specialization. See Be aware of when Julia avoids specializing for more information.","category":"page"},{"location":"manual/methods.html#man-ambiguities","page":"Methods","title":"Method Ambiguities","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"It is possible to define a set of function methods such that there is no unique most specific method applicable to some combinations of arguments:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> g(x::Float64, y) = 2x + y\ng (generic function with 1 method)\n\njulia> g(x, y::Float64) = x + 2y\ng (generic function with 2 methods)\n\njulia> g(2.0, 3)\n7.0\n\njulia> g(2, 3.0)\n8.0\n\njulia> g(2.0, 3.0)\nERROR: MethodError: g(::Float64, ::Float64) is ambiguous.\n\nCandidates:\n  g(x, y::Float64)\n    @ Main none:1\n  g(x::Float64, y)\n    @ Main none:1\n\nPossible fix, define\n  g(::Float64, ::Float64)\n\nStacktrace:\n[...]","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Here the call g(2.0, 3.0) could be handled by either the g(::Float64, ::Any) or the g(::Any, ::Float64) method. The order in which the methods are defined does not matter and neither is more specific than the other. In such cases, Julia raises a MethodError rather than arbitrarily picking a method. You can avoid method ambiguities by specifying an appropriate method for the intersection case:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> g(x::Float64, y::Float64) = 2x + 2y\ng (generic function with 3 methods)\n\njulia> g(2.0, 3)\n7.0\n\njulia> g(2, 3.0)\n8.0\n\njulia> g(2.0, 3.0)\n10.0","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"It is recommended that the disambiguating method be defined first, since otherwise the ambiguity exists, if transiently, until the more specific method is defined.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"In more complex cases, resolving method ambiguities involves a certain element of design; this topic is explored further below.","category":"page"},{"location":"manual/methods.html#Parametric-Methods","page":"Methods","title":"Parametric Methods","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Method definitions can optionally have type parameters qualifying the signature:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> same_type(x::T, y::T) where {T} = true\nsame_type (generic function with 1 method)\n\njulia> same_type(x,y) = false\nsame_type (generic function with 2 methods)","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"The first method applies whenever both arguments are of the same concrete type, regardless of what type that is, while the second method acts as a catch-all, covering all other cases. Thus, overall, this defines a boolean function that checks whether its two arguments are of the same type:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> same_type(1, 2)\ntrue\n\njulia> same_type(1, 2.0)\nfalse\n\njulia> same_type(1.0, 2.0)\ntrue\n\njulia> same_type(\"foo\", 2.0)\nfalse\n\njulia> same_type(\"foo\", \"bar\")\ntrue\n\njulia> same_type(Int32(1), Int64(2))\nfalse","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Such definitions correspond to methods whose type signatures are UnionAll types (see UnionAll Types).","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"This kind of definition of function behavior by dispatch is quite common – idiomatic, even – in Julia. Method type parameters are not restricted to being used as the types of arguments: they can be used anywhere a value would be in the signature of the function or body of the function. Here's an example where the method type parameter T is used as the type parameter to the parametric type Vector{T} in the method signature:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> function myappend(v::Vector{T}, x::T) where {T}\n           return [v..., x]\n       end\nmyappend (generic function with 1 method)","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"The type parameter T in this example ensures that the added element x is a subtype of the existing eltype of the vector v. The where keyword introduces a list of those constraints after the method signature definition. This works the same for one-line definitions, as seen above, and must appear before the return type declaration, if present, as illustrated below:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> (myappend(v::Vector{T}, x::T)::Vector) where {T} = [v..., x]\nmyappend (generic function with 1 method)\n\njulia> myappend([1,2,3],4)\n4-element Vector{Int64}:\n 1\n 2\n 3\n 4\n\njulia> myappend([1,2,3],2.5)\nERROR: MethodError: no method matching myappend(::Vector{Int64}, ::Float64)\nThe function `myappend` exists, but no method is defined for this combination of argument types.\n\nClosest candidates are:\n  myappend(::Vector{T}, !Matched::T) where T\n   @ Main none:1\n\nStacktrace:\n[...]\n\njulia> myappend([1.0,2.0,3.0],4.0)\n4-element Vector{Float64}:\n 1.0\n 2.0\n 3.0\n 4.0\n\njulia> myappend([1.0,2.0,3.0],4)\nERROR: MethodError: no method matching myappend(::Vector{Float64}, ::Int64)\nThe function `myappend` exists, but no method is defined for this combination of argument types.\n\nClosest candidates are:\n  myappend(::Vector{T}, !Matched::T) where T\n   @ Main none:1\n\nStacktrace:\n[...]","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"If the type of the appended element does not match the element type of the vector it is appended to, a MethodError is raised. In the following example, the method's type parameter T is used as the return value:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> mytypeof(x::T) where {T} = T\nmytypeof (generic function with 1 method)\n\njulia> mytypeof(1)\nInt64\n\njulia> mytypeof(1.0)\nFloat64","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Just as you can put subtype constraints on type parameters in type declarations (see Parametric Types), you can also constrain type parameters of methods:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> same_type_numeric(x::T, y::T) where {T<:Number} = true\nsame_type_numeric (generic function with 1 method)\n\njulia> same_type_numeric(x::Number, y::Number) = false\nsame_type_numeric (generic function with 2 methods)\n\njulia> same_type_numeric(1, 2)\ntrue\n\njulia> same_type_numeric(1, 2.0)\nfalse\n\njulia> same_type_numeric(1.0, 2.0)\ntrue\n\njulia> same_type_numeric(\"foo\", 2.0)\nERROR: MethodError: no method matching same_type_numeric(::String, ::Float64)\nThe function `same_type_numeric` exists, but no method is defined for this combination of argument types.\n\nClosest candidates are:\n  same_type_numeric(!Matched::T, ::T) where T<:Number\n   @ Main none:1\n  same_type_numeric(!Matched::Number, ::Number)\n   @ Main none:1\n\nStacktrace:\n[...]\n\njulia> same_type_numeric(\"foo\", \"bar\")\nERROR: MethodError: no method matching same_type_numeric(::String, ::String)\nThe function `same_type_numeric` exists, but no method is defined for this combination of argument types.\n\njulia> same_type_numeric(Int32(1), Int64(2))\nfalse","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"The same_type_numeric function behaves much like the same_type function defined above, but is only defined for pairs of numbers.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Parametric methods allow the same syntax as where expressions used to write types (see UnionAll Types). If there is only a single parameter, the enclosing curly braces (in where {T}) can be omitted, but are often preferred for clarity. Multiple parameters can be separated with commas, e.g. where {T, S<:Real}, or written using nested where, e.g. where S<:Real where T.","category":"page"},{"location":"manual/methods.html#Redefining-Methods","page":"Methods","title":"Redefining Methods","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"When redefining a method or adding new methods, it is important to realize that these changes don't take effect immediately. This is key to Julia's ability to statically infer and compile code to run fast, without the usual JIT tricks and overhead. Indeed, any new method definition won't be visible to the current runtime environment, including Tasks and Threads (and any previously defined @generated functions). Let's start with an example to see what this means:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> function tryeval()\n           @eval newfun() = 1\n           newfun()\n       end\ntryeval (generic function with 1 method)\n\njulia> tryeval()\nERROR: MethodError: no method matching newfun()\nThe applicable method may be too new: running in world age xxxx1, while current world is xxxx2.\nClosest candidates are:\n  newfun() at none:1 (method too new to be called from this world context.)\n in tryeval() at none:1\n ...\n\njulia> newfun()\n1","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"In this example, observe that the new definition for newfun has been created, but can't be immediately called. The new global is immediately visible to the tryeval function, so you could write return newfun (without parentheses). But neither you, nor any of your callers, nor the functions they call, or etc. can call this new method definition!","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"But there's an exception: future calls to newfun from the REPL work as expected, being able to both see and call the new definition of newfun.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"However, future calls to tryeval will continue to see the definition of newfun as it was at the previous statement at the REPL, and thus before that call to tryeval.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"You may want to try this for yourself to see how it works.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"The implementation of this behavior is a \"world age counter\". This monotonically increasing value tracks each method definition operation. This allows describing \"the set of method definitions visible to a given runtime environment\" as a single number, or \"world age\". It also allows comparing the methods available in two worlds just by comparing their ordinal value. In the example above, we see that the \"current world\" (in which the method newfun exists), is one greater than the task-local \"runtime world\" that was fixed when the execution of tryeval started.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Sometimes it is necessary to get around this (for example, if you are implementing the above REPL). Fortunately, there is an easy solution: call the function using Base.invokelatest:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> function tryeval2()\n           @eval newfun2() = 2\n           Base.invokelatest(newfun2)\n       end\ntryeval2 (generic function with 1 method)\n\njulia> tryeval2()\n2","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Finally, let's take a look at some more complex examples where this rule comes into play. Define a function f(x), which initially has one method:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> f(x) = \"original definition\"\nf (generic function with 1 method)","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Start some other operations that use f(x):","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> g(x) = f(x)\ng (generic function with 1 method)\n\njulia> t = @async f(wait()); yield();","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Now we add some new methods to f(x):","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> f(x::Int) = \"definition for Int\"\nf (generic function with 2 methods)\n\njulia> f(x::Type{Int}) = \"definition for Type{Int}\"\nf (generic function with 3 methods)","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Compare how these results differ:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> f(1)\n\"definition for Int\"\n\njulia> g(1)\n\"definition for Int\"\n\njulia> fetch(schedule(t, 1))\n\"original definition\"\n\njulia> t = @async f(wait()); yield();\n\njulia> fetch(schedule(t, 1))\n\"definition for Int\"","category":"page"},{"location":"manual/methods.html#Design-Patterns-with-Parametric-Methods","page":"Methods","title":"Design Patterns with Parametric Methods","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"While complex dispatch logic is not required for performance or usability, sometimes it can be the best way to express some algorithm. Here are a few common design patterns that come up sometimes when using dispatch in this way.","category":"page"},{"location":"manual/methods.html#Extracting-the-type-parameter-from-a-super-type","page":"Methods","title":"Extracting the type parameter from a super-type","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Here is a correct code template for returning the element-type T of any arbitrary subtype of AbstractArray that has well-defined element type:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"abstract type AbstractArray{T, N} end\neltype(::Type{<:AbstractArray{T}}) where {T} = T","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"using so-called triangular dispatch.  Note that UnionAll types, for example eltype(AbstractArray{T} where T <: Integer), do not match the above method. The implementation of eltype in Base adds a fallback method to Any for such cases.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"One common mistake is to try and get the element-type by using introspection:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"eltype_wrong(::Type{A}) where {A<:AbstractArray} = A.parameters[1]","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"However, it is not hard to construct cases where this will fail:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"struct BitVector <: AbstractArray{Bool, 1}; end","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Here we have created a type BitVector which has no parameters, but where the element-type is still fully specified, with T equal to Bool!","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Another mistake is to try to walk up the type hierarchy using supertype:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"eltype_wrong(::Type{AbstractArray{T}}) where {T} = T\neltype_wrong(::Type{AbstractArray{T, N}}) where {T, N} = T\neltype_wrong(::Type{A}) where {A<:AbstractArray} = eltype_wrong(supertype(A))","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"While this works for declared types, it fails for types without supertypes:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> eltype_wrong(Union{AbstractArray{Int}, AbstractArray{Float64}})\nERROR: MethodError: no method matching supertype(::Type{Union{AbstractArray{Float64,N} where N, AbstractArray{Int64,N} where N}})\nClosest candidates are:\n  supertype(::DataType) at operators.jl:43\n  supertype(::UnionAll) at operators.jl:48","category":"page"},{"location":"manual/methods.html#Building-a-similar-type-with-a-different-type-parameter","page":"Methods","title":"Building a similar type with a different type parameter","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"When building generic code, there is often a need for constructing a similar object with some change made to the layout of the type, also necessitating a change of the type parameters. For instance, you might have some sort of abstract array with an arbitrary element type and want to write your computation on it with a specific element type. We must implement a method for each AbstractArray{T} subtype that describes how to compute this type transform. There is no general transform of one subtype into another subtype with a different parameter.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"The subtypes of AbstractArray typically implement two methods to achieve this: A method to convert the input array to a subtype of a specific AbstractArray{T, N} abstract type; and a method to make a new uninitialized array with a specific element type. Sample implementations of these can be found in Julia Base. Here is a basic example usage of them, guaranteeing that input and output are of the same type:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"input = convert(AbstractArray{Eltype}, input)\noutput = similar(input, Eltype)","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"As an extension of this, in cases where the algorithm needs a copy of the input array, convert is insufficient as the return value may alias the original input. Combining similar (to make the output array) and copyto! (to fill it with the input data) is a generic way to express the requirement for a mutable copy of the input argument:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"copy_with_eltype(input, Eltype) = copyto!(similar(input, Eltype), input)","category":"page"},{"location":"manual/methods.html#Iterated-dispatch","page":"Methods","title":"Iterated dispatch","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"In order to dispatch a multi-level parametric argument list, often it is best to separate each level of dispatch into distinct functions. This may sound similar in approach to single-dispatch, but as we shall see below, it is still more flexible.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"For example, trying to dispatch on the element-type of an array will often run into ambiguous situations. Instead, commonly code will dispatch first on the container type, then recurse down to a more specific method based on eltype. In most cases, the algorithms lend themselves conveniently to this hierarchical approach, while in other cases, this rigor must be resolved manually. This dispatching branching can be observed, for example, in the logic to sum two matrices:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"# First dispatch selects the map algorithm for element-wise summation.\n+(a::Matrix, b::Matrix) = map(+, a, b)\n# Then dispatch handles each element and selects the appropriate\n# common element type for the computation.\n+(a, b) = +(promote(a, b)...)\n# Once the elements have the same type, they can be added.\n# For example, via primitive operations exposed by the processor.\n+(a::Float64, b::Float64) = Core.add(a, b)","category":"page"},{"location":"manual/methods.html#Trait-based-dispatch","page":"Methods","title":"Trait-based dispatch","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"A natural extension to the iterated dispatch above is to add a layer to method selection that allows to dispatch on sets of types which are independent from the sets defined by the type hierarchy. We could construct such a set by writing out a Union of the types in question, but then this set would not be extensible as Union-types cannot be altered after creation. However, such an extensible set can be programmed with a design pattern often referred to as a \"Holy-trait\".","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"This pattern is implemented by defining a generic function which computes a different singleton value (or type) for each trait-set to which the function arguments may belong to.  If this function is pure there is no impact on performance compared to normal dispatch.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"The example in the previous section glossed over the implementation details of map and promote, which both operate in terms of these traits. When iterating over a matrix, such as in the implementation of map, one important question is what order to use to traverse the data. When AbstractArray subtypes implement the Base.IndexStyle trait, other functions such as map can dispatch on this information to pick the best algorithm (see Abstract Array Interface). This means that each subtype does not need to implement a custom version of map, since the generic definitions + trait classes will enable the system to select the fastest version. Here is a toy implementation of map illustrating the trait-based dispatch:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"map(f, a::AbstractArray, b::AbstractArray) = map(Base.IndexStyle(a, b), f, a, b)\n# generic implementation:\nmap(::Base.IndexCartesian, f, a::AbstractArray, b::AbstractArray) = ...\n# linear-indexing implementation (faster)\nmap(::Base.IndexLinear, f, a::AbstractArray, b::AbstractArray) = ...","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"This trait-based approach is also present in the promote mechanism employed by the scalar +. It uses promote_type, which returns the optimal common type to compute the operation given the two types of the operands. This makes it possible to reduce the problem of implementing every function for every pair of possible type arguments, to the much smaller problem of implementing a conversion operation from each type to a common type, plus a table of preferred pair-wise promotion rules.","category":"page"},{"location":"manual/methods.html#Output-type-computation","page":"Methods","title":"Output-type computation","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"The discussion of trait-based promotion provides a transition into our next design pattern: computing the output element type for a matrix operation.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"For implementing primitive operations, such as addition, we use the promote_type function to compute the desired output type. (As before, we saw this at work in the promote call in the call to +).","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"For more complex functions on matrices, it may be necessary to compute the expected return type for a more complex sequence of operations. This is often performed by the following steps:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Write a small function op that expresses the set of operations performed by the kernel of the algorithm.\nCompute the element type R of the result matrix as promote_op(op, argument_types...), where argument_types is computed from eltype applied to each input array.\nBuild the output matrix as similar(R, dims), where dims are the desired dimensions of the output array.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"For a more specific example, a generic square-matrix multiply pseudo-code might look like:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"function matmul(a::AbstractMatrix, b::AbstractMatrix)\n    op = (ai, bi) -> ai * bi + ai * bi\n\n    ## this is insufficient because it assumes `one(eltype(a))` is constructable:\n    # R = typeof(op(one(eltype(a)), one(eltype(b))))\n\n    ## this fails because it assumes `a[1]` exists and is representative of all elements of the array\n    # R = typeof(op(a[1], b[1]))\n\n    ## this is incorrect because it assumes that `+` calls `promote_type`\n    ## but this is not true for some types, such as Bool:\n    # R = promote_type(ai, bi)\n\n    # this is wrong, since depending on the return value\n    # of type-inference is very brittle (as well as not being optimizable):\n    # R = Base.return_types(op, (eltype(a), eltype(b)))\n\n    ## but, finally, this works:\n    R = promote_op(op, eltype(a), eltype(b))\n    ## although sometimes it may give a larger type than desired\n    ## it will always give a correct type\n\n    output = similar(b, R, (size(a, 1), size(b, 2)))\n    if size(a, 2) > 0\n        for j in 1:size(b, 2)\n            for i in 1:size(a, 1)\n                ## here we don't use `ab = zero(R)`,\n                ## since `R` might be `Any` and `zero(Any)` is not defined\n                ## we also must declare `ab::R` to make the type of `ab` constant in the loop,\n                ## since it is possible that typeof(a * b) != typeof(a * b + a * b) == R\n                ab::R = a[i, 1] * b[1, j]\n                for k in 2:size(a, 2)\n                    ab += a[i, k] * b[k, j]\n                end\n                output[i, j] = ab\n            end\n        end\n    end\n    return output\nend","category":"page"},{"location":"manual/methods.html#Separate-convert-and-kernel-logic","page":"Methods","title":"Separate convert and kernel logic","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"One way to significantly cut down on compile-times and testing complexity is to isolate the logic for converting to the desired type and the computation. This lets the compiler specialize and inline the conversion logic independent from the rest of the body of the larger kernel.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"This is a common pattern seen when converting from a larger class of types to the one specific argument type that is actually supported by the algorithm:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"complexfunction(arg::Int) = ...\ncomplexfunction(arg::Any) = complexfunction(convert(Int, arg))\n\nmatmul(a::T, b::T) = ...\nmatmul(a, b) = matmul(promote(a, b)...)","category":"page"},{"location":"manual/methods.html#Parametrically-constrained-Varargs-methods","page":"Methods","title":"Parametrically-constrained Varargs methods","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Function parameters can also be used to constrain the number of arguments that may be supplied to a \"varargs\" function (Varargs Functions).  The notation Vararg{T,N} is used to indicate such a constraint.  For example:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> bar(a,b,x::Vararg{Any,2}) = (a,b,x)\nbar (generic function with 1 method)\n\njulia> bar(1,2,3)\nERROR: MethodError: no method matching bar(::Int64, ::Int64, ::Int64)\nThe function `bar` exists, but no method is defined for this combination of argument types.\n\nClosest candidates are:\n  bar(::Any, ::Any, ::Any, !Matched::Any)\n   @ Main none:1\n\nStacktrace:\n[...]\n\njulia> bar(1,2,3,4)\n(1, 2, (3, 4))\n\njulia> bar(1,2,3,4,5)\nERROR: MethodError: no method matching bar(::Int64, ::Int64, ::Int64, ::Int64, ::Int64)\nThe function `bar` exists, but no method is defined for this combination of argument types.\n\nClosest candidates are:\n  bar(::Any, ::Any, ::Any, ::Any)\n   @ Main none:1\n\nStacktrace:\n[...]","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"More usefully, it is possible to constrain varargs methods by a parameter. For example:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"function getindex(A::AbstractArray{T,N}, indices::Vararg{Number,N}) where {T,N}","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"would be called only when the number of indices matches the dimensionality of the array.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"When only the type of supplied arguments needs to be constrained Vararg{T} can be equivalently written as T.... For instance f(x::Int...) = x is a shorthand for f(x::Vararg{Int}) = x.","category":"page"},{"location":"manual/methods.html#Note-on-Optional-and-keyword-Arguments","page":"Methods","title":"Note on Optional and keyword Arguments","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"As mentioned briefly in Functions, optional arguments are implemented as syntax for multiple method definitions. For example, this definition:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"f(a=1,b=2) = a+2b","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"translates to the following three methods:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"f(a,b) = a+2b\nf(a) = f(a,2)\nf() = f(1,2)","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"This means that calling f() is equivalent to calling f(1,2). In this case the result is 5, because f(1,2) invokes the first method of f above. However, this need not always be the case. If you define a fourth method that is more specialized for integers:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"f(a::Int,b::Int) = a-2b","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"then the result of both f() and f(1,2) is -3. In other words, optional arguments are tied to a function, not to any specific method of that function. It depends on the types of the optional arguments which method is invoked. When optional arguments are defined in terms of a global variable, the type of the optional argument may even change at run-time.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Keyword arguments behave quite differently from ordinary positional arguments. In particular, they do not participate in method dispatch. Methods are dispatched based only on positional arguments, with keyword arguments processed after the matching method is identified.","category":"page"},{"location":"manual/methods.html#Function-like-objects","page":"Methods","title":"Function-like objects","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Methods are associated with types, so it is possible to make any arbitrary Julia object \"callable\" by adding methods to its type. (Such \"callable\" objects are sometimes called \"functors.\")","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"For example, you can define a type that stores the coefficients of a polynomial, but behaves like a function evaluating the polynomial:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> struct Polynomial{R}\n           coeffs::Vector{R}\n       end\n\njulia> function (p::Polynomial)(x)\n           v = p.coeffs[end]\n           for i = (length(p.coeffs)-1):-1:1\n               v = v*x + p.coeffs[i]\n           end\n           return v\n       end\n\njulia> (p::Polynomial)() = p(5)","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Notice that the function is specified by type instead of by name. As with normal functions there is a terse syntax form. In the function body, p will refer to the object that was called. A Polynomial can be used as follows:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> p = Polynomial([1,10,100])\nPolynomial{Int64}([1, 10, 100])\n\njulia> p(3)\n931\n\njulia> p()\n2551","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"This mechanism is also the key to how type constructors and closures (inner functions that refer to their surrounding environment) work in Julia.","category":"page"},{"location":"manual/methods.html#Empty-generic-functions","page":"Methods","title":"Empty generic functions","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Occasionally it is useful to introduce a generic function without yet adding methods. This can be used to separate interface definitions from implementations. It might also be done for the purpose of documentation or code readability. The syntax for this is an empty function block without a tuple of arguments:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"function emptyfunc end","category":"page"},{"location":"manual/methods.html#man-method-design-ambiguities","page":"Methods","title":"Method design and the avoidance of ambiguities","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Julia's method polymorphism is one of its most powerful features, yet exploiting this power can pose design challenges.  In particular, in more complex method hierarchies it is not uncommon for ambiguities to arise.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Above, it was pointed out that one can resolve ambiguities like","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"f(x, y::Int) = 1\nf(x::Int, y) = 2","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"by defining a method","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"f(x::Int, y::Int) = 3","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"This is often the right strategy; however, there are circumstances where following this advice mindlessly can be counterproductive. In particular, the more methods a generic function has, the more possibilities there are for ambiguities. When your method hierarchies get more complicated than this simple example, it can be worth your while to think carefully about alternative strategies.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Below we discuss particular challenges and some alternative ways to resolve such issues.","category":"page"},{"location":"manual/methods.html#Tuple-and-NTuple-arguments","page":"Methods","title":"Tuple and NTuple arguments","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Tuple (and NTuple) arguments present special challenges. For example,","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"f(x::NTuple{N,Int}) where {N} = 1\nf(x::NTuple{N,Float64}) where {N} = 2","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"are ambiguous because of the possibility that N == 0: there are no elements to determine whether the Int or Float64 variant should be called. To resolve the ambiguity, one approach is define a method for the empty tuple:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"f(x::Tuple{}) = 3","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Alternatively, for all methods but one you can insist that there is at least one element in the tuple:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"f(x::NTuple{N,Int}) where {N} = 1           # this is the fallback\nf(x::Tuple{Float64, Vararg{Float64}}) = 2   # this requires at least one Float64","category":"page"},{"location":"manual/methods.html#man-methods-orthogonalize","page":"Methods","title":"Orthogonalize your design","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"When you might be tempted to dispatch on two or more arguments, consider whether a \"wrapper\" function might make for a simpler design. For example, instead of writing multiple variants:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"f(x::A, y::A) = ...\nf(x::A, y::B) = ...\nf(x::B, y::A) = ...\nf(x::B, y::B) = ...","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"you might consider defining","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"f(x::A, y::A) = ...\nf(x, y) = f(g(x), g(y))","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"where g converts the argument to type A. This is a very specific example of the more general principle of orthogonal design, in which separate concepts are assigned to separate methods. Here, g will most likely need a fallback definition","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"g(x::A) = x","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"A related strategy exploits promote to bring x and y to a common type:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"f(x::T, y::T) where {T} = ...\nf(x, y) = f(promote(x, y)...)","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"One risk with this design is the possibility that if there is no suitable promotion method converting x and y to the same type, the second method will recurse on itself infinitely and trigger a stack overflow.","category":"page"},{"location":"manual/methods.html#Dispatch-on-one-argument-at-a-time","page":"Methods","title":"Dispatch on one argument at a time","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"If you need to dispatch on multiple arguments, and there are many fallbacks with too many combinations to make it practical to define all possible variants, then consider introducing a \"name cascade\" where (for example) you dispatch on the first argument and then call an internal method:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"f(x::A, y) = _fA(x, y)\nf(x::B, y) = _fB(x, y)","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Then the internal methods _fA and _fB can dispatch on y without concern about ambiguities with each other with respect to x.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Be aware that this strategy has at least one major disadvantage: in many cases, it is not possible for users to further customize the behavior of f by defining further specializations of your exported function f. Instead, they have to define specializations for your internal methods _fA and _fB, and this blurs the lines between exported and internal methods.","category":"page"},{"location":"manual/methods.html#Abstract-containers-and-element-types","page":"Methods","title":"Abstract containers and element types","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Where possible, try to avoid defining methods that dispatch on specific element types of abstract containers. For example,","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"-(A::AbstractArray{T}, b::Date) where {T<:Date}","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"generates ambiguities for anyone who defines a method","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"-(A::MyArrayType{T}, b::T) where {T}","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"The best approach is to avoid defining either of these methods: instead, rely on a generic method -(A::AbstractArray, b) and make sure this method is implemented with generic calls (like similar and -) that do the right thing for each container type and element type separately. This is just a more complex variant of the advice to orthogonalize your methods.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"When this approach is not possible, it may be worth starting a discussion with other developers about resolving the ambiguity; just because one method was defined first does not necessarily mean that it can't be modified or eliminated.  As a last resort, one developer can define the \"band-aid\" method","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"-(A::MyArrayType{T}, b::Date) where {T<:Date} = ...","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"that resolves the ambiguity by brute force.","category":"page"},{"location":"manual/methods.html#Complex-method-\"cascades\"-with-default-arguments","page":"Methods","title":"Complex method \"cascades\" with default arguments","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"If you are defining a method \"cascade\" that supplies defaults, be careful about dropping any arguments that correspond to potential defaults. For example, suppose you're writing a digital filtering algorithm and you have a method that handles the edges of the signal by applying padding:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"function myfilter(A, kernel, ::Replicate)\n    Apadded = replicate_edges(A, size(kernel))\n    myfilter(Apadded, kernel)  # now perform the \"real\" computation\nend","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"This will run afoul of a method that supplies default padding:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"myfilter(A, kernel) = myfilter(A, kernel, Replicate()) # replicate the edge by default","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"Together, these two methods generate an infinite recursion with A constantly growing bigger.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"The better design would be to define your call hierarchy like this:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"struct NoPad end  # indicate that no padding is desired, or that it's already applied\n\nmyfilter(A, kernel) = myfilter(A, kernel, Replicate())  # default boundary conditions\n\nfunction myfilter(A, kernel, ::Replicate)\n    Apadded = replicate_edges(A, size(kernel))\n    myfilter(Apadded, kernel, NoPad())  # indicate the new boundary conditions\nend\n\n# other padding methods go here\n\nfunction myfilter(A, kernel, ::NoPad)\n    # Here's the \"real\" implementation of the core computation\nend","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"NoPad is supplied in the same argument position as any other kind of padding, so it keeps the dispatch hierarchy well organized and with reduced likelihood of ambiguities. Moreover, it extends the \"public\" myfilter interface: a user who wants to control the padding explicitly can call the NoPad variant directly.","category":"page"},{"location":"manual/methods.html#Defining-methods-in-local-scope","page":"Methods","title":"Defining methods in local scope","text":"","category":"section"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"You can define methods within a local scope, for example","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"julia> function f(x)\n           g(y::Int) = y + x\n           g(y) = y - x\n           g\n       end\nf (generic function with 1 method)\n\njulia> h = f(3);\n\njulia> h(4)\n7\n\njulia> h(4.0)\n1.0","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"However, you should not define local methods conditionally or subject to control flow, as in","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"function f2(inc)\n    if inc\n        g(x) = x + 1\n    else\n        g(x) = x - 1\n    end\nend\n\nfunction f3()\n    function g end\n    return g\n    g() = 0\nend","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"as it is not clear what function will end up getting defined. In the future, it might be an error to define local methods in this manner.","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"For cases like this use anonymous functions instead:","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"function f2(inc)\n    g = if inc\n        x -> x + 1\n    else\n        x -> x - 1\n    end\nend","category":"page"},{"location":"manual/methods.html","page":"Methods","title":"Methods","text":"[Clarke61]: Arthur C. Clarke, Profiles of the Future (1961): Clarke's Third Law.","category":"page"},{"location":"manual/command-line-interface.html#cli","page":"Command-line Interface","title":"Command-line Interface","text":"","category":"section"},{"location":"manual/command-line-interface.html#Using-arguments-inside-scripts","page":"Command-line Interface","title":"Using arguments inside scripts","text":"","category":"section"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"When running a script using julia, you can pass additional arguments to your script:","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"$ julia script.jl arg1 arg2...","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"These additional command-line arguments are passed in the global constant ARGS. The name of the script itself is passed in as the global PROGRAM_FILE. Note that ARGS is also set when a Julia expression is given using the -e option on the command line (see the julia help output below) but PROGRAM_FILE will be empty. For example, to just print the arguments given to a script, you could do this:","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"$ julia -e 'println(PROGRAM_FILE); for x in ARGS; println(x); end' foo bar\n\nfoo\nbar","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"Or you could put that code into a script and run it:","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"$ echo 'println(PROGRAM_FILE); for x in ARGS; println(x); end' > script.jl\n$ julia script.jl foo bar\nscript.jl\nfoo\nbar","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"The -- delimiter can be used to separate command-line arguments intended for the script file from arguments intended for Julia:","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"$ julia --color=yes -O -- script.jl arg1 arg2..","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"See also Scripting for more information on writing Julia scripts.","category":"page"},{"location":"manual/command-line-interface.html#The-Main.main-entry-point","page":"Command-line Interface","title":"The Main.main entry point","text":"","category":"section"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"As of Julia, 1.11, Base exports the macro @main. This macro expands to the symbol main, but at the conclusion of executing a script or expression, julia will attempt to execute the function Main.main(ARGS) if such a function has been defined and this behavior was opted into by using the @main macro.","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"This feature is intended to aid in the unification of compiled and interactive workflows. In compiled workflows, loading the code that defines the main function may be spatially and temporally separated from the invocation. However, for interactive workflows, the behavior is equivalent to explicitly calling exit(main(ARGS)) at the end of the evaluated script or expression.","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"compat: Julia 1.11\nThe special entry point Main.main was added in Julia 1.11. For compatibility with prior julia versions, add an explicit @isdefined(var\"@main\") ? (@main) : exit(main(ARGS)) at the end of your scripts.","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"To see this feature in action, consider the following definition, which will execute the print function despite there being no explicit call to main:","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"$ julia -e '(@main)(args) = println(\"Hello World!\")'\nHello World!\n$","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"Only the main binding in the Main module has this behavior and only if the macro @main was used within the defining module.","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"For example, using hello instead of main will not result in the hello function executing:","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"$ julia -e 'hello(ARGS) = println(\"Hello World!\")'\n$","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"and neither will a plain definition of main:","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"$ julia -e 'main(ARGS) = println(\"Hello World!\")'\n$","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"However, the opt-in need not occur at definition time:","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"$ julia -e 'main(ARGS) = println(\"Hello World!\"); @main'\nHello World!\n$","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"The main binding may be imported from a package. A hello world package defined as","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"module Hello\n\nexport main\n(@main)(args) = println(\"Hello from the package!\")\n\nend","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"may be used as:","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"$ julia -e 'using Hello'\nHello from the package!\n$ julia -e 'import Hello' # N.B.: Execution depends on the binding not whether the package is loaded\n$","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"However, note that the current best practice recommendation is to not mix application and reusable library code in the same package. Helper applications may be distributed as separate packages or as scripts with separate main entry points in a package's bin folder.","category":"page"},{"location":"manual/command-line-interface.html#Parallel-mode","page":"Command-line Interface","title":"Parallel mode","text":"","category":"section"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"Julia can be started in parallel mode with either the -p or the --machine-file options. -p n will launch an additional n worker processes, while --machine-file file will launch a worker for each line in file file. The machines defined in file must be accessible via a password-less ssh login, with Julia installed at the same location as the current host. Each machine definition takes the form [count*][user@]host[:port] [bind_addr[:port]]. user defaults to current user, port to the standard ssh port. count is the number of workers to spawn on the node, and defaults to 1. The optional bind-to bind_addr[:port] specifies the IP address and port that other workers should use to connect to this worker.","category":"page"},{"location":"manual/command-line-interface.html#Startup-file","page":"Command-line Interface","title":"Startup file","text":"","category":"section"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"If you have code that you want executed whenever Julia is run, you can put it in ~/.julia/config/startup.jl:","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"$ echo 'println(\"Greetings! 你好! 안녕하세요?\")' > ~/.julia/config/startup.jl\n$ julia\nGreetings! 你好! 안녕하세요?\n\n...","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"Note that although you should have a ~/.julia directory once you've run Julia for the first time, you may need to create the ~/.julia/config folder and the ~/.julia/config/startup.jl file if you use it.","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"To have startup code run only in The Julia REPL (and not when julia is e.g. run on a script), use atreplinit in startup.jl:","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"atreplinit() do repl\n    # ...\nend","category":"page"},{"location":"manual/command-line-interface.html#command-line-interface","page":"Command-line Interface","title":"Command-line switches for Julia","text":"","category":"section"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"There are various ways to run Julia code and provide options, similar to those available for the perl and ruby programs:","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"julia [switches] -- [programfile] [args...]","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"The following is a complete list of command-line switches available when launching julia (a '*' marks the default value, if applicable; settings marked '($)' may trigger package precompilation):","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"Switch Description\n-v, --version Display version information\n-h, --help Print command-line options (this message)\n--help-hidden Print uncommon options not shown by -h\n--project[={<dir>|@.}] Set <dir> as the active project/environment. The default @. option will search through parent directories until a Project.toml or JuliaProject.toml file is found.\n-J, --sysimage <file> Start up with the given system image file\n-H, --home <dir> Set location of julia executable\n--startup-file={yes*|no} Load JULIA_DEPOT_PATH/config/startup.jl; if JULIA_DEPOT_PATH environment variable is unset, load ~/.julia/config/startup.jl\n--handle-signals={yes*|no} Enable or disable Julia's default signal handlers\n--sysimage-native-code={yes*|no} Use native code from system image if available\n--compiled-modules={yes*|no|existing|strict} Enable or disable incremental precompilation of modules. The existing option allows use of existing compiled modules that were previously precompiled, but disallows creation of new precompile files. The strict option is similar, but will error if no precompile file is found.\n--pkgimages={yes*|no|existing} Enable or disable usage of native code caching in the form of pkgimages. The existing option allows use of existing pkgimages but disallows creation of new ones\n-e, --eval <expr> Evaluate <expr>\n-E, --print <expr> Evaluate <expr> and display the result\n-m, --module <Package> [args] Run entry point of Package (@main function) with `args'\n-L, --load <file> Load <file> immediately on all processors\n-t, --threads {auto|N[,auto|M]} Enable N[+M] threads; N threads are assigned to the default threadpool, and if M is specified, M threads are assigned to the interactive threadpool; auto tries to infer a useful default number of threads to use but the exact behavior might change in the future. Currently sets N to the number of CPUs assigned to this Julia process based on the OS-specific affinity assignment interface if supported (Linux and Windows) or to the number of CPU threads if not supported (MacOS) or if process affinity is not configured, and sets M to 1.\n--gcthreads=N[,M] Use N threads for the mark phase of GC and M (0 or 1) threads for the concurrent sweeping phase of GC. N is set to half of the number of compute threads and M is set to 0 if unspecified.\n-p, --procs {N|auto} Integer value N launches N additional local worker processes; auto launches as many workers as the number of local CPU threads (logical cores)\n--machine-file <file> Run processes on hosts listed in <file>\n-i, --interactive Interactive mode; REPL runs and isinteractive() is true\n-q, --quiet Quiet startup: no banner, suppress REPL warnings\n--banner={yes|no|short|auto*} Enable or disable startup banner\n--color={yes|no|auto*} Enable or disable color text\n--history-file={yes*|no} Load or save history\n--depwarn={yes|no*|error} Enable or disable syntax and method deprecation warnings (error turns warnings into errors)\n--warn-overwrite={yes|no*} Enable or disable method overwrite warnings\n--warn-scope={yes*|no} Enable or disable warning for ambiguous top-level scope\n-C, --cpu-target <target> Limit usage of CPU features up to <target>; set to help to see the available options\n-O, --optimize={0|1|2*|3} Set the optimization level (level is 3 if -O is used without a level) ($)\n--min-optlevel={0*|1|2|3} Set the lower bound on per-module optimization\n-g, --debug-info={0|1*|2} Set the level of debug info generation (level is 2 if -g is used without a level) ($)\n--inline={yes|no} Control whether inlining is permitted, including overriding @inline declarations\n--check-bounds={yes|no|auto*} Emit bounds checks always, never, or respect @inbounds declarations ($)\n--math-mode={ieee,fast} Disallow or enable unsafe floating point optimizations (overrides @fastmath declaration)\n--polly={yes*|no} Enable or disable the polyhedral optimizer Polly (overrides @polly declaration)\n--code-coverage[={none*|user|all}] Count executions of source lines (omitting setting is equivalent to user)\n--code-coverage=@<path> Count executions but only in files that fall under the given file path/directory. The @ prefix is required to select this option. A @ with no path will track the current directory.\n--code-coverage=tracefile.info Append coverage information to the LCOV tracefile (filename supports format tokens).\n--track-allocation[={none*|user|all}] Count bytes allocated by each source line (omitting setting is equivalent to \"user\")\n--track-allocation=@<path> Count bytes but only in files that fall under the given file path/directory. The @ prefix is required to select this option. A @ with no path will track the current directory.\n--bug-report=KIND Launch a bug report session. It can be used to start a REPL, run a script, or evaluate expressions. It first tries to use BugReporting.jl installed in current environment and falls back to the latest compatible BugReporting.jl if not. For more information, see --bug-report=help.\n--heap-size-hint=<size> Forces garbage collection if memory usage is higher than the given value. The value may be specified as a number of bytes, optionally in units of KB, MB, GB, or TB, or as a percentage of physical memory with %.\n--compile={yes*|no|all|min} Enable or disable JIT compiler, or request exhaustive or minimal compilation\n--output-o <name> Generate an object file (including system image data)\n--output-ji <name> Generate a system image data file (.ji)\n--strip-metadata Remove docstrings and source location info from system image\n--strip-ir Remove IR (intermediate representation) of compiled functions\n--output-unopt-bc <name> Generate unoptimized LLVM bitcode (.bc)\n--output-bc <name> Generate LLVM bitcode (.bc)\n--output-asm <name> Generate an assembly file (.s)\n--output-incremental={yes|no*} Generate an incremental output file (rather than complete)\n--trace-compile={stderr|name} Print precompile statements for methods compiled during execution or save to a path\n--image-codegen Force generate code in imaging mode\n--permalloc-pkgimg={yes|no*} Copy the data section of package images into memory","category":"page"},{"location":"manual/command-line-interface.html","page":"Command-line Interface","title":"Command-line Interface","text":"compat: Julia 1.1\nIn Julia 1.0, the default --project=@. option did not search up from the root directory of a Git repository for the Project.toml file. From Julia 1.1 forward, it does.","category":"page"},{"location":"devdocs/sanitizers.html#Sanitizer-support","page":"Sanitizer support","title":"Sanitizer support","text":"","category":"section"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"Sanitizers can be used in custom Julia builds to make it easier to detect certain kinds of errors in Julia's internal C/C++ code.","category":"page"},{"location":"devdocs/sanitizers.html#Address-Sanitizer:-easy-build","page":"Sanitizer support","title":"Address Sanitizer: easy build","text":"","category":"section"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"From a source-checkout of Julia, you should be able to build a version supporting address sanitization in Julia and LLVM as follows:","category":"page"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"$ mkdir /tmp/julia\n$ contrib/asan/build.sh /tmp/julia/","category":"page"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"Here we've chosen /tmp/julia as a build directory, but you can choose whatever you wish. Once built, run the workload you wish to test with /tmp/julia/julia. Memory bugs will result in errors.","category":"page"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"If you require customization or further detail, see the documentation below.","category":"page"},{"location":"devdocs/sanitizers.html#General-considerations","page":"Sanitizer support","title":"General considerations","text":"","category":"section"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"Using Clang's sanitizers obviously requires you to use Clang (USECLANG=1), but there's another catch: most sanitizers require a run-time library, provided by the host compiler, while the instrumented code generated by Julia's JIT relies on functionality from that library. This implies that the LLVM version of your host compiler must match that of the LLVM library used within Julia.","category":"page"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"An easy solution is to have a dedicated build folder for providing a matching toolchain, by building with BUILD_LLVM_CLANG=1. You can then refer to this toolchain from another build folder by specifying USECLANG=1 while overriding the CC and CXX variables.","category":"page"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"The sanitizers error out when they detect a shared library being opened using RTLD_DEEPBIND (ref: google/sanitizers#611). Since libblastrampoline by default uses RTLD_DEEPBIND, we need to set the environment variable LBT_USE_RTLD_DEEPBIND=0 when using a sanitizer.","category":"page"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"To use one of of the sanitizers set SANITIZE=1 and then the appropriate flag for the sanitizer you want to use.","category":"page"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"On macOS, this might need some extra flags also to work. Altogether, it might look like this, plus one or more of the SANITIZE_* flags listed below:","category":"page"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"make -C deps USE_BINARYBUILDER_LLVM=0 LLVM_VER=svn stage-llvm\n\nmake -C src SANITIZE=1 USECLANG=1 \\\n    CC=~+/deps/scratch/llvm-svn/build_Release/bin/clang \\\n    CXX=~+/deps/scratch/llvm-svn/build_Release/bin/clang++ \\\n    CPPFLAGS=\"-isysroot $(xcode-select -p)/Platforms/MacOSX.platform/Developer/SDKs/MacOSX.sdk\" \\\n    CXXFLAGS=\"-isystem $(xcode-select -p)/Toolchains/XcodeDefault.xctoolchain/usr/include/c++/v1\"","category":"page"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"(or put these into your Make.user, so you don't need to remember them every time).","category":"page"},{"location":"devdocs/sanitizers.html#Address-Sanitizer-(ASAN)","page":"Sanitizer support","title":"Address Sanitizer (ASAN)","text":"","category":"section"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"For detecting or debugging memory bugs, you can use Clang's address sanitizer (ASAN). By compiling with SANITIZE_ADDRESS=1 you enable ASAN for the Julia compiler and its generated code. In addition, you can specify LLVM_SANITIZE=1 to sanitize the LLVM library as well. Note that these options incur a high performance and memory cost. For example, using ASAN for Julia and LLVM makes testall1 take 8-10 times as long while using 20 times as much memory (this can be reduced to respectively a factor of 3 and 4 by using the options described below).","category":"page"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"By default, Julia sets the allow_user_segv_handler=1 ASAN flag, which is required for signal delivery to work properly. You can define other options using the ASAN_OPTIONS environment flag, in which case you'll need to repeat the default option mentioned before. For example, memory usage can be reduced by specifying fast_unwind_on_malloc=0 and malloc_context_size=2, at the cost of backtrace accuracy. For now, Julia also sets detect_leaks=0, but this should be removed in the future.","category":"page"},{"location":"devdocs/sanitizers.html#Example-setup","page":"Sanitizer support","title":"Example setup","text":"","category":"section"},{"location":"devdocs/sanitizers.html#Step-1:-Install-toolchain","page":"Sanitizer support","title":"Step 1: Install toolchain","text":"","category":"section"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"Checkout a Git worktree (or create out-of-tree build directory) at $TOOLCHAIN_WORKTREE and create a config file $TOOLCHAIN_WORKTREE/Make.user with","category":"page"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"USE_BINARYBUILDER_LLVM=1\nBUILD_LLVM_CLANG=1","category":"page"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"Run:","category":"page"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"cd $TOOLCHAIN_WORKTREE\nmake -C deps install-llvm install-clang install-llvm-tools","category":"page"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"to install toolchain binaries in $TOOLCHAIN_WORKTREE/usr/tools","category":"page"},{"location":"devdocs/sanitizers.html#Step-2:-Build-Julia-with-ASAN","page":"Sanitizer support","title":"Step 2: Build Julia with ASAN","text":"","category":"section"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"Checkout a Git worktree (or create out-of-tree build directory) at $BUILD_WORKTREE and create a config file $BUILD_WORKTREE/Make.user with","category":"page"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"TOOLCHAIN=$(TOOLCHAIN_WORKTREE)/usr/tools\n\n# use our new toolchain\nUSECLANG=1\noverride CC=$(TOOLCHAIN)/clang\noverride CXX=$(TOOLCHAIN)/clang++\nexport ASAN_SYMBOLIZER_PATH=$(TOOLCHAIN)/llvm-symbolizer\n\nUSE_BINARYBUILDER_LLVM=1\n\noverride SANITIZE=1\noverride SANITIZE_ADDRESS=1\n\n# make the GC use regular malloc/frees, which are hooked by ASAN\noverride WITH_GC_DEBUG_ENV=1\n\n# default to a debug build for better line number reporting\noverride JULIA_BUILD_MODE=debug\n\n# make ASAN consume less memory\nexport ASAN_OPTIONS=detect_leaks=0:fast_unwind_on_malloc=0:allow_user_segv_handler=1:malloc_context_size=2\n\nJULIA_PRECOMPILE=1\n\n# tell libblastrampoline to not use RTLD_DEEPBIND\nexport LBT_USE_RTLD_DEEPBIND=0","category":"page"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"Run:","category":"page"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"cd $BUILD_WORKTREE\nmake debug","category":"page"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"to build julia-debug with ASAN.","category":"page"},{"location":"devdocs/sanitizers.html#Memory-Sanitizer-(MSAN)","page":"Sanitizer support","title":"Memory Sanitizer (MSAN)","text":"","category":"section"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"For detecting use of uninitialized memory, you can use Clang's memory sanitizer (MSAN) by compiling with SANITIZE_MEMORY=1.","category":"page"},{"location":"devdocs/sanitizers.html#Thread-Sanitizer-(TSAN)","page":"Sanitizer support","title":"Thread Sanitizer (TSAN)","text":"","category":"section"},{"location":"devdocs/sanitizers.html","page":"Sanitizer support","title":"Sanitizer support","text":"For debugging data-races and other threading related issues you can use Clang's thread sanitizer (TSAN) by compiling with SANITIZE_THREAD=1.","category":"page"},{"location":"devdocs/build/arm.html#ARM-(Linux)","page":"ARM (Linux)","title":"ARM (Linux)","text":"","category":"section"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"Julia fully supports ARMv8 (AArch64) processors, and supports ARMv7 and ARMv6 (AArch32) with some caveats. This file provides general guidelines for compilation, in addition to instructions for specific devices.","category":"page"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"A list of known issues for ARM is available. If you encounter difficulties, please create an issue including the output from cat /proc/cpuinfo.","category":"page"},{"location":"devdocs/build/arm.html#32-bit-(ARMv6,-ARMv7)","page":"ARM (Linux)","title":"32-bit (ARMv6, ARMv7)","text":"","category":"section"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"Julia has been successfully compiled on several variants of the following ARMv6 & ARMv7 devices:","category":"page"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"ARMv7 / Cortex A15 Samsung Chromebooks running Ubuntu Linux under Crouton;\nRaspberry Pi.\nOdroid.","category":"page"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"Julia requires at least the armv6 and vfpv2 instruction sets. It's recommended to use  armv7-a. armv5 or soft float are not supported.","category":"page"},{"location":"devdocs/build/arm.html#Raspberry-Pi-1-/-Raspberry-Pi-Zero","page":"ARM (Linux)","title":"Raspberry Pi 1 / Raspberry Pi Zero","text":"","category":"section"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"If the type of ARM CPU used in the Raspberry Pi is not detected by LLVM, then explicitly set the CPU target by adding the following to Make.user:","category":"page"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"JULIA_CPU_TARGET=arm1176jzf-s","category":"page"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"To complete the build, you may need to increase the swap file size. To do so, edit /etc/dphys-swapfile, changing the line:","category":"page"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"CONF_SWAPSIZE=100","category":"page"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"to:","category":"page"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"CONF_SWAPSIZE=512","category":"page"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"before restarting the swapfile service:","category":"page"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"sudo /etc/init.d/dphys-swapfile stop\nsudo /etc/init.d/dphys-swapfile start","category":"page"},{"location":"devdocs/build/arm.html#Raspberry-Pi-2","page":"ARM (Linux)","title":"Raspberry Pi 2","text":"","category":"section"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"The type of ARM CPU used in the Raspberry Pi 2 is not detected by LLVM. Explicitly set the CPU target by adding the following to Make.user:","category":"page"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"JULIA_CPU_TARGET=cortex-a7","category":"page"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"Depending on the exact compiler and distribution, there might be a build failure due to unsupported inline assembly. In that case, add MCPU=armv7-a to Make.user.","category":"page"},{"location":"devdocs/build/arm.html#AArch64-(ARMv8)","page":"ARM (Linux)","title":"AArch64 (ARMv8)","text":"","category":"section"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"Julia is expected to work and build on ARMv8 cpus. One should follow the general build instructions. Julia expects to have around 8GB of ram or swap enabled to build itself.","category":"page"},{"location":"devdocs/build/arm.html#Known-issues","page":"ARM (Linux)","title":"Known issues","text":"","category":"section"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"Starting from Julia v1.10, JITLink is automatically enabled on this architecture for all operating systems when linking to LLVM 15 or later versions. Due to a bug in LLVM memory manager, non-trivial workloads may generate too many memory mappings that on Linux can exceed the limit of memory mappings (mmap) set in the file /proc/sys/vm/max_map_count, resulting in an error like","category":"page"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"JIT session error: Cannot allocate memory","category":"page"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"Should this happen, ask your system administrator to increase the limit of memory mappings for example with the command","category":"page"},{"location":"devdocs/build/arm.html","page":"ARM (Linux)","title":"ARM (Linux)","text":"sysctl -w vm.max_map_count=262144","category":"page"},{"location":"stdlib/Dates.html#Dates","page":"Dates","title":"Dates","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"DocTestSetup = :(using Dates)","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"The Dates module provides two types for working with dates: Date and DateTime, representing day and millisecond precision, respectively; both are subtypes of the abstract TimeType. The motivation for distinct types is simple: some operations are much simpler, both in terms of code and mental reasoning, when the complexities of greater precision don't have to be dealt with. For example, since the Date type only resolves to the precision of a single date (i.e. no hours, minutes, or seconds), normal considerations for time zones, daylight savings/summer time, and leap seconds are unnecessary and avoided.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Both Date and DateTime are basically immutable Int64 wrappers. The single instant field of either type is actually a UTInstant{P} type, which represents a continuously increasing machine timeline based on the UT second [1]. The DateTime type is not aware of time zones (naive, in Python parlance), analogous to a LocalDateTime in Java 8. Additional time zone functionality can be added through the TimeZones.jl package, which compiles the IANA time zone database. Both Date and DateTime are based on the ISO 8601 standard, which follows the proleptic Gregorian calendar. One note is that the ISO 8601 standard is particular about BC/BCE dates. In general, the last day of the BC/BCE era, 1-12-31 BC/BCE, was followed by 1-1-1 AD/CE, thus no year zero exists. The ISO standard, however, states that 1 BC/BCE is year zero, so 0000-12-31 is the day before 0001-01-01, and year -0001 (yes, negative one for the year) is 2 BC/BCE, year -0002 is 3 BC/BCE, etc.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"[1]: The notion of the UT second is actually quite fundamental. There are basically two different notions of time generally accepted, one based on the physical rotation of the earth (one full rotation = 1 day), the other based on the SI second (a fixed, constant value). These are radically different! Think about it, a \"UT second\", as defined relative to the rotation of the earth, may have a different absolute length depending on the day! Anyway, the fact that Date and DateTime are based on UT seconds is a simplifying, yet honest assumption so that things like leap seconds and all their complexity can be avoided. This basis of time is formally called UT or UT1. Basing types on the UT second basically means that every minute has 60 seconds and every day has 24 hours and leads to more natural calculations when working with calendar dates.","category":"page"},{"location":"stdlib/Dates.html#Constructors","page":"Dates","title":"Constructors","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Date and DateTime types can be constructed by integer or Period types, by parsing, or through adjusters (more on those later):","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> DateTime(2013)\n2013-01-01T00:00:00\n\njulia> DateTime(2013,7)\n2013-07-01T00:00:00\n\njulia> DateTime(2013,7,1)\n2013-07-01T00:00:00\n\njulia> DateTime(2013,7,1,12)\n2013-07-01T12:00:00\n\njulia> DateTime(2013,7,1,12,30)\n2013-07-01T12:30:00\n\njulia> DateTime(2013,7,1,12,30,59)\n2013-07-01T12:30:59\n\njulia> DateTime(2013,7,1,12,30,59,1)\n2013-07-01T12:30:59.001\n\njulia> Date(2013)\n2013-01-01\n\njulia> Date(2013,7)\n2013-07-01\n\njulia> Date(2013,7,1)\n2013-07-01\n\njulia> Date(Dates.Year(2013),Dates.Month(7),Dates.Day(1))\n2013-07-01\n\njulia> Date(Dates.Month(7),Dates.Year(2013))\n2013-07-01","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Date or DateTime parsing is accomplished by the use of format strings. Format strings work by the notion of defining delimited or fixed-width \"slots\" that contain a period to parse and passing the text to parse and format string to a Date or DateTime constructor, of the form Date(\"2015-01-01\",dateformat\"y-m-d\") or DateTime(\"20150101\",dateformat\"yyyymmdd\").","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Delimited slots are marked by specifying the delimiter the parser should expect between two subsequent periods; so \"y-m-d\" lets the parser know that between the first and second slots in a date string like \"2014-07-16\", it should find the - character. The y, m, and d characters let the parser know which periods to parse in each slot.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"As in the case of constructors above such as Date(2013), delimited DateFormats allow for missing parts of dates and times so long as the preceding parts are given. The other parts are given the usual default values.  For example, Date(\"1981-03\", dateformat\"y-m-d\") returns 1981-03-01, whilst Date(\"31/12\", dateformat\"d/m/y\") gives 0001-12-31.  (Note that the default year is 1 AD/CE.) An empty string, however, always throws an ArgumentError.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Fixed-width slots are specified by repeating the period character the number of times corresponding to the width with no delimiter between characters. So dateformat\"yyyymmdd\" would correspond to a date string like \"20140716\". The parser distinguishes a fixed-width slot by the absence of a delimiter, noting the transition \"yyyymm\" from one period character to the next.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Support for text-form month parsing is also supported through the u and U characters, for abbreviated and full-length month names, respectively. By default, only English month names are supported, so u corresponds to \"Jan\", \"Feb\", \"Mar\", etc. And U corresponds to \"January\", \"February\", \"March\", etc. Similar to other name=>value mapping functions dayname and monthname, custom locales can be loaded by passing in the locale=>Dict{String,Int} mapping to the MONTHTOVALUEABBR and MONTHTOVALUE dicts for abbreviated and full-name month names, respectively.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"The above examples used the dateformat\"\" string macro. This macro creates a DateFormat object once when the macro is expanded and uses the same DateFormat object even if a code snippet is run multiple times.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> for i = 1:10^5\n           Date(\"2015-01-01\", dateformat\"y-m-d\")\n       end","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Or you can create the DateFormat object explicitly:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> df = DateFormat(\"y-m-d\");\n\njulia> dt = Date(\"2015-01-01\",df)\n2015-01-01\n\njulia> dt2 = Date(\"2015-01-02\",df)\n2015-01-02","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Alternatively, use broadcasting:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> years = [\"2015\", \"2016\"];\n\njulia> Date.(years, DateFormat(\"yyyy\"))\n2-element Vector{Date}:\n 2015-01-01\n 2016-01-01","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"For convenience, you may pass the format string directly (e.g., Date(\"2015-01-01\",\"y-m-d\")), although this form incurs performance costs if you are parsing the same format repeatedly, as it internally creates a new DateFormat object each time.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"As well as via the constructors, a Date or DateTime can be constructed from strings using the parse and tryparse functions, but with an optional third argument of type DateFormat specifying the format; for example, parse(Date, \"06.23.2013\", dateformat\"m.d.y\"), or tryparse(DateTime, \"1999-12-31T23:59:59\") which uses the default format. The notable difference between the functions is that with tryparse, an error is not thrown if the string is empty or in an invalid format; instead nothing is returned.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"compat: Julia 1.9\nBefore Julia 1.9, empty strings could be passed to constructors and parse without error, returning as appropriate DateTime(1), Date(1) or Time(0). Likewise, tryparse did not return nothing.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"A full suite of parsing and formatting tests and examples is available in stdlib/Dates/test/io.jl.","category":"page"},{"location":"stdlib/Dates.html#Durations/Comparisons","page":"Dates","title":"Durations/Comparisons","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Finding the length of time between two Date or DateTime is straightforward given their underlying representation as UTInstant{Day} and UTInstant{Millisecond}, respectively. The difference between Date is returned in the number of Day, and DateTime in the number of Millisecond. Similarly, comparing TimeType is a simple matter of comparing the underlying machine instants (which in turn compares the internal Int64 values).","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> dt = Date(2012,2,29)\n2012-02-29\n\njulia> dt2 = Date(2000,2,1)\n2000-02-01\n\njulia> dump(dt)\nDate\n  instant: Dates.UTInstant{Day}\n    periods: Day\n      value: Int64 734562\n\njulia> dump(dt2)\nDate\n  instant: Dates.UTInstant{Day}\n    periods: Day\n      value: Int64 730151\n\njulia> dt > dt2\ntrue\n\njulia> dt != dt2\ntrue\n\njulia> dt + dt2\nERROR: MethodError: no method matching +(::Date, ::Date)\n[...]\n\njulia> dt * dt2\nERROR: MethodError: no method matching *(::Date, ::Date)\n[...]\n\njulia> dt / dt2\nERROR: MethodError: no method matching /(::Date, ::Date)\n\njulia> dt - dt2\n4411 days\n\njulia> dt2 - dt\n-4411 days\n\njulia> dt = DateTime(2012,2,29)\n2012-02-29T00:00:00\n\njulia> dt2 = DateTime(2000,2,1)\n2000-02-01T00:00:00\n\njulia> dt - dt2\n381110400000 milliseconds","category":"page"},{"location":"stdlib/Dates.html#Accessor-Functions","page":"Dates","title":"Accessor Functions","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Because the Date and DateTime types are stored as single Int64 values, date parts or fields can be retrieved through accessor functions. The lowercase accessors return the field as an integer:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> t = Date(2014, 1, 31)\n2014-01-31\n\njulia> Dates.year(t)\n2014\n\njulia> Dates.month(t)\n1\n\njulia> Dates.week(t)\n5\n\njulia> Dates.day(t)\n31","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"While propercase return the same value in the corresponding Period type:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> Dates.Year(t)\n2014 years\n\njulia> Dates.Day(t)\n31 days","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Compound methods are provided because it is more efficient to access multiple fields at the same time than individually:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> Dates.yearmonth(t)\n(2014, 1)\n\njulia> Dates.monthday(t)\n(1, 31)\n\njulia> Dates.yearmonthday(t)\n(2014, 1, 31)","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"One may also access the underlying UTInstant or integer value:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> dump(t)\nDate\n  instant: Dates.UTInstant{Day}\n    periods: Day\n      value: Int64 735264\n\njulia> t.instant\nDates.UTInstant{Day}(Day(735264))\n\njulia> Dates.value(t)\n735264","category":"page"},{"location":"stdlib/Dates.html#Query-Functions","page":"Dates","title":"Query Functions","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Query functions provide calendrical information about a TimeType. They include information about the day of the week:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> t = Date(2014, 1, 31)\n2014-01-31\n\njulia> Dates.dayofweek(t)\n5\n\njulia> Dates.dayname(t)\n\"Friday\"\n\njulia> Dates.dayofweekofmonth(t) # 5th Friday of January\n5","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Month of the year:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> Dates.monthname(t)\n\"January\"\n\njulia> Dates.daysinmonth(t)\n31","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"As well as information about the TimeType's year and quarter:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> Dates.isleapyear(t)\nfalse\n\njulia> Dates.dayofyear(t)\n31\n\njulia> Dates.quarterofyear(t)\n1\n\njulia> Dates.dayofquarter(t)\n31","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"The dayname and monthname methods can also take an optional locale keyword that can be used to return the name of the day or month of the year for other languages/locales. There are also versions of these functions returning the abbreviated names, namely dayabbr and monthabbr. First the mapping is loaded into the LOCALES variable:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> french_months = [\"janvier\", \"février\", \"mars\", \"avril\", \"mai\", \"juin\",\n                        \"juillet\", \"août\", \"septembre\", \"octobre\", \"novembre\", \"décembre\"];\n\njulia> french_months_abbrev = [\"janv\",\"févr\",\"mars\",\"avril\",\"mai\",\"juin\",\n                              \"juil\",\"août\",\"sept\",\"oct\",\"nov\",\"déc\"];\n\njulia> french_days = [\"lundi\",\"mardi\",\"mercredi\",\"jeudi\",\"vendredi\",\"samedi\",\"dimanche\"];\n\njulia> Dates.LOCALES[\"french\"] = Dates.DateLocale(french_months, french_months_abbrev, french_days, [\"\"]);","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"The above mentioned functions can then be used to perform the queries:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> Dates.dayname(t;locale=\"french\")\n\"vendredi\"\n\njulia> Dates.monthname(t;locale=\"french\")\n\"janvier\"\n\njulia> Dates.monthabbr(t;locale=\"french\")\n\"janv\"","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Since the abbreviated versions of the days are not loaded, trying to use the function dayabbr will throw an error.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> Dates.dayabbr(t;locale=\"french\")\nERROR: BoundsError: attempt to access 1-element Vector{String} at index [5]\nStacktrace:\n[...]","category":"page"},{"location":"stdlib/Dates.html#TimeType-Period-Arithmetic","page":"Dates","title":"TimeType-Period Arithmetic","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"It's good practice when using any language/date framework to be familiar with how date-period arithmetic is handled as there are some tricky issues to deal with (though much less so for day-precision types).","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"The Dates module approach tries to follow the simple principle of trying to change as little as possible when doing Period arithmetic. This approach is also often known as calendrical arithmetic or what you would probably guess if someone were to ask you the same calculation in a conversation. Why all the fuss about this? Let's take a classic example: add 1 month to January 31st, 2014. What's the answer? Javascript will say March 3 (assumes 31 days). PHP says March 2 (assumes 30 days). The fact is, there is no right answer. In the Dates module, it gives the result of February 28th. How does it figure that out? Consider the classic 7-7-7 gambling game in casinos.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Now just imagine that instead of 7-7-7, the slots are Year-Month-Day, or in our example, 2014-01-31. When you ask to add 1 month to this date, the month slot is incremented, so now we have 2014-02-31. Then the day number is checked if it is greater than the last valid day of the new month; if it is (as in the case above), the day number is adjusted down to the last valid day (28). What are the ramifications with this approach? Go ahead and add another month to our date, 2014-02-28 + Month(1) == 2014-03-28. What? Were you expecting the last day of March? Nope, sorry, remember the 7-7-7 slots. As few slots as possible are going to change, so we first increment the month slot by 1, 2014-03-28, and boom, we're done because that's a valid date. On the other hand, if we were to add 2 months to our original date, 2014-01-31, then we end up with 2014-03-31, as expected. The other ramification of this approach is a loss in associativity when a specific ordering is forced (i.e. adding things in different orders results in different outcomes). For example:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> (Date(2014,1,29)+Dates.Day(1)) + Dates.Month(1)\n2014-02-28\n\njulia> (Date(2014,1,29)+Dates.Month(1)) + Dates.Day(1)\n2014-03-01","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"What's going on there? In the first line, we're adding 1 day to January 29th, which results in 2014-01-30; then we add 1 month, so we get 2014-02-30, which then adjusts down to 2014-02-28. In the second example, we add 1 month first, where we get 2014-02-29, which adjusts down to 2014-02-28, and then add 1 day, which results in 2014-03-01. One design principle that helps in this case is that, in the presence of multiple Periods, the operations will be ordered by the Periods' types, not their value or positional order; this means Year will always be added first, then Month, then Week, etc. Hence the following does result in associativity and Just Works:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> Date(2014,1,29) + Dates.Day(1) + Dates.Month(1)\n2014-03-01\n\njulia> Date(2014,1,29) + Dates.Month(1) + Dates.Day(1)\n2014-03-01","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Tricky? Perhaps. What is an innocent Dates user to do? The bottom line is to be aware that explicitly forcing a certain associativity, when dealing with months, may lead to some unexpected results, but otherwise, everything should work as expected. Thankfully, that's pretty much the extent of the odd cases in date-period arithmetic when dealing with time in UT (avoiding the \"joys\" of dealing with daylight savings, leap seconds, etc.).","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"As a bonus, all period arithmetic objects work directly with ranges:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> dr = Date(2014,1,29):Day(1):Date(2014,2,3)\nDate(\"2014-01-29\"):Day(1):Date(\"2014-02-03\")\n\njulia> collect(dr)\n6-element Vector{Date}:\n 2014-01-29\n 2014-01-30\n 2014-01-31\n 2014-02-01\n 2014-02-02\n 2014-02-03\n\njulia> dr = Date(2014,1,29):Dates.Month(1):Date(2014,07,29)\nDate(\"2014-01-29\"):Month(1):Date(\"2014-07-29\")\n\njulia> collect(dr)\n7-element Vector{Date}:\n 2014-01-29\n 2014-02-28\n 2014-03-29\n 2014-04-29\n 2014-05-29\n 2014-06-29\n 2014-07-29","category":"page"},{"location":"stdlib/Dates.html#Adjuster-Functions","page":"Dates","title":"Adjuster Functions","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"As convenient as date-period arithmetic is, often the kinds of calculations needed on dates take on a calendrical or temporal nature rather than a fixed number of periods. Holidays are a perfect example; most follow rules such as \"Memorial Day = Last Monday of May\", or \"Thanksgiving = 4th Thursday of November\". These kinds of temporal expressions deal with rules relative to the calendar, like first or last of the month, next Tuesday, or the first and third Wednesdays, etc.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"The Dates module provides the adjuster API through several convenient methods that aid in simply and succinctly expressing temporal rules. The first group of adjuster methods deal with the first and last of weeks, months, quarters, and years. They each take a single TimeType as input and return or adjust to the first or last of the desired period relative to the input.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> Dates.firstdayofweek(Date(2014,7,16)) # Adjusts the input to the Monday of the input's week\n2014-07-14\n\njulia> Dates.lastdayofmonth(Date(2014,7,16)) # Adjusts to the last day of the input's month\n2014-07-31\n\njulia> Dates.lastdayofquarter(Date(2014,7,16)) # Adjusts to the last day of the input's quarter\n2014-09-30","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"The next two higher-order methods, tonext, and toprev, generalize working with temporal expressions by taking a DateFunction as first argument, along with a starting TimeType. A DateFunction is just a function, usually anonymous, that takes a single TimeType as input and returns a Bool, true indicating a satisfied adjustment criterion. For example:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> istuesday = x->Dates.dayofweek(x) == Dates.Tuesday; # Returns true if the day of the week of x is Tuesday\n\njulia> Dates.tonext(istuesday, Date(2014,7,13)) # 2014-07-13 is a Sunday\n2014-07-15\n\njulia> Dates.tonext(Date(2014,7,13), Dates.Tuesday) # Convenience method provided for day of the week adjustments\n2014-07-15","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"This is useful with the do-block syntax for more complex temporal expressions:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> Dates.tonext(Date(2014,7,13)) do x\n           # Return true on the 4th Thursday of November (Thanksgiving)\n           Dates.dayofweek(x) == Dates.Thursday &&\n           Dates.dayofweekofmonth(x) == 4 &&\n           Dates.month(x) == Dates.November\n       end\n2014-11-27","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"The Base.filter method can be used to obtain all valid dates/moments in a specified range:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"# Pittsburgh street cleaning; Every 2nd Tuesday from April to November\n# Date range from January 1st, 2014 to January 1st, 2015\njulia> dr = Dates.Date(2014):Day(1):Dates.Date(2015);\n\njulia> filter(dr) do x\n           Dates.dayofweek(x) == Dates.Tue &&\n           Dates.April <= Dates.month(x) <= Dates.Nov &&\n           Dates.dayofweekofmonth(x) == 2\n       end\n8-element Vector{Date}:\n 2014-04-08\n 2014-05-13\n 2014-06-10\n 2014-07-08\n 2014-08-12\n 2014-09-09\n 2014-10-14\n 2014-11-11","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Additional examples and tests are available in stdlib/Dates/test/adjusters.jl.","category":"page"},{"location":"stdlib/Dates.html#Period-Types","page":"Dates","title":"Period Types","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Periods are a human view of discrete, sometimes irregular durations of time. Consider 1 month; it could represent, in days, a value of 28, 29, 30, or 31 depending on the year and month context. Or a year could represent 365 or 366 days in the case of a leap year. Period types are simple Int64 wrappers and are constructed by wrapping any Int64 convertible type, i.e. Year(1) or Month(3.0). Arithmetic between Period of the same type behave like integers, and limited Period-Real arithmetic is available.  You can extract the underlying integer with Dates.value.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> y1 = Dates.Year(1)\n1 year\n\njulia> y2 = Dates.Year(2)\n2 years\n\njulia> y3 = Dates.Year(10)\n10 years\n\njulia> y1 + y2\n3 years\n\njulia> div(y3,y2)\n5\n\njulia> y3 - y2\n8 years\n\njulia> y3 % y2\n0 years\n\njulia> div(y3,3) # mirrors integer division\n3 years\n\njulia> Dates.value(Dates.Millisecond(10))\n10","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Representing periods or durations that are not integer multiples of the basic types can be achieved with the Dates.CompoundPeriod type. Compound periods may be constructed manually from simple Period types. Additionally, the canonicalize function can be used to break down a period into a Dates.CompoundPeriod. This is particularly useful to convert a duration, e.g., a difference of two DateTime, into a more convenient representation.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> cp = Dates.CompoundPeriod(Day(1),Minute(1))\n1 day, 1 minute\n\njulia> t1 = DateTime(2018,8,8,16,58,00)\n2018-08-08T16:58:00\n\njulia> t2 = DateTime(2021,6,23,10,00,00)\n2021-06-23T10:00:00\n\njulia> canonicalize(t2-t1) # creates a CompoundPeriod\n149 weeks, 6 days, 17 hours, 2 minutes","category":"page"},{"location":"stdlib/Dates.html#Rounding","page":"Dates","title":"Rounding","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Date and DateTime values can be rounded to a specified resolution (e.g., 1 month or 15 minutes) with floor, ceil, or round:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> floor(Date(1985, 8, 16), Dates.Month)\n1985-08-01\n\njulia> ceil(DateTime(2013, 2, 13, 0, 31, 20), Dates.Minute(15))\n2013-02-13T00:45:00\n\njulia> round(DateTime(2016, 8, 6, 20, 15), Dates.Day)\n2016-08-07T00:00:00","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Unlike the numeric round method, which breaks ties toward the even number by default, the TimeTyperound method uses the RoundNearestTiesUp rounding mode. (It's difficult to guess what breaking ties to nearest \"even\" TimeType would entail.) Further details on the available RoundingMode s can be found in the API reference.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Rounding should generally behave as expected, but there are a few cases in which the expected behaviour is not obvious.","category":"page"},{"location":"stdlib/Dates.html#Rounding-Epoch","page":"Dates","title":"Rounding Epoch","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"In many cases, the resolution specified for rounding (e.g., Dates.Second(30)) divides evenly into the next largest period (in this case, Dates.Minute(1)). But rounding behaviour in cases in which this is not true may lead to confusion. What is the expected result of rounding a DateTime to the nearest 10 hours?","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> round(DateTime(2016, 7, 17, 11, 55), Dates.Hour(10))\n2016-07-17T12:00:00","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"That may seem confusing, given that the hour (12) is not divisible by 10. The reason that 2016-07-17T12:00:00 was chosen is that it is 17,676,660 hours after 0000-01-01T00:00:00, and 17,676,660 is divisible by 10.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"As Julia Date and DateTime values are represented according to the ISO 8601 standard, 0000-01-01T00:00:00 was chosen as base (or \"rounding epoch\") from which to begin the count of days (and milliseconds) used in rounding calculations. (Note that this differs slightly from Julia's internal representation of Date s using Rata Die notation; but since the ISO 8601 standard is most visible to the end user, 0000-01-01T00:00:00 was chosen as the rounding epoch instead of the 0000-12-31T00:00:00 used internally to minimize confusion.)","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"The only exception to the use of 0000-01-01T00:00:00 as the rounding epoch is when rounding to weeks. Rounding to the nearest week will always return a Monday (the first day of the week as specified by ISO 8601). For this reason, we use 0000-01-03T00:00:00 (the first day of the first week of year 0000, as defined by ISO 8601) as the base when rounding to a number of weeks.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Here is a related case in which the expected behaviour is not necessarily obvious: What happens when we round to the nearest P(2), where P is a Period type? In some cases (specifically, when P <: Dates.TimePeriod) the answer is clear:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> round(DateTime(2016, 7, 17, 8, 55, 30), Dates.Hour(2))\n2016-07-17T08:00:00\n\njulia> round(DateTime(2016, 7, 17, 8, 55, 30), Dates.Minute(2))\n2016-07-17T08:56:00","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"This seems obvious, because two of each of these periods still divides evenly into the next larger order period. But in the case of two months (which still divides evenly into one year), the answer may be surprising:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"julia> round(DateTime(2016, 7, 17, 8, 55, 30), Dates.Month(2))\n2016-07-01T00:00:00","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Why round to the first day in July, even though it is month 7 (an odd number)? The key is that months are 1-indexed (the first month is assigned 1), unlike hours, minutes, seconds, and milliseconds (the first of which are assigned 0).","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"This means that rounding a DateTime to an even multiple of seconds, minutes, hours, or years (because the ISO 8601 specification includes a year zero) will result in a DateTime with an even value in that field, while rounding a DateTime to an even multiple of months will result in the months field having an odd value. Because both months and years may contain an irregular number of days, whether rounding to an even number of days will result in an even value in the days field is uncertain.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"See the API reference for additional information on methods exported from the Dates module.","category":"page"},{"location":"stdlib/Dates.html#stdlib-dates-api","page":"Dates","title":"API reference","text":"","category":"section"},{"location":"stdlib/Dates.html#Dates-and-Time-Types","page":"Dates","title":"Dates and Time Types","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Dates.Period\nDates.CompoundPeriod\nDates.Instant\nDates.UTInstant\nDates.TimeType\nDates.DateTime\nDates.Date\nDates.Time\nDates.TimeZone\nDates.UTC","category":"page"},{"location":"stdlib/Dates.html#Dates.Period","page":"Dates","title":"Dates.Period","text":"Period\nYear\nQuarter\nMonth\nWeek\nDay\nHour\nMinute\nSecond\nMillisecond\nMicrosecond\nNanosecond\n\nPeriod types represent discrete, human representations of time.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Dates.html#Dates.CompoundPeriod","page":"Dates","title":"Dates.CompoundPeriod","text":"CompoundPeriod\n\nA CompoundPeriod is useful for expressing time periods that are not a fixed multiple of smaller periods. For example, \"a year and a  day\" is not a fixed number of days, but can be expressed using a CompoundPeriod. In fact, a CompoundPeriod is automatically generated by addition of different period types, e.g. Year(1) + Day(1) produces a CompoundPeriod result.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Dates.html#Dates.Instant","page":"Dates","title":"Dates.Instant","text":"Instant\n\nInstant types represent integer-based, machine representations of time as continuous timelines starting from an epoch.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Dates.html#Dates.UTInstant","page":"Dates","title":"Dates.UTInstant","text":"UTInstant{T}\n\nThe UTInstant represents a machine timeline based on UT time (1 day = one revolution of the earth). The T is a Period parameter that indicates the resolution or precision of the instant.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Dates.html#Dates.TimeType","page":"Dates","title":"Dates.TimeType","text":"TimeType\n\nTimeType types wrap Instant machine instances to provide human representations of the machine instant. Time, DateTime and Date are subtypes of TimeType.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Dates.html#Dates.DateTime","page":"Dates","title":"Dates.DateTime","text":"DateTime\n\nDateTime represents a point in time according to the proleptic Gregorian calendar. The finest resolution of the time is millisecond (i.e., microseconds or nanoseconds cannot be represented by this type). The type supports fixed-point arithmetic, and thus is prone to underflowing (and overflowing). A notable consequence is rounding when adding a Microsecond or a Nanosecond:\n\njulia> dt = DateTime(2023, 8, 19, 17, 45, 32, 900)\n2023-08-19T17:45:32.900\n\njulia> dt + Millisecond(1)\n2023-08-19T17:45:32.901\n\njulia> dt + Microsecond(1000) # 1000us == 1ms\n2023-08-19T17:45:32.901\n\njulia> dt + Microsecond(999) # 999us rounded to 1000us\n2023-08-19T17:45:32.901\n\njulia> dt + Microsecond(1499) # 1499 rounded to 1000us\n2023-08-19T17:45:32.901\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Dates.html#Dates.Date","page":"Dates","title":"Dates.Date","text":"Date\n\nDate wraps a UTInstant{Day} and interprets it according to the proleptic Gregorian calendar.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Dates.html#Dates.Time","page":"Dates","title":"Dates.Time","text":"Time\n\nTime wraps a Nanosecond and represents a specific moment in a 24-hour day.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Dates.html#Dates.TimeZone","page":"Dates","title":"Dates.TimeZone","text":"TimeZone\n\nGeographic zone generally based on longitude determining what the time is at a certain location. Some time zones observe daylight savings (eg EST -> EDT). For implementations and more support, see the TimeZones.jl package\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Dates.html#Dates.UTC","page":"Dates","title":"Dates.UTC","text":"UTC\n\nUTC, or Coordinated Universal Time, is the TimeZone from which all others are measured. It is associated with the time at 0° longitude. It is not adjusted for daylight savings.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Dates.html#Dates-Functions","page":"Dates","title":"Dates Functions","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Dates.DateTime(::Int64, ::Int64, ::Int64, ::Int64, ::Int64, ::Int64, ::Int64)\nDates.DateTime(::Dates.Period)\nDates.DateTime(::Function, ::Any...)\nDates.DateTime(::Dates.TimeType)\nDates.DateTime(::AbstractString, ::AbstractString)\nDates.format(::Dates.TimeType, ::AbstractString)\nDates.DateFormat\nDates.@dateformat_str\nDates.DateTime(::AbstractString, ::Dates.DateFormat)\nDates.Date(::Int64, ::Int64, ::Int64)\nDates.Date(::Dates.Period)\nDates.Date(::Function, ::Any, ::Any, ::Any)\nDates.Date(::Dates.TimeType)\nDates.Date(::AbstractString, ::AbstractString)\nDates.Date(::AbstractString, ::Dates.DateFormat)\nDates.Time(::Int64::Int64, ::Int64, ::Int64, ::Int64, ::Int64)\nDates.Time(::Dates.TimePeriod)\nDates.Time(::Function, ::Any...)\nDates.Time(::Dates.DateTime)\nDates.Time(::AbstractString, ::AbstractString)\nDates.Time(::AbstractString, ::Dates.DateFormat)\nDates.now()\nDates.now(::Type{Dates.UTC})\nBase.eps(::Union{Type{DateTime}, Type{Date}, Type{Time}, TimeType})","category":"page"},{"location":"stdlib/Dates.html#Dates.DateTime-NTuple{7, Int64}","page":"Dates","title":"Dates.DateTime","text":"DateTime(y, [m, d, h, mi, s, ms]) -> DateTime\n\nConstruct a DateTime type by parts. Arguments must be convertible to Int64.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.DateTime-Tuple{Period}","page":"Dates","title":"Dates.DateTime","text":"DateTime(periods::Period...) -> DateTime\n\nConstruct a DateTime type by Period type parts. Arguments may be in any order. DateTime parts not provided will default to the value of Dates.default(period).\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.DateTime-Tuple{Function, Vararg{Any}}","page":"Dates","title":"Dates.DateTime","text":"DateTime(f::Function, y[, m, d, h, mi, s]; step=Day(1), limit=10000) -> DateTime\n\nCreate a DateTime through the adjuster API. The starting point will be constructed from the provided y, m, d... arguments, and will be adjusted until f::Function returns true. The step size in adjusting can be provided manually through the step keyword. limit provides a limit to the max number of iterations the adjustment API will pursue before throwing an error (in the case that f::Function is never satisfied).\n\nExamples\n\njulia> DateTime(dt -> second(dt) == 40, 2010, 10, 20, 10; step = Second(1))\n2010-10-20T10:00:40\n\njulia> DateTime(dt -> hour(dt) == 20, 2010, 10, 20, 10; step = Hour(1), limit = 5)\nERROR: ArgumentError: Adjustment limit reached: 5 iterations\nStacktrace:\n[...]\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.DateTime-Tuple{TimeType}","page":"Dates","title":"Dates.DateTime","text":"DateTime(dt::Date) -> DateTime\n\nConvert a Date to a DateTime. The hour, minute, second, and millisecond parts of the new DateTime are assumed to be zero.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.DateTime-Tuple{AbstractString, AbstractString}","page":"Dates","title":"Dates.DateTime","text":"DateTime(dt::AbstractString, format::AbstractString; locale=\"english\") -> DateTime\n\nConstruct a DateTime by parsing the dt date time string following the pattern given in the format string (see DateFormat  for syntax).\n\nnote: Note\nThis method creates a DateFormat object each time it is called. It is recommended that you create a DateFormat object instead and use that as the second argument to avoid performance loss when using the same format repeatedly.\n\nExamples\n\njulia> DateTime(\"2020-01-01\", \"yyyy-mm-dd\")\n2020-01-01T00:00:00\n\njulia> a = (\"2020-01-01\", \"2020-01-02\");\n\njulia> [DateTime(d, dateformat\"yyyy-mm-dd\") for d ∈ a] # preferred\n2-element Vector{DateTime}:\n 2020-01-01T00:00:00\n 2020-01-02T00:00:00\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.format-Tuple{TimeType, AbstractString}","page":"Dates","title":"Dates.format","text":"format(dt::TimeType, format::AbstractString; locale=\"english\") -> AbstractString\n\nConstruct a string by using a TimeType object and applying the provided format. The following character codes can be used to construct the format string:\n\nCode Examples Comment\ny 6 Numeric year with a fixed width\nY 1996 Numeric year with a minimum width\nm 1, 12 Numeric month with a minimum width\nu Jan Month name shortened to 3-chars according to the locale\nU January Full month name according to the locale keyword\nd 1, 31 Day of the month with a minimum width\nH 0, 23 Hour (24-hour clock) with a minimum width\nM 0, 59 Minute with a minimum width\nS 0, 59 Second with a minimum width\ns 000, 500 Millisecond with a minimum width of 3\ne Mon, Tue Abbreviated days of the week\nE Monday Full day of week name\n\nThe number of sequential code characters indicate the width of the code. A format of yyyy-mm specifies that the code y should have a width of four while m a width of two. Codes that yield numeric digits have an associated mode: fixed-width or minimum-width. The fixed-width mode left-pads the value with zeros when it is shorter than the specified width and truncates the value when longer. Minimum-width mode works the same as fixed-width except that it does not truncate values longer than the width.\n\nWhen creating a format you can use any non-code characters as a separator. For example to generate the string \"1996-01-15T00:00:00\" you could use format: \"yyyy-mm-ddTHH:MM:SS\". Note that if you need to use a code character as a literal you can use the escape character backslash. The string \"1996y01m\" can be produced with the format \"yyyy\\ymm\\m\".\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.DateFormat","page":"Dates","title":"Dates.DateFormat","text":"DateFormat(format::AbstractString, locale=\"english\") -> DateFormat\n\nConstruct a date formatting object that can be used for parsing date strings or formatting a date object as a string. The following character codes can be used to construct the format string:\n\nCode Matches Comment\nY 1996, 96 Returns year of 1996, 0096\ny 1996, 96 Same as Y on parse but discards excess digits on format\nm 1, 01 Matches 1 or 2-digit months\nu Jan Matches abbreviated months according to the locale keyword\nU January Matches full month names according to the locale keyword\nd 1, 01 Matches 1 or 2-digit days\nH 00 Matches hours (24-hour clock)\nI 00 For outputting hours with 12-hour clock\nM 00 Matches minutes\nS 00 Matches seconds\ns .500 Matches milliseconds\ne Mon, Tues Matches abbreviated days of the week\nE Monday Matches full name days of the week\np AM Matches AM/PM (case-insensitive)\nyyyymmdd 19960101 Matches fixed-width year, month, and day\n\nCharacters not listed above are normally treated as delimiters between date and time slots. For example a dt string of \"1996-01-15T00:00:00.0\" would have a format string like \"y-m-dTH:M:S.s\". If you need to use a code character as a delimiter you can escape it using backslash. The date \"1995y01m\" would have the format \"y\\ym\\m\".\n\nNote that 12:00AM corresponds 00:00 (midnight), and 12:00PM corresponds to 12:00 (noon). When parsing a time with a p specifier, any hour (either H or I) is interpreted as as a 12-hour clock, so the I code is mainly useful for output.\n\nCreating a DateFormat object is expensive. Whenever possible, create it once and use it many times or try the dateformat\"\" string macro. Using this macro creates the DateFormat object once at macro expansion time and reuses it later. There are also several pre-defined formatters, listed later.\n\nSee DateTime and format for how to use a DateFormat object to parse and write Date strings respectively.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/Dates.html#Dates.@dateformat_str","page":"Dates","title":"Dates.@dateformat_str","text":"dateformat\"Y-m-d H:M:S\"\n\nCreate a DateFormat object. Similar to DateFormat(\"Y-m-d H:M:S\") but creates the DateFormat object once during macro expansion.\n\nSee DateFormat for details about format specifiers.\n\n\n\n\n\n","category":"macro"},{"location":"stdlib/Dates.html#Dates.DateTime-Tuple{AbstractString, DateFormat}","page":"Dates","title":"Dates.DateTime","text":"DateTime(dt::AbstractString, df::DateFormat=ISODateTimeFormat) -> DateTime\n\nConstruct a DateTime by parsing the dt date time string following the pattern given in the DateFormat object, or dateformat\"yyyy-mm-dd\\THH:MM:SS.s\" if omitted.\n\nSimilar to DateTime(::AbstractString, ::AbstractString) but more efficient when repeatedly parsing similarly formatted date time strings with a pre-created DateFormat object.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Date-Tuple{Int64, Int64, Int64}","page":"Dates","title":"Dates.Date","text":"Date(y, [m, d]) -> Date\n\nConstruct a Date type by parts. Arguments must be convertible to Int64.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Date-Tuple{Period}","page":"Dates","title":"Dates.Date","text":"Date(period::Period...) -> Date\n\nConstruct a Date type by Period type parts. Arguments may be in any order. Date parts not provided will default to the value of Dates.default(period).\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Date-Tuple{Function, Any, Any, Any}","page":"Dates","title":"Dates.Date","text":"Date(f::Function, y[, m, d]; step=Day(1), limit=10000) -> Date\n\nCreate a Date through the adjuster API. The starting point will be constructed from the provided y, m, d arguments, and will be adjusted until f::Function returns true. The step size in adjusting can be provided manually through the step keyword. limit provides a limit to the max number of iterations the adjustment API will pursue before throwing an error (given that f::Function is never satisfied).\n\nExamples\n\njulia> Date(date -> week(date) == 20, 2010, 01, 01)\n2010-05-17\n\njulia> Date(date -> year(date) == 2010, 2000, 01, 01)\n2010-01-01\n\njulia> Date(date -> month(date) == 10, 2000, 01, 01; limit = 5)\nERROR: ArgumentError: Adjustment limit reached: 5 iterations\nStacktrace:\n[...]\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Date-Tuple{TimeType}","page":"Dates","title":"Dates.Date","text":"Date(dt::DateTime) -> Date\n\nConvert a DateTime to a Date. The hour, minute, second, and millisecond parts of the DateTime are truncated, so only the year, month and day parts are used in construction.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Date-Tuple{AbstractString, AbstractString}","page":"Dates","title":"Dates.Date","text":"Date(d::AbstractString, format::AbstractString; locale=\"english\") -> Date\n\nConstruct a Date by parsing the d date string following the pattern given in the format string (see DateFormat for syntax).\n\nnote: Note\nThis method creates a DateFormat object each time it is called. It is recommended that you create a DateFormat object instead and use that as the second argument to avoid performance loss when using the same format repeatedly.\n\nExamples\n\njulia> Date(\"2020-01-01\", \"yyyy-mm-dd\")\n2020-01-01\n\njulia> a = (\"2020-01-01\", \"2020-01-02\");\n\njulia> [Date(d, dateformat\"yyyy-mm-dd\") for d ∈ a] # preferred\n2-element Vector{Date}:\n 2020-01-01\n 2020-01-02\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Date-Tuple{AbstractString, DateFormat}","page":"Dates","title":"Dates.Date","text":"Date(d::AbstractString, df::DateFormat=ISODateFormat) -> Date\n\nConstruct a Date by parsing the d date string following the pattern given in the DateFormat object, or dateformat\"yyyy-mm-dd\" if omitted.\n\nSimilar to Date(::AbstractString, ::AbstractString) but more efficient when repeatedly parsing similarly formatted date strings with a pre-created DateFormat object.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Time-NTuple{5, Int64}","page":"Dates","title":"Dates.Time","text":"Time(h, [mi, s, ms, us, ns]) -> Time\n\nConstruct a Time type by parts. Arguments must be convertible to Int64.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Time-Tuple{TimePeriod}","page":"Dates","title":"Dates.Time","text":"Time(period::TimePeriod...) -> Time\n\nConstruct a Time type by Period type parts. Arguments may be in any order. Time parts not provided will default to the value of Dates.default(period).\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Time-Tuple{Function, Vararg{Any}}","page":"Dates","title":"Dates.Time","text":"Time(f::Function, h, mi=0; step::Period=Second(1), limit::Int=10000)\nTime(f::Function, h, mi, s; step::Period=Millisecond(1), limit::Int=10000)\nTime(f::Function, h, mi, s, ms; step::Period=Microsecond(1), limit::Int=10000)\nTime(f::Function, h, mi, s, ms, us; step::Period=Nanosecond(1), limit::Int=10000)\n\nCreate a Time through the adjuster API. The starting point will be constructed from the provided h, mi, s, ms, us arguments, and will be adjusted until f::Function returns true. The step size in adjusting can be provided manually through the step keyword. limit provides a limit to the max number of iterations the adjustment API will pursue before throwing an error (in the case that f::Function is never satisfied). Note that the default step will adjust to allow for greater precision for the given arguments; i.e. if hour, minute, and second arguments are provided, the default step will be Millisecond(1) instead of Second(1).\n\nExamples\n\njulia> Time(t -> minute(t) == 30, 20)\n20:30:00\n\njulia> Time(t -> minute(t) == 0, 20)\n20:00:00\n\njulia> Time(t -> hour(t) == 10, 3; limit = 5)\nERROR: ArgumentError: Adjustment limit reached: 5 iterations\nStacktrace:\n[...]\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Time-Tuple{DateTime}","page":"Dates","title":"Dates.Time","text":"Time(dt::DateTime) -> Time\n\nConvert a DateTime to a Time. The hour, minute, second, and millisecond parts of the DateTime are used to create the new Time. Microsecond and nanoseconds are zero by default.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Time-Tuple{AbstractString, AbstractString}","page":"Dates","title":"Dates.Time","text":"Time(t::AbstractString, format::AbstractString; locale=\"english\") -> Time\n\nConstruct a Time by parsing the t time string following the pattern given in the format string (see DateFormat for syntax).\n\nnote: Note\nThis method creates a DateFormat object each time it is called. It is recommended that you create a DateFormat object instead and use that as the second argument to avoid performance loss when using the same format repeatedly.\n\nExamples\n\njulia> Time(\"12:34pm\", \"HH:MMp\")\n12:34:00\n\njulia> a = (\"12:34pm\", \"2:34am\");\n\njulia> [Time(d, dateformat\"HH:MMp\") for d ∈ a] # preferred\n2-element Vector{Time}:\n 12:34:00\n 02:34:00\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Time-Tuple{AbstractString, DateFormat}","page":"Dates","title":"Dates.Time","text":"Time(t::AbstractString, df::DateFormat=ISOTimeFormat) -> Time\n\nConstruct a Time by parsing the t date time string following the pattern given in the DateFormat object, or dateformat\"HH:MM:SS.s\" if omitted.\n\nSimilar to Time(::AbstractString, ::AbstractString) but more efficient when repeatedly parsing similarly formatted time strings with a pre-created DateFormat object.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.now-Tuple{}","page":"Dates","title":"Dates.now","text":"now() -> DateTime\n\nReturn a DateTime corresponding to the user's system time including the system timezone locale.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.now-Tuple{Type{UTC}}","page":"Dates","title":"Dates.now","text":"now(::Type{UTC}) -> DateTime\n\nReturn a DateTime corresponding to the user's system time as UTC/GMT. For other time zones, see the TimeZones.jl package.\n\nExamples\n\njulia> now(UTC)\n2023-01-04T10:52:24.864\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Base.eps-Tuple{Union{Type{Date}, Type{DateTime}, Type{Time}, TimeType}}","page":"Dates","title":"Base.eps","text":"eps(::Type{DateTime}) -> Millisecond\neps(::Type{Date}) -> Day\neps(::Type{Time}) -> Nanosecond\neps(::TimeType) -> Period\n\nReturn the smallest unit value supported by the TimeType.\n\nExamples\n\njulia> eps(DateTime)\n1 millisecond\n\njulia> eps(Date)\n1 day\n\njulia> eps(Time)\n1 nanosecond\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Accessor-Functions-2","page":"Dates","title":"Accessor Functions","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Dates.year\nDates.month\nDates.week\nDates.day\nDates.hour\nDates.minute\nDates.second\nDates.millisecond\nDates.microsecond\nDates.nanosecond\nDates.Year(::Dates.TimeType)\nDates.Month(::Dates.TimeType)\nDates.Week(::Dates.TimeType)\nDates.Day(::Dates.TimeType)\nDates.Hour(::DateTime)\nDates.Minute(::DateTime)\nDates.Second(::DateTime)\nDates.Millisecond(::DateTime)\nDates.Microsecond(::Dates.Time)\nDates.Nanosecond(::Dates.Time)\nDates.yearmonth\nDates.monthday\nDates.yearmonthday","category":"page"},{"location":"stdlib/Dates.html#Dates.year","page":"Dates","title":"Dates.year","text":"year(dt::TimeType) -> Int64\n\nThe year of a Date or DateTime as an Int64.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.month","page":"Dates","title":"Dates.month","text":"month(dt::TimeType) -> Int64\n\nThe month of a Date or DateTime as an Int64.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.week","page":"Dates","title":"Dates.week","text":"week(dt::TimeType) -> Int64\n\nReturn the ISO week date of a Date or DateTime as an Int64. Note that the first week of a year is the week that contains the first Thursday of the year, which can result in dates prior to January 4th being in the last week of the previous year. For example, week(Date(2005, 1, 1)) is the 53rd week of 2004.\n\nExamples\n\njulia> week(Date(1989, 6, 22))\n25\n\njulia> week(Date(2005, 1, 1))\n53\n\njulia> week(Date(2004, 12, 31))\n53\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.day","page":"Dates","title":"Dates.day","text":"day(dt::TimeType) -> Int64\n\nThe day of month of a Date or DateTime as an Int64.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.hour","page":"Dates","title":"Dates.hour","text":"hour(dt::DateTime) -> Int64\n\nThe hour of day of a DateTime as an Int64.\n\n\n\n\n\nhour(t::Time) -> Int64\n\nThe hour of a Time as an Int64.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.minute","page":"Dates","title":"Dates.minute","text":"minute(dt::DateTime) -> Int64\n\nThe minute of a DateTime as an Int64.\n\n\n\n\n\nminute(t::Time) -> Int64\n\nThe minute of a Time as an Int64.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.second","page":"Dates","title":"Dates.second","text":"second(dt::DateTime) -> Int64\n\nThe second of a DateTime as an Int64.\n\n\n\n\n\nsecond(t::Time) -> Int64\n\nThe second of a Time as an Int64.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.millisecond","page":"Dates","title":"Dates.millisecond","text":"millisecond(dt::DateTime) -> Int64\n\nThe millisecond of a DateTime as an Int64.\n\n\n\n\n\nmillisecond(t::Time) -> Int64\n\nThe millisecond of a Time as an Int64.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.microsecond","page":"Dates","title":"Dates.microsecond","text":"microsecond(t::Time) -> Int64\n\nThe microsecond of a Time as an Int64.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.nanosecond","page":"Dates","title":"Dates.nanosecond","text":"nanosecond(t::Time) -> Int64\n\nThe nanosecond of a Time as an Int64.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.Year-Tuple{TimeType}","page":"Dates","title":"Dates.Year","text":"Year(v)\n\nConstruct a Year object with the given v value. Input must be losslessly convertible to an Int64.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Month-Tuple{TimeType}","page":"Dates","title":"Dates.Month","text":"Month(v)\n\nConstruct a Month object with the given v value. Input must be losslessly convertible to an Int64.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Week-Tuple{TimeType}","page":"Dates","title":"Dates.Week","text":"Week(v)\n\nConstruct a Week object with the given v value. Input must be losslessly convertible to an Int64.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Day-Tuple{TimeType}","page":"Dates","title":"Dates.Day","text":"Day(v)\n\nConstruct a Day object with the given v value. Input must be losslessly convertible to an Int64.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Hour-Tuple{DateTime}","page":"Dates","title":"Dates.Hour","text":"Hour(dt::DateTime) -> Hour\n\nThe hour part of a DateTime as a Hour.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Minute-Tuple{DateTime}","page":"Dates","title":"Dates.Minute","text":"Minute(dt::DateTime) -> Minute\n\nThe minute part of a DateTime as a Minute.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Second-Tuple{DateTime}","page":"Dates","title":"Dates.Second","text":"Second(dt::DateTime) -> Second\n\nThe second part of a DateTime as a Second.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Millisecond-Tuple{DateTime}","page":"Dates","title":"Dates.Millisecond","text":"Millisecond(dt::DateTime) -> Millisecond\n\nThe millisecond part of a DateTime as a Millisecond.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Microsecond-Tuple{Time}","page":"Dates","title":"Dates.Microsecond","text":"Microsecond(dt::Time) -> Microsecond\n\nThe microsecond part of a Time as a Microsecond.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.Nanosecond-Tuple{Time}","page":"Dates","title":"Dates.Nanosecond","text":"Nanosecond(dt::Time) -> Nanosecond\n\nThe nanosecond part of a Time as a Nanosecond.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.yearmonth","page":"Dates","title":"Dates.yearmonth","text":"yearmonth(dt::TimeType) -> (Int64, Int64)\n\nSimultaneously return the year and month parts of a Date or DateTime.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.monthday","page":"Dates","title":"Dates.monthday","text":"monthday(dt::TimeType) -> (Int64, Int64)\n\nSimultaneously return the month and day parts of a Date or DateTime.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.yearmonthday","page":"Dates","title":"Dates.yearmonthday","text":"yearmonthday(dt::TimeType) -> (Int64, Int64, Int64)\n\nSimultaneously return the year, month and day parts of a Date or DateTime.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Query-Functions-2","page":"Dates","title":"Query Functions","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Dates.dayname\nDates.dayabbr\nDates.dayofweek\nDates.dayofmonth\nDates.dayofweekofmonth\nDates.daysofweekinmonth\nDates.monthname\nDates.monthabbr\nDates.daysinmonth\nDates.isleapyear\nDates.dayofyear\nDates.daysinyear\nDates.quarterofyear\nDates.dayofquarter","category":"page"},{"location":"stdlib/Dates.html#Dates.dayname","page":"Dates","title":"Dates.dayname","text":"dayname(dt::TimeType; locale=\"english\") -> String\ndayname(day::Integer; locale=\"english\") -> String\n\nReturn the full day name corresponding to the day of the week of the Date or DateTime in the given locale. Also accepts Integer.\n\nExamples\n\njulia> dayname(Date(\"2000-01-01\"))\n\"Saturday\"\n\njulia> dayname(4)\n\"Thursday\"\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.dayabbr","page":"Dates","title":"Dates.dayabbr","text":"dayabbr(dt::TimeType; locale=\"english\") -> String\ndayabbr(day::Integer; locale=\"english\") -> String\n\nReturn the abbreviated name corresponding to the day of the week of the Date or DateTime in the given locale. Also accepts Integer.\n\nExamples\n\njulia> dayabbr(Date(\"2000-01-01\"))\n\"Sat\"\n\njulia> dayabbr(3)\n\"Wed\"\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.dayofweek","page":"Dates","title":"Dates.dayofweek","text":"dayofweek(dt::TimeType) -> Int64\n\nReturn the day of the week as an Int64 with 1 = Monday, 2 = Tuesday, etc..\n\nExamples\n\njulia> dayofweek(Date(\"2000-01-01\"))\n6\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.dayofmonth","page":"Dates","title":"Dates.dayofmonth","text":"dayofmonth(dt::TimeType) -> Int64\n\nThe day of month of a Date or DateTime as an Int64.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.dayofweekofmonth","page":"Dates","title":"Dates.dayofweekofmonth","text":"dayofweekofmonth(dt::TimeType) -> Int\n\nFor the day of week of dt, return which number it is in dt's month. So if the day of the week of dt is Monday, then 1 = First Monday of the month, 2 = Second Monday of the month, etc. In the range 1:5.\n\nExamples\n\njulia> dayofweekofmonth(Date(\"2000-02-01\"))\n1\n\njulia> dayofweekofmonth(Date(\"2000-02-08\"))\n2\n\njulia> dayofweekofmonth(Date(\"2000-02-15\"))\n3\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.daysofweekinmonth","page":"Dates","title":"Dates.daysofweekinmonth","text":"daysofweekinmonth(dt::TimeType) -> Int\n\nFor the day of week of dt, return the total number of that day of the week in dt's month. Returns 4 or 5. Useful in temporal expressions for specifying the last day of a week in a month by including dayofweekofmonth(dt) == daysofweekinmonth(dt) in the adjuster function.\n\nExamples\n\njulia> daysofweekinmonth(Date(\"2005-01-01\"))\n5\n\njulia> daysofweekinmonth(Date(\"2005-01-04\"))\n4\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.monthname","page":"Dates","title":"Dates.monthname","text":"monthname(dt::TimeType; locale=\"english\") -> String\nmonthname(month::Integer, locale=\"english\") -> String\n\nReturn the full name of the month of the Date or DateTime or Integer in the given locale.\n\nExamples\n\njulia> monthname(Date(\"2005-01-04\"))\n\"January\"\n\njulia> monthname(2)\n\"February\"\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.monthabbr","page":"Dates","title":"Dates.monthabbr","text":"monthabbr(dt::TimeType; locale=\"english\") -> String\nmonthabbr(month::Integer, locale=\"english\") -> String\n\nReturn the abbreviated month name of the Date or DateTime or Integer in the given locale.\n\nExamples\n\njulia> monthabbr(Date(\"2005-01-04\"))\n\"Jan\"\n\njulia> monthabbr(2)\n\"Feb\"\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.daysinmonth","page":"Dates","title":"Dates.daysinmonth","text":"daysinmonth(dt::TimeType) -> Int\n\nReturn the number of days in the month of dt. Value will be 28, 29, 30, or 31.\n\nExamples\n\njulia> daysinmonth(Date(\"2000-01\"))\n31\n\njulia> daysinmonth(Date(\"2001-02\"))\n28\n\njulia> daysinmonth(Date(\"2000-02\"))\n29\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.isleapyear","page":"Dates","title":"Dates.isleapyear","text":"isleapyear(dt::TimeType) -> Bool\n\nReturn true if the year of dt is a leap year.\n\nExamples\n\njulia> isleapyear(Date(\"2004\"))\ntrue\n\njulia> isleapyear(Date(\"2005\"))\nfalse\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.dayofyear","page":"Dates","title":"Dates.dayofyear","text":"dayofyear(dt::TimeType) -> Int\n\nReturn the day of the year for dt with January 1st being day 1.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.daysinyear","page":"Dates","title":"Dates.daysinyear","text":"daysinyear(dt::TimeType) -> Int\n\nReturn 366 if the year of dt is a leap year, otherwise return 365.\n\nExamples\n\njulia> daysinyear(1999)\n365\n\njulia> daysinyear(2000)\n366\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.quarterofyear","page":"Dates","title":"Dates.quarterofyear","text":"quarterofyear(dt::TimeType) -> Int\n\nReturn the quarter that dt resides in. Range of value is 1:4.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.dayofquarter","page":"Dates","title":"Dates.dayofquarter","text":"dayofquarter(dt::TimeType) -> Int\n\nReturn the day of the current quarter of dt. Range of value is 1:92.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Adjuster-Functions-2","page":"Dates","title":"Adjuster Functions","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Base.trunc(::Dates.TimeType, ::Type{Dates.Period})\nDates.firstdayofweek\nDates.lastdayofweek\nDates.firstdayofmonth\nDates.lastdayofmonth\nDates.firstdayofyear\nDates.lastdayofyear\nDates.firstdayofquarter\nDates.lastdayofquarter\nDates.tonext(::Dates.TimeType, ::Int)\nDates.toprev(::Dates.TimeType, ::Int)\nDates.tofirst\nDates.tolast\nDates.tonext(::Function, ::Dates.TimeType)\nDates.toprev(::Function, ::Dates.TimeType)","category":"page"},{"location":"stdlib/Dates.html#Base.trunc-Tuple{TimeType, Type{Period}}","page":"Dates","title":"Base.trunc","text":"trunc(dt::TimeType, ::Type{Period}) -> TimeType\n\nTruncates the value of dt according to the provided Period type.\n\nExamples\n\njulia> trunc(DateTime(\"1996-01-01T12:30:00\"), Day)\n1996-01-01T00:00:00\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.firstdayofweek","page":"Dates","title":"Dates.firstdayofweek","text":"firstdayofweek(dt::TimeType) -> TimeType\n\nAdjusts dt to the Monday of its week.\n\nExamples\n\njulia> firstdayofweek(DateTime(\"1996-01-05T12:30:00\"))\n1996-01-01T00:00:00\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.lastdayofweek","page":"Dates","title":"Dates.lastdayofweek","text":"lastdayofweek(dt::TimeType) -> TimeType\n\nAdjusts dt to the Sunday of its week.\n\nExamples\n\njulia> lastdayofweek(DateTime(\"1996-01-05T12:30:00\"))\n1996-01-07T00:00:00\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.firstdayofmonth","page":"Dates","title":"Dates.firstdayofmonth","text":"firstdayofmonth(dt::TimeType) -> TimeType\n\nAdjusts dt to the first day of its month.\n\nExamples\n\njulia> firstdayofmonth(DateTime(\"1996-05-20\"))\n1996-05-01T00:00:00\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.lastdayofmonth","page":"Dates","title":"Dates.lastdayofmonth","text":"lastdayofmonth(dt::TimeType) -> TimeType\n\nAdjusts dt to the last day of its month.\n\nExamples\n\njulia> lastdayofmonth(DateTime(\"1996-05-20\"))\n1996-05-31T00:00:00\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.firstdayofyear","page":"Dates","title":"Dates.firstdayofyear","text":"firstdayofyear(dt::TimeType) -> TimeType\n\nAdjusts dt to the first day of its year.\n\nExamples\n\njulia> firstdayofyear(DateTime(\"1996-05-20\"))\n1996-01-01T00:00:00\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.lastdayofyear","page":"Dates","title":"Dates.lastdayofyear","text":"lastdayofyear(dt::TimeType) -> TimeType\n\nAdjusts dt to the last day of its year.\n\nExamples\n\njulia> lastdayofyear(DateTime(\"1996-05-20\"))\n1996-12-31T00:00:00\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.firstdayofquarter","page":"Dates","title":"Dates.firstdayofquarter","text":"firstdayofquarter(dt::TimeType) -> TimeType\n\nAdjusts dt to the first day of its quarter.\n\nExamples\n\njulia> firstdayofquarter(DateTime(\"1996-05-20\"))\n1996-04-01T00:00:00\n\njulia> firstdayofquarter(DateTime(\"1996-08-20\"))\n1996-07-01T00:00:00\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.lastdayofquarter","page":"Dates","title":"Dates.lastdayofquarter","text":"lastdayofquarter(dt::TimeType) -> TimeType\n\nAdjusts dt to the last day of its quarter.\n\nExamples\n\njulia> lastdayofquarter(DateTime(\"1996-05-20\"))\n1996-06-30T00:00:00\n\njulia> lastdayofquarter(DateTime(\"1996-08-20\"))\n1996-09-30T00:00:00\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.tonext-Tuple{TimeType, Int64}","page":"Dates","title":"Dates.tonext","text":"tonext(dt::TimeType, dow::Int; same::Bool=false) -> TimeType\n\nAdjusts dt to the next day of week corresponding to dow with 1 = Monday, 2 = Tuesday, etc. Setting same=true allows the current dt to be considered as the next dow, allowing for no adjustment to occur.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.toprev-Tuple{TimeType, Int64}","page":"Dates","title":"Dates.toprev","text":"toprev(dt::TimeType, dow::Int; same::Bool=false) -> TimeType\n\nAdjusts dt to the previous day of week corresponding to dow with 1 = Monday, 2 = Tuesday, etc. Setting same=true allows the current dt to be considered as the previous dow, allowing for no adjustment to occur.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.tofirst","page":"Dates","title":"Dates.tofirst","text":"tofirst(dt::TimeType, dow::Int; of=Month) -> TimeType\n\nAdjusts dt to the first dow of its month. Alternatively, of=Year will adjust to the first dow of the year.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.tolast","page":"Dates","title":"Dates.tolast","text":"tolast(dt::TimeType, dow::Int; of=Month) -> TimeType\n\nAdjusts dt to the last dow of its month. Alternatively, of=Year will adjust to the last dow of the year.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.tonext-Tuple{Function, TimeType}","page":"Dates","title":"Dates.tonext","text":"tonext(func::Function, dt::TimeType; step=Day(1), limit=10000, same=false) -> TimeType\n\nAdjusts dt by iterating at most limit iterations by step increments until func returns true. func must take a single TimeType argument and return a Bool. same allows dt to be considered in satisfying func.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.toprev-Tuple{Function, TimeType}","page":"Dates","title":"Dates.toprev","text":"toprev(func::Function, dt::TimeType; step=Day(-1), limit=10000, same=false) -> TimeType\n\nAdjusts dt by iterating at most limit iterations by step increments until func returns true. func must take a single TimeType argument and return a Bool. same allows dt to be considered in satisfying func.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Periods","page":"Dates","title":"Periods","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Dates.Period(::Any)\nDates.CompoundPeriod(::Vector{<:Dates.Period})\nDates.canonicalize\nDates.value\nDates.default\nDates.periods","category":"page"},{"location":"stdlib/Dates.html#Dates.Period-Tuple{Any}","page":"Dates","title":"Dates.Period","text":"Year(v)\nQuarter(v)\nMonth(v)\nWeek(v)\nDay(v)\nHour(v)\nMinute(v)\nSecond(v)\nMillisecond(v)\nMicrosecond(v)\nNanosecond(v)\n\nConstruct a Period type with the given v value. Input must be losslessly convertible to an Int64.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.CompoundPeriod-Tuple{Vector{<:Period}}","page":"Dates","title":"Dates.CompoundPeriod","text":"CompoundPeriod(periods) -> CompoundPeriod\n\nConstruct a CompoundPeriod from a Vector of Periods. All Periods of the same type will be added together.\n\nExamples\n\njulia> Dates.CompoundPeriod(Dates.Hour(12), Dates.Hour(13))\n25 hours\n\njulia> Dates.CompoundPeriod(Dates.Hour(-1), Dates.Minute(1))\n-1 hour, 1 minute\n\njulia> Dates.CompoundPeriod(Dates.Month(1), Dates.Week(-2))\n1 month, -2 weeks\n\njulia> Dates.CompoundPeriod(Dates.Minute(50000))\n50000 minutes\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Dates.canonicalize","page":"Dates","title":"Dates.canonicalize","text":"canonicalize(::CompoundPeriod) -> CompoundPeriod\n\nReduces the CompoundPeriod into its canonical form by applying the following rules:\n\nAny Period large enough be partially representable by a coarser Period will be broken into multiple Periods (eg. Hour(30) becomes Day(1) + Hour(6))\nPeriods with opposite signs will be combined when possible (eg. Hour(1) - Day(1) becomes -Hour(23))\n\nExamples\n\njulia> canonicalize(Dates.CompoundPeriod(Dates.Hour(12), Dates.Hour(13)))\n1 day, 1 hour\n\njulia> canonicalize(Dates.CompoundPeriod(Dates.Hour(-1), Dates.Minute(1)))\n-59 minutes\n\njulia> canonicalize(Dates.CompoundPeriod(Dates.Month(1), Dates.Week(-2)))\n1 month, -2 weeks\n\njulia> canonicalize(Dates.CompoundPeriod(Dates.Minute(50000)))\n4 weeks, 6 days, 17 hours, 20 minutes\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.value","page":"Dates","title":"Dates.value","text":"Dates.value(x::Period) -> Int64\n\nFor a given period, return the value associated with that period.  For example, value(Millisecond(10)) returns 10 as an integer.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.default","page":"Dates","title":"Dates.default","text":"default(p::Period) -> Period\n\nReturn a sensible \"default\" value for the input Period by returning T(1) for Year, Month, and Day, and T(0) for Hour, Minute, Second, and Millisecond.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.periods","page":"Dates","title":"Dates.periods","text":"Dates.periods(::CompoundPeriod) -> Vector{Period}\n\nReturn the Vector of Periods that comprise the given CompoundPeriod.\n\ncompat: Julia 1.7\nThis function requires Julia 1.7 or later.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Rounding-Functions","page":"Dates","title":"Rounding Functions","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Date and DateTime values can be rounded to a specified resolution (e.g., 1 month or 15 minutes) with floor, ceil, or round.","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Base.floor(::Dates.TimeType, ::Dates.Period)\nBase.ceil(::Dates.TimeType, ::Dates.Period)\nBase.round(::Dates.TimeType, ::Dates.Period, ::RoundingMode{:NearestTiesUp})","category":"page"},{"location":"stdlib/Dates.html#Base.floor-Tuple{TimeType, Period}","page":"Dates","title":"Base.floor","text":"floor(dt::TimeType, p::Period) -> TimeType\n\nReturn the nearest Date or DateTime less than or equal to dt at resolution p.\n\nFor convenience, p may be a type instead of a value: floor(dt, Dates.Hour) is a shortcut for floor(dt, Dates.Hour(1)).\n\njulia> floor(Date(1985, 8, 16), Month)\n1985-08-01\n\njulia> floor(DateTime(2013, 2, 13, 0, 31, 20), Minute(15))\n2013-02-13T00:30:00\n\njulia> floor(DateTime(2016, 8, 6, 12, 0, 0), Day)\n2016-08-06T00:00:00\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Base.ceil-Tuple{TimeType, Period}","page":"Dates","title":"Base.ceil","text":"ceil(dt::TimeType, p::Period) -> TimeType\n\nReturn the nearest Date or DateTime greater than or equal to dt at resolution p.\n\nFor convenience, p may be a type instead of a value: ceil(dt, Dates.Hour) is a shortcut for ceil(dt, Dates.Hour(1)).\n\njulia> ceil(Date(1985, 8, 16), Month)\n1985-09-01\n\njulia> ceil(DateTime(2013, 2, 13, 0, 31, 20), Minute(15))\n2013-02-13T00:45:00\n\njulia> ceil(DateTime(2016, 8, 6, 12, 0, 0), Day)\n2016-08-07T00:00:00\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Base.round-Tuple{TimeType, Period, RoundingMode{:NearestTiesUp}}","page":"Dates","title":"Base.round","text":"round(dt::TimeType, p::Period, [r::RoundingMode]) -> TimeType\n\nReturn the Date or DateTime nearest to dt at resolution p. By default (RoundNearestTiesUp), ties (e.g., rounding 9:30 to the nearest hour) will be rounded up.\n\nFor convenience, p may be a type instead of a value: round(dt, Dates.Hour) is a shortcut for round(dt, Dates.Hour(1)).\n\njulia> round(Date(1985, 8, 16), Month)\n1985-08-01\n\njulia> round(DateTime(2013, 2, 13, 0, 31, 20), Minute(15))\n2013-02-13T00:30:00\n\njulia> round(DateTime(2016, 8, 6, 12, 0, 0), Day)\n2016-08-07T00:00:00\n\nValid rounding modes for round(::TimeType, ::Period, ::RoundingMode) are RoundNearestTiesUp (default), RoundDown (floor), and RoundUp (ceil).\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Most Period values can also be rounded to a specified resolution:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Base.floor(::Dates.ConvertiblePeriod, ::T) where T <: Dates.ConvertiblePeriod\nBase.ceil(::Dates.ConvertiblePeriod, ::Dates.ConvertiblePeriod)\nBase.round(::Dates.ConvertiblePeriod, ::Dates.ConvertiblePeriod, ::RoundingMode{:NearestTiesUp})","category":"page"},{"location":"stdlib/Dates.html#Base.floor-Union{Tuple{T}, Tuple{Union{Day, Week, TimePeriod}, T}} where T<:Union{Day, Week, TimePeriod}","page":"Dates","title":"Base.floor","text":"floor(x::Period, precision::T) where T <: Union{TimePeriod, Week, Day} -> T\n\nRound x down to the nearest multiple of precision. If x and precision are different subtypes of Period, the return value will have the same type as precision.\n\nFor convenience, precision may be a type instead of a value: floor(x, Dates.Hour) is a shortcut for floor(x, Dates.Hour(1)).\n\njulia> floor(Day(16), Week)\n2 weeks\n\njulia> floor(Minute(44), Minute(15))\n30 minutes\n\njulia> floor(Hour(36), Day)\n1 day\n\nRounding to a precision of Months or Years is not supported, as these Periods are of inconsistent length.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Base.ceil-Tuple{Union{Day, Week, TimePeriod}, Union{Day, Week, TimePeriod}}","page":"Dates","title":"Base.ceil","text":"ceil(x::Period, precision::T) where T <: Union{TimePeriod, Week, Day} -> T\n\nRound x up to the nearest multiple of precision. If x and precision are different subtypes of Period, the return value will have the same type as precision.\n\nFor convenience, precision may be a type instead of a value: ceil(x, Dates.Hour) is a shortcut for ceil(x, Dates.Hour(1)).\n\njulia> ceil(Day(16), Week)\n3 weeks\n\njulia> ceil(Minute(44), Minute(15))\n45 minutes\n\njulia> ceil(Hour(36), Day)\n2 days\n\nRounding to a precision of Months or Years is not supported, as these Periods are of inconsistent length.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html#Base.round-Tuple{Union{Day, Week, TimePeriod}, Union{Day, Week, TimePeriod}, RoundingMode{:NearestTiesUp}}","page":"Dates","title":"Base.round","text":"round(x::Period, precision::T, [r::RoundingMode]) where T <: Union{TimePeriod, Week, Day} -> T\n\nRound x to the nearest multiple of precision. If x and precision are different subtypes of Period, the return value will have the same type as precision. By default (RoundNearestTiesUp), ties (e.g., rounding 90 minutes to the nearest hour) will be rounded up.\n\nFor convenience, precision may be a type instead of a value: round(x, Dates.Hour) is a shortcut for round(x, Dates.Hour(1)).\n\njulia> round(Day(16), Week)\n2 weeks\n\njulia> round(Minute(44), Minute(15))\n45 minutes\n\njulia> round(Hour(36), Day)\n2 days\n\nValid rounding modes for round(::Period, ::T, ::RoundingMode) are RoundNearestTiesUp (default), RoundDown (floor), and RoundUp (ceil).\n\nRounding to a precision of Months or Years is not supported, as these Periods are of inconsistent length.\n\n\n\n\n\n","category":"method"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"The following functions are not exported:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Dates.floorceil\nDates.epochdays2date\nDates.epochms2datetime\nDates.date2epochdays\nDates.datetime2epochms","category":"page"},{"location":"stdlib/Dates.html#Dates.floorceil","page":"Dates","title":"Dates.floorceil","text":"floorceil(dt::TimeType, p::Period) -> (TimeType, TimeType)\n\nSimultaneously return the floor and ceil of a Date or DateTime at resolution p. More efficient than calling both floor and ceil individually.\n\n\n\n\n\nfloorceil(x::Period, precision::T) where T <: Union{TimePeriod, Week, Day} -> (T, T)\n\nSimultaneously return the floor and ceil of Period at resolution p.  More efficient than calling both floor and ceil individually.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.epochdays2date","page":"Dates","title":"Dates.epochdays2date","text":"epochdays2date(days) -> Date\n\nTake the number of days since the rounding epoch (0000-01-01T00:00:00) and return the corresponding Date.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.epochms2datetime","page":"Dates","title":"Dates.epochms2datetime","text":"epochms2datetime(milliseconds) -> DateTime\n\nTake the number of milliseconds since the rounding epoch (0000-01-01T00:00:00) and return the corresponding DateTime.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.date2epochdays","page":"Dates","title":"Dates.date2epochdays","text":"date2epochdays(dt::Date) -> Int64\n\nTake the given Date and return the number of days since the rounding epoch (0000-01-01T00:00:00) as an Int64.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.datetime2epochms","page":"Dates","title":"Dates.datetime2epochms","text":"datetime2epochms(dt::DateTime) -> Int64\n\nTake the given DateTime and return the number of milliseconds since the rounding epoch (0000-01-01T00:00:00) as an Int64.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Conversion-Functions","page":"Dates","title":"Conversion Functions","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Dates.today\nDates.unix2datetime\nDates.datetime2unix\nDates.julian2datetime\nDates.datetime2julian\nDates.rata2datetime\nDates.datetime2rata","category":"page"},{"location":"stdlib/Dates.html#Dates.today","page":"Dates","title":"Dates.today","text":"today() -> Date\n\nReturn the date portion of now().\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.unix2datetime","page":"Dates","title":"Dates.unix2datetime","text":"unix2datetime(x) -> DateTime\n\nTake the number of seconds since unix epoch 1970-01-01T00:00:00 and convert to the corresponding DateTime.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.datetime2unix","page":"Dates","title":"Dates.datetime2unix","text":"datetime2unix(dt::DateTime) -> Float64\n\nTake the given DateTime and return the number of seconds since the unix epoch 1970-01-01T00:00:00 as a Float64.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.julian2datetime","page":"Dates","title":"Dates.julian2datetime","text":"julian2datetime(julian_days) -> DateTime\n\nTake the number of Julian calendar days since epoch -4713-11-24T12:00:00 and return the corresponding DateTime.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.datetime2julian","page":"Dates","title":"Dates.datetime2julian","text":"datetime2julian(dt::DateTime) -> Float64\n\nTake the given DateTime and return the number of Julian calendar days since the julian epoch -4713-11-24T12:00:00 as a Float64.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.rata2datetime","page":"Dates","title":"Dates.rata2datetime","text":"rata2datetime(days) -> DateTime\n\nTake the number of Rata Die days since epoch 0000-12-31T00:00:00 and return the corresponding DateTime.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Dates.datetime2rata","page":"Dates","title":"Dates.datetime2rata","text":"datetime2rata(dt::TimeType) -> Int64\n\nReturn the number of Rata Die days since epoch from the given Date or DateTime.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Dates.html#Constants","page":"Dates","title":"Constants","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Days of the Week:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Variable Abbr. Value (Int)\nMonday Mon 1\nTuesday Tue 2\nWednesday Wed 3\nThursday Thu 4\nFriday Fri 5\nSaturday Sat 6\nSunday Sun 7","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Months of the Year:","category":"page"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"Variable Abbr. Value (Int)\nJanuary Jan 1\nFebruary Feb 2\nMarch Mar 3\nApril Apr 4\nMay May 5\nJune Jun 6\nJuly Jul 7\nAugust Aug 8\nSeptember Sep 9\nOctober Oct 10\nNovember Nov 11\nDecember Dec 12","category":"page"},{"location":"stdlib/Dates.html#Common-Date-Formatters","page":"Dates","title":"Common Date Formatters","text":"","category":"section"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"ISODateTimeFormat\nISODateFormat\nISOTimeFormat\nRFC1123Format","category":"page"},{"location":"stdlib/Dates.html#Dates.ISODateTimeFormat","page":"Dates","title":"Dates.ISODateTimeFormat","text":"Dates.ISODateTimeFormat\n\nDescribes the ISO8601 formatting for a date and time. This is the default value for Dates.format of a DateTime.\n\nExamples\n\njulia> Dates.format(DateTime(2018, 8, 8, 12, 0, 43, 1), ISODateTimeFormat)\n\"2018-08-08T12:00:43.001\"\n\n\n\n\n\n","category":"constant"},{"location":"stdlib/Dates.html#Dates.ISODateFormat","page":"Dates","title":"Dates.ISODateFormat","text":"Dates.ISODateFormat\n\nDescribes the ISO8601 formatting for a date. This is the default value for Dates.format of a Date.\n\nExamples\n\njulia> Dates.format(Date(2018, 8, 8), ISODateFormat)\n\"2018-08-08\"\n\n\n\n\n\n","category":"constant"},{"location":"stdlib/Dates.html#Dates.ISOTimeFormat","page":"Dates","title":"Dates.ISOTimeFormat","text":"Dates.ISOTimeFormat\n\nDescribes the ISO8601 formatting for a time. This is the default value for Dates.format of a Time.\n\nExamples\n\njulia> Dates.format(Time(12, 0, 43, 1), ISOTimeFormat)\n\"12:00:43.001\"\n\n\n\n\n\n","category":"constant"},{"location":"stdlib/Dates.html#Dates.RFC1123Format","page":"Dates","title":"Dates.RFC1123Format","text":"Dates.RFC1123Format\n\nDescribes the RFC1123 formatting for a date and time.\n\nExamples\n\njulia> Dates.format(DateTime(2018, 8, 8, 12, 0, 43, 1), RFC1123Format)\n\"Wed, 08 Aug 2018 12:00:43\"\n\n\n\n\n\n","category":"constant"},{"location":"stdlib/Dates.html","page":"Dates","title":"Dates","text":"DocTestSetup = nothing","category":"page"},{"location":"stdlib/TOML.html","page":"TOML","title":"TOML","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/stdlib/TOML/docs/src/index.md\"","category":"page"},{"location":"stdlib/TOML.html#TOML","page":"TOML","title":"TOML","text":"","category":"section"},{"location":"stdlib/TOML.html","page":"TOML","title":"TOML","text":"TOML.jl is a Julia standard library for parsing and writing TOML v1.0 files.","category":"page"},{"location":"stdlib/TOML.html#Parsing-TOML-data","page":"TOML","title":"Parsing TOML data","text":"","category":"section"},{"location":"stdlib/TOML.html","page":"TOML","title":"TOML","text":"julia> using TOML\n\njulia> data = \"\"\"\n           [database]\n           server = \"192.168.1.1\"\n           ports = [ 8001, 8001, 8002 ]\n       \"\"\";\n\njulia> TOML.parse(data)\nDict{String, Any} with 1 entry:\n  \"database\" => Dict{String, Any}(\"server\"=>\"192.168.1.1\", \"ports\"=>[8001, 8001…","category":"page"},{"location":"stdlib/TOML.html","page":"TOML","title":"TOML","text":"To parse a file, use TOML.parsefile. If the file has a syntax error, an exception is thrown:","category":"page"},{"location":"stdlib/TOML.html","page":"TOML","title":"TOML","text":"julia> using TOML\n\njulia> TOML.parse(\"\"\"\n           value = 0.0.0\n       \"\"\")\nERROR: TOML Parser error:\nnone:1:16 error: failed to parse value\n      value = 0.0.0\n                 ^\n[...]","category":"page"},{"location":"stdlib/TOML.html","page":"TOML","title":"TOML","text":"There are other versions of the parse functions (TOML.tryparse and TOML.tryparsefile) that instead of throwing exceptions on parser error returns a TOML.ParserError with information:","category":"page"},{"location":"stdlib/TOML.html","page":"TOML","title":"TOML","text":"julia> using TOML\n\njulia> err = TOML.tryparse(\"\"\"\n           value = 0.0.0\n       \"\"\");\n\njulia> err.type\nErrGenericValueError::ErrorType = 14\n\njulia> err.line\n1\n\njulia> err.column\n16","category":"page"},{"location":"stdlib/TOML.html#Exporting-data-to-TOML-file","page":"TOML","title":"Exporting data to TOML file","text":"","category":"section"},{"location":"stdlib/TOML.html","page":"TOML","title":"TOML","text":"The TOML.print function is used to print (or serialize) data into TOML format.","category":"page"},{"location":"stdlib/TOML.html","page":"TOML","title":"TOML","text":"julia> using TOML\n\njulia> data = Dict(\n          \"names\" => [\"Julia\", \"Julio\"],\n          \"age\" => [10, 20],\n       );\n\njulia> TOML.print(data)\nnames = [\"Julia\", \"Julio\"]\nage = [10, 20]\n\njulia> fname = tempname();\n\njulia> open(fname, \"w\") do io\n           TOML.print(io, data)\n       end\n\njulia> TOML.parsefile(fname)\nDict{String, Any} with 2 entries:\n  \"names\" => [\"Julia\", \"Julio\"]\n  \"age\"   => [10, 20]","category":"page"},{"location":"stdlib/TOML.html","page":"TOML","title":"TOML","text":"Keys can be sorted according to some value","category":"page"},{"location":"stdlib/TOML.html","page":"TOML","title":"TOML","text":"julia> using TOML\n\njulia> TOML.print(Dict(\n       \"abc\"  => 1,\n       \"ab\"   => 2,\n       \"abcd\" => 3,\n       ); sorted=true, by=length)\nab = 2\nabc = 1\nabcd = 3","category":"page"},{"location":"stdlib/TOML.html","page":"TOML","title":"TOML","text":"For custom structs, pass a function that converts the struct to a supported type","category":"page"},{"location":"stdlib/TOML.html","page":"TOML","title":"TOML","text":"julia> using TOML\n\njulia> struct MyStruct\n           a::Int\n           b::String\n       end\n\njulia> TOML.print(Dict(\"foo\" => MyStruct(5, \"bar\"))) do x\n           x isa MyStruct && return [x.a, x.b]\n           error(\"unhandled type $(typeof(x))\")\n       end\nfoo = [5, \"bar\"]","category":"page"},{"location":"stdlib/TOML.html#References","page":"TOML","title":"References","text":"","category":"section"},{"location":"stdlib/TOML.html","page":"TOML","title":"TOML","text":"TOML.parse\nTOML.parsefile\nTOML.tryparse\nTOML.tryparsefile\nTOML.print\nTOML.Parser\nTOML.ParserError","category":"page"},{"location":"stdlib/TOML.html#TOML.parse","page":"TOML","title":"TOML.parse","text":"parse(x::Union{AbstractString, IO})\nparse(p::Parser, x::Union{AbstractString, IO})\n\nParse the string  or stream x, and return the resulting table (dictionary). Throw a ParserError upon failure.\n\nSee also TOML.tryparse.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/TOML.html#TOML.parsefile","page":"TOML","title":"TOML.parsefile","text":"parsefile(f::AbstractString)\nparsefile(p::Parser, f::AbstractString)\n\nParse file f and return the resulting table (dictionary). Throw a ParserError upon failure.\n\nSee also TOML.tryparsefile.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/TOML.html#TOML.tryparse","page":"TOML","title":"TOML.tryparse","text":"tryparse(x::Union{AbstractString, IO})\ntryparse(p::Parser, x::Union{AbstractString, IO})\n\nParse the string or stream x, and return the resulting table (dictionary). Return a ParserError upon failure.\n\nSee also TOML.parse.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/TOML.html#TOML.tryparsefile","page":"TOML","title":"TOML.tryparsefile","text":"tryparsefile(f::AbstractString)\ntryparsefile(p::Parser, f::AbstractString)\n\nParse file f and return the resulting table (dictionary). Return a ParserError upon failure.\n\nSee also TOML.parsefile.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/TOML.html#TOML.print","page":"TOML","title":"TOML.print","text":"print([to_toml::Function], io::IO [=stdout], data::AbstractDict; sorted=false, by=identity, inline_tables::IdSet{<:AbstractDict})\n\nWrite data as TOML syntax to the stream io. If the keyword argument sorted is set to true, sort tables according to the function given by the keyword argument by. If the keyword argument inline_tables is given, it should be a set of tables that should be printed \"inline\".\n\nThe following data types are supported: AbstractDict, AbstractVector, AbstractString, Integer, AbstractFloat, Bool, Dates.DateTime, Dates.Time, Dates.Date. Note that the integers and floats need to be convertible to Float64 and Int64 respectively. For other data types, pass the function to_toml that takes the data types and returns a value of a supported type.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/TOML.html#TOML.Parser","page":"TOML","title":"TOML.Parser","text":"Parser()\n\nConstructor for a TOML Parser.  Note that in most cases one does not need to explicitly create a Parser but instead one directly use use TOML.parsefile or TOML.parse.  Using an explicit parser will however reuse some internal data structures which can be beneficial for performance if a larger number of small files are parsed.\n\n\n\n\n\n","category":"type"},{"location":"stdlib/TOML.html#TOML.ParserError","page":"TOML","title":"TOML.ParserError","text":"ParserError\n\nType that is returned from tryparse and tryparsefile when parsing fails. It contains (among others) the following fields:\n\npos, the position in the string when the error happened\ntable, the result that so far was successfully parsed\ntype, an error type, different for different types of errors\n\n\n\n\n\n","category":"type"},{"location":"manual/asynchronous-programming.html#man-asynchronous","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"","category":"section"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"When a program needs to interact with the outside world, for example communicating with another machine over the internet, operations in the program may need to happen in an unpredictable order. Say your program needs to download a file. We would like to initiate the download operation, perform other operations while we wait for it to complete, and then resume the code that needs the downloaded file when it is available. This sort of scenario falls in the domain of asynchronous programming, sometimes also referred to as concurrent programming (since, conceptually, multiple things are happening at once).","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"To address these scenarios, Julia provides Tasks (also known by several other names, such as symmetric coroutines, lightweight threads, cooperative multitasking, or one-shot continuations). When a piece of computing work (in practice, executing a particular function) is designated as a Task, it becomes possible to interrupt it by switching to another Task. The original Task can later be resumed, at which point it will pick up right where it left off. At first, this may seem similar to a function call. However there are two key differences. First, switching tasks does not use any space, so any number of task switches can occur without consuming the call stack. Second, switching among tasks can occur in any order, unlike function calls, where the called function must finish executing before control returns to the calling function.","category":"page"},{"location":"manual/asynchronous-programming.html#Basic-Task-operations","page":"Asynchronous Programming","title":"Basic Task operations","text":"","category":"section"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"You can think of a Task as a handle to a unit of computational work to be performed. It has a create-start-run-finish lifecycle. Tasks are created by calling the Task constructor on a 0-argument function to run, or using the @task macro:","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"julia> t = @task begin; sleep(5); println(\"done\"); end\nTask (runnable) @0x00007f13a40c0eb0","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"@task x is equivalent to Task(()->x).","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"This task will wait for five seconds, and then print done. However, it has not started running yet. We can run it whenever we're ready by calling schedule:","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"julia> schedule(t);","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"If you try this in the REPL, you will see that schedule returns immediately. That is because it simply adds t to an internal queue of tasks to run. Then, the REPL will print the next prompt and wait for more input. Waiting for keyboard input provides an opportunity for other tasks to run, so at that point t will start. t calls sleep, which sets a timer and stops execution. If other tasks have been scheduled, they could run then. After five seconds, the timer fires and restarts t, and you will see done printed. t is then finished.","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"The wait function blocks the calling task until some other task finishes. So for example if you type","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"julia> schedule(t); wait(t)","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"instead of only calling schedule, you will see a five second pause before the next input prompt appears. That is because the REPL is waiting for t to finish before proceeding.","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"It is common to want to create a task and schedule it right away, so the macro @async is provided for that purpose –- @async x is equivalent to schedule(@task x).","category":"page"},{"location":"manual/asynchronous-programming.html#Communicating-with-Channels","page":"Asynchronous Programming","title":"Communicating with Channels","text":"","category":"section"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"In some problems, the various pieces of required work are not naturally related by function calls; there is no obvious \"caller\" or \"callee\" among the jobs that need to be done. An example is the producer-consumer problem, where one complex procedure is generating values and another complex procedure is consuming them. The consumer cannot simply call a producer function to get a value, because the producer may have more values to generate and so might not yet be ready to return. With tasks, the producer and consumer can both run as long as they need to, passing values back and forth as necessary.","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"Julia provides a Channel mechanism for solving this problem. A Channel is a waitable first-in first-out queue which can have multiple tasks reading from and writing to it.","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"Let's define a producer task, which produces values via the put! call. To consume values, we need to schedule the producer to run in a new task. A special Channel constructor which accepts a 1-arg function as an argument can be used to run a task bound to a channel. We can then take! values repeatedly from the channel object:","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"julia> function producer(c::Channel)\n           put!(c, \"start\")\n           for n=1:4\n               put!(c, 2n)\n           end\n           put!(c, \"stop\")\n       end;\n\njulia> chnl = Channel(producer);\n\njulia> take!(chnl)\n\"start\"\n\njulia> take!(chnl)\n2\n\njulia> take!(chnl)\n4\n\njulia> take!(chnl)\n6\n\njulia> take!(chnl)\n8\n\njulia> take!(chnl)\n\"stop\"","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"One way to think of this behavior is that producer was able to return multiple times. Between calls to put!, the producer's execution is suspended and the consumer has control.","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"The returned Channel can be used as an iterable object in a for loop, in which case the loop variable takes on all the produced values. The loop is terminated when the channel is closed.","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"julia> for x in Channel(producer)\n           println(x)\n       end\nstart\n2\n4\n6\n8\nstop","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"Note that we did not have to explicitly close the channel in the producer. This is because the act of binding a Channel to a Task associates the open lifetime of a channel with that of the bound task. The channel object is closed automatically when the task terminates. Multiple channels can be bound to a task, and vice-versa.","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"While the Task constructor expects a 0-argument function, the Channel method that creates a task-bound channel expects a function that accepts a single argument of type Channel. A common pattern is for the producer to be parameterized, in which case a partial function application is needed to create a 0 or 1 argument anonymous function.","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"For Task objects this can be done either directly or by use of a convenience macro:","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"function mytask(myarg)\n    ...\nend\n\ntaskHdl = Task(() -> mytask(7))\n# or, equivalently\ntaskHdl = @task mytask(7)","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"To orchestrate more advanced work distribution patterns, bind and schedule can be used in conjunction with Task and Channel constructors to explicitly link a set of channels with a set of producer/consumer tasks.","category":"page"},{"location":"manual/asynchronous-programming.html#More-on-Channels","page":"Asynchronous Programming","title":"More on Channels","text":"","category":"section"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"A channel can be visualized as a pipe, i.e., it has a write end and a read end :","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"Multiple writers in different tasks can write to the same channel concurrently via put! calls.\nMultiple readers in different tasks can read data concurrently via take! calls.\nAs an example:\n# Given Channels c1 and c2,\nc1 = Channel(32)\nc2 = Channel(32)\n\n# and a function `foo` which reads items from c1, processes the item read\n# and writes a result to c2,\nfunction foo()\n    while true\n        data = take!(c1)\n        [...]               # process data\n        put!(c2, result)    # write out result\n    end\nend\n\n# we can schedule `n` instances of `foo` to be active concurrently.\nfor _ in 1:n\n    errormonitor(@async foo())\nend\nChannels are created via the Channel{T}(sz) constructor. The channel will only hold objects of type T. If the type is not specified, the channel can hold objects of any type. sz refers to the maximum number of elements that can be held in the channel at any time. For example, Channel(32) creates a channel that can hold a maximum of 32 objects of any type. A Channel{MyType}(64) can hold up to 64 objects of MyType at any time.\nIf a Channel is empty, readers (on a take! call) will block until data is available.\nIf a Channel is full, writers (on a put! call) will block until space becomes available.\nisready tests for the presence of any object in the channel, while wait waits for an object to become available.\nA Channel is in an open state initially. This means that it can be read from and written to freely via take! and put! calls. close closes a Channel. On a closed Channel, put! will fail. For example:\njulia> c = Channel(2);\n\njulia> put!(c, 1) # `put!` on an open channel succeeds\n1\n\njulia> close(c);\n\njulia> put!(c, 2) # `put!` on a closed channel throws an exception.\nERROR: InvalidStateException: Channel is closed.\nStacktrace:\n[...]\ntake! and fetch (which retrieves but does not remove the value) on a closed channel successfully return any existing values until it is emptied. Continuing the above example:\njulia> fetch(c) # Any number of `fetch` calls succeed.\n1\n\njulia> fetch(c)\n1\n\njulia> take!(c) # The first `take!` removes the value.\n1\n\njulia> take!(c) # No more data available on a closed channel.\nERROR: InvalidStateException: Channel is closed.\nStacktrace:\n[...]","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"Consider a simple example using channels for inter-task communication. We start 4 tasks to process data from a single jobs channel. Jobs, identified by an id (job_id), are written to the channel. Each task in this simulation reads a job_id, waits for a random amount of time and writes back a tuple of job_id and the simulated time to the results channel. Finally all the results are printed out.","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"julia> const jobs = Channel{Int}(32);\n\njulia> const results = Channel{Tuple}(32);\n\njulia> function do_work()\n           for job_id in jobs\n               exec_time = rand()\n               sleep(exec_time)                # simulates elapsed time doing actual work\n                                               # typically performed externally.\n               put!(results, (job_id, exec_time))\n           end\n       end;\n\njulia> function make_jobs(n)\n           for i in 1:n\n               put!(jobs, i)\n           end\n       end;\n\njulia> n = 12;\n\njulia> errormonitor(@async make_jobs(n)); # feed the jobs channel with \"n\" jobs\n\njulia> for i in 1:4 # start 4 tasks to process requests in parallel\n           errormonitor(@async do_work())\n       end\n\njulia> @elapsed while n > 0 # print out results\n           job_id, exec_time = take!(results)\n           println(\"$job_id finished in $(round(exec_time; digits=2)) seconds\")\n           global n = n - 1\n       end\n4 finished in 0.22 seconds\n3 finished in 0.45 seconds\n1 finished in 0.5 seconds\n7 finished in 0.14 seconds\n2 finished in 0.78 seconds\n5 finished in 0.9 seconds\n9 finished in 0.36 seconds\n6 finished in 0.87 seconds\n8 finished in 0.79 seconds\n10 finished in 0.64 seconds\n12 finished in 0.5 seconds\n11 finished in 0.97 seconds\n0.029772311","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"Instead of errormonitor(t), a more robust solution may be to use bind(results, t), as that will not only log any unexpected failures, but also force the associated resources to close and propagate the exception everywhere.","category":"page"},{"location":"manual/asynchronous-programming.html#More-task-operations","page":"Asynchronous Programming","title":"More task operations","text":"","category":"section"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"Task operations are built on a low-level primitive called yieldto. yieldto(task, value) suspends the current task, switches to the specified task, and causes that task's last yieldto call to return the specified value. Notice that yieldto is the only operation required to use task-style control flow; instead of calling and returning we are always just switching to a different task. This is why this feature is also called \"symmetric coroutines\"; each task is switched to and from using the same mechanism.","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"yieldto is powerful, but most uses of tasks do not invoke it directly. Consider why this might be. If you switch away from the current task, you will probably want to switch back to it at some point, but knowing when to switch back, and knowing which task has the responsibility of switching back, can require considerable coordination. For example, put! and take! are blocking operations, which, when used in the context of channels maintain state to remember who the consumers are. Not needing to manually keep track of the consuming task is what makes put! easier to use than the low-level yieldto.","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"In addition to yieldto, a few other basic functions are needed to use tasks effectively.","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"current_task gets a reference to the currently-running task.\nistaskdone queries whether a task has exited.\nistaskstarted queries whether a task has run yet.\ntask_local_storage manipulates a key-value store specific to the current task.","category":"page"},{"location":"manual/asynchronous-programming.html#Tasks-and-events","page":"Asynchronous Programming","title":"Tasks and events","text":"","category":"section"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"Most task switches occur as a result of waiting for events such as I/O requests, and are performed by a scheduler included in Julia Base. The scheduler maintains a queue of runnable tasks, and executes an event loop that restarts tasks based on external events such as message arrival.","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"The basic function for waiting for an event is wait. Several objects implement wait; for example, given a Process object, wait will wait for it to exit. wait is often implicit; for example, a wait can happen inside a call to read to wait for data to be available.","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"In all of these cases, wait ultimately operates on a Condition object, which is in charge of queueing and restarting tasks. When a task calls wait on a Condition, the task is marked as non-runnable, added to the condition's queue, and switches to the scheduler. The scheduler will then pick another task to run, or block waiting for external events. If all goes well, eventually an event handler will call notify on the condition, which causes tasks waiting for that condition to become runnable again.","category":"page"},{"location":"manual/asynchronous-programming.html","page":"Asynchronous Programming","title":"Asynchronous Programming","text":"A task created explicitly by calling Task is initially not known to the scheduler. This allows you to manage tasks manually using yieldto if you wish. However, when such a task waits for an event, it still gets restarted automatically when the event happens, as you would expect.","category":"page"},{"location":"base/strings.html#lib-strings","page":"Strings","title":"Strings","text":"","category":"section"},{"location":"base/strings.html","page":"Strings","title":"Strings","text":"Core.AbstractString\nCore.AbstractChar\nCore.Char\nBase.codepoint\nBase.length(::AbstractString)\nBase.sizeof(::AbstractString)\nBase.:*(::Union{AbstractChar, AbstractString}, ::Union{AbstractChar, AbstractString}...)\nBase.:^(::Union{AbstractString, AbstractChar}, ::Integer)\nBase.string\nBase.repeat(::AbstractString, ::Integer)\nBase.repeat(::AbstractChar, ::Integer)\nBase.repr(::Any)\nCore.String(::AbstractString)\nBase.SubString\nBase.LazyString\nBase.@lazy_str\nBase.transcode\nBase.unsafe_string\nBase.ncodeunits(::AbstractString)\nBase.codeunit\nBase.codeunits\nBase.ascii\nBase.Regex\nBase.@r_str\nBase.SubstitutionString\nBase.@s_str\nBase.@raw_str\nBase.@b_str\nBase.Docs.@html_str\nBase.Docs.@text_str\nBase.isvalid(::Any)\nBase.isvalid(::Any, ::Any)\nBase.isvalid(::AbstractString, ::Integer)\nBase.match\nBase.eachmatch\nBase.RegexMatch\nBase.keys(::RegexMatch)\nBase.isless(::AbstractString, ::AbstractString)\nBase.:(==)(::AbstractString, ::AbstractString)\nBase.cmp(::AbstractString, ::AbstractString)\nBase.lpad\nBase.rpad\nBase.findfirst(::AbstractString, ::AbstractString)\nBase.findnext(::AbstractString, ::AbstractString, ::Integer)\nBase.findnext(::AbstractChar, ::AbstractString, ::Integer)\nBase.findlast(::AbstractString, ::AbstractString)\nBase.findlast(::AbstractChar, ::AbstractString)\nBase.findprev(::AbstractString, ::AbstractString, ::Integer)\nBase.occursin\nBase.reverse(::Union{String,SubString{String}})\nBase.replace(::IO, s::AbstractString, ::Pair...)\nBase.eachsplit\nBase.eachrsplit\nBase.split\nBase.rsplit\nBase.strip\nBase.lstrip\nBase.rstrip\nBase.startswith\nBase.endswith\nBase.contains\nBase.first(::AbstractString, ::Integer)\nBase.last(::AbstractString, ::Integer)\nBase.uppercase\nBase.lowercase\nBase.titlecase\nBase.uppercasefirst\nBase.lowercasefirst\nBase.join\nBase.chop\nBase.chopprefix\nBase.chopsuffix\nBase.chomp\nBase.thisind\nBase.nextind(::AbstractString, ::Integer, ::Integer)\nBase.prevind(::AbstractString, ::Integer, ::Integer)\nBase.textwidth\nBase.isascii\nBase.iscntrl\nBase.isdigit\nBase.isletter\nBase.islowercase\nBase.isnumeric\nBase.isprint\nBase.ispunct\nBase.isspace\nBase.isuppercase\nBase.isxdigit\nBase.escape_string\nBase.escape_raw_string\nBase.unescape_string","category":"page"},{"location":"base/strings.html#Core.AbstractString","page":"Strings","title":"Core.AbstractString","text":"The AbstractString type is the supertype of all string implementations in Julia. Strings are encodings of sequences of Unicode code points as represented by the AbstractChar type. Julia makes a few assumptions about strings:\n\nStrings are encoded in terms of fixed-size \"code units\"\nCode units can be extracted with codeunit(s, i)\nThe first code unit has index 1\nThe last code unit has index ncodeunits(s)\nAny index i such that 1 ≤ i ≤ ncodeunits(s) is in bounds\nString indexing is done in terms of these code units:\nCharacters are extracted by s[i] with a valid string index i\nEach AbstractChar in a string is encoded by one or more code units\nOnly the index of the first code unit of an AbstractChar is a valid index\nThe encoding of an AbstractChar is independent of what precedes or follows it\nString encodings are self-synchronizing – i.e. isvalid(s, i) is O(1)\n\nSome string functions that extract code units, characters or substrings from strings error if you pass them out-of-bounds or invalid string indices. This includes codeunit(s, i) and s[i]. Functions that do string index arithmetic take a more relaxed approach to indexing and give you the closest valid string index when in-bounds, or when out-of-bounds, behave as if there were an infinite number of characters padding each side of the string. Usually these imaginary padding characters have code unit length 1 but string types may choose different \"imaginary\" character sizes as makes sense for their implementations (e.g. substrings may pass index arithmetic through to the underlying string they provide a view into). Relaxed indexing functions include those intended for index arithmetic: thisind, nextind and prevind. This model allows index arithmetic to work with out-of-bounds indices as intermediate values so long as one never uses them to retrieve a character, which often helps avoid needing to code around edge cases.\n\nSee also codeunit, ncodeunits, thisind, nextind, prevind.\n\n\n\n\n\n","category":"type"},{"location":"base/strings.html#Core.AbstractChar","page":"Strings","title":"Core.AbstractChar","text":"The AbstractChar type is the supertype of all character implementations in Julia. A character represents a Unicode code point, and can be converted to an integer via the codepoint function in order to obtain the numerical value of the code point, or constructed from the same integer. These numerical values determine how characters are compared with < and ==, for example.  New T <: AbstractChar types should define a codepoint(::T) method and a T(::UInt32) constructor, at minimum.\n\nA given AbstractChar subtype may be capable of representing only a subset of Unicode, in which case conversion from an unsupported UInt32 value may throw an error. Conversely, the built-in Char type represents a superset of Unicode (in order to losslessly encode invalid byte streams), in which case conversion of a non-Unicode value to UInt32 throws an error. The isvalid function can be used to check which codepoints are representable in a given AbstractChar type.\n\nInternally, an AbstractChar type may use a variety of encodings.  Conversion via codepoint(char) will not reveal this encoding because it always returns the Unicode value of the character. print(io, c) of any c::AbstractChar produces an encoding determined by io (UTF-8 for all built-in IO types), via conversion to Char if necessary.\n\nwrite(io, c), in contrast, may emit an encoding depending on typeof(c), and read(io, typeof(c)) should read the same encoding as write. New AbstractChar types must provide their own implementations of write and read.\n\n\n\n\n\n","category":"type"},{"location":"base/strings.html#Core.Char","page":"Strings","title":"Core.Char","text":"Char(c::Union{Number,AbstractChar})\n\nChar is a 32-bit AbstractChar type that is the default representation of characters in Julia. Char is the type used for character literals like 'x' and it is also the element type of String.\n\nIn order to losslessly represent arbitrary byte streams stored in a String, a Char value may store information that cannot be converted to a Unicode codepoint — converting such a Char to UInt32 will throw an error. The isvalid(c::Char) function can be used to query whether c represents a valid Unicode character.\n\n\n\n\n\n","category":"type"},{"location":"base/strings.html#Base.codepoint","page":"Strings","title":"Base.codepoint","text":"codepoint(c::AbstractChar) -> Integer\n\nReturn the Unicode codepoint (an unsigned integer) corresponding to the character c (or throw an exception if c does not represent a valid character). For Char, this is a UInt32 value, but AbstractChar types that represent only a subset of Unicode may return a different-sized integer (e.g. UInt8).\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.length-Tuple{AbstractString}","page":"Strings","title":"Base.length","text":"length(s::AbstractString) -> Int\nlength(s::AbstractString, i::Integer, j::Integer) -> Int\n\nReturn the number of characters in string s from indices i through j.\n\nThis is computed as the number of code unit indices from i to j which are valid character indices. With only a single string argument, this computes the number of characters in the entire string. With i and j arguments it computes the number of indices between i and j inclusive that are valid indices in the string s. In addition to in-bounds values, i may take the out-of-bounds value ncodeunits(s) + 1 and j may take the out-of-bounds value 0.\n\nnote: Note\nThe time complexity of this operation is linear in general. That is, it will take the time proportional to the number of bytes or characters in the string because it counts the value on the fly. This is in contrast to the method for arrays, which is a constant-time operation.\n\nSee also isvalid, ncodeunits, lastindex, thisind, nextind, prevind.\n\nExamples\n\njulia> length(\"jμΛIα\")\n5\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.sizeof-Tuple{AbstractString}","page":"Strings","title":"Base.sizeof","text":"sizeof(str::AbstractString)\n\nSize, in bytes, of the string str. Equal to the number of code units in str multiplied by the size, in bytes, of one code unit in str.\n\nExamples\n\njulia> sizeof(\"\")\n0\n\njulia> sizeof(\"∀\")\n3\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.:*-Tuple{Union{AbstractChar, AbstractString}, Vararg{Union{AbstractChar, AbstractString}}}","page":"Strings","title":"Base.:*","text":"*(s::Union{AbstractString, AbstractChar}, t::Union{AbstractString, AbstractChar}...) -> AbstractString\n\nConcatenate strings and/or characters, producing a String or AnnotatedString (as appropriate). This is equivalent to calling the string or annotatedstring function on the arguments. Concatenation of built-in string types always produces a value of type String but other string types may choose to return a string of a different type as appropriate.\n\nExamples\n\njulia> \"Hello \" * \"world\"\n\"Hello world\"\n\njulia> 'j' * \"ulia\"\n\"julia\"\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.:^-Tuple{Union{AbstractChar, AbstractString}, Integer}","page":"Strings","title":"Base.:^","text":"^(s::Union{AbstractString,AbstractChar}, n::Integer) -> AbstractString\n\nRepeat a string or character n times. This can also be written as repeat(s, n).\n\nSee also repeat.\n\nExamples\n\njulia> \"Test \"^3\n\"Test Test Test \"\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.string","page":"Strings","title":"Base.string","text":"string(n::Integer; base::Integer = 10, pad::Integer = 1)\n\nConvert an integer n to a string in the given base, optionally specifying a number of digits to pad to.\n\nSee also digits, bitstring, count_zeros.\n\nExamples\n\njulia> string(5, base = 13, pad = 4)\n\"0005\"\n\njulia> string(-13, base = 5, pad = 4)\n\"-0023\"\n\n\n\n\n\nstring(xs...)\n\nCreate a string from any values using the print function.\n\nstring should usually not be defined directly. Instead, define a method print(io::IO, x::MyType). If string(x) for a certain type needs to be highly efficient, then it may make sense to add a method to string and define print(io::IO, x::MyType) = print(io, string(x)) to ensure the functions are consistent.\n\nSee also: String, repr, sprint, show.\n\nExamples\n\njulia> string(\"a\", 1, true)\n\"a1true\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.repeat-Tuple{AbstractString, Integer}","page":"Strings","title":"Base.repeat","text":"repeat(s::AbstractString, r::Integer)\n\nRepeat a string r times. This can be written as s^r.\n\nSee also ^.\n\nExamples\n\njulia> repeat(\"ha\", 3)\n\"hahaha\"\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.repeat-Tuple{AbstractChar, Integer}","page":"Strings","title":"Base.repeat","text":"repeat(c::AbstractChar, r::Integer) -> String\n\nRepeat a character r times. This can equivalently be accomplished by calling c^r.\n\nExamples\n\njulia> repeat('A', 3)\n\"AAA\"\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.repr-Tuple{Any}","page":"Strings","title":"Base.repr","text":"repr(x; context=nothing)\n\nCreate a string from any value using the show function. You should not add methods to repr; define a show method instead.\n\nThe optional keyword argument context can be set to a :key=>value pair, a tuple of :key=>value pairs, or an IO or IOContext object whose attributes are used for the I/O stream passed to show.\n\nNote that repr(x) is usually similar to how the value of x would be entered in Julia.  See also repr(MIME(\"text/plain\"), x) to instead return a \"pretty-printed\" version of x designed more for human consumption, equivalent to the REPL display of x.\n\ncompat: Julia 1.7\nPassing a tuple to keyword context requires Julia 1.7 or later.\n\nExamples\n\njulia> repr(1)\n\"1\"\n\njulia> repr(zeros(3))\n\"[0.0, 0.0, 0.0]\"\n\njulia> repr(big(1/3))\n\"0.333333333333333314829616256247390992939472198486328125\"\n\njulia> repr(big(1/3), context=:compact => true)\n\"0.333333\"\n\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Core.String-Tuple{AbstractString}","page":"Strings","title":"Core.String","text":"String(s::AbstractString)\n\nCreate a new String from an existing AbstractString.\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.SubString","page":"Strings","title":"Base.SubString","text":"SubString(s::AbstractString, i::Integer, j::Integer=lastindex(s))\nSubString(s::AbstractString, r::UnitRange{<:Integer})\n\nLike getindex, but returns a view into the parent string s within range i:j or r respectively instead of making a copy.\n\nThe @views macro converts any string slices s[i:j] into substrings SubString(s, i, j) in a block of code.\n\nExamples\n\njulia> SubString(\"abc\", 1, 2)\n\"ab\"\n\njulia> SubString(\"abc\", 1:2)\n\"ab\"\n\njulia> SubString(\"abc\", 2)\n\"bc\"\n\n\n\n\n\n","category":"type"},{"location":"base/strings.html#Base.LazyString","page":"Strings","title":"Base.LazyString","text":"LazyString <: AbstractString\n\nA lazy representation of string interpolation. This is useful when a string needs to be constructed in a context where performing the actual interpolation and string construction is unnecessary or undesirable (e.g. in error paths of functions).\n\nThis type is designed to be cheap to construct at runtime, trying to offload as much work as possible to either the macro or later printing operations.\n\nExamples\n\njulia> n = 5; str = LazyString(\"n is \", n)\n\"n is 5\"\n\nSee also @lazy_str.\n\ncompat: Julia 1.8\nLazyString requires Julia 1.8 or later.\n\nExtended help\n\nSafety properties for concurrent programs\n\nA lazy string itself does not introduce any concurrency problems even if it is printed in multiple Julia tasks.  However, if print methods on a captured value can have a concurrency issue when invoked without synchronizations, printing the lazy string may cause an issue.  Furthermore, the print methods on the captured values may be invoked multiple times, though only exactly one result will be returned.\n\ncompat: Julia 1.9\nLazyString is safe in the above sense in Julia 1.9 and later.\n\n\n\n\n\n","category":"type"},{"location":"base/strings.html#Base.@lazy_str","page":"Strings","title":"Base.@lazy_str","text":"lazy\"str\"\n\nCreate a LazyString using regular string interpolation syntax. Note that interpolations are evaluated at LazyString construction time, but printing is delayed until the first access to the string.\n\nSee LazyString documentation for the safety properties for concurrent programs.\n\nExamples\n\njulia> n = 5; str = lazy\"n is $n\"\n\"n is 5\"\n\njulia> typeof(str)\nLazyString\n\ncompat: Julia 1.8\nlazy\"str\" requires Julia 1.8 or later.\n\n\n\n\n\n","category":"macro"},{"location":"base/strings.html#Base.transcode","page":"Strings","title":"Base.transcode","text":"transcode(T, src)\n\nConvert string data between Unicode encodings. src is either a String or a Vector{UIntXX} of UTF-XX code units, where XX is 8, 16, or 32. T indicates the encoding of the return value: String to return a (UTF-8 encoded) String or UIntXX to return a Vector{UIntXX} of UTF-XX data. (The alias Cwchar_t can also be used as the integer type, for converting wchar_t* strings used by external C libraries.)\n\nThe transcode function succeeds as long as the input data can be reasonably represented in the target encoding; it always succeeds for conversions between UTF-XX encodings, even for invalid Unicode data.\n\nOnly conversion to/from UTF-8 is currently supported.\n\nExamples\n\njulia> str = \"αβγ\"\n\"αβγ\"\n\njulia> transcode(UInt16, str)\n3-element Vector{UInt16}:\n 0x03b1\n 0x03b2\n 0x03b3\n\njulia> transcode(String, transcode(UInt16, str))\n\"αβγ\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.unsafe_string","page":"Strings","title":"Base.unsafe_string","text":"unsafe_string(p::Ptr{UInt8}, [length::Integer])\n\nCopy a string from the address of a C-style (NUL-terminated) string encoded as UTF-8. (The pointer can be safely freed afterwards.) If length is specified (the length of the data in bytes), the string does not have to be NUL-terminated.\n\nThis function is labeled \"unsafe\" because it will crash if p is not a valid memory address to data of the requested length.\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.ncodeunits-Tuple{AbstractString}","page":"Strings","title":"Base.ncodeunits","text":"ncodeunits(s::AbstractString) -> Int\n\nReturn the number of code units in a string. Indices that are in bounds to access this string must satisfy 1 ≤ i ≤ ncodeunits(s). Not all such indices are valid – they may not be the start of a character, but they will return a code unit value when calling codeunit(s,i).\n\nExamples\n\njulia> ncodeunits(\"The Julia Language\")\n18\n\njulia> ncodeunits(\"∫eˣ\")\n6\n\njulia> ncodeunits('∫'), ncodeunits('e'), ncodeunits('ˣ')\n(3, 1, 2)\n\nSee also codeunit, checkbounds, sizeof, length, lastindex.\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.codeunit","page":"Strings","title":"Base.codeunit","text":"codeunit(s::AbstractString) -> Type{<:Union{UInt8, UInt16, UInt32}}\n\nReturn the code unit type of the given string object. For ASCII, Latin-1, or UTF-8 encoded strings, this would be UInt8; for UCS-2 and UTF-16 it would be UInt16; for UTF-32 it would be UInt32. The code unit type need not be limited to these three types, but it's hard to think of widely used string encodings that don't use one of these units. codeunit(s) is the same as typeof(codeunit(s,1)) when s is a non-empty string.\n\nSee also ncodeunits.\n\n\n\n\n\ncodeunit(s::AbstractString, i::Integer) -> Union{UInt8, UInt16, UInt32}\n\nReturn the code unit value in the string s at index i. Note that\n\ncodeunit(s, i) :: codeunit(s)\n\nI.e. the value returned by codeunit(s, i) is of the type returned by codeunit(s).\n\nExamples\n\njulia> a = codeunit(\"Hello\", 2)\n0x65\n\njulia> typeof(a)\nUInt8\n\nSee also ncodeunits, checkbounds.\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.codeunits","page":"Strings","title":"Base.codeunits","text":"codeunits(s::AbstractString)\n\nObtain a vector-like object containing the code units of a string. Returns a CodeUnits wrapper by default, but codeunits may optionally be defined for new string types if necessary.\n\nExamples\n\njulia> codeunits(\"Juλia\")\n6-element Base.CodeUnits{UInt8, String}:\n 0x4a\n 0x75\n 0xce\n 0xbb\n 0x69\n 0x61\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.ascii","page":"Strings","title":"Base.ascii","text":"ascii(s::AbstractString)\n\nConvert a string to String type and check that it contains only ASCII data, otherwise throwing an ArgumentError indicating the position of the first non-ASCII byte.\n\nSee also the isascii predicate to filter or replace non-ASCII characters.\n\nExamples\n\njulia> ascii(\"abcdeγfgh\")\nERROR: ArgumentError: invalid ASCII at index 6 in \"abcdeγfgh\"\nStacktrace:\n[...]\n\njulia> ascii(\"abcdefgh\")\n\"abcdefgh\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.Regex","page":"Strings","title":"Base.Regex","text":"Regex(pattern[, flags]) <: AbstractPattern\n\nA type representing a regular expression. Regex objects can be used to match strings with match.\n\nRegex objects can be created using the @r_str string macro. The Regex(pattern[, flags]) constructor is usually used if the pattern string needs to be interpolated. See the documentation of the string macro for details on flags.\n\nnote: Note\nTo escape interpolated variables use \\Q and \\E (e.g. Regex(\"\\\\Q$x\\\\E\"))\n\n\n\n\n\n","category":"type"},{"location":"base/strings.html#Base.@r_str","page":"Strings","title":"Base.@r_str","text":"@r_str -> Regex\n\nConstruct a regex, such as r\"^[a-z]*$\", without interpolation and unescaping (except for quotation mark \" which still has to be escaped). The regex also accepts one or more flags, listed after the ending quote, to change its behaviour:\n\ni enables case-insensitive matching\nm treats the ^ and $ tokens as matching the start and end of individual lines, as opposed to the whole string.\ns allows the . modifier to match newlines.\nx enables \"free-spacing mode\": whitespace between regex tokens is ignored except when escaped with \\,  and # in the regex is treated as starting a comment (which is ignored to the line ending).\na enables ASCII mode (disables UTF and UCP modes). By default \\B, \\b, \\D, \\d, \\S, \\s, \\W, \\w, etc. match based on Unicode character properties. With this option, these sequences only match ASCII characters. This includes \\u also, which will emit the specified character value directly as a single byte, and not attempt to encode it into UTF-8. Importantly, this option allows matching against invalid UTF-8 strings, by treating both matcher and target as simple bytes (as if they were ISO/IEC 8859-1 / Latin-1 bytes) instead of as character encodings. In this case, this option is often combined with s. This option can be further refined by starting the pattern with (UCP) or (UTF).\n\nSee Regex if interpolation is needed.\n\nExamples\n\njulia> match(r\"a+.*b+.*?d$\"ism, \"Goodbye,\\nOh, angry,\\nBad world\\n\")\nRegexMatch(\"angry,\\nBad world\")\n\nThis regex has the first three flags enabled.\n\n\n\n\n\n","category":"macro"},{"location":"base/strings.html#Base.SubstitutionString","page":"Strings","title":"Base.SubstitutionString","text":"SubstitutionString(substr) <: AbstractString\n\nStores the given string substr as a SubstitutionString, for use in regular expression substitutions. Most commonly constructed using the @s_str macro.\n\nExamples\n\njulia> SubstitutionString(\"Hello \\\\g<name>, it's \\\\1\")\ns\"Hello \\g<name>, it's \\1\"\n\njulia> subst = s\"Hello \\g<name>, it's \\1\"\ns\"Hello \\g<name>, it's \\1\"\n\njulia> typeof(subst)\nSubstitutionString{String}\n\n\n\n\n\n","category":"type"},{"location":"base/strings.html#Base.@s_str","page":"Strings","title":"Base.@s_str","text":"@s_str -> SubstitutionString\n\nConstruct a substitution string, used for regular expression substitutions.  Within the string, sequences of the form \\N refer to the Nth capture group in the regex, and \\g<groupname> refers to a named capture group with name groupname.\n\nExamples\n\njulia> msg = \"#Hello# from Julia\";\n\njulia> replace(msg, r\"#(.+)# from (?<from>\\w+)\" => s\"FROM: \\g<from>; MESSAGE: \\1\")\n\"FROM: Julia; MESSAGE: Hello\"\n\n\n\n\n\n","category":"macro"},{"location":"base/strings.html#Base.@raw_str","page":"Strings","title":"Base.@raw_str","text":"@raw_str -> String\n\nCreate a raw string without interpolation and unescaping. The exception is that quotation marks still must be escaped. Backslashes escape both quotation marks and other backslashes, but only when a sequence of backslashes precedes a quote character. Thus, 2n backslashes followed by a quote encodes n backslashes and the end of the literal while 2n+1 backslashes followed by a quote encodes n backslashes followed by a quote character.\n\nExamples\n\njulia> println(raw\"\\ $x\")\n\\ $x\n\njulia> println(raw\"\\\"\")\n\"\n\njulia> println(raw\"\\\\\\\"\")\n\\\"\n\njulia> println(raw\"\\\\x \\\\\\\"\")\n\\\\x \\\"\n\n\n\n\n\n","category":"macro"},{"location":"base/strings.html#Base.@b_str","page":"Strings","title":"Base.@b_str","text":"@b_str\n\nCreate an immutable byte (UInt8) vector using string syntax.\n\nExamples\n\njulia> v = b\"12\\x01\\x02\"\n4-element Base.CodeUnits{UInt8, String}:\n 0x31\n 0x32\n 0x01\n 0x02\n\njulia> v[2]\n0x32\n\n\n\n\n\n","category":"macro"},{"location":"base/strings.html#Base.Docs.@html_str","page":"Strings","title":"Base.Docs.@html_str","text":"@html_str -> Docs.HTML\n\nCreate an HTML object from a literal string.\n\nExamples\n\njulia> html\"Julia\"\nHTML{String}(\"Julia\")\n\n\n\n\n\n","category":"macro"},{"location":"base/strings.html#Base.Docs.@text_str","page":"Strings","title":"Base.Docs.@text_str","text":"@text_str -> Docs.Text\n\nCreate a Text object from a literal string.\n\nExamples\n\njulia> text\"Julia\"\nJulia\n\n\n\n\n\n","category":"macro"},{"location":"base/strings.html#Base.isvalid-Tuple{Any}","page":"Strings","title":"Base.isvalid","text":"isvalid(value) -> Bool\n\nReturn true if the given value is valid for its type, which currently can be either AbstractChar or String or SubString{String}.\n\nExamples\n\njulia> isvalid(Char(0xd800))\nfalse\n\njulia> isvalid(SubString(String(UInt8[0xfe,0x80,0x80,0x80,0x80,0x80]),1,2))\nfalse\n\njulia> isvalid(Char(0xd799))\ntrue\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.isvalid-Tuple{Any, Any}","page":"Strings","title":"Base.isvalid","text":"isvalid(T, value) -> Bool\n\nReturn true if the given value is valid for that type. Types currently can be either AbstractChar or String. Values for AbstractChar can be of type AbstractChar or UInt32. Values for String can be of that type, SubString{String}, Vector{UInt8}, or a contiguous subarray thereof.\n\nExamples\n\njulia> isvalid(Char, 0xd800)\nfalse\n\njulia> isvalid(String, SubString(\"thisisvalid\",1,5))\ntrue\n\njulia> isvalid(Char, 0xd799)\ntrue\n\ncompat: Julia 1.6\nSupport for subarray values was added in Julia 1.6.\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.isvalid-Tuple{AbstractString, Integer}","page":"Strings","title":"Base.isvalid","text":"isvalid(s::AbstractString, i::Integer) -> Bool\n\nPredicate indicating whether the given index is the start of the encoding of a character in s or not. If isvalid(s, i) is true then s[i] will return the character whose encoding starts at that index, if it's false, then s[i] will raise an invalid index error or a bounds error depending on if i is in bounds. In order for isvalid(s, i) to be an O(1) function, the encoding of s must be self-synchronizing. This is a basic assumption of Julia's generic string support.\n\nSee also getindex, iterate, thisind, nextind, prevind, length.\n\nExamples\n\njulia> str = \"αβγdef\";\n\njulia> isvalid(str, 1)\ntrue\n\njulia> str[1]\n'α': Unicode U+03B1 (category Ll: Letter, lowercase)\n\njulia> isvalid(str, 2)\nfalse\n\njulia> str[2]\nERROR: StringIndexError: invalid index [2], valid nearby indices [1]=>'α', [3]=>'β'\nStacktrace:\n[...]\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.match","page":"Strings","title":"Base.match","text":"match(r::Regex, s::AbstractString[, idx::Integer[, addopts]])\n\nSearch for the first match of the regular expression r in s and return a RegexMatch object containing the match, or nothing if the match failed. The matching substring can be retrieved by accessing m.match and the captured sequences can be retrieved by accessing m.captures The optional idx argument specifies an index at which to start the search.\n\nExamples\n\njulia> rx = r\"a(.)a\"\nr\"a(.)a\"\n\njulia> m = match(rx, \"cabac\")\nRegexMatch(\"aba\", 1=\"b\")\n\njulia> m.captures\n1-element Vector{Union{Nothing, SubString{String}}}:\n \"b\"\n\njulia> m.match\n\"aba\"\n\njulia> match(rx, \"cabac\", 3) === nothing\ntrue\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.eachmatch","page":"Strings","title":"Base.eachmatch","text":"eachmatch(r::Regex, s::AbstractString; overlap::Bool=false)\n\nSearch for all matches of the regular expression r in s and return an iterator over the matches. If overlap is true, the matching sequences are allowed to overlap indices in the original string, otherwise they must be from distinct character ranges.\n\nExamples\n\njulia> rx = r\"a.a\"\nr\"a.a\"\n\njulia> m = eachmatch(rx, \"a1a2a3a\")\nBase.RegexMatchIterator{String}(r\"a.a\", \"a1a2a3a\", false)\n\njulia> collect(m)\n2-element Vector{RegexMatch}:\n RegexMatch(\"a1a\")\n RegexMatch(\"a3a\")\n\njulia> collect(eachmatch(rx, \"a1a2a3a\", overlap = true))\n3-element Vector{RegexMatch}:\n RegexMatch(\"a1a\")\n RegexMatch(\"a2a\")\n RegexMatch(\"a3a\")\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.RegexMatch","page":"Strings","title":"Base.RegexMatch","text":"RegexMatch <: AbstractMatch\n\nA type representing a single match to a Regex found in a string. Typically created from the match function.\n\nThe match field stores the substring of the entire matched string. The captures field stores the substrings for each capture group, indexed by number. To index by capture group name, the entire match object should be indexed instead, as shown in the examples. The location of the start of the match is stored in the offset field. The offsets field stores the locations of the start of each capture group, with 0 denoting a group that was not captured.\n\nThis type can be used as an iterator over the capture groups of the Regex, yielding the substrings captured in each group. Because of this, the captures of a match can be destructured. If a group was not captured, nothing will be yielded instead of a substring.\n\nMethods that accept a RegexMatch object are defined for iterate, length, eltype, keys, haskey, and getindex, where keys are the the names or numbers of a capture group. See keys for more information.\n\nExamples\n\njulia> m = match(r\"(?<hour>\\d+):(?<minute>\\d+)(am|pm)?\", \"11:30 in the morning\")\nRegexMatch(\"11:30\", hour=\"11\", minute=\"30\", 3=nothing)\n\njulia> m.match\n\"11:30\"\n\njulia> m.captures\n3-element Vector{Union{Nothing, SubString{String}}}:\n \"11\"\n \"30\"\n nothing\n\n\njulia> m[\"minute\"]\n\"30\"\n\njulia> hr, min, ampm = m; # destructure capture groups by iteration\n\njulia> hr\n\"11\"\n\n\n\n\n\n","category":"type"},{"location":"base/strings.html#Base.keys-Tuple{RegexMatch}","page":"Strings","title":"Base.keys","text":"keys(m::RegexMatch) -> Vector\n\nReturn a vector of keys for all capture groups of the underlying regex. A key is included even if the capture group fails to match. That is, idx will be in the return value even if m[idx] == nothing.\n\nUnnamed capture groups will have integer keys corresponding to their index. Named capture groups will have string keys.\n\ncompat: Julia 1.7\nThis method was added in Julia 1.7\n\nExamples\n\njulia> keys(match(r\"(?<hour>\\d+):(?<minute>\\d+)(am|pm)?\", \"11:30\"))\n3-element Vector{Any}:\n  \"hour\"\n  \"minute\"\n 3\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.isless-Tuple{AbstractString, AbstractString}","page":"Strings","title":"Base.isless","text":"isless(a::AbstractString, b::AbstractString) -> Bool\n\nTest whether string a comes before string b in alphabetical order (technically, in lexicographical order by Unicode code points).\n\nExamples\n\njulia> isless(\"a\", \"b\")\ntrue\n\njulia> isless(\"β\", \"α\")\nfalse\n\njulia> isless(\"a\", \"a\")\nfalse\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.:==-Tuple{AbstractString, AbstractString}","page":"Strings","title":"Base.:==","text":"==(a::AbstractString, b::AbstractString) -> Bool\n\nTest whether two strings are equal character by character (technically, Unicode code point by code point). Should either string be a AnnotatedString the string properties must match too.\n\nExamples\n\njulia> \"abc\" == \"abc\"\ntrue\n\njulia> \"abc\" == \"αβγ\"\nfalse\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.cmp-Tuple{AbstractString, AbstractString}","page":"Strings","title":"Base.cmp","text":"cmp(a::AbstractString, b::AbstractString) -> Int\n\nCompare two strings. Return 0 if both strings have the same length and the character at each index is the same in both strings. Return -1 if a is a prefix of b, or if a comes before b in alphabetical order. Return 1 if b is a prefix of a, or if b comes before a in alphabetical order (technically, lexicographical order by Unicode code points).\n\nExamples\n\njulia> cmp(\"abc\", \"abc\")\n0\n\njulia> cmp(\"ab\", \"abc\")\n-1\n\njulia> cmp(\"abc\", \"ab\")\n1\n\njulia> cmp(\"ab\", \"ac\")\n-1\n\njulia> cmp(\"ac\", \"ab\")\n1\n\njulia> cmp(\"α\", \"a\")\n1\n\njulia> cmp(\"b\", \"β\")\n-1\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.lpad","page":"Strings","title":"Base.lpad","text":"lpad(s, n::Integer, p::Union{AbstractChar,AbstractString}=' ') -> String\n\nStringify s and pad the resulting string on the left with p to make it n characters (in textwidth) long. If s is already n characters long, an equal string is returned. Pad with spaces by default.\n\nExamples\n\njulia> lpad(\"March\", 10)\n\"     March\"\n\ncompat: Julia 1.7\nIn Julia 1.7, this function was changed to use textwidth rather than a raw character (codepoint) count.\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.rpad","page":"Strings","title":"Base.rpad","text":"rpad(s, n::Integer, p::Union{AbstractChar,AbstractString}=' ') -> String\n\nStringify s and pad the resulting string on the right with p to make it n characters (in textwidth) long. If s is already n characters long, an equal string is returned. Pad with spaces by default.\n\nExamples\n\njulia> rpad(\"March\", 20)\n\"March               \"\n\ncompat: Julia 1.7\nIn Julia 1.7, this function was changed to use textwidth rather than a raw character (codepoint) count.\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.findfirst-Tuple{AbstractString, AbstractString}","page":"Strings","title":"Base.findfirst","text":"findfirst(pattern::AbstractString, string::AbstractString)\nfindfirst(pattern::AbstractPattern, string::String)\n\nFind the first occurrence of pattern in string. Equivalent to findnext(pattern, string, firstindex(s)).\n\nExamples\n\njulia> findfirst(\"z\", \"Hello to the world\") # returns nothing, but not printed in the REPL\n\njulia> findfirst(\"Julia\", \"JuliaLang\")\n1:5\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.findnext-Tuple{AbstractString, AbstractString, Integer}","page":"Strings","title":"Base.findnext","text":"findnext(pattern::AbstractString, string::AbstractString, start::Integer)\nfindnext(pattern::AbstractPattern, string::String, start::Integer)\n\nFind the next occurrence of pattern in string starting at position start. pattern can be either a string, or a regular expression, in which case string must be of type String.\n\nThe return value is a range of indices where the matching sequence is found, such that s[findnext(x, s, i)] == x:\n\nfindnext(\"substring\", string, i) == start:stop such that string[start:stop] == \"substring\" and i <= start, or nothing if unmatched.\n\nExamples\n\njulia> findnext(\"z\", \"Hello to the world\", 1) === nothing\ntrue\n\njulia> findnext(\"o\", \"Hello to the world\", 6)\n8:8\n\njulia> findnext(\"Lang\", \"JuliaLang\", 2)\n6:9\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.findnext-Tuple{AbstractChar, AbstractString, Integer}","page":"Strings","title":"Base.findnext","text":"findnext(ch::AbstractChar, string::AbstractString, start::Integer)\n\nFind the next occurrence of character ch in string starting at position start.\n\ncompat: Julia 1.3\nThis method requires at least Julia 1.3.\n\nExamples\n\njulia> findnext('z', \"Hello to the world\", 1) === nothing\ntrue\n\njulia> findnext('o', \"Hello to the world\", 6)\n8\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.findlast-Tuple{AbstractString, AbstractString}","page":"Strings","title":"Base.findlast","text":"findlast(pattern::AbstractString, string::AbstractString)\n\nFind the last occurrence of pattern in string. Equivalent to findprev(pattern, string, lastindex(string)).\n\nExamples\n\njulia> findlast(\"o\", \"Hello to the world\")\n15:15\n\njulia> findfirst(\"Julia\", \"JuliaLang\")\n1:5\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.findlast-Tuple{AbstractChar, AbstractString}","page":"Strings","title":"Base.findlast","text":"findlast(ch::AbstractChar, string::AbstractString)\n\nFind the last occurrence of character ch in string.\n\ncompat: Julia 1.3\nThis method requires at least Julia 1.3.\n\nExamples\n\njulia> findlast('p', \"happy\")\n4\n\njulia> findlast('z', \"happy\") === nothing\ntrue\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.findprev-Tuple{AbstractString, AbstractString, Integer}","page":"Strings","title":"Base.findprev","text":"findprev(pattern::AbstractString, string::AbstractString, start::Integer)\n\nFind the previous occurrence of pattern in string starting at position start.\n\nThe return value is a range of indices where the matching sequence is found, such that s[findprev(x, s, i)] == x:\n\nfindprev(\"substring\", string, i) == start:stop such that string[start:stop] == \"substring\" and stop <= i, or nothing if unmatched.\n\nExamples\n\njulia> findprev(\"z\", \"Hello to the world\", 18) === nothing\ntrue\n\njulia> findprev(\"o\", \"Hello to the world\", 18)\n15:15\n\njulia> findprev(\"Julia\", \"JuliaLang\", 6)\n1:5\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.occursin","page":"Strings","title":"Base.occursin","text":"occursin(needle::Union{AbstractString,AbstractPattern,AbstractChar}, haystack::AbstractString)\n\nDetermine whether the first argument is a substring of the second. If needle is a regular expression, checks whether haystack contains a match.\n\nExamples\n\njulia> occursin(\"Julia\", \"JuliaLang is pretty cool!\")\ntrue\n\njulia> occursin('a', \"JuliaLang is pretty cool!\")\ntrue\n\njulia> occursin(r\"a.a\", \"aba\")\ntrue\n\njulia> occursin(r\"a.a\", \"abba\")\nfalse\n\nSee also contains.\n\n\n\n\n\noccursin(haystack)\n\nCreate a function that checks whether its argument occurs in haystack, i.e. a function equivalent to needle -> occursin(needle, haystack).\n\nThe returned function is of type Base.Fix2{typeof(occursin)}.\n\ncompat: Julia 1.6\nThis method requires Julia 1.6 or later.\n\nExamples\n\njulia> search_f = occursin(\"JuliaLang is a programming language\");\n\njulia> search_f(\"JuliaLang\")\ntrue\n\njulia> search_f(\"Python\")\nfalse\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.reverse-Tuple{Union{SubString{String}, String}}","page":"Strings","title":"Base.reverse","text":"reverse(s::AbstractString) -> AbstractString\n\nReverses a string. Technically, this function reverses the codepoints in a string and its main utility is for reversed-order string processing, especially for reversed regular-expression searches. See also reverseind to convert indices in s to indices in reverse(s) and vice-versa, and graphemes from module Unicode to operate on user-visible \"characters\" (graphemes) rather than codepoints. See also Iterators.reverse for reverse-order iteration without making a copy. Custom string types must implement the reverse function themselves and should typically return a string with the same type and encoding. If they return a string with a different encoding, they must also override reverseind for that string type to satisfy s[reverseind(s,i)] == reverse(s)[i].\n\nExamples\n\njulia> reverse(\"JuliaLang\")\n\"gnaLailuJ\"\n\nnote: Note\nThe examples below may be rendered differently on different systems. The comments indicate how they're supposed to be rendered\n\nCombining characters can lead to surprising results:\n\njulia> reverse(\"ax̂e\") # hat is above x in the input, above e in the output\n\"êxa\"\n\njulia> using Unicode\n\njulia> join(reverse(collect(graphemes(\"ax̂e\")))) # reverses graphemes; hat is above x in both in- and output\n\"ex̂a\"\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.replace-Tuple{IO, AbstractString, Vararg{Pair}}","page":"Strings","title":"Base.replace","text":"replace([io::IO], s::AbstractString, pat=>r, [pat2=>r2, ...]; [count::Integer])\n\nSearch for the given pattern pat in s, and replace each occurrence with r. If count is provided, replace at most count occurrences. pat may be a single character, a vector or a set of characters, a string, or a regular expression. If r is a function, each occurrence is replaced with r(s) where s is the matched substring (when pat is a AbstractPattern or AbstractString) or character (when pat is an AbstractChar or a collection of AbstractChar). If pat is a regular expression and r is a SubstitutionString, then capture group references in r are replaced with the corresponding matched text. To remove instances of pat from string, set r to the empty String (\"\").\n\nThe return value is a new string after the replacements.  If the io::IO argument is supplied, the transformed string is instead written to io (returning io). (For example, this can be used in conjunction with an IOBuffer to re-use a pre-allocated buffer array in-place.)\n\nMultiple patterns can be specified, and they will be applied left-to-right simultaneously, so only one pattern will be applied to any character, and the patterns will only be applied to the input text, not the replacements.\n\ncompat: Julia 1.7\nSupport for multiple patterns requires version 1.7.\n\ncompat: Julia 1.10\nThe io::IO argument requires version 1.10.\n\nExamples\n\njulia> replace(\"Python is a programming language.\", \"Python\" => \"Julia\")\n\"Julia is a programming language.\"\n\njulia> replace(\"The quick foxes run quickly.\", \"quick\" => \"slow\", count=1)\n\"The slow foxes run quickly.\"\n\njulia> replace(\"The quick foxes run quickly.\", \"quick\" => \"\", count=1)\n\"The  foxes run quickly.\"\n\njulia> replace(\"The quick foxes run quickly.\", r\"fox(es)?\" => s\"bus\\1\")\n\"The quick buses run quickly.\"\n\njulia> replace(\"abcabc\", \"a\" => \"b\", \"b\" => \"c\", r\".+\" => \"a\")\n\"bca\"\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.eachsplit","page":"Strings","title":"Base.eachsplit","text":"eachsplit(str::AbstractString, dlm; limit::Integer=0, keepempty::Bool=true)\neachsplit(str::AbstractString; limit::Integer=0, keepempty::Bool=false)\n\nSplit str on occurrences of the delimiter(s) dlm and return an iterator over the substrings.  dlm can be any of the formats allowed by findnext's first argument (i.e. as a string, regular expression or a function), or as a single character or collection of characters.\n\nIf dlm is omitted, it defaults to isspace.\n\nThe optional keyword arguments are:\n\nlimit: the maximum size of the result. limit=0 implies no maximum (default)\nkeepempty: whether empty fields should be kept in the result. Default is false without a dlm argument, true with a dlm argument.\n\nSee also split.\n\ncompat: Julia 1.8\nThe eachsplit function requires at least Julia 1.8.\n\nExamples\n\njulia> a = \"Ma.rch\"\n\"Ma.rch\"\n\njulia> b = eachsplit(a, \".\")\nBase.SplitIterator{String, String}(\"Ma.rch\", \".\", 0, true)\n\njulia> collect(b)\n2-element Vector{SubString{String}}:\n \"Ma\"\n \"rch\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.eachrsplit","page":"Strings","title":"Base.eachrsplit","text":"eachrsplit(str::AbstractString, dlm; limit::Integer=0, keepempty::Bool=true)\neachrsplit(str::AbstractString; limit::Integer=0, keepempty::Bool=false)\n\nReturn an iterator over SubStrings of str, produced when splitting on the delimiter(s) dlm, and yielded in reverse order (from right to left). dlm can be any of the formats allowed by findprev's first argument (i.e. a string, a single character or a function), or a collection of characters.\n\nIf dlm is omitted, it defaults to isspace, and keepempty default to false.\n\nThe optional keyword arguments are:\n\nIf limit > 0, the iterator will split at most limit - 1 times before returning the rest of the string unsplit. limit < 1 implies no cap to splits (default).\nkeepempty: whether empty fields should be returned when iterating Default is false without a dlm argument, true with a dlm argument.\n\nNote that unlike split, rsplit and eachsplit, this function iterates the substrings right to left as they occur in the input.\n\nSee also eachsplit, rsplit.\n\ncompat: Julia 1.11\nThis function requires Julia 1.11 or later.\n\nExamples\n\njulia> a = \"Ma.r.ch\";\n\njulia> collect(eachrsplit(a, \".\")) == [\"ch\", \"r\", \"Ma\"]\ntrue\n\njulia> collect(eachrsplit(a, \".\"; limit=2)) == [\"ch\", \"Ma.r\"]\ntrue\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.split","page":"Strings","title":"Base.split","text":"split(str::AbstractString, dlm; limit::Integer=0, keepempty::Bool=true)\nsplit(str::AbstractString; limit::Integer=0, keepempty::Bool=false)\n\nSplit str into an array of substrings on occurrences of the delimiter(s) dlm.  dlm can be any of the formats allowed by findnext's first argument (i.e. as a string, regular expression or a function), or as a single character or collection of characters.\n\nIf dlm is omitted, it defaults to isspace.\n\nThe optional keyword arguments are:\n\nlimit: the maximum size of the result. limit=0 implies no maximum (default)\nkeepempty: whether empty fields should be kept in the result. Default is false without a dlm argument, true with a dlm argument.\n\nSee also rsplit, eachsplit.\n\nExamples\n\njulia> a = \"Ma.rch\"\n\"Ma.rch\"\n\njulia> split(a, \".\")\n2-element Vector{SubString{String}}:\n \"Ma\"\n \"rch\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.rsplit","page":"Strings","title":"Base.rsplit","text":"rsplit(s::AbstractString; limit::Integer=0, keepempty::Bool=false)\nrsplit(s::AbstractString, chars; limit::Integer=0, keepempty::Bool=true)\n\nSimilar to split, but starting from the end of the string.\n\nExamples\n\njulia> a = \"M.a.r.c.h\"\n\"M.a.r.c.h\"\n\njulia> rsplit(a, \".\")\n5-element Vector{SubString{String}}:\n \"M\"\n \"a\"\n \"r\"\n \"c\"\n \"h\"\n\njulia> rsplit(a, \".\"; limit=1)\n1-element Vector{SubString{String}}:\n \"M.a.r.c.h\"\n\njulia> rsplit(a, \".\"; limit=2)\n2-element Vector{SubString{String}}:\n \"M.a.r.c\"\n \"h\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.strip","page":"Strings","title":"Base.strip","text":"strip([pred=isspace,] str::AbstractString) -> SubString\nstrip(str::AbstractString, chars) -> SubString\n\nRemove leading and trailing characters from str, either those specified by chars or those for which the function pred returns true.\n\nThe default behaviour is to remove leading and trailing whitespace and delimiters: see isspace for precise details.\n\nThe optional chars argument specifies which characters to remove: it can be a single character, vector or set of characters.\n\nSee also lstrip and rstrip.\n\ncompat: Julia 1.2\nThe method which accepts a predicate function requires Julia 1.2 or later.\n\nExamples\n\njulia> strip(\"{3, 5}\\n\", ['{', '}', '\\n'])\n\"3, 5\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.lstrip","page":"Strings","title":"Base.lstrip","text":"lstrip([pred=isspace,] str::AbstractString) -> SubString\nlstrip(str::AbstractString, chars) -> SubString\n\nRemove leading characters from str, either those specified by chars or those for which the function pred returns true.\n\nThe default behaviour is to remove leading whitespace and delimiters: see isspace for precise details.\n\nThe optional chars argument specifies which characters to remove: it can be a single character, or a vector or set of characters.\n\nSee also strip and rstrip.\n\nExamples\n\njulia> a = lpad(\"March\", 20)\n\"               March\"\n\njulia> lstrip(a)\n\"March\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.rstrip","page":"Strings","title":"Base.rstrip","text":"rstrip([pred=isspace,] str::AbstractString) -> SubString\nrstrip(str::AbstractString, chars) -> SubString\n\nRemove trailing characters from str, either those specified by chars or those for which the function pred returns true.\n\nThe default behaviour is to remove trailing whitespace and delimiters: see isspace for precise details.\n\nThe optional chars argument specifies which characters to remove: it can be a single character, or a vector or set of characters.\n\nSee also strip and lstrip.\n\nExamples\n\njulia> a = rpad(\"March\", 20)\n\"March               \"\n\njulia> rstrip(a)\n\"March\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.startswith","page":"Strings","title":"Base.startswith","text":"startswith(s::AbstractString, prefix::Union{AbstractString,Base.Chars})\n\nReturn true if s starts with prefix, which can be a string, a character, or a tuple/vector/set of characters. If prefix is a tuple/vector/set of characters, test whether the first character of s belongs to that set.\n\nSee also endswith, contains.\n\nExamples\n\njulia> startswith(\"JuliaLang\", \"Julia\")\ntrue\n\n\n\n\n\nstartswith(io::IO, prefix::Union{AbstractString,Base.Chars})\n\nCheck if an IO object starts with a prefix, which can be either a string, a character, or a tuple/vector/set of characters.  See also peek.\n\n\n\n\n\nstartswith(prefix)\n\nCreate a function that checks whether its argument starts with prefix, i.e. a function equivalent to y -> startswith(y, prefix).\n\nThe returned function is of type Base.Fix2{typeof(startswith)}, which can be used to implement specialized methods.\n\ncompat: Julia 1.5\nThe single argument startswith(prefix) requires at least Julia 1.5.\n\nExamples\n\njulia> startswith(\"Julia\")(\"JuliaLang\")\ntrue\n\njulia> startswith(\"Julia\")(\"Ends with Julia\")\nfalse\n\n\n\n\n\nstartswith(s::AbstractString, prefix::Regex)\n\nReturn true if s starts with the regex pattern, prefix.\n\nnote: Note\nstartswith does not compile the anchoring into the regular expression, but instead passes the anchoring as match_option to PCRE. If compile time is amortized, occursin(r\"^...\", s) is faster than startswith(s, r\"...\").\n\nSee also occursin and endswith.\n\ncompat: Julia 1.2\nThis method requires at least Julia 1.2.\n\nExamples\n\njulia> startswith(\"JuliaLang\", r\"Julia|Romeo\")\ntrue\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.endswith","page":"Strings","title":"Base.endswith","text":"endswith(s::AbstractString, suffix::Union{AbstractString,Base.Chars})\n\nReturn true if s ends with suffix, which can be a string, a character, or a tuple/vector/set of characters. If suffix is a tuple/vector/set of characters, test whether the last character of s belongs to that set.\n\nSee also startswith, contains.\n\nExamples\n\njulia> endswith(\"Sunday\", \"day\")\ntrue\n\n\n\n\n\nendswith(suffix)\n\nCreate a function that checks whether its argument ends with suffix, i.e. a function equivalent to y -> endswith(y, suffix).\n\nThe returned function is of type Base.Fix2{typeof(endswith)}, which can be used to implement specialized methods.\n\ncompat: Julia 1.5\nThe single argument endswith(suffix) requires at least Julia 1.5.\n\nExamples\n\njulia> endswith(\"Julia\")(\"Ends with Julia\")\ntrue\n\njulia> endswith(\"Julia\")(\"JuliaLang\")\nfalse\n\n\n\n\n\nendswith(s::AbstractString, suffix::Regex)\n\nReturn true if s ends with the regex pattern, suffix.\n\nnote: Note\nendswith does not compile the anchoring into the regular expression, but instead passes the anchoring as match_option to PCRE. If compile time is amortized, occursin(r\"...$\", s) is faster than endswith(s, r\"...\").\n\nSee also occursin and startswith.\n\ncompat: Julia 1.2\nThis method requires at least Julia 1.2.\n\nExamples\n\njulia> endswith(\"JuliaLang\", r\"Lang|Roberts\")\ntrue\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.contains","page":"Strings","title":"Base.contains","text":"contains(haystack::AbstractString, needle)\n\nReturn true if haystack contains needle. This is the same as occursin(needle, haystack), but is provided for consistency with startswith(haystack, needle) and endswith(haystack, needle).\n\nSee also occursin, in, issubset.\n\nExamples\n\njulia> contains(\"JuliaLang is pretty cool!\", \"Julia\")\ntrue\n\njulia> contains(\"JuliaLang is pretty cool!\", 'a')\ntrue\n\njulia> contains(\"aba\", r\"a.a\")\ntrue\n\njulia> contains(\"abba\", r\"a.a\")\nfalse\n\ncompat: Julia 1.5\nThe contains function requires at least Julia 1.5.\n\n\n\n\n\ncontains(needle)\n\nCreate a function that checks whether its argument contains needle, i.e. a function equivalent to haystack -> contains(haystack, needle).\n\nThe returned function is of type Base.Fix2{typeof(contains)}, which can be used to implement specialized methods.\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.first-Tuple{AbstractString, Integer}","page":"Strings","title":"Base.first","text":"first(s::AbstractString, n::Integer)\n\nGet a string consisting of the first n characters of s.\n\nExamples\n\njulia> first(\"∀ϵ≠0: ϵ²>0\", 0)\n\"\"\n\njulia> first(\"∀ϵ≠0: ϵ²>0\", 1)\n\"∀\"\n\njulia> first(\"∀ϵ≠0: ϵ²>0\", 3)\n\"∀ϵ≠\"\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.last-Tuple{AbstractString, Integer}","page":"Strings","title":"Base.last","text":"last(s::AbstractString, n::Integer)\n\nGet a string consisting of the last n characters of s.\n\nExamples\n\njulia> last(\"∀ϵ≠0: ϵ²>0\", 0)\n\"\"\n\njulia> last(\"∀ϵ≠0: ϵ²>0\", 1)\n\"0\"\n\njulia> last(\"∀ϵ≠0: ϵ²>0\", 3)\n\"²>0\"\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.Unicode.uppercase","page":"Strings","title":"Base.Unicode.uppercase","text":"uppercase(c::AbstractChar)\n\nConvert c to uppercase.\n\nSee also lowercase, titlecase.\n\nExamples\n\njulia> uppercase('a')\n'A': ASCII/Unicode U+0041 (category Lu: Letter, uppercase)\n\njulia> uppercase('ê')\n'Ê': Unicode U+00CA (category Lu: Letter, uppercase)\n\n\n\n\n\nuppercase(s::AbstractString)\n\nReturn s with all characters converted to uppercase.\n\nSee also lowercase, titlecase, uppercasefirst.\n\nExamples\n\njulia> uppercase(\"Julia\")\n\"JULIA\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.Unicode.lowercase","page":"Strings","title":"Base.Unicode.lowercase","text":"lowercase(c::AbstractChar)\n\nConvert c to lowercase.\n\nSee also uppercase, titlecase.\n\nExamples\n\njulia> lowercase('A')\n'a': ASCII/Unicode U+0061 (category Ll: Letter, lowercase)\n\njulia> lowercase('Ö')\n'ö': Unicode U+00F6 (category Ll: Letter, lowercase)\n\n\n\n\n\nlowercase(s::AbstractString)\n\nReturn s with all characters converted to lowercase.\n\nSee also uppercase, titlecase, lowercasefirst.\n\nExamples\n\njulia> lowercase(\"STRINGS AND THINGS\")\n\"strings and things\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.Unicode.titlecase","page":"Strings","title":"Base.Unicode.titlecase","text":"titlecase(c::AbstractChar)\n\nConvert c to titlecase. This may differ from uppercase for digraphs, compare the example below.\n\nSee also uppercase, lowercase.\n\nExamples\n\njulia> titlecase('a')\n'A': ASCII/Unicode U+0041 (category Lu: Letter, uppercase)\n\njulia> titlecase('ǆ')\n'ǅ': Unicode U+01C5 (category Lt: Letter, titlecase)\n\njulia> uppercase('ǆ')\n'Ǆ': Unicode U+01C4 (category Lu: Letter, uppercase)\n\n\n\n\n\ntitlecase(s::AbstractString; [wordsep::Function], strict::Bool=true) -> String\n\nCapitalize the first character of each word in s; if strict is true, every other character is converted to lowercase, otherwise they are left unchanged. By default, all non-letters beginning a new grapheme are considered as word separators; a predicate can be passed as the wordsep keyword to determine which characters should be considered as word separators. See also uppercasefirst to capitalize only the first character in s.\n\nSee also uppercase, lowercase, uppercasefirst.\n\nExamples\n\njulia> titlecase(\"the JULIA programming language\")\n\"The Julia Programming Language\"\n\njulia> titlecase(\"ISS - international space station\", strict=false)\n\"ISS - International Space Station\"\n\njulia> titlecase(\"a-a b-b\", wordsep = c->c==' ')\n\"A-a B-b\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.Unicode.uppercasefirst","page":"Strings","title":"Base.Unicode.uppercasefirst","text":"uppercasefirst(s::AbstractString) -> String\n\nReturn s with the first character converted to uppercase (technically \"title case\" for Unicode). See also titlecase to capitalize the first character of every word in s.\n\nSee also lowercasefirst, uppercase, lowercase, titlecase.\n\nExamples\n\njulia> uppercasefirst(\"python\")\n\"Python\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.Unicode.lowercasefirst","page":"Strings","title":"Base.Unicode.lowercasefirst","text":"lowercasefirst(s::AbstractString)\n\nReturn s with the first character converted to lowercase.\n\nSee also uppercasefirst, uppercase, lowercase, titlecase.\n\nExamples\n\njulia> lowercasefirst(\"Julia\")\n\"julia\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.join","page":"Strings","title":"Base.join","text":"join([io::IO,] iterator [, delim [, last]])\n\nJoin any iterator into a single string, inserting the given delimiter (if any) between adjacent items.  If last is given, it will be used instead of delim between the last two items.  Each item of iterator is converted to a string via print(io::IOBuffer, x). If io is given, the result is written to io rather than returned as a String.\n\nExamples\n\njulia> join([\"apples\", \"bananas\", \"pineapples\"], \", \", \" and \")\n\"apples, bananas and pineapples\"\n\njulia> join([1,2,3,4,5])\n\"12345\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.chop","page":"Strings","title":"Base.chop","text":"chop(s::AbstractString; head::Integer = 0, tail::Integer = 1)\n\nRemove the first head and the last tail characters from s. The call chop(s) removes the last character from s. If it is requested to remove more characters than length(s) then an empty string is returned.\n\nSee also chomp, startswith, first.\n\nExamples\n\njulia> a = \"March\"\n\"March\"\n\njulia> chop(a)\n\"Marc\"\n\njulia> chop(a, head = 1, tail = 2)\n\"ar\"\n\njulia> chop(a, head = 5, tail = 5)\n\"\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.chopprefix","page":"Strings","title":"Base.chopprefix","text":"chopprefix(s::AbstractString, prefix::Union{AbstractString,Regex}) -> SubString\n\nRemove the prefix prefix from s. If s does not start with prefix, a string equal to s is returned.\n\nSee also chopsuffix.\n\ncompat: Julia 1.8\nThis function is available as of Julia 1.8.\n\nExamples\n\njulia> chopprefix(\"Hamburger\", \"Ham\")\n\"burger\"\n\njulia> chopprefix(\"Hamburger\", \"hotdog\")\n\"Hamburger\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.chopsuffix","page":"Strings","title":"Base.chopsuffix","text":"chopsuffix(s::AbstractString, suffix::Union{AbstractString,Regex}) -> SubString\n\nRemove the suffix suffix from s. If s does not end with suffix, a string equal to s is returned.\n\nSee also chopprefix.\n\ncompat: Julia 1.8\nThis function is available as of Julia 1.8.\n\nExamples\n\njulia> chopsuffix(\"Hamburger\", \"er\")\n\"Hamburg\"\n\njulia> chopsuffix(\"Hamburger\", \"hotdog\")\n\"Hamburger\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.chomp","page":"Strings","title":"Base.chomp","text":"chomp(s::AbstractString) -> SubString\n\nRemove a single trailing newline from a string.\n\nSee also chop.\n\nExamples\n\njulia> chomp(\"Hello\\n\")\n\"Hello\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.thisind","page":"Strings","title":"Base.thisind","text":"thisind(s::AbstractString, i::Integer) -> Int\n\nIf i is in bounds in s return the index of the start of the character whose encoding code unit i is part of. In other words, if i is the start of a character, return i; if i is not the start of a character, rewind until the start of a character and return that index. If i is equal to 0 or ncodeunits(s)+1 return i. In all other cases throw BoundsError.\n\nExamples\n\njulia> thisind(\"α\", 0)\n0\n\njulia> thisind(\"α\", 1)\n1\n\njulia> thisind(\"α\", 2)\n1\n\njulia> thisind(\"α\", 3)\n3\n\njulia> thisind(\"α\", 4)\nERROR: BoundsError: attempt to access 2-codeunit String at index [4]\n[...]\n\njulia> thisind(\"α\", -1)\nERROR: BoundsError: attempt to access 2-codeunit String at index [-1]\n[...]\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.nextind-Tuple{AbstractString, Integer, Integer}","page":"Strings","title":"Base.nextind","text":"nextind(str::AbstractString, i::Integer, n::Integer=1) -> Int\n\nCase n == 1\nIf i is in bounds in s return the index of the start of the character whose encoding starts after index i. In other words, if i is the start of a character, return the start of the next character; if i is not the start of a character, move forward until the start of a character and return that index. If i is equal to 0 return 1. If i is in bounds but greater or equal to lastindex(str) return ncodeunits(str)+1. Otherwise throw BoundsError.\nCase n > 1\nBehaves like applying n times nextind for n==1. The only difference is that if n is so large that applying nextind would reach ncodeunits(str)+1 then each remaining iteration increases the returned value by 1. This means that in this case nextind can return a value greater than ncodeunits(str)+1.\nCase n == 0\nReturn i only if i is a valid index in s or is equal to 0. Otherwise StringIndexError or BoundsError is thrown.\n\nExamples\n\njulia> nextind(\"α\", 0)\n1\n\njulia> nextind(\"α\", 1)\n3\n\njulia> nextind(\"α\", 3)\nERROR: BoundsError: attempt to access 2-codeunit String at index [3]\n[...]\n\njulia> nextind(\"α\", 0, 2)\n3\n\njulia> nextind(\"α\", 1, 2)\n4\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.prevind-Tuple{AbstractString, Integer, Integer}","page":"Strings","title":"Base.prevind","text":"prevind(str::AbstractString, i::Integer, n::Integer=1) -> Int\n\nCase n == 1\nIf i is in bounds in s return the index of the start of the character whose encoding starts before index i. In other words, if i is the start of a character, return the start of the previous character; if i is not the start of a character, rewind until the start of a character and return that index. If i is equal to 1 return 0. If i is equal to ncodeunits(str)+1 return lastindex(str). Otherwise throw BoundsError.\nCase n > 1\nBehaves like applying n times prevind for n==1. The only difference is that if n is so large that applying prevind would reach 0 then each remaining iteration decreases the returned value by 1. This means that in this case prevind can return a negative value.\nCase n == 0\nReturn i only if i is a valid index in str or is equal to ncodeunits(str)+1. Otherwise StringIndexError or BoundsError is thrown.\n\nExamples\n\njulia> prevind(\"α\", 3)\n1\n\njulia> prevind(\"α\", 1)\n0\n\njulia> prevind(\"α\", 0)\nERROR: BoundsError: attempt to access 2-codeunit String at index [0]\n[...]\n\njulia> prevind(\"α\", 2, 2)\n0\n\njulia> prevind(\"α\", 2, 3)\n-1\n\n\n\n\n\n","category":"method"},{"location":"base/strings.html#Base.Unicode.textwidth","page":"Strings","title":"Base.Unicode.textwidth","text":"textwidth(c)\n\nGive the number of columns needed to print a character.\n\nExamples\n\njulia> textwidth('α')\n1\n\njulia> textwidth('⛵')\n2\n\n\n\n\n\ntextwidth(s::AbstractString)\n\nGive the number of columns needed to print a string.\n\nExamples\n\njulia> textwidth(\"March\")\n5\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.isascii","page":"Strings","title":"Base.isascii","text":"isascii(c::Union{AbstractChar,AbstractString}) -> Bool\n\nTest whether a character belongs to the ASCII character set, or whether this is true for all elements of a string.\n\nExamples\n\njulia> isascii('a')\ntrue\n\njulia> isascii('α')\nfalse\n\njulia> isascii(\"abc\")\ntrue\n\njulia> isascii(\"αβγ\")\nfalse\n\nFor example, isascii can be used as a predicate function for filter or replace to remove or replace non-ASCII characters, respectively:\n\njulia> filter(isascii, \"abcdeγfgh\") # discard non-ASCII chars\n\"abcdefgh\"\n\njulia> replace(\"abcdeγfgh\", !isascii=>' ') # replace non-ASCII chars with spaces\n\"abcde fgh\"\n\n\n\n\n\nisascii(cu::AbstractVector{CU}) where {CU <: Integer} -> Bool\n\nTest whether all values in the vector belong to the ASCII character set (0x00 to 0x7f). This function is intended to be used by other string implementations that need a fast ASCII check.\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.Unicode.iscntrl","page":"Strings","title":"Base.Unicode.iscntrl","text":"iscntrl(c::AbstractChar) -> Bool\n\nTests whether a character is a control character. Control characters are the non-printing characters of the Latin-1 subset of Unicode.\n\nExamples\n\njulia> iscntrl('\\x01')\ntrue\n\njulia> iscntrl('a')\nfalse\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.Unicode.isdigit","page":"Strings","title":"Base.Unicode.isdigit","text":"isdigit(c::AbstractChar) -> Bool\n\nTests whether a character is a decimal digit (0-9).\n\nSee also: isletter.\n\nExamples\n\njulia> isdigit('❤')\nfalse\n\njulia> isdigit('9')\ntrue\n\njulia> isdigit('α')\nfalse\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.Unicode.isletter","page":"Strings","title":"Base.Unicode.isletter","text":"isletter(c::AbstractChar) -> Bool\n\nTest whether a character is a letter. A character is classified as a letter if it belongs to the Unicode general category Letter, i.e. a character whose category code begins with 'L'.\n\nSee also: isdigit.\n\nExamples\n\njulia> isletter('❤')\nfalse\n\njulia> isletter('α')\ntrue\n\njulia> isletter('9')\nfalse\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.Unicode.islowercase","page":"Strings","title":"Base.Unicode.islowercase","text":"islowercase(c::AbstractChar) -> Bool\n\nTests whether a character is a lowercase letter (according to the Unicode standard's Lowercase derived property).\n\nSee also isuppercase.\n\nExamples\n\njulia> islowercase('α')\ntrue\n\njulia> islowercase('Γ')\nfalse\n\njulia> islowercase('❤')\nfalse\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.Unicode.isnumeric","page":"Strings","title":"Base.Unicode.isnumeric","text":"isnumeric(c::AbstractChar) -> Bool\n\nTests whether a character is numeric. A character is classified as numeric if it belongs to the Unicode general category Number, i.e. a character whose category code begins with 'N'.\n\nNote that this broad category includes characters such as ¾ and ௰. Use isdigit to check whether a character is a decimal digit between 0 and 9.\n\nExamples\n\njulia> isnumeric('௰')\ntrue\n\njulia> isnumeric('9')\ntrue\n\njulia> isnumeric('α')\nfalse\n\njulia> isnumeric('❤')\nfalse\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.Unicode.isprint","page":"Strings","title":"Base.Unicode.isprint","text":"isprint(c::AbstractChar) -> Bool\n\nTests whether a character is printable, including spaces, but not a control character.\n\nExamples\n\njulia> isprint('\\x01')\nfalse\n\njulia> isprint('A')\ntrue\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.Unicode.ispunct","page":"Strings","title":"Base.Unicode.ispunct","text":"ispunct(c::AbstractChar) -> Bool\n\nTests whether a character belongs to the Unicode general category Punctuation, i.e. a character whose category code begins with 'P'.\n\nExamples\n\njulia> ispunct('α')\nfalse\n\njulia> ispunct('/')\ntrue\n\njulia> ispunct(';')\ntrue\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.Unicode.isspace","page":"Strings","title":"Base.Unicode.isspace","text":"isspace(c::AbstractChar) -> Bool\n\nTests whether a character is any whitespace character. Includes ASCII characters '\\t', '\\n', '\\v', '\\f', '\\r', and ' ', Latin-1 character U+0085, and characters in Unicode category Zs.\n\nExamples\n\njulia> isspace('\\n')\ntrue\n\njulia> isspace('\\r')\ntrue\n\njulia> isspace(' ')\ntrue\n\njulia> isspace('\\x20')\ntrue\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.Unicode.isuppercase","page":"Strings","title":"Base.Unicode.isuppercase","text":"isuppercase(c::AbstractChar) -> Bool\n\nTests whether a character is an uppercase letter (according to the Unicode standard's Uppercase derived property).\n\nSee also islowercase.\n\nExamples\n\njulia> isuppercase('γ')\nfalse\n\njulia> isuppercase('Γ')\ntrue\n\njulia> isuppercase('❤')\nfalse\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.Unicode.isxdigit","page":"Strings","title":"Base.Unicode.isxdigit","text":"isxdigit(c::AbstractChar) -> Bool\n\nTest whether a character is a valid hexadecimal digit. Note that this does not include x (as in the standard 0x prefix).\n\nExamples\n\njulia> isxdigit('a')\ntrue\n\njulia> isxdigit('x')\nfalse\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.escape_string","page":"Strings","title":"Base.escape_string","text":"escape_string(str::AbstractString[, esc]; keep = ())::AbstractString\nescape_string(io, str::AbstractString[, esc]; keep = ())::Nothing\n\nGeneral escaping of traditional C and Unicode escape sequences. The first form returns the escaped string, the second prints the result to io.\n\nBackslashes (\\) are escaped with a double-backslash (\"\\\\\"). Non-printable characters are escaped either with their standard C escape codes, \"\\0\" for NUL (if unambiguous), unicode code point (\"\\u\" prefix) or hex (\"\\x\" prefix).\n\nThe optional esc argument specifies any additional characters that should also be escaped by a prepending backslash (\" is also escaped by default in the first form).\n\nThe argument keep specifies a collection of characters which are to be kept as they are. Notice that esc has precedence here.\n\nSee also unescape_string for the reverse operation.\n\ncompat: Julia 1.7\nThe keep argument is available as of Julia 1.7.\n\nExamples\n\njulia> escape_string(\"aaa\\nbbb\")\n\"aaa\\\\nbbb\"\n\njulia> escape_string(\"aaa\\nbbb\"; keep = '\\n')\n\"aaa\\nbbb\"\n\njulia> escape_string(\"\\xfe\\xff\") # invalid utf-8\n\"\\\\xfe\\\\xff\"\n\njulia> escape_string(string('\\u2135','\\0')) # unambiguous\n\"ℵ\\\\0\"\n\njulia> escape_string(string('\\u2135','\\0','0')) # \\0 would be ambiguous\n\"ℵ\\\\x000\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.escape_raw_string","page":"Strings","title":"Base.escape_raw_string","text":"escape_raw_string(s::AbstractString, delim='\"') -> AbstractString\nescape_raw_string(io, s::AbstractString, delim='\"')\n\nEscape a string in the manner used for parsing raw string literals. For each double-quote (\") character in input string s (or delim if specified), this function counts the number n of preceding backslash (\\) characters, and then increases there the number of backslashes from n to 2n+1 (even for n = 0). It also doubles a sequence of backslashes at the end of the string.\n\nThis escaping convention is used in raw strings and other non-standard string literals. (It also happens to be the escaping convention expected by the Microsoft C/C++ compiler runtime when it parses a command-line string into the argv[] array.)\n\nSee also escape_string.\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.unescape_string","page":"Strings","title":"Base.unescape_string","text":"unescape_string(str::AbstractString, keep = ())::AbstractString\nunescape_string(io, s::AbstractString, keep = ())::Nothing\n\nGeneral unescaping of traditional C and Unicode escape sequences. The first form returns the escaped string, the second prints the result to io. The argument keep specifies a collection of characters which (along with backlashes) are to be kept as they are.\n\nThe following escape sequences are recognised:\n\nEscaped backslash (\\\\)\nEscaped double-quote (\\\")\nStandard C escape sequences (\\a, \\b, \\t, \\n, \\v, \\f, \\r, \\e)\nUnicode BMP code points (\\u with 1-4 trailing hex digits)\nAll Unicode code points (\\U with 1-8 trailing hex digits; max value = 0010ffff)\nHex bytes (\\x with 1-2 trailing hex digits)\nOctal bytes (\\ with 1-3 trailing octal digits)\n\nSee also escape_string.\n\nExamples\n\njulia> unescape_string(\"aaa\\\\nbbb\") # C escape sequence\n\"aaa\\nbbb\"\n\njulia> unescape_string(\"\\\\u03c0\") # unicode\n\"π\"\n\njulia> unescape_string(\"\\\\101\") # octal\n\"A\"\n\njulia> unescape_string(\"aaa \\\\g \\\\n\", ['g']) # using `keep` argument\n\"aaa \\\\g \\n\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#AnnotatedStrings","page":"Strings","title":"AnnotatedStrings","text":"","category":"section"},{"location":"base/strings.html","page":"Strings","title":"Strings","text":"note: Note\nThe API for AnnotatedStrings is considered experimental and is subject to change between Julia versions.","category":"page"},{"location":"base/strings.html","page":"Strings","title":"Strings","text":"Base.AnnotatedString\nBase.AnnotatedChar\nBase.annotatedstring\nBase.annotations\nBase.annotate!","category":"page"},{"location":"base/strings.html#Base.AnnotatedString","page":"Strings","title":"Base.AnnotatedString","text":"AnnotatedString{S <: AbstractString} <: AbstractString\n\nA string with metadata, in the form of annotated regions.\n\nMore specifically, this is a simple wrapper around any other AbstractString that allows for regions of the wrapped string to be annotated with labeled values.\n\n                           C\n                    ┌──────┸─────────┐\n  \"this is an example annotated string\"\n  └──┰────────┼─────┘         │\n     A        └─────┰─────────┘\n                    B\n\nThe above diagram represents a AnnotatedString where three ranges have been annotated (labeled A, B, and C). Each annotation holds a label (Symbol) and a value (Any). These three pieces of information are held as a @NamedTuple{region::UnitRange{Int64}, label::Symbol, value}.\n\nLabels do not need to be unique, the same region can hold multiple annotations with the same label.\n\nCode written for AnnotatedStrings in general should conserve the following properties:\n\nWhich characters an annotation is applied to\nThe order in which annotations are applied to each character\n\nAdditional semantics may be introduced by specific uses of AnnotatedStrings.\n\nA corollary of these rules is that adjacent, consecutively placed, annotations with identical labels and values are equivalent to a single annotation spanning the combined range.\n\nSee also AnnotatedChar, annotatedstring, annotations, and annotate!.\n\nConstructors\n\nAnnotatedString(s::S<:AbstractString) -> AnnotatedString{S}\nAnnotatedString(s::S<:AbstractString, annotations::Vector{@NamedTuple{region::UnitRange{Int64}, label::Symbol, value}})\n\nA AnnotatedString can also be created with annotatedstring, which acts much like string but preserves any annotations present in the arguments.\n\nExamples\n\njulia> AnnotatedString(\"this is an example annotated string\",\n                    [(1:18, :A => 1), (12:28, :B => 2), (18:35, :C => 3)])\n\"this is an example annotated string\"\n\n\n\n\n\n","category":"type"},{"location":"base/strings.html#Base.AnnotatedChar","page":"Strings","title":"Base.AnnotatedChar","text":"AnnotatedChar{S <: AbstractChar} <: AbstractChar\n\nA Char with annotations.\n\nMore specifically, this is a simple wrapper around any other AbstractChar, which holds a list of arbitrary labelled annotations (@NamedTuple{label::Symbol, value}) with the wrapped character.\n\nSee also: AnnotatedString, annotatedstring, annotations, and annotate!.\n\nConstructors\n\nAnnotatedChar(s::S) -> AnnotatedChar{S}\nAnnotatedChar(s::S, annotations::Vector{@NamedTuple{label::Symbol, value}})\n\nExamples\n\njulia> AnnotatedChar('j', :label => 1)\n'j': ASCII/Unicode U+006A (category Ll: Letter, lowercase)\n\n\n\n\n\n","category":"type"},{"location":"base/strings.html#Base.annotatedstring","page":"Strings","title":"Base.annotatedstring","text":"annotatedstring(values...)\n\nCreate a AnnotatedString from any number of values using their printed representation.\n\nThis acts like string, but takes care to preserve any annotations present (in the form of AnnotatedString or AnnotatedChar values).\n\nSee also AnnotatedString and AnnotatedChar.\n\nExamples\n\njulia> annotatedstring(\"now a AnnotatedString\")\n\"now a AnnotatedString\"\n\njulia> annotatedstring(AnnotatedString(\"annotated\", [(1:9, :label => 1)]), \", and unannotated\")\n\"annotated, and unannotated\"\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.annotations","page":"Strings","title":"Base.annotations","text":"annotations(str::Union{AnnotatedString, SubString{AnnotatedString}},\n            [position::Union{Integer, UnitRange}]) ->\n    Vector{@NamedTuple{region::UnitRange{Int64}, label::Symbol, value}}\n\nGet all annotations that apply to str. Should position be provided, only annotations that overlap with position will be returned.\n\nAnnotations are provided together with the regions they apply to, in the form of a vector of region–annotation tuples.\n\nIn accordance with the semantics documented in AnnotatedString, the order of annotations returned matches the order in which they were applied.\n\nSee also: annotate!.\n\n\n\n\n\nannotations(chr::AnnotatedChar) -> Vector{@NamedTuple{label::Symbol, value}}\n\nGet all annotations of chr, in the form of a vector of annotation pairs.\n\n\n\n\n\n","category":"function"},{"location":"base/strings.html#Base.annotate!","page":"Strings","title":"Base.annotate!","text":"annotate!(str::AnnotatedString, [range::UnitRange{Int}], label::Symbol, value)\nannotate!(str::SubString{AnnotatedString}, [range::UnitRange{Int}], label::Symbol, value)\n\nAnnotate a range of str (or the entire string) with a labeled value (label => value). To remove existing label annotations, use a value of nothing.\n\nThe order in which annotations are applied to str is semantically meaningful, as described in AnnotatedString.\n\n\n\n\n\nannotate!(char::AnnotatedChar, label::Symbol, value::Any)\n\nAnnotate char with the pair label => value.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Libdl.html","page":"Dynamic Linker","title":"Dynamic Linker","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/stdlib/Libdl/docs/src/index.md\"","category":"page"},{"location":"stdlib/Libdl.html","page":"Dynamic Linker","title":"Dynamic Linker","text":"Libdl","category":"page"},{"location":"stdlib/Libdl.html#Libdl","page":"Dynamic Linker","title":"Libdl","text":"The Libdl module in Julia provides specialized and lower-level facilities for dynamic linking with shared libraries. While Julia inherently supports linking to runtime shared libraries through the ccall intrinsic, Libdl extends this capability by offering additional, more granular control. It enables users to search for shared libraries both in memory and the filesystem, manually load them with specific runtime linker options, and look up library symbols as low-level pointers.\n\n\n\n\n\n","category":"module"},{"location":"stdlib/Libdl.html#Dynamic-Linker","page":"Dynamic Linker","title":"Dynamic Linker","text":"","category":"section"},{"location":"stdlib/Libdl.html","page":"Dynamic Linker","title":"Dynamic Linker","text":"Libdl.dlopen\nLibdl.dlopen_e\nLibdl.RTLD_NOW\nLibdl.dlsym\nLibdl.dlsym_e\nLibdl.dlclose\nLibdl.dlext\nLibdl.dllist\nLibdl.dlpath\nLibdl.find_library\nLibdl.DL_LOAD_PATH","category":"page"},{"location":"stdlib/Libdl.html#Base.Libc.Libdl.dlopen","page":"Dynamic Linker","title":"Base.Libc.Libdl.dlopen","text":"dlopen(libfile::AbstractString [, flags::Integer]; throw_error:Bool = true)\n\nLoad a shared library, returning an opaque handle.\n\nThe extension given by the constant dlext (.so, .dll, or .dylib) can be omitted from the libfile string, as it is automatically appended if needed.   If libfile is not an absolute path name, then the paths in the array DL_LOAD_PATH are searched for libfile, followed by the system load path.\n\nThe optional flags argument is a bitwise-or of zero or more of RTLD_LOCAL, RTLD_GLOBAL, RTLD_LAZY, RTLD_NOW, RTLD_NODELETE, RTLD_NOLOAD, RTLD_DEEPBIND, and RTLD_FIRST. These are converted to the corresponding flags of the POSIX (and/or GNU libc and/or MacOS) dlopen command, if possible, or are ignored if the specified functionality is not available on the current platform. The default flags are platform specific. On MacOS the default dlopen flags are RTLD_LAZY|RTLD_DEEPBIND|RTLD_GLOBAL while on other platforms the defaults are RTLD_LAZY|RTLD_DEEPBIND|RTLD_LOCAL. An important usage of these flags is to specify non default behavior for when the dynamic library loader binds library references to exported symbols and if the bound references are put into process local or global scope. For instance RTLD_LAZY|RTLD_DEEPBIND|RTLD_GLOBAL allows the library's symbols to be available for usage in other shared libraries, addressing situations where there are dependencies between shared libraries.\n\nIf the library cannot be found, this method throws an error, unless the keyword argument throw_error is set to false, in which case this method returns nothing.\n\nnote: Note\nFrom Julia 1.6 on, this method replaces paths starting with @executable_path/ with  the path to the Julia executable, allowing for relocatable relative-path loads. In  Julia 1.5 and earlier, this only worked on macOS.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Libdl.html#Base.Libc.Libdl.dlopen_e","page":"Dynamic Linker","title":"Base.Libc.Libdl.dlopen_e","text":"dlopen_e(libfile::AbstractString [, flags::Integer])\n\nSimilar to dlopen, except returns C_NULL instead of raising errors. This method is now deprecated in favor of dlopen(libfile::AbstractString [, flags::Integer]; throw_error=false).\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Libdl.html#Base.Libc.Libdl.RTLD_NOW","page":"Dynamic Linker","title":"Base.Libc.Libdl.RTLD_NOW","text":"RTLD_DEEPBIND\nRTLD_FIRST\nRTLD_GLOBAL\nRTLD_LAZY\nRTLD_LOCAL\nRTLD_NODELETE\nRTLD_NOLOAD\nRTLD_NOW\n\nEnum constant for dlopen. See your platform man page for details, if applicable.\n\n\n\n\n\n","category":"constant"},{"location":"stdlib/Libdl.html#Base.Libc.Libdl.dlsym","page":"Dynamic Linker","title":"Base.Libc.Libdl.dlsym","text":"dlsym(handle, sym; throw_error::Bool = true)\n\nLook up a symbol from a shared library handle, return callable function pointer on success.\n\nIf the symbol cannot be found, this method throws an error, unless the keyword argument throw_error is set to false, in which case this method returns nothing.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Libdl.html#Base.Libc.Libdl.dlsym_e","page":"Dynamic Linker","title":"Base.Libc.Libdl.dlsym_e","text":"dlsym_e(handle, sym)\n\nLook up a symbol from a shared library handle, silently return C_NULL on lookup failure. This method is now deprecated in favor of dlsym(handle, sym; throw_error=false).\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Libdl.html#Base.Libc.Libdl.dlclose","page":"Dynamic Linker","title":"Base.Libc.Libdl.dlclose","text":"dlclose(handle)\n\nClose shared library referenced by handle.\n\n\n\n\n\ndlclose(::Nothing)\n\nFor the very common pattern usage pattern of\n\ntry\n    hdl = dlopen(library_name)\n    ... do something\nfinally\n    dlclose(hdl)\nend\n\nWe define a dlclose() method that accepts a parameter of type Nothing, so that user code does not have to change its behavior for the case that library_name was not found.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Libdl.html#Base.Libc.Libdl.dlext","page":"Dynamic Linker","title":"Base.Libc.Libdl.dlext","text":"dlext\n\nFile extension for dynamic libraries (e.g. dll, dylib, so) on the current platform.\n\n\n\n\n\n","category":"constant"},{"location":"stdlib/Libdl.html#Base.Libc.Libdl.dllist","page":"Dynamic Linker","title":"Base.Libc.Libdl.dllist","text":"dllist()\n\nReturn the paths of dynamic libraries currently loaded in a Vector{String}.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Libdl.html#Base.Libc.Libdl.dlpath","page":"Dynamic Linker","title":"Base.Libc.Libdl.dlpath","text":"dlpath(handle::Ptr{Cvoid})\n\nGiven a library handle from dlopen, return the full path.\n\n\n\n\n\ndlpath(libname::Union{AbstractString, Symbol})\n\nGet the full path of the library libname.\n\nExamples\n\njulia> dlpath(\"libjulia\")\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Libdl.html#Base.Libc.Libdl.find_library","page":"Dynamic Linker","title":"Base.Libc.Libdl.find_library","text":"find_library(names [, locations])\n\nSearches for the first library in names in the paths in the locations list, DL_LOAD_PATH, or system library paths (in that order) which can successfully be dlopen'd. On success, the return value will be one of the names (potentially prefixed by one of the paths in locations). This string can be assigned to a global const and used as the library name in future ccall's. On failure, it returns the empty string.\n\n\n\n\n\n","category":"function"},{"location":"stdlib/Libdl.html#Base.DL_LOAD_PATH","page":"Dynamic Linker","title":"Base.DL_LOAD_PATH","text":"DL_LOAD_PATH\n\nWhen calling dlopen, the paths in this list will be searched first, in order, before searching the system locations for a valid library handle.\n\n\n\n\n\n","category":"constant"},{"location":"base/arrays.html#lib-arrays","page":"Arrays","title":"Arrays","text":"","category":"section"},{"location":"base/arrays.html#Constructors-and-Types","page":"Arrays","title":"Constructors and Types","text":"","category":"section"},{"location":"base/arrays.html","page":"Arrays","title":"Arrays","text":"Core.AbstractArray\nBase.AbstractVector\nBase.AbstractMatrix\nBase.AbstractVecOrMat\nCore.Array\nCore.Array(::UndefInitializer, ::Any)\nCore.Array(::Nothing, ::Any)\nCore.Array(::Missing, ::Any)\nCore.UndefInitializer\nCore.undef\nBase.Vector\nBase.Vector(::UndefInitializer, ::Any)\nBase.Vector(::Nothing, ::Any)\nBase.Vector(::Missing, ::Any)\nBase.Matrix\nBase.Matrix(::UndefInitializer, ::Any, ::Any)\nBase.Matrix(::Nothing, ::Any, ::Any)\nBase.Matrix(::Missing, ::Any, ::Any)\nBase.VecOrMat\nCore.DenseArray\nBase.DenseVector\nBase.DenseMatrix\nBase.DenseVecOrMat\nBase.StridedArray\nBase.StridedVector\nBase.StridedMatrix\nBase.StridedVecOrMat\nBase.GenericMemory\nBase.Memory\nBase.memoryref\nBase.Slices\nBase.RowSlices\nBase.ColumnSlices\nBase.getindex(::Type, ::Any...)\nBase.zeros\nBase.ones\nBase.BitArray\nBase.BitArray(::UndefInitializer, ::Integer...)\nBase.BitArray(::Any)\nBase.trues\nBase.falses\nBase.fill\nBase.fill!\nBase.empty\nBase.similar","category":"page"},{"location":"base/arrays.html#Core.AbstractArray","page":"Arrays","title":"Core.AbstractArray","text":"AbstractArray{T,N}\n\nSupertype for N-dimensional arrays (or array-like types) with elements of type T. Array and other types are subtypes of this. See the manual section on the AbstractArray interface.\n\nSee also: AbstractVector, AbstractMatrix, eltype, ndims.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.AbstractVector","page":"Arrays","title":"Base.AbstractVector","text":"AbstractVector{T}\n\nSupertype for one-dimensional arrays (or array-like types) with elements of type T. Alias for AbstractArray{T,1}.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.AbstractMatrix","page":"Arrays","title":"Base.AbstractMatrix","text":"AbstractMatrix{T}\n\nSupertype for two-dimensional arrays (or array-like types) with elements of type T. Alias for AbstractArray{T,2}.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.AbstractVecOrMat","page":"Arrays","title":"Base.AbstractVecOrMat","text":"AbstractVecOrMat{T}\n\nUnion type of AbstractVector{T} and AbstractMatrix{T}.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Core.Array","page":"Arrays","title":"Core.Array","text":"Array{T,N} <: AbstractArray{T,N}\n\nN-dimensional dense array with elements of type T.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Core.Array-Tuple{UndefInitializer, Any}","page":"Arrays","title":"Core.Array","text":"Array{T}(undef, dims)\nArray{T,N}(undef, dims)\n\nConstruct an uninitialized N-dimensional Array containing elements of type T. N can either be supplied explicitly, as in Array{T,N}(undef, dims), or be determined by the length or number of dims. dims may be a tuple or a series of integer arguments corresponding to the lengths in each dimension. If the rank N is supplied explicitly, then it must match the length or number of dims. Here undef is the UndefInitializer.\n\nExamples\n\njulia> A = Array{Float64, 2}(undef, 2, 3) # N given explicitly\n2×3 Matrix{Float64}:\n 6.90198e-310  6.90198e-310  6.90198e-310\n 6.90198e-310  6.90198e-310  0.0\n\njulia> B = Array{Float64}(undef, 4) # N determined by the input\n4-element Vector{Float64}:\n   2.360075077e-314\n NaN\n   2.2671131793e-314\n   2.299821756e-314\n\njulia> similar(B, 2, 4, 1) # use typeof(B), and the given size\n2×4×1 Array{Float64, 3}:\n[:, :, 1] =\n 2.26703e-314  2.26708e-314  0.0           2.80997e-314\n 0.0           2.26703e-314  2.26708e-314  0.0\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Core.Array-Tuple{Nothing, Any}","page":"Arrays","title":"Core.Array","text":"Array{T}(nothing, dims)\nArray{T,N}(nothing, dims)\n\nConstruct an N-dimensional Array containing elements of type T, initialized with nothing entries. Element type T must be able to hold these values, i.e. Nothing <: T.\n\nExamples\n\njulia> Array{Union{Nothing, String}}(nothing, 2)\n2-element Vector{Union{Nothing, String}}:\n nothing\n nothing\n\njulia> Array{Union{Nothing, Int}}(nothing, 2, 3)\n2×3 Matrix{Union{Nothing, Int64}}:\n nothing  nothing  nothing\n nothing  nothing  nothing\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Core.Array-Tuple{Missing, Any}","page":"Arrays","title":"Core.Array","text":"Array{T}(missing, dims)\nArray{T,N}(missing, dims)\n\nConstruct an N-dimensional Array containing elements of type T, initialized with missing entries. Element type T must be able to hold these values, i.e. Missing <: T.\n\nExamples\n\njulia> Array{Union{Missing, String}}(missing, 2)\n2-element Vector{Union{Missing, String}}:\n missing\n missing\n\njulia> Array{Union{Missing, Int}}(missing, 2, 3)\n2×3 Matrix{Union{Missing, Int64}}:\n missing  missing  missing\n missing  missing  missing\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Core.UndefInitializer","page":"Arrays","title":"Core.UndefInitializer","text":"UndefInitializer\n\nSingleton type used in array initialization, indicating the array-constructor-caller would like an uninitialized array. See also undef, an alias for UndefInitializer().\n\nExamples\n\njulia> Array{Float64, 1}(UndefInitializer(), 3)\n3-element Array{Float64, 1}:\n 2.2752528595e-314\n 2.202942107e-314\n 2.275252907e-314\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Core.undef","page":"Arrays","title":"Core.undef","text":"undef\n\nAlias for UndefInitializer(), which constructs an instance of the singleton type UndefInitializer, used in array initialization to indicate the array-constructor-caller would like an uninitialized array.\n\nSee also: missing, similar.\n\nExamples\n\njulia> Array{Float64, 1}(undef, 3)\n3-element Vector{Float64}:\n 2.2752528595e-314\n 2.202942107e-314\n 2.275252907e-314\n\n\n\n\n\n","category":"constant"},{"location":"base/arrays.html#Base.Vector","page":"Arrays","title":"Base.Vector","text":"Vector{T} <: AbstractVector{T}\n\nOne-dimensional dense array with elements of type T, often used to represent a mathematical vector. Alias for Array{T,1}.\n\nSee also empty, similar and zero for creating vectors.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.Vector-Tuple{UndefInitializer, Any}","page":"Arrays","title":"Base.Vector","text":"Vector{T}(undef, n)\n\nConstruct an uninitialized Vector{T} of length n.\n\nExamples\n\njulia> Vector{Float64}(undef, 3)\n3-element Array{Float64, 1}:\n 6.90966e-310\n 6.90966e-310\n 6.90966e-310\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Base.Vector-Tuple{Nothing, Any}","page":"Arrays","title":"Base.Vector","text":"Vector{T}(nothing, m)\n\nConstruct a Vector{T} of length m, initialized with nothing entries. Element type T must be able to hold these values, i.e. Nothing <: T.\n\nExamples\n\njulia> Vector{Union{Nothing, String}}(nothing, 2)\n2-element Vector{Union{Nothing, String}}:\n nothing\n nothing\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Base.Vector-Tuple{Missing, Any}","page":"Arrays","title":"Base.Vector","text":"Vector{T}(missing, m)\n\nConstruct a Vector{T} of length m, initialized with missing entries. Element type T must be able to hold these values, i.e. Missing <: T.\n\nExamples\n\njulia> Vector{Union{Missing, String}}(missing, 2)\n2-element Vector{Union{Missing, String}}:\n missing\n missing\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Base.Matrix","page":"Arrays","title":"Base.Matrix","text":"Matrix{T} <: AbstractMatrix{T}\n\nTwo-dimensional dense array with elements of type T, often used to represent a mathematical matrix. Alias for Array{T,2}.\n\nSee also fill, zeros, undef and similar for creating matrices.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.Matrix-Tuple{UndefInitializer, Any, Any}","page":"Arrays","title":"Base.Matrix","text":"Matrix{T}(undef, m, n)\n\nConstruct an uninitialized Matrix{T} of size m×n.\n\nExamples\n\njulia> Matrix{Float64}(undef, 2, 3)\n2×3 Array{Float64, 2}:\n 2.36365e-314  2.28473e-314    5.0e-324\n 2.26704e-314  2.26711e-314  NaN\n\njulia> similar(ans, Int32, 2, 2)\n2×2 Matrix{Int32}:\n 490537216  1277177453\n         1  1936748399\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Base.Matrix-Tuple{Nothing, Any, Any}","page":"Arrays","title":"Base.Matrix","text":"Matrix{T}(nothing, m, n)\n\nConstruct a Matrix{T} of size m×n, initialized with nothing entries. Element type T must be able to hold these values, i.e. Nothing <: T.\n\nExamples\n\njulia> Matrix{Union{Nothing, String}}(nothing, 2, 3)\n2×3 Matrix{Union{Nothing, String}}:\n nothing  nothing  nothing\n nothing  nothing  nothing\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Base.Matrix-Tuple{Missing, Any, Any}","page":"Arrays","title":"Base.Matrix","text":"Matrix{T}(missing, m, n)\n\nConstruct a Matrix{T} of size m×n, initialized with missing entries. Element type T must be able to hold these values, i.e. Missing <: T.\n\nExamples\n\njulia> Matrix{Union{Missing, String}}(missing, 2, 3)\n2×3 Matrix{Union{Missing, String}}:\n missing  missing  missing\n missing  missing  missing\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Base.VecOrMat","page":"Arrays","title":"Base.VecOrMat","text":"VecOrMat{T}\n\nUnion type of Vector{T} and Matrix{T} which allows functions to accept either a Matrix or a Vector.\n\nExamples\n\njulia> Vector{Float64} <: VecOrMat{Float64}\ntrue\n\njulia> Matrix{Float64} <: VecOrMat{Float64}\ntrue\n\njulia> Array{Float64, 3} <: VecOrMat{Float64}\nfalse\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Core.DenseArray","page":"Arrays","title":"Core.DenseArray","text":"DenseArray{T, N} <: AbstractArray{T,N}\n\nN-dimensional dense array with elements of type T. The elements of a dense array are stored contiguously in memory.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.DenseVector","page":"Arrays","title":"Base.DenseVector","text":"DenseVector{T}\n\nOne-dimensional DenseArray with elements of type T. Alias for DenseArray{T,1}.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.DenseMatrix","page":"Arrays","title":"Base.DenseMatrix","text":"DenseMatrix{T}\n\nTwo-dimensional DenseArray with elements of type T. Alias for DenseArray{T,2}.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.DenseVecOrMat","page":"Arrays","title":"Base.DenseVecOrMat","text":"DenseVecOrMat{T}\n\nUnion type of DenseVector{T} and DenseMatrix{T}.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.StridedArray","page":"Arrays","title":"Base.StridedArray","text":"StridedArray{T, N}\n\nA hard-coded Union of common array types that follow the strided array interface, with elements of type T and N dimensions.\n\nIf A is a StridedArray, then its elements are stored in memory with offsets, which may vary between dimensions but are constant within a dimension. For example, A could have stride 2 in dimension 1, and stride 3 in dimension 2. Incrementing A along dimension d jumps in memory by [stride(A, d)] slots. Strided arrays are particularly important and useful because they can sometimes be passed directly as pointers to foreign language libraries like BLAS.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.StridedVector","page":"Arrays","title":"Base.StridedVector","text":"StridedVector{T}\n\nOne dimensional StridedArray with elements of type T.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.StridedMatrix","page":"Arrays","title":"Base.StridedMatrix","text":"StridedMatrix{T}\n\nTwo dimensional StridedArray with elements of type T.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.StridedVecOrMat","page":"Arrays","title":"Base.StridedVecOrMat","text":"StridedVecOrMat{T}\n\nUnion type of StridedVector and StridedMatrix with elements of type T.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Core.GenericMemory","page":"Arrays","title":"Core.GenericMemory","text":"GenericMemory{kind::Symbol, T, addrspace=Core.CPU} <: DenseVector{T}\n\nFixed-size DenseVector{T}.\n\nkind can currently be either :not_atomic or :atomic. For details on what :atomic implies, see AtomicMemory\n\naddrspace can currently only be set to Core.CPU. It is designed to  to permit extension by other systems such as GPUs, which might define values such as:\n\nmodule CUDA\nconst Generic = bitcast(Core.AddrSpace{CUDA}, 0)\nconst Global = bitcast(Core.AddrSpace{CUDA}, 1)\nend\n\nThe exact semantics of these other addrspaces is defined by the specific backend, but will error if the user is attempting to access these on the CPU.\n\ncompat: Julia 1.11\nThis type requires Julia 1.11 or later.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Core.Memory","page":"Arrays","title":"Core.Memory","text":"Memory{T} == GenericMemory{:not_atomic, T, Core.CPU}\n\nFixed-size DenseVector{T}.\n\ncompat: Julia 1.11\nThis type requires Julia 1.11 or later.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Core.memoryref","page":"Arrays","title":"Core.memoryref","text":"`memoryref(::GenericMemory)`\n\nConstruct a GenericMemoryRef from a memory object. This does not fail, but the resulting memory will point out-of-bounds if and only if the memory is empty.\n\n\n\n\n\nmemoryref(::GenericMemory, index::Integer)\nmemoryref(::GenericMemoryRef, index::Integer)\n\nConstruct a GenericMemoryRef from a memory object and an offset index (1-based) which can also be negative. This always returns an inbounds object, and will throw an error if that is not possible (because the index would result in a shift out-of-bounds of the underlying memory).\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.Slices","page":"Arrays","title":"Base.Slices","text":"Slices{P,SM,AX,S,N} <: AbstractSlices{S,N}\n\nAn AbstractArray of slices into a parent array over specified dimension(s), returning views that select all the data from the other dimension(s).\n\nThese should typically be constructed by eachslice, eachcol or eachrow.\n\nparent(s::Slices) will return the parent array.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.RowSlices","page":"Arrays","title":"Base.RowSlices","text":"RowSlices{M,AX,S}\n\nA special case of Slices that is a vector of row slices of a matrix, as constructed by eachrow.\n\nparent can be used to get the underlying matrix.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.ColumnSlices","page":"Arrays","title":"Base.ColumnSlices","text":"ColumnSlices{M,AX,S}\n\nA special case of Slices that is a vector of column slices of a matrix, as constructed by eachcol.\n\nparent can be used to get the underlying matrix.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.getindex-Tuple{Type, Vararg{Any}}","page":"Arrays","title":"Base.getindex","text":"getindex(type[, elements...])\n\nConstruct a 1-d array of the specified type. This is usually called with the syntax Type[]. Element values can be specified using Type[a,b,c,...].\n\nExamples\n\njulia> Int8[1, 2, 3]\n3-element Vector{Int8}:\n 1\n 2\n 3\n\njulia> getindex(Int8, 1, 2, 3)\n3-element Vector{Int8}:\n 1\n 2\n 3\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Base.zeros","page":"Arrays","title":"Base.zeros","text":"zeros([T=Float64,] dims::Tuple)\nzeros([T=Float64,] dims...)\n\nCreate an Array, with element type T, of all zeros with size specified by dims. See also fill, ones, zero.\n\nExamples\n\njulia> zeros(1)\n1-element Vector{Float64}:\n 0.0\n\njulia> zeros(Int8, 2, 3)\n2×3 Matrix{Int8}:\n 0  0  0\n 0  0  0\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.ones","page":"Arrays","title":"Base.ones","text":"ones([T=Float64,] dims::Tuple)\nones([T=Float64,] dims...)\n\nCreate an Array, with element type T, of all ones with size specified by dims. See also fill, zeros.\n\nExamples\n\njulia> ones(1,2)\n1×2 Matrix{Float64}:\n 1.0  1.0\n\njulia> ones(ComplexF64, 2, 3)\n2×3 Matrix{ComplexF64}:\n 1.0+0.0im  1.0+0.0im  1.0+0.0im\n 1.0+0.0im  1.0+0.0im  1.0+0.0im\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.BitArray","page":"Arrays","title":"Base.BitArray","text":"BitArray{N} <: AbstractArray{Bool, N}\n\nSpace-efficient N-dimensional boolean array, using just one bit for each boolean value.\n\nBitArrays pack up to 64 values into every 8 bytes, resulting in an 8x space efficiency over Array{Bool, N} and allowing some operations to work on 64 values at once.\n\nBy default, Julia returns BitArrays from broadcasting operations that generate boolean elements (including dotted-comparisons like .==) as well as from the functions trues and falses.\n\nnote: Note\nDue to its packed storage format, concurrent access to the elements of a BitArray where at least one of them is a write is not thread-safe.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.BitArray-Tuple{UndefInitializer, Vararg{Integer}}","page":"Arrays","title":"Base.BitArray","text":"BitArray(undef, dims::Integer...)\nBitArray{N}(undef, dims::NTuple{N,Int})\n\nConstruct an undef BitArray with the given dimensions. Behaves identically to the Array constructor. See undef.\n\nExamples\n\njulia> BitArray(undef, 2, 2)\n2×2 BitMatrix:\n 0  0\n 0  0\n\njulia> BitArray(undef, (3, 1))\n3×1 BitMatrix:\n 0\n 0\n 0\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Base.BitArray-Tuple{Any}","page":"Arrays","title":"Base.BitArray","text":"BitArray(itr)\n\nConstruct a BitArray generated by the given iterable object. The shape is inferred from the itr object.\n\nExamples\n\njulia> BitArray([1 0; 0 1])\n2×2 BitMatrix:\n 1  0\n 0  1\n\njulia> BitArray(x+y == 3 for x = 1:2, y = 1:3)\n2×3 BitMatrix:\n 0  1  0\n 1  0  0\n\njulia> BitArray(x+y == 3 for x = 1:2 for y = 1:3)\n6-element BitVector:\n 0\n 1\n 0\n 1\n 0\n 0\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Base.trues","page":"Arrays","title":"Base.trues","text":"trues(dims)\n\nCreate a BitArray with all values set to true.\n\nExamples\n\njulia> trues(2,3)\n2×3 BitMatrix:\n 1  1  1\n 1  1  1\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.falses","page":"Arrays","title":"Base.falses","text":"falses(dims)\n\nCreate a BitArray with all values set to false.\n\nExamples\n\njulia> falses(2,3)\n2×3 BitMatrix:\n 0  0  0\n 0  0  0\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.fill","page":"Arrays","title":"Base.fill","text":"fill(value, dims::Tuple)\nfill(value, dims...)\n\nCreate an array of size dims with every location set to value.\n\nFor example, fill(1.0, (5,5)) returns a 5×5 array of floats, with 1.0 in every location of the array.\n\nThe dimension lengths dims may be specified as either a tuple or a sequence of arguments. An N-length tuple or N arguments following the value specify an N-dimensional array. Thus, a common idiom for creating a zero-dimensional array with its only location set to x is fill(x).\n\nEvery location of the returned array is set to (and is thus === to) the value that was passed; this means that if the value is itself modified, all elements of the filled array will reflect that modification because they're still that very value. This is of no concern with fill(1.0, (5,5)) as the value 1.0 is immutable and cannot itself be modified, but can be unexpected with mutable values like — most commonly — arrays.  For example, fill([], 3) places the very same empty array in all three locations of the returned vector:\n\njulia> v = fill([], 3)\n3-element Vector{Vector{Any}}:\n []\n []\n []\n\njulia> v[1] === v[2] === v[3]\ntrue\n\njulia> value = v[1]\nAny[]\n\njulia> push!(value, 867_5309)\n1-element Vector{Any}:\n 8675309\n\njulia> v\n3-element Vector{Vector{Any}}:\n [8675309]\n [8675309]\n [8675309]\n\nTo create an array of many independent inner arrays, use a comprehension instead. This creates a new and distinct array on each iteration of the loop:\n\njulia> v2 = [[] for _ in 1:3]\n3-element Vector{Vector{Any}}:\n []\n []\n []\n\njulia> v2[1] === v2[2] === v2[3]\nfalse\n\njulia> push!(v2[1], 8675309)\n1-element Vector{Any}:\n 8675309\n\njulia> v2\n3-element Vector{Vector{Any}}:\n [8675309]\n []\n []\n\nSee also: fill!, zeros, ones, similar.\n\nExamples\n\njulia> fill(1.0, (2,3))\n2×3 Matrix{Float64}:\n 1.0  1.0  1.0\n 1.0  1.0  1.0\n\njulia> fill(42)\n0-dimensional Array{Int64, 0}:\n42\n\njulia> A = fill(zeros(2), 2) # sets both elements to the same [0.0, 0.0] vector\n2-element Vector{Vector{Float64}}:\n [0.0, 0.0]\n [0.0, 0.0]\n\njulia> A[1][1] = 42; # modifies the filled value to be [42.0, 0.0]\n\njulia> A # both A[1] and A[2] are the very same vector\n2-element Vector{Vector{Float64}}:\n [42.0, 0.0]\n [42.0, 0.0]\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.fill!","page":"Arrays","title":"Base.fill!","text":"fill!(A, x)\n\nFill array A with the value x. If x is an object reference, all elements will refer to the same object. fill!(A, Foo()) will return A filled with the result of evaluating Foo() once.\n\nExamples\n\njulia> A = zeros(2,3)\n2×3 Matrix{Float64}:\n 0.0  0.0  0.0\n 0.0  0.0  0.0\n\njulia> fill!(A, 2.)\n2×3 Matrix{Float64}:\n 2.0  2.0  2.0\n 2.0  2.0  2.0\n\njulia> a = [1, 1, 1]; A = fill!(Vector{Vector{Int}}(undef, 3), a); a[1] = 2; A\n3-element Vector{Vector{Int64}}:\n [2, 1, 1]\n [2, 1, 1]\n [2, 1, 1]\n\njulia> x = 0; f() = (global x += 1; x); fill!(Vector{Int}(undef, 3), f())\n3-element Vector{Int64}:\n 1\n 1\n 1\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.empty","page":"Arrays","title":"Base.empty","text":"empty(x::Tuple)\n\nReturn an empty tuple, ().\n\n\n\n\n\nempty(v::AbstractVector, [eltype])\n\nCreate an empty vector similar to v, optionally changing the eltype.\n\nSee also: empty!, isempty, isassigned.\n\nExamples\n\njulia> empty([1.0, 2.0, 3.0])\nFloat64[]\n\njulia> empty([1.0, 2.0, 3.0], String)\nString[]\n\n\n\n\n\nempty(a::AbstractDict, [index_type=keytype(a)], [value_type=valtype(a)])\n\nCreate an empty AbstractDict container which can accept indices of type index_type and values of type value_type. The second and third arguments are optional and default to the input's keytype and valtype, respectively. (If only one of the two types is specified, it is assumed to be the value_type, and the index_type we default to keytype(a)).\n\nCustom AbstractDict subtypes may choose which specific dictionary type is best suited to return for the given index and value types, by specializing on the three-argument signature. The default is to return an empty Dict.\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.similar","page":"Arrays","title":"Base.similar","text":"similar(A::AbstractSparseMatrixCSC{Tv,Ti}, [::Type{TvNew}, ::Type{TiNew}, m::Integer, n::Integer]) where {Tv,Ti}\n\nCreate an uninitialized mutable array with the given element type, index type, and size, based upon the given source SparseMatrixCSC. The new sparse matrix maintains the structure of the original sparse matrix, except in the case where dimensions of the output matrix are different from the output.\n\nThe output matrix has zeros in the same locations as the input, but uninitialized values for the nonzero locations.\n\n\n\n\n\nsimilar(array, [element_type=eltype(array)], [dims=size(array)])\n\nCreate an uninitialized mutable array with the given element type and size, based upon the given source array. The second and third arguments are both optional, defaulting to the given array's eltype and size. The dimensions may be specified either as a single tuple argument or as a series of integer arguments.\n\nCustom AbstractArray subtypes may choose which specific array type is best-suited to return for the given element type and dimensionality. If they do not specialize this method, the default is an Array{element_type}(undef, dims...).\n\nFor example, similar(1:10, 1, 4) returns an uninitialized Array{Int,2} since ranges are neither mutable nor support 2 dimensions:\n\njulia> similar(1:10, 1, 4)\n1×4 Matrix{Int64}:\n 4419743872  4374413872  4419743888  0\n\nConversely, similar(trues(10,10), 2) returns an uninitialized BitVector with two elements since BitArrays are both mutable and can support 1-dimensional arrays:\n\njulia> similar(trues(10,10), 2)\n2-element BitVector:\n 0\n 0\n\nSince BitArrays can only store elements of type Bool, however, if you request a different element type it will create a regular Array instead:\n\njulia> similar(falses(10), Float64, 2, 4)\n2×4 Matrix{Float64}:\n 2.18425e-314  2.18425e-314  2.18425e-314  2.18425e-314\n 2.18425e-314  2.18425e-314  2.18425e-314  2.18425e-314\n\nSee also: undef, isassigned.\n\n\n\n\n\nsimilar(storagetype, axes)\n\nCreate an uninitialized mutable array analogous to that specified by storagetype, but with axes specified by the last argument.\n\nExamples:\n\nsimilar(Array{Int}, axes(A))\n\ncreates an array that \"acts like\" an Array{Int} (and might indeed be backed by one), but which is indexed identically to A. If A has conventional indexing, this will be identical to Array{Int}(undef, size(A)), but if A has unconventional indexing then the indices of the result will match A.\n\nsimilar(BitArray, (axes(A, 2),))\n\nwould create a 1-dimensional logical array whose indices match those of the columns of A.\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Basic-functions","page":"Arrays","title":"Basic functions","text":"","category":"section"},{"location":"base/arrays.html","page":"Arrays","title":"Arrays","text":"Base.ndims\nBase.size\nBase.axes(::Any)\nBase.axes(::AbstractArray, ::Any)\nBase.length(::AbstractArray)\nBase.keys(::AbstractArray)\nBase.eachindex\nBase.IndexStyle\nBase.IndexLinear\nBase.IndexCartesian\nBase.conj!\nBase.stride\nBase.strides","category":"page"},{"location":"base/arrays.html#Base.ndims","page":"Arrays","title":"Base.ndims","text":"ndims(A::AbstractArray) -> Integer\n\nReturn the number of dimensions of A.\n\nSee also: size, axes.\n\nExamples\n\njulia> A = fill(1, (3,4,5));\n\njulia> ndims(A)\n3\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.size","page":"Arrays","title":"Base.size","text":"size(A::AbstractArray, [dim])\n\nReturn a tuple containing the dimensions of A. Optionally you can specify a dimension to just get the length of that dimension.\n\nNote that size may not be defined for arrays with non-standard indices, in which case axes may be useful. See the manual chapter on arrays with custom indices.\n\nSee also: length, ndims, eachindex, sizeof.\n\nExamples\n\njulia> A = fill(1, (2,3,4));\n\njulia> size(A)\n(2, 3, 4)\n\njulia> size(A, 2)\n3\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.axes-Tuple{Any}","page":"Arrays","title":"Base.axes","text":"axes(A)\n\nReturn the tuple of valid indices for array A.\n\nSee also: size, keys, eachindex.\n\nExamples\n\njulia> A = fill(1, (5,6,7));\n\njulia> axes(A)\n(Base.OneTo(5), Base.OneTo(6), Base.OneTo(7))\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Base.axes-Tuple{AbstractArray, Any}","page":"Arrays","title":"Base.axes","text":"axes(A, d)\n\nReturn the valid range of indices for array A along dimension d.\n\nSee also size, and the manual chapter on arrays with custom indices.\n\nExamples\n\njulia> A = fill(1, (5,6,7));\n\njulia> axes(A, 2)\nBase.OneTo(6)\n\njulia> axes(A, 4) == 1:1  # all dimensions d > ndims(A) have size 1\ntrue\n\nUsage note\n\nEach of the indices has to be an AbstractUnitRange{<:Integer}, but at the same time can be a type that uses custom indices. So, for example, if you need a subset, use generalized indexing constructs like begin/end or firstindex/lastindex:\n\nix = axes(v, 1)\nix[2:end]          # will work for eg Vector, but may fail in general\nix[(begin+1):end]  # works for generalized indexes\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Base.length-Tuple{AbstractArray}","page":"Arrays","title":"Base.length","text":"length(A::AbstractArray)\n\nReturn the number of elements in the array, defaults to prod(size(A)).\n\nExamples\n\njulia> length([1, 2, 3, 4])\n4\n\njulia> length([1 2; 3 4])\n4\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Base.keys-Tuple{AbstractArray}","page":"Arrays","title":"Base.keys","text":"keys(a::AbstractArray)\n\nReturn an efficient array describing all valid indices for a arranged in the shape of a itself.\n\nThe keys of 1-dimensional arrays (vectors) are integers, whereas all other N-dimensional arrays use CartesianIndex to describe their locations.  Often the special array types LinearIndices and CartesianIndices are used to efficiently represent these arrays of integers and CartesianIndexes, respectively.\n\nNote that the keys of an array might not be the most efficient index type; for maximum performance use  eachindex instead.\n\nExamples\n\njulia> keys([4, 5, 6])\n3-element LinearIndices{1, Tuple{Base.OneTo{Int64}}}:\n 1\n 2\n 3\n\njulia> keys([4 5; 6 7])\nCartesianIndices((2, 2))\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Base.eachindex","page":"Arrays","title":"Base.eachindex","text":"eachindex(A...)\neachindex(::IndexStyle, A::AbstractArray...)\n\nCreate an iterable object for visiting each index of an AbstractArray A in an efficient manner. For array types that have opted into fast linear indexing (like Array), this is simply the range 1:length(A) if they use 1-based indexing. For array types that have not opted into fast linear indexing, a specialized Cartesian range is typically returned to efficiently index into the array with indices specified for every dimension.\n\nIn general eachindex accepts arbitrary iterables, including strings and dictionaries, and returns an iterator object supporting arbitrary index types (e.g. unevenly spaced or non-integer indices).\n\nIf A is AbstractArray it is possible to explicitly specify the style of the indices that should be returned by eachindex by passing a value having IndexStyle type as its first argument (typically IndexLinear() if linear indices are required or IndexCartesian() if Cartesian range is wanted).\n\nIf you supply more than one AbstractArray argument, eachindex will create an iterable object that is fast for all arguments (typically a UnitRange if all inputs have fast linear indexing, a CartesianIndices otherwise). If the arrays have different sizes and/or dimensionalities, a DimensionMismatch exception will be thrown.\n\nSee also pairs(A) to iterate over indices and values together, and axes(A, 2) for valid indices along one dimension.\n\nExamples\n\njulia> A = [10 20; 30 40];\n\njulia> for i in eachindex(A) # linear indexing\n           println(\"A[\", i, \"] == \", A[i])\n       end\nA[1] == 10\nA[2] == 30\nA[3] == 20\nA[4] == 40\n\njulia> for i in eachindex(view(A, 1:2, 1:1)) # Cartesian indexing\n           println(i)\n       end\nCartesianIndex(1, 1)\nCartesianIndex(2, 1)\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.IndexStyle","page":"Arrays","title":"Base.IndexStyle","text":"IndexStyle(A)\nIndexStyle(typeof(A))\n\nIndexStyle specifies the \"native indexing style\" for array A. When you define a new AbstractArray type, you can choose to implement either linear indexing (with IndexLinear) or cartesian indexing. If you decide to only implement linear indexing, then you must set this trait for your array type:\n\nBase.IndexStyle(::Type{<:MyArray}) = IndexLinear()\n\nThe default is IndexCartesian().\n\nJulia's internal indexing machinery will automatically (and invisibly) recompute all indexing operations into the preferred style. This allows users to access elements of your array using any indexing style, even when explicit methods have not been provided.\n\nIf you define both styles of indexing for your AbstractArray, this trait can be used to select the most performant indexing style. Some methods check this trait on their inputs, and dispatch to different algorithms depending on the most efficient access pattern. In particular, eachindex creates an iterator whose type depends on the setting of this trait.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.IndexLinear","page":"Arrays","title":"Base.IndexLinear","text":"IndexLinear()\n\nSubtype of IndexStyle used to describe arrays which are optimally indexed by one linear index.\n\nA linear indexing style uses one integer index to describe the position in the array (even if it's a multidimensional array) and column-major ordering is used to efficiently access the elements. This means that requesting eachindex from an array that is IndexLinear will return a simple one-dimensional range, even if it is multidimensional.\n\nA custom array that reports its IndexStyle as IndexLinear only needs to implement indexing (and indexed assignment) with a single Int index; all other indexing expressions — including multidimensional accesses — will be recomputed to the linear index.  For example, if A were a 2×3 custom matrix with linear indexing, and we referenced A[1, 3], this would be recomputed to the equivalent linear index and call A[5] since 1 + 2*(3 - 1) = 5.\n\nSee also IndexCartesian.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.IndexCartesian","page":"Arrays","title":"Base.IndexCartesian","text":"IndexCartesian()\n\nSubtype of IndexStyle used to describe arrays which are optimally indexed by a Cartesian index. This is the default for new custom AbstractArray subtypes.\n\nA Cartesian indexing style uses multiple integer indices to describe the position in a multidimensional array, with exactly one index per dimension. This means that requesting eachindex from an array that is IndexCartesian will return a range of CartesianIndices.\n\nA N-dimensional custom array that reports its IndexStyle as IndexCartesian needs to implement indexing (and indexed assignment) with exactly N Int indices; all other indexing expressions — including linear indexing — will be recomputed to the equivalent Cartesian location.  For example, if A were a 2×3 custom matrix with cartesian indexing, and we referenced A[5], this would be recomputed to the equivalent Cartesian index and call A[1, 3] since 5 = 1 + 2*(3 - 1).\n\nIt is significantly more expensive to compute Cartesian indices from a linear index than it is to go the other way.  The former operation requires division — a very costly operation — whereas the latter only uses multiplication and addition and is essentially free. This asymmetry means it is far more costly to use linear indexing with an IndexCartesian array than it is to use Cartesian indexing with an IndexLinear array.\n\nSee also IndexLinear.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.conj!","page":"Arrays","title":"Base.conj!","text":"conj!(A)\n\nTransform an array to its complex conjugate in-place.\n\nSee also conj.\n\nExamples\n\njulia> A = [1+im 2-im; 2+2im 3+im]\n2×2 Matrix{Complex{Int64}}:\n 1+1im  2-1im\n 2+2im  3+1im\n\njulia> conj!(A);\n\njulia> A\n2×2 Matrix{Complex{Int64}}:\n 1-1im  2+1im\n 2-2im  3-1im\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.stride","page":"Arrays","title":"Base.stride","text":"stride(A, k::Integer)\n\nReturn the distance in memory (in number of elements) between adjacent elements in dimension k.\n\nSee also: strides.\n\nExamples\n\njulia> A = fill(1, (3,4,5));\n\njulia> stride(A,2)\n3\n\njulia> stride(A,3)\n12\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.strides","page":"Arrays","title":"Base.strides","text":"strides(A)\n\nReturn a tuple of the memory strides in each dimension.\n\nSee also: stride.\n\nExamples\n\njulia> A = fill(1, (3,4,5));\n\njulia> strides(A)\n(1, 3, 12)\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Broadcast-and-vectorization","page":"Arrays","title":"Broadcast and vectorization","text":"","category":"section"},{"location":"base/arrays.html","page":"Arrays","title":"Arrays","text":"See also the dot syntax for vectorizing functions; for example, f.(args...) implicitly calls broadcast(f, args...). Rather than relying on \"vectorized\" methods of functions like sin to operate on arrays, you should use sin.(a) to vectorize via broadcast.","category":"page"},{"location":"base/arrays.html","page":"Arrays","title":"Arrays","text":"Base.broadcast\nBase.Broadcast.broadcast!\nBase.@__dot__","category":"page"},{"location":"base/arrays.html#Base.Broadcast.broadcast","page":"Arrays","title":"Base.Broadcast.broadcast","text":"broadcast(f, As...)\n\nBroadcast the function f over the arrays, tuples, collections, Refs and/or scalars As.\n\nBroadcasting applies the function f over the elements of the container arguments and the scalars themselves in As. Singleton and missing dimensions are expanded to match the extents of the other arguments by virtually repeating the value. By default, only a limited number of types are considered scalars, including Numbers, Strings, Symbols, Types, Functions and some common singletons like missing and nothing. All other arguments are iterated over or indexed into elementwise.\n\nThe resulting container type is established by the following rules:\n\nIf all the arguments are scalars or zero-dimensional arrays, it returns an unwrapped scalar.\nIf at least one argument is a tuple and all others are scalars or zero-dimensional arrays, it returns a tuple.\nAll other combinations of arguments default to returning an Array, but custom container types can define their own implementation and promotion-like rules to customize the result when they appear as arguments.\n\nA special syntax exists for broadcasting: f.(args...) is equivalent to broadcast(f, args...), and nested f.(g.(args...)) calls are fused into a single broadcast loop.\n\nExamples\n\njulia> A = [1, 2, 3, 4, 5]\n5-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n\njulia> B = [1 2; 3 4; 5 6; 7 8; 9 10]\n5×2 Matrix{Int64}:\n 1   2\n 3   4\n 5   6\n 7   8\n 9  10\n\njulia> broadcast(+, A, B)\n5×2 Matrix{Int64}:\n  2   3\n  5   6\n  8   9\n 11  12\n 14  15\n\njulia> parse.(Int, [\"1\", \"2\"])\n2-element Vector{Int64}:\n 1\n 2\n\njulia> abs.((1, -2))\n(1, 2)\n\njulia> broadcast(+, 1.0, (0, -2.0))\n(1.0, -1.0)\n\njulia> (+).([[0,2], [1,3]], Ref{Vector{Int}}([1,-1]))\n2-element Vector{Vector{Int64}}:\n [1, 1]\n [2, 2]\n\njulia> string.((\"one\",\"two\",\"three\",\"four\"), \": \", 1:4)\n4-element Vector{String}:\n \"one: 1\"\n \"two: 2\"\n \"three: 3\"\n \"four: 4\"\n\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.Broadcast.broadcast!","page":"Arrays","title":"Base.Broadcast.broadcast!","text":"broadcast!(f, dest, As...)\n\nLike broadcast, but store the result of broadcast(f, As...) in the dest array. Note that dest is only used to store the result, and does not supply arguments to f unless it is also listed in the As, as in broadcast!(f, A, A, B) to perform A[:] = broadcast(f, A, B).\n\nExamples\n\njulia> A = [1.0; 0.0]; B = [0.0; 0.0];\n\njulia> broadcast!(+, B, A, (0, -2.0));\n\njulia> B\n2-element Vector{Float64}:\n  1.0\n -2.0\n\njulia> A\n2-element Vector{Float64}:\n 1.0\n 0.0\n\njulia> broadcast!(+, A, A, (0, -2.0));\n\njulia> A\n2-element Vector{Float64}:\n  1.0\n -2.0\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.Broadcast.@__dot__","page":"Arrays","title":"Base.Broadcast.@__dot__","text":"@. expr\n\nConvert every function call or operator in expr into a \"dot call\" (e.g. convert f(x) to f.(x)), and convert every assignment in expr to a \"dot assignment\" (e.g. convert += to .+=).\n\nIf you want to avoid adding dots for selected function calls in expr, splice those function calls in with $.  For example, @. sqrt(abs($sort(x))) is equivalent to sqrt.(abs.(sort(x))) (no dot for sort).\n\n(@. is equivalent to a call to @__dot__.)\n\nExamples\n\njulia> x = 1.0:3.0; y = similar(x);\n\njulia> @. y = x + 3 * sin(x)\n3-element Vector{Float64}:\n 3.5244129544236893\n 4.727892280477045\n 3.4233600241796016\n\n\n\n\n\n","category":"macro"},{"location":"base/arrays.html","page":"Arrays","title":"Arrays","text":"For specializing broadcast on custom types, see","category":"page"},{"location":"base/arrays.html","page":"Arrays","title":"Arrays","text":"Base.BroadcastStyle\nBase.Broadcast.AbstractArrayStyle\nBase.Broadcast.ArrayStyle\nBase.Broadcast.DefaultArrayStyle\nBase.Broadcast.broadcastable\nBase.Broadcast.combine_axes\nBase.Broadcast.combine_styles\nBase.Broadcast.result_style","category":"page"},{"location":"base/arrays.html#Base.Broadcast.BroadcastStyle","page":"Arrays","title":"Base.Broadcast.BroadcastStyle","text":"BroadcastStyle is an abstract type and trait-function used to determine behavior of objects under broadcasting. BroadcastStyle(typeof(x)) returns the style associated with x. To customize the broadcasting behavior of a type, one can declare a style by defining a type/method pair\n\nstruct MyContainerStyle <: BroadcastStyle end\nBase.BroadcastStyle(::Type{<:MyContainer}) = MyContainerStyle()\n\nOne then writes method(s) (at least similar) operating on Broadcasted{MyContainerStyle}. There are also several pre-defined subtypes of BroadcastStyle that you may be able to leverage; see the Interfaces chapter for more information.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.Broadcast.AbstractArrayStyle","page":"Arrays","title":"Base.Broadcast.AbstractArrayStyle","text":"Broadcast.AbstractArrayStyle{N} <: BroadcastStyle is the abstract supertype for any style associated with an AbstractArray type. The N parameter is the dimensionality, which can be handy for AbstractArray types that only support specific dimensionalities:\n\nstruct SparseMatrixStyle <: Broadcast.AbstractArrayStyle{2} end\nBase.BroadcastStyle(::Type{<:SparseMatrixCSC}) = SparseMatrixStyle()\n\nFor AbstractArray types that support arbitrary dimensionality, N can be set to Any:\n\nstruct MyArrayStyle <: Broadcast.AbstractArrayStyle{Any} end\nBase.BroadcastStyle(::Type{<:MyArray}) = MyArrayStyle()\n\nIn cases where you want to be able to mix multiple AbstractArrayStyles and keep track of dimensionality, your style needs to support a Val constructor:\n\nstruct MyArrayStyleDim{N} <: Broadcast.AbstractArrayStyle{N} end\n(::Type{<:MyArrayStyleDim})(::Val{N}) where N = MyArrayStyleDim{N}()\n\nNote that if two or more AbstractArrayStyle subtypes conflict, broadcasting machinery will fall back to producing Arrays. If this is undesirable, you may need to define binary BroadcastStyle rules to control the output type.\n\nSee also Broadcast.DefaultArrayStyle.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.Broadcast.ArrayStyle","page":"Arrays","title":"Base.Broadcast.ArrayStyle","text":"Broadcast.ArrayStyle{MyArrayType}() is a BroadcastStyle indicating that an object behaves as an array for broadcasting. It presents a simple way to construct Broadcast.AbstractArrayStyles for specific AbstractArray container types. Broadcast styles created this way lose track of dimensionality; if keeping track is important for your type, you should create your own custom Broadcast.AbstractArrayStyle.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.Broadcast.DefaultArrayStyle","page":"Arrays","title":"Base.Broadcast.DefaultArrayStyle","text":"Broadcast.DefaultArrayStyle{N}() is a BroadcastStyle indicating that an object behaves as an N-dimensional array for broadcasting. Specifically, DefaultArrayStyle is used for any AbstractArray type that hasn't defined a specialized style, and in the absence of overrides from other broadcast arguments the resulting output type is Array. When there are multiple inputs to broadcast, DefaultArrayStyle \"loses\" to any other Broadcast.ArrayStyle.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.Broadcast.broadcastable","page":"Arrays","title":"Base.Broadcast.broadcastable","text":"Broadcast.broadcastable(x)\n\nReturn either x or an object like x such that it supports axes, indexing, and its type supports ndims.\n\nIf x supports iteration, the returned value should have the same axes and indexing behaviors as collect(x).\n\nIf x is not an AbstractArray but it supports axes, indexing, and its type supports ndims, then broadcastable(::typeof(x)) may be implemented to just return itself. Further, if x defines its own BroadcastStyle, then it must define its broadcastable method to return itself for the custom style to have any effect.\n\nExamples\n\njulia> Broadcast.broadcastable([1,2,3]) # like `identity` since arrays already support axes and indexing\n3-element Vector{Int64}:\n 1\n 2\n 3\n\njulia> Broadcast.broadcastable(Int) # Types don't support axes, indexing, or iteration but are commonly used as scalars\nBase.RefValue{Type{Int64}}(Int64)\n\njulia> Broadcast.broadcastable(\"hello\") # Strings break convention of matching iteration and act like a scalar instead\nBase.RefValue{String}(\"hello\")\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.Broadcast.combine_axes","page":"Arrays","title":"Base.Broadcast.combine_axes","text":"combine_axes(As...) -> Tuple\n\nDetermine the result axes for broadcasting across all values in As.\n\njulia> Broadcast.combine_axes([1], [1 2; 3 4; 5 6])\n(Base.OneTo(3), Base.OneTo(2))\n\njulia> Broadcast.combine_axes(1, 1, 1)\n()\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.Broadcast.combine_styles","page":"Arrays","title":"Base.Broadcast.combine_styles","text":"combine_styles(cs...) -> BroadcastStyle\n\nDecides which BroadcastStyle to use for any number of value arguments. Uses BroadcastStyle to get the style for each argument, and uses result_style to combine styles.\n\nExamples\n\njulia> Broadcast.combine_styles([1], [1 2; 3 4])\nBase.Broadcast.DefaultArrayStyle{2}()\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.Broadcast.result_style","page":"Arrays","title":"Base.Broadcast.result_style","text":"result_style(s1::BroadcastStyle[, s2::BroadcastStyle]) -> BroadcastStyle\n\nTakes one or two BroadcastStyles and combines them using BroadcastStyle to determine a common BroadcastStyle.\n\nExamples\n\njulia> Broadcast.result_style(Broadcast.DefaultArrayStyle{0}(), Broadcast.DefaultArrayStyle{3}())\nBase.Broadcast.DefaultArrayStyle{3}()\n\njulia> Broadcast.result_style(Broadcast.Unknown(), Broadcast.DefaultArrayStyle{1}())\nBase.Broadcast.DefaultArrayStyle{1}()\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Indexing-and-assignment","page":"Arrays","title":"Indexing and assignment","text":"","category":"section"},{"location":"base/arrays.html","page":"Arrays","title":"Arrays","text":"Base.getindex(::AbstractArray, ::Any...)\nBase.setindex!(::AbstractArray, ::Any, ::Any...)\nBase.nextind\nBase.prevind\nBase.copyto!(::AbstractArray, ::CartesianIndices, ::AbstractArray, ::CartesianIndices)\nBase.copy!\nBase.isassigned\nBase.Colon\nBase.CartesianIndex\nBase.CartesianIndices\nBase.Dims\nBase.LinearIndices\nBase.to_indices\nBase.checkbounds\nBase.checkindex\nBase.elsize","category":"page"},{"location":"base/arrays.html#Base.getindex-Tuple{AbstractArray, Vararg{Any}}","page":"Arrays","title":"Base.getindex","text":"getindex(A, inds...)\n\nReturn a subset of array A as selected by the indices inds.\n\nEach index may be any supported index type, such as an Integer, CartesianIndex, range, or array of supported indices. A : may be used to select all elements along a specific dimension, and a boolean array (e.g. an Array{Bool} or a BitArray) may be used to filter for elements where the corresponding index is true.\n\nWhen inds selects multiple elements, this function returns a newly allocated array. To index multiple elements without making a copy, use view instead.\n\nSee the manual section on array indexing for details.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> getindex(A, 1)\n1\n\njulia> getindex(A, [2, 1])\n2-element Vector{Int64}:\n 3\n 1\n\njulia> getindex(A, 2:4)\n3-element Vector{Int64}:\n 3\n 2\n 4\n\njulia> getindex(A, 2, 1)\n3\n\njulia> getindex(A, CartesianIndex(2, 1))\n3\n\njulia> getindex(A, :, 2)\n2-element Vector{Int64}:\n 2\n 4\n\njulia> getindex(A, 2, :)\n2-element Vector{Int64}:\n 3\n 4\n\njulia> getindex(A, A .> 2)\n2-element Vector{Int64}:\n 3\n 4\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Base.setindex!-Tuple{AbstractArray, Any, Vararg{Any}}","page":"Arrays","title":"Base.setindex!","text":"setindex!(A, X, inds...)\nA[inds...] = X\n\nStore values from array X within some subset of A as specified by inds. The syntax A[inds...] = X is equivalent to (setindex!(A, X, inds...); X).\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nExamples\n\njulia> A = zeros(2,2);\n\njulia> setindex!(A, [10, 20], [1, 2]);\n\njulia> A[[3, 4]] = [30, 40];\n\njulia> A\n2×2 Matrix{Float64}:\n 10.0  30.0\n 20.0  40.0\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Base.nextind","page":"Arrays","title":"Base.nextind","text":"nextind(A, i)\n\nReturn the index after i in A. The returned index is often equivalent to i + 1 for an integer i. This function can be useful for generic code.\n\nwarning: Warning\nThe returned index might be out of bounds. Consider using checkbounds.\n\nSee also: prevind.\n\nExamples\n\njulia> x = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> nextind(x, 1) # valid result\n2\n\njulia> nextind(x, 4) # invalid result\n5\n\njulia> nextind(x, CartesianIndex(1, 1)) # valid result\nCartesianIndex(2, 1)\n\njulia> nextind(x, CartesianIndex(2, 2)) # invalid result\nCartesianIndex(1, 3)\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.prevind","page":"Arrays","title":"Base.prevind","text":"prevind(A, i)\n\nReturn the index before i in A. The returned index is often equivalent to i - 1 for an integer i. This function can be useful for generic code.\n\nwarning: Warning\nThe returned index might be out of bounds. Consider using checkbounds.\n\nSee also: nextind.\n\nExamples\n\njulia> x = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> prevind(x, 4) # valid result\n3\n\njulia> prevind(x, 1) # invalid result\n0\n\njulia> prevind(x, CartesianIndex(2, 2)) # valid result\nCartesianIndex(1, 2)\n\njulia> prevind(x, CartesianIndex(1, 1)) # invalid result\nCartesianIndex(2, 0)\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.copyto!-Tuple{AbstractArray, CartesianIndices, AbstractArray, CartesianIndices}","page":"Arrays","title":"Base.copyto!","text":"copyto!(dest, Rdest::CartesianIndices, src, Rsrc::CartesianIndices) -> dest\n\nCopy the block of src in the range of Rsrc to the block of dest in the range of Rdest. The sizes of the two regions must match.\n\nExamples\n\njulia> A = zeros(5, 5);\n\njulia> B = [1 2; 3 4];\n\njulia> Ainds = CartesianIndices((2:3, 2:3));\n\njulia> Binds = CartesianIndices(B);\n\njulia> copyto!(A, Ainds, B, Binds)\n5×5 Matrix{Float64}:\n 0.0  0.0  0.0  0.0  0.0\n 0.0  1.0  2.0  0.0  0.0\n 0.0  3.0  4.0  0.0  0.0\n 0.0  0.0  0.0  0.0  0.0\n 0.0  0.0  0.0  0.0  0.0\n\n\n\n\n\n","category":"method"},{"location":"base/arrays.html#Base.copy!","page":"Arrays","title":"Base.copy!","text":"copy!(dst, src) -> dst\n\nIn-place copy of src into dst, discarding any pre-existing elements in dst. If dst and src are of the same type, dst == src should hold after the call. If dst and src are multidimensional arrays, they must have equal axes.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nSee also copyto!.\n\ncompat: Julia 1.1\nThis method requires at least Julia 1.1. In Julia 1.0 this method is available from the Future standard library as Future.copy!.\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.isassigned","page":"Arrays","title":"Base.isassigned","text":"isassigned(array, i) -> Bool\n\nTest whether the given array has a value associated with index i. Return false if the index is out of bounds, or has an undefined reference.\n\nExamples\n\njulia> isassigned(rand(3, 3), 5)\ntrue\n\njulia> isassigned(rand(3, 3), 3 * 3 + 1)\nfalse\n\njulia> mutable struct Foo end\n\njulia> v = similar(rand(3), Foo)\n3-element Vector{Foo}:\n #undef\n #undef\n #undef\n\njulia> isassigned(v, 1)\nfalse\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.Colon","page":"Arrays","title":"Base.Colon","text":"Colon()\n\nColons (:) are used to signify indexing entire objects or dimensions at once.\n\nVery few operations are defined on Colons directly; instead they are converted by to_indices to an internal vector type (Base.Slice) to represent the collection of indices they span before being used.\n\nThe singleton instance of Colon is also a function used to construct ranges; see :.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.IteratorsMD.CartesianIndex","page":"Arrays","title":"Base.IteratorsMD.CartesianIndex","text":"CartesianIndex(i, j, k...)   -> I\nCartesianIndex((i, j, k...)) -> I\n\nCreate a multidimensional index I, which can be used for indexing a multidimensional array A.  In particular, A[I] is equivalent to A[i,j,k...].  One can freely mix integer and CartesianIndex indices; for example, A[Ipre, i, Ipost] (where Ipre and Ipost are CartesianIndex indices and i is an Int) can be a useful expression when writing algorithms that work along a single dimension of an array of arbitrary dimensionality.\n\nA CartesianIndex is sometimes produced by eachindex, and always when iterating with an explicit CartesianIndices.\n\nAn I::CartesianIndex is treated as a \"scalar\" (not a container) for broadcast.   In order to iterate over the components of a CartesianIndex, convert it to a tuple with Tuple(I).\n\nExamples\n\njulia> A = reshape(Vector(1:16), (2, 2, 2, 2))\n2×2×2×2 Array{Int64, 4}:\n[:, :, 1, 1] =\n 1  3\n 2  4\n\n[:, :, 2, 1] =\n 5  7\n 6  8\n\n[:, :, 1, 2] =\n  9  11\n 10  12\n\n[:, :, 2, 2] =\n 13  15\n 14  16\n\njulia> A[CartesianIndex((1, 1, 1, 1))]\n1\n\njulia> A[CartesianIndex((1, 1, 1, 2))]\n9\n\njulia> A[CartesianIndex((1, 1, 2, 1))]\n5\n\ncompat: Julia 1.10\nUsing a CartesianIndex as a \"scalar\" for broadcast requires Julia 1.10; in previous releases, use Ref(I).\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.IteratorsMD.CartesianIndices","page":"Arrays","title":"Base.IteratorsMD.CartesianIndices","text":"CartesianIndices(sz::Dims) -> R\nCartesianIndices((istart:[istep:]istop, jstart:[jstep:]jstop, ...)) -> R\n\nDefine a region R spanning a multidimensional rectangular range of integer indices. These are most commonly encountered in the context of iteration, where for I in R ... end will return CartesianIndex indices I equivalent to the nested loops\n\nfor j = jstart:jstep:jstop\n    for i = istart:istep:istop\n        ...\n    end\nend\n\nConsequently these can be useful for writing algorithms that work in arbitrary dimensions.\n\nCartesianIndices(A::AbstractArray) -> R\n\nAs a convenience, constructing a CartesianIndices from an array makes a range of its indices.\n\ncompat: Julia 1.6\nThe step range method CartesianIndices((istart:istep:istop, jstart:[jstep:]jstop, ...)) requires at least Julia 1.6.\n\nExamples\n\njulia> foreach(println, CartesianIndices((2, 2, 2)))\nCartesianIndex(1, 1, 1)\nCartesianIndex(2, 1, 1)\nCartesianIndex(1, 2, 1)\nCartesianIndex(2, 2, 1)\nCartesianIndex(1, 1, 2)\nCartesianIndex(2, 1, 2)\nCartesianIndex(1, 2, 2)\nCartesianIndex(2, 2, 2)\n\njulia> CartesianIndices(fill(1, (2,3)))\nCartesianIndices((2, 3))\n\nConversion between linear and cartesian indices\n\nLinear index to cartesian index conversion exploits the fact that a CartesianIndices is an AbstractArray and can be indexed linearly:\n\njulia> cartesian = CartesianIndices((1:3, 1:2))\nCartesianIndices((1:3, 1:2))\n\njulia> cartesian[4]\nCartesianIndex(1, 2)\n\njulia> cartesian = CartesianIndices((1:2:5, 1:2))\nCartesianIndices((1:2:5, 1:2))\n\njulia> cartesian[2, 2]\nCartesianIndex(3, 2)\n\nBroadcasting\n\nCartesianIndices support broadcasting arithmetic (+ and -) with a CartesianIndex.\n\ncompat: Julia 1.1\nBroadcasting of CartesianIndices requires at least Julia 1.1.\n\njulia> CIs = CartesianIndices((2:3, 5:6))\nCartesianIndices((2:3, 5:6))\n\njulia> CI = CartesianIndex(3, 4)\nCartesianIndex(3, 4)\n\njulia> CIs .+ CI\nCartesianIndices((5:6, 9:10))\n\nFor cartesian to linear index conversion, see LinearIndices.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.Dims","page":"Arrays","title":"Base.Dims","text":"Dims{N}\n\nAn NTuple of N Ints used to represent the dimensions of an AbstractArray.\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.LinearIndices","page":"Arrays","title":"Base.LinearIndices","text":"LinearIndices(A::AbstractArray)\n\nReturn a LinearIndices array with the same shape and axes as A, holding the linear index of each entry in A. Indexing this array with cartesian indices allows mapping them to linear indices.\n\nFor arrays with conventional indexing (indices start at 1), or any multidimensional array, linear indices range from 1 to length(A). However, for AbstractVectors linear indices are axes(A, 1), and therefore do not start at 1 for vectors with unconventional indexing.\n\nCalling this function is the \"safe\" way to write algorithms that exploit linear indexing.\n\nExamples\n\njulia> A = fill(1, (5,6,7));\n\njulia> b = LinearIndices(A);\n\njulia> extrema(b)\n(1, 210)\n\nLinearIndices(inds::CartesianIndices) -> R\nLinearIndices(sz::Dims) -> R\nLinearIndices((istart:istop, jstart:jstop, ...)) -> R\n\nReturn a LinearIndices array with the specified shape or axes.\n\nExamples\n\nThe main purpose of this constructor is intuitive conversion from cartesian to linear indexing:\n\njulia> linear = LinearIndices((1:3, 1:2))\n3×2 LinearIndices{2, Tuple{UnitRange{Int64}, UnitRange{Int64}}}:\n 1  4\n 2  5\n 3  6\n\njulia> linear[1,2]\n4\n\n\n\n\n\n","category":"type"},{"location":"base/arrays.html#Base.to_indices","page":"Arrays","title":"Base.to_indices","text":"to_indices(A, I::Tuple)\n\nConvert the tuple I to a tuple of indices for use in indexing into array A.\n\nThe returned tuple must only contain either Ints or AbstractArrays of scalar indices that are supported by array A. It will error upon encountering a novel index type that it does not know how to process.\n\nFor simple index types, it defers to the unexported Base.to_index(A, i) to process each index i. While this internal function is not intended to be called directly, Base.to_index may be extended by custom array or index types to provide custom indexing behaviors.\n\nMore complicated index types may require more context about the dimension into which they index. To support those cases, to_indices(A, I) calls to_indices(A, axes(A), I), which then recursively walks through both the given tuple of indices and the dimensional indices of A in tandem. As such, not all index types are guaranteed to propagate to Base.to_index.\n\nExamples\n\njulia> A = zeros(1,2,3,4);\n\njulia> to_indices(A, (1,1,2,2))\n(1, 1, 2, 2)\n\njulia> to_indices(A, (1,1,2,20)) # no bounds checking\n(1, 1, 2, 20)\n\njulia> to_indices(A, (CartesianIndex((1,)), 2, CartesianIndex((3,4)))) # exotic index\n(1, 2, 3, 4)\n\njulia> to_indices(A, ([1,1], 1:2, 3, 4))\n([1, 1], 1:2, 3, 4)\n\njulia> to_indices(A, (1,2)) # no shape checking\n(1, 2)\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.checkbounds","page":"Arrays","title":"Base.checkbounds","text":"checkbounds(Bool, A, I...)\n\nReturn true if the specified indices I are in bounds for the given array A. Subtypes of AbstractArray should specialize this method if they need to provide custom bounds checking behaviors; however, in many cases one can rely on A's indices and checkindex.\n\nSee also checkindex.\n\nExamples\n\njulia> A = rand(3, 3);\n\njulia> checkbounds(Bool, A, 2)\ntrue\n\njulia> checkbounds(Bool, A, 3, 4)\nfalse\n\njulia> checkbounds(Bool, A, 1:3)\ntrue\n\njulia> checkbounds(Bool, A, 1:3, 2:4)\nfalse\n\n\n\n\n\ncheckbounds(A, I...)\n\nThrow an error if the specified indices I are not in bounds for the given array A.\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.checkindex","page":"Arrays","title":"Base.checkindex","text":"checkindex(Bool, inds::AbstractUnitRange, index)\n\nReturn true if the given index is within the bounds of inds. Custom types that would like to behave as indices for all arrays can extend this method in order to provide a specialized bounds checking implementation.\n\nSee also checkbounds.\n\nExamples\n\njulia> checkindex(Bool, 1:20, 8)\ntrue\n\njulia> checkindex(Bool, 1:20, 21)\nfalse\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.elsize","page":"Arrays","title":"Base.elsize","text":"elsize(type)\n\nCompute the memory stride in bytes between consecutive elements of eltype stored inside the given type, if the array elements are stored densely with a uniform linear stride.\n\nExamples\n\njulia> Base.elsize(rand(Float32, 10))\n4\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Views-(SubArrays-and-other-view-types)","page":"Arrays","title":"Views (SubArrays and other view types)","text":"","category":"section"},{"location":"base/arrays.html","page":"Arrays","title":"Arrays","text":"A “view” is a data structure that acts like an array (it is a subtype of AbstractArray), but the underlying data is actually part of another array.","category":"page"},{"location":"base/arrays.html","page":"Arrays","title":"Arrays","text":"For example, if x is an array and v = @view x[1:10], then v acts like a 10-element array, but its data is actually accessing the first 10 elements of x. Writing to a view, e.g. v[3] = 2, writes directly to the underlying array x (in this case modifying x[3]).","category":"page"},{"location":"base/arrays.html","page":"Arrays","title":"Arrays","text":"Slicing operations like x[1:10] create a copy by default in Julia. @view x[1:10] changes it to make a view. The @views macro can be used on a whole block of code (e.g. @views function foo() .... end or @views begin ... end) to change all the slicing operations in that block to use views.  Sometimes making a copy of the data is faster and sometimes using a view is faster, as described in the performance tips.","category":"page"},{"location":"base/arrays.html","page":"Arrays","title":"Arrays","text":"Base.view\nBase.@view\nBase.@views\nBase.parent\nBase.parentindices\nBase.selectdim\nBase.reinterpret\nBase.reshape\nBase.dropdims\nBase.vec\nBase.SubArray","category":"page"},{"location":"base/arrays.html#Base.view","page":"Arrays","title":"Base.view","text":"view(A, inds...)\n\nLike getindex, but returns a lightweight array that lazily references (or is effectively a view into) the parent array A at the given index or indices inds instead of eagerly extracting elements or constructing a copied subset. Calling getindex or setindex! on the returned value (often a SubArray) computes the indices to access or modify the parent array on the fly.  The behavior is undefined if the shape of the parent array is changed after view is called because there is no bound check for the parent array; e.g., it may cause a segmentation fault.\n\nSome immutable parent arrays (like ranges) may choose to simply recompute a new array in some circumstances instead of returning a SubArray if doing so is efficient and provides compatible semantics.\n\ncompat: Julia 1.6\nIn Julia 1.6 or later, view can be called on an AbstractString, returning a SubString.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> b = view(A, :, 1)\n2-element view(::Matrix{Int64}, :, 1) with eltype Int64:\n 1\n 3\n\njulia> fill!(b, 0)\n2-element view(::Matrix{Int64}, :, 1) with eltype Int64:\n 0\n 0\n\njulia> A # Note A has changed even though we modified b\n2×2 Matrix{Int64}:\n 0  2\n 0  4\n\njulia> view(2:5, 2:3) # returns a range as type is immutable\n3:4\n\n\n\n\n\n","category":"function"},{"location":"base/arrays.html#Base.@view","page":"Arrays","title":"Base.@view","text":"@view A[inds...]\n\nTransform the indexing expression A[inds...] into the equivalent view call.\n\nThis can only be applied directly to a single indexing expression and is particularly helpful for expressions that include the special begin or end indexing syntaxes like A[begin, 2:end-1] (as those are not supported by the normal view function).\n\nNote that @view cannot be used as the target of a regular assignment (e.g., @view(A[1, 2:end]) = ...), nor would the un-decorated indexed assignment (A[1, 2:end] = ...) or broadcasted indexed assignment (A[1, 2:end] .= ...) make a copy.  It can be useful, however, for updating broadcasted assignments like @view(A[1, 2:end]) .+= 1 because this is a simple syntax for @view(A[1, 2:end]) .= @view(A[1, 2:end]) + 1, and the indexing expression on the right-hand side would otherwise make a copy without the @view.\n\nSee also @views to switch an entire block of code to use views for non-scalar indexing.\n\ncompat: Julia 1.5\nUsing begin in an indexing expression to refer to the first index requires at least Julia 1.5.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> b = @view A[:, 1]\n2-element view(::Matrix{Int64}, :, 1) with eltype Int64:\n 1\n 3\n\njulia> fill!(b, 0)\n2-element view(::Matrix{Int64}, :, 1) with eltype Int64:\n 0\n 0\n\njulia> A\n2×2 Matrix{Int64}:\n 0  2\n 0  4\n\n\n\n\n\n","category":"macro"},{"location":"base/arrays.html#Base.@views","page":"Arrays","title":"Base.@views","text":"@views expression\n\nConvert every array-slicing operation in the given expression (which may be a begin/end block, loop, function, etc.) to return a view. Scalar indices, non-array types, and explicit getindex calls (as opposed to array[...]) are unaffected.\n\nSimilarly, @views converts string slices into SubString views.\n\nnote: Note\nThe @views macro only affects array[...] expressions that appear explicitly in the given expression, not array slicing that occurs in functions called by that code.\n\ncompat: Julia 1.5\nUsing begin in an indexing expression to refer to the first index was implemented in Julia 1.4, but was only supported by @views starting in Julia 1.5.\n\nExamples\n\njulia> A = zeros(3, 3);\n\njulia> @views for row in 1:3\n           b = A[row, :] # b is a view, not a copy\n           b .= row      # assign every element to the row index\n       end\n\njulia> A\n3×3 Matrix{Float64}:\n 1.0  1.0  1.0\n 2.0  2.0  2.0\n 3.0  3.0  3.0\n\n\n\n\n\n","category":"macro"},{"location":"base/arrays.html#Base.parent","page":"Arrays","title":"Base.parent","text":"parent(A)\n\nReturn the underlying parent object of the view. This parent of objects of types SubArray, SubString, ReshapedArray or LinearAlgebra.Transpose is what was passed as an argument to view, reshape, transpose, etc. during object creation. If the input is not a wrapped object, return the input itself. If the input is wrapp