# This file was autogenerated by base/version_git.sh
struct GitVersionInfo
    commit::String
    commit_short_raw::String
    branch::String
    build_number::Int
    date_string::String
    tagged_commit::Bool
    fork_master_distance::Int
    fork_master_timestamp::Float64
    build_system_commit::String
    build_system_commit_short::String
end

function Base.getproperty(info::GitVersionInfo, s::Symbol)
    if s === :commit_short
        commit = getfield(info, :commit_short_raw)
        dirty_file = joinpath(Sys.BINDIR, Base.DATAROOTDIR, "julia", "base", "version_git_dirty")
        dirty_str = try
            read(dirty_file, String)
        catch
            ""
        end
        if strip(dirty_str) == "true"
            return commit * "*"
        end
        return commit
    else
        return getfield(info, s)
    end
end

const GIT_VERSION_INFO = GitVersionInfo(
    "b6610e890b3c6067fcee5382df6986d76c959239",
    "b6610e890b3",
    "v1.13.0-beta1",
    0,
    "2026-01-12 13:00 UTC",
    true,
    81,
    1761678891.0,
    "0b91eca6d5a2bfde2246b82ee2a68da548d4a270",
    "0b91eca",
)
